/*
 * config.h	Default configuration.
 *
 *		This file is part of the minicom communications package,
 *		Copyright 1991,1992,1993,1994 Miquel van Smoorenburg.
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */

/*
 * Definitions below are not hard-coded - you can change them from
 * the setup menu in minicom, or you can start minicom with the
 * "-s" flag.
 * Recommended setting for some systems are commented. Uncomment
 * and adjust them to your system.
 */

/* Operating system INdependant parameters. (Usually the same everywhere) */
#define KERMIT "/usr/bin/kermit -l %l -b %b"	/* How to call kermit */
#define UUCPLOCK	"/usr/spool/uucp"	/* Lock file directory */
#define LOGFILE		"minicom.log"		/* Not defined = not used */

/* Operating system dependant parameters, per OS. A few samples are given. */
#if defined(linux) || defined(__linux)
#  define DFL_PORT "/dev/cua1"		/* Which tty to use */
#  define DEF_BAUD "19200"		/* Default baud rate */
#  define CALLOUT  ""			/* Gets run to get into dial out mode */
#  define CALLIN   ""			/* Gets run to get into dial in mode */
#endif

#ifdef _MINIX
#  define DFL_PORT "/dev/tty1"
#  define DEF_BAUD "2400"
#  define CALLOUT  ""
#  define CALLIN   ""
#endif

#if defined (_COHERENT)
#  define DFL_PORT "/dev/modem"
#  define DEF_BAUD "9600"
#  define CALLOUT  "" /* "/etc/disable com1r" */
#  define CALLIN   "" /* "/etc/enable com1r"  */
#endif

#ifdef _HPUX_SOURCE
#  define DFL_PORT "/dev/cua2p0"
#  define DEF_BAUD "19200"
#  define CALLOUT  ""
#  define CALLIN   ""
#endif

#ifdef ISC
#  define DFL_PORT "/dev/tty01"
#  define DEF_BAUD "9600"
#  define CALLOUT  ""
#  define CALLIN   ""
#endif

/* Some reasonable defaults if not defined */
#ifndef DFL_PORT
#  define DFL_PORT "/dev/tty8"
#  define DEF_BAUD "2400"
#  define CALLIN   ""
#  define CALLOUT  ""
#endif

/*
 * The next definitions are permanent ones - you can't edit the
 * configuration from within minicom to change them
 * (unless you use a binary editor, like a real hacker :-)
 */

/* Menu Colors (for all possible colors - look in window.h) */
#define MFG	YELLOW	/* ForeGround */
#define MBG	BLUE	/* BackGround */

/* Terminal window colors */
#define SFG	BLUE
#define SBG	CYAN

/* The next automatically defines "KEY_KLUDGE" for a Minix system;
 * it improves the algorithm for decoding escape sequences but
 * is very Minix specific (read: DIRTY)
 */
#if defined (_MINIX) || defined(linux) /*Experimental */
#  define KEY_KLUDGE 1
#endif

/*
 * Only and only define this if you have a slow machine and find
 * the output of minicom unaccepably jerky.
 */
#ifdef _MINIX
#  define SMOOTH /* */
#endif

/*
 * Minix and Coherent V3 probably don't have enough memory for a
 * scroll back buffer and/or a translate buffer.
 */
#if defined(_MINIX) || defined(_COH3)
#  define HISTORY 0
#  define TRANSLATE 0
#else
#  define HISTORY 1
#  if __STDC__
#    define TRANSLATE 1
#  else
#    define TRANSLATE 0
# endif
#endif

#if defined (_SYSV) || defined (_BSD43)
#  if !defined(_SVR2) && !defined(_SYSV3) && !defined(_COH42)
#    define HAS_FCHOWN
#    if defined(__linux__) || defined(_BSD43)
#	ifdef _POSIX_SOURCE
		extern int fchmod();
		extern int fchown(); /* Not Posix. */
#	endif
#    endif
#  endif
#endif
