/* filename	: partact.c
 * purpose	: set active partition
 * author	: Randy Wright
 * Copyright	: ((C)) Copyright 1993 Randy Wright
 *
 * $LOG$
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/fdisk.h>
#include <fcntl.h>
#include <errno.h>

main(argc,argv)
int argc;
char **argv;
{
char xdev[80], inbuf[80];
int i, fd, newpart;
HDISK_S hd;
FDISK_S *fptr;

if( argc < 3 )
	{
	if( isatty(0) )
		{
		printf( "Xdevice : "); fflush(stdout);
		gets(xdev);
		printf( "Partition to make active: ");  fflush(stdout);
		newpart = atoi( (gets(inbuf)) );
		}
	else exit(1);
	}
else
	{
	strncpy(xdev, argv[1], 80 );
	newpart = atoi( argv[2] );
	}


if( (fd = open( xdev, O_RDWR)) < 0 )
	{
	printf( "Can't open %s\n", xdev );
	exit(1);
	}

if( (lseek( fd, 0L, 0 )) < 0 )
	{
	printf( "can't lseek to begining of drive %s\n", xdev );
	close(fd);
	exit(1);
	}

if( (read(fd, &hd, 512)) != 512 )
	{
	printf( "bad read of %s\n", xdev );
	perror("");
	close(fd);
	exit(1);
	}

if( hd.hd_sig != 0xaa55 )
	{
	printf( "bad signature.\n" );
	exit(1);
	}

printf( "signature : 0x%x\n", hd.hd_sig );


for( i=0, fptr = &hd.hd_partn[0]; i < 4;  i++, fptr++ )
	{
	if( i == newpart )
		{
		fptr->p_boot = 128;
		printf( "parition %d set to active\n", i );
		}
	else
		{
		fptr->p_boot = 0;
		printf( "parition %d set to inactive\n", i );	
		}
	}

if( (lseek( fd, 0L, 0 )) < 0 )
	{
	printf( "can't lseek to begining of drive %s\n", xdev );
	close(fd);
	exit(1);
	}

if( (write(fd, &hd, 512)) != 512 )
	{
	printf( "bad read of %s\n", xdev );
	perror("");
	close(fd);
	exit(1);
	}

close(fd);
exit(0);
}
