/*	spk.c
 *	IBM speaker driver - plays tune written to it.
 *
 *	(c) Szigeti Szabolcs 1993
 *
 *		minor device : 0 -> HERTZ-TICKS;HERTZ-TICKS;...
 */

#include "h\types.h"
#include "h\param.h"
#include "h\user.h"
#include "h\machine.h"
#include "h\systm.h"

#define MAJOR	6
#define NUNIT	1

#define SPKPRI	15

#define RELEASED	0
#define INUSE		1

#define HERTZ	0
#define TICKS	1

int spflag;	/* device open flag	*/
word spdata[2];	/* freq and timing data	*/

/*
 * open device for exclusive use
 */

spopen(dev,flag)
register int dev,flag;
	{
	dev=minor(dev);

	if (dev>=NUNIT)
		{
		u->u_error=ENXIO;
		return;
		}
	if (spflag!=RELEASED)
		{
		u->u_error=EIO;
		return;
		}
	spflag=INUSE;
	outbyte (TIMERC,TIMER2MOD);
	outbyte (IO_PPI,0);
	}
/*
 * close device
 */
spclose(dev,flag)
	{
	outbyte (IO_PPI,0);
	spflag=RELEASED;
	}
/*
 * write chars to device
 *
 * string written should take the following format:
 *
 *	xxxx-yyyy; ...
 *
 *	xxxx: sound frequency in Hertz in decimal
 *	yyyy: duration in HZ ticks in decimal
 *            playing starts when ';' is reached
 *	 any other characxter resets driver to look for next xxxx
 */
spwrite(dev)
	{
	register int c;

	static int state=HERTZ;

	while ((c=cpass())>=0)
		{
		if ('0'<=c && c<='9')	/* get data for freq and time	*/
			{
			spdata[state]*=10;
			spdata[state]+=c-'0';
			continue;
			}
		if (c=='-')		/* next numbers for duration	*/
			{
			state=TICKS;
			continue;
			}
		if (c==';')		/* start sound			*/
			{
			sound();
			}
		spdata[HERTZ]=0;	/* reached at end of sound or	*/
		spdata[TICKS]=0;	/* when illegal char encountered*/
		state=HERTZ;
		}
	}
/*
 * Produce sound specified in spdata[]
 *	returns when timer expires
 */

sound()
	{
	register word count;
	if (spdata[HERTZ]==0)
		outbyte (IO_PPI,0);	/* freq==0 is silence	*/
	else
		{			/* calculate freq	*/

		count= (TIMERFREQ/spdata[HERTZ])&0xffff;
		lock();

		outbyte (TIMER2,count&0xff);
		outbyte (TIMER2,count>>8);

		outbyte(IO_PPI,SPK_ON);

		enable();
		}
	timeout(wakeup,&spflag,spdata[TICKS]);

	sleep((int)&spflag,SPKPRI);	/* wait for time       	*/

	outbyte (IO_PPI,0);		/* stop sound		*/
	}

