/*
 *	stdio.h
 *		header for the portable i/o library
 *							
 */ 

#define BUFSIZE		512	/* Equals the sector size	*/	
#define _NFILE		20      /* Max open files in one proc	*/

typedef struct _iobuf
	{
	char	*_ptr;  /* Position in file	*/
	int    	_cnt;	/* Characters left	*/
	char	*_base;	/* Addr of buffer	*/
	int	_flag;	/* see defines below	*/
	int	_fd;	/* File descriptor	*/
	} FILE;

extern FILE _iob[_NFILE];

#define stdin	(& _iob[0])
#define stdout	(& _iob[1])
#define stderr	(& _iob[2])

#define	_READ	 01 	/* File open for read	*/
#define	_WRITE	 02	/* File open for write	*/                                               
#define	_UNBUF	 04	/* File is unbuffered	*/
#define	_BIGBUF	010	/* File has big buffer	*/
#define	_EOF	020	/* File is at EOF	*/
#define	_ERR	040	/* There was an error	*/

#define	NULL	0
#define	EOF	(-1)

#define	getc(p)	((!((p)->_flag&_WRITE)&&(--(p)->_cnt>=0))? \
			*(p)->_ptr++&0377:_filbuf(p))
#define	getchar()	getc(stdin)
#define putc(x,p) ((!((p)->_flag&_READ)&&(--(p)->_cnt>=0))? \
			((int)(*(p)->_ptr++=(char)(x))):\
			_flusbuf((unsigned)(x),p))
#define	putchar(x)	putc(x,stdout)
#define	feof(p)		(((p)->_flag&_EOF)!=0)
#define	ferror(p)	(((p)->_flag&_ERR)!=0)
#define	fileno(p)	p->_file

FILE	*fopen(char*,char*);
FILE	*freopen();
FILE	*fdopen();
FILE	*popen();
long	ftell();
char	*fgets();

