
#include <stdio.h>
#include <dos.h>
#include <string.h>

#define BLOCK_SIZ	256
#define S_READ		0x02
#define S_WRITE		0x03

#define BIOS_DISK	0x13
int heads=2;
int sectors=18;
int first_blk=0;
int unit=1;

char s_buf [BLOCK_SIZ*2];


blk_io(rblk,mode,buf)
unsigned int rblk,mode;
char *buf;
	{
	unsigned int cyl,sec,hed;
	unsigned long blk;
	static union REGS regs;

	blk=rblk+first_blk;
	cyl = (int)(blk / (heads * sectors));
	sec = (int)(blk % sectors)+1;
	hed = (int)(blk % (heads * sectors)) / sectors;
	regs.h.ah = mode;
	regs.h.dl = unit;
	regs.h.dh = hed;
	regs.h.ch = cyl & 0xff;
	regs.h.cl = (sec & 0x3f) + ((cyl >> 2) & 0xc0);
	regs.h.al = 1;
	regs.x.bx = (int)buf;
	_ES 	  = _DS;
	int86 (BIOS_DISK,&regs,&regs);
	if (regs.x.cflag) 
		error(regs.h.ah);
	}
error(code)
char code;
	{
	fprintf(stderr,"I/O error: %u\n",code);
	exit(1);
	}

main(argc,argv)
char argc,*argv[];
	{
	int ln;
	int red,blk;
	FILE *in;
	if (argc<2)
		{
		printf("Bad args\n");
		exit(1);
		}
	if ((in=fopen(argv[1],"rb"))==NULL)
		{
		printf("Bad file\n");
		exit(1);
		}
	ln=lseek(in->fd,0L,SEEK_END);
	fseek(in,0L,SEEK_SET);
	if (ln<17)
		{
		printf ("Short\n");
		exit(1);
		}
	*(int*)s_buf = ln;
	strcpy(&s_buf[2],argv[1]);
	blk_io(0,S_WRITE,s_buf);
	blk=1;
	do
		{
		red=fread(s_buf,1,512,in);
		blk_io(blk++,S_WRITE,s_buf);
		}
	while (red==512);
	fclose (in);
	exit(0);
	}