/ disk boot program to load and transfer
/ to a unix entry.
/ for use with 1 KB byte blocks.
/ NDIRIN is the number of direct inode addresses (currently 4)

NBOO	= 1.		/ number of boot blocks
NSUP	= 1.		/ number of super blocks
CLSIZE	= 2.		/ number of physical disk blocks per logical block
INOPB	= 16.		/ inodes per logical block
INOSIZ	= 64.		/ size of inode in bytes
INOFF	= 31.		/ inode offset = INOPB * (NBOO+NSUP) - 1
WC	= -512.		/ word count 256 * CLSIZE
NDIRIN	= 4.		/ number of direct inode addresses

/ entry is made by jsr pc,*$0
/ so return can be rts pc

core = 28.
.. = [core*2048.]-512.

/ establish sp and check if running below
/ intended origin, if so, copy
/ program up to 'core' K words.
start:
	mov	$..,sp
	mov	sp,r1
	cmp	pc,r1
	bhis	2f
	clr	r0
	cmp	(r0),$407
	bne	1f
	mov	$20,r0
1:
	mov	(r0)+,(r1)+
	cmp	r1,$end
	blo	1b
	jmp	(sp)

/ clear core to make things clean
2:
	clr	(r0)+
	cmp	r0,sp
	blo	2b

/ at origin, read pathname,
/ initialize rp
	mov	$drive,*$rmcs2
	mov	$preset+go,*$rmcs1
	mov	$fmt22,*$rmof

/ spread out in array 'names', one
/ component every 14 bytes.
	mov	$names,r1
1:
	mov	r1,r2
2:
	jsr	pc,getc
	cmp	r0,$'\n
	beq	1f
	cmp	r0,$'/
	beq	3f
	movb	r0,(r2)+
	br	2b
3:
	cmp	r1,r2
	beq	2b
	add	$14.,r1
	br	1b

/ now start reading the inodes
/ starting at the root and
/ going through directories
1:
	mov	$names,r1
	mov	$2,r0
1:
	clr	bno
	jsr	pc,iget
	tst	(r1)
	beq	1f
2:
	jsr	pc,rmblk
		br start
	mov	$buf,r2
3:
	mov	r1,r3
	mov	r2,r4
	add	$16.,r2
	tst	(r4)+
	beq	5f
4:
	cmpb	(r3)+,(r4)+
	bne	5f
	cmp	r4,r2
	blo	4b
	mov	-16.(r2),r0
	add	$14.,r1
	br	1b
5:
	cmp	r2,$buf+1024.		/ change when changing CLSIZE
	blo	3b
	br	2b

/ read file into core until
/ a mapping error, (no disk address)
1:
	clr	r1
1:
	jsr	pc,rmblk
		br 1f
	mov	$buf,r2
2:
	mov	(r2)+,(r1)+
	cmp	r2,$buf+1024.		/ change when changing CLSIZE
	blo	2b
	br	1b
/ relocate core around
/ assembler header
1:
	clr	r0
	cmp	(r0),$407
	bne	2f
1:
	mov	20(r0),(r0)+
	cmp	r0,sp
	blo	1b
/ enter program and
/ restart if return
2:
	jsr	pc,*$0
	br	start

/ get the inode specified in r0
iget:
	add	$INOFF,r0
	mov	r0,r5
	ash	$-4.,r0
	bic	$!7777,r0
	mov	r0,dno
	clr	r0
	jsr	pc,rblk
	bic	$!17,r5
	mul	$INOSIZ,r5
	add	$buf,r5
	mov	$inod,r4
1:
	mov	(r5)+,(r4)+
	cmp	r4,$inod+64.
	blo	1b
	rts	pc

/ read a mapped block
/ offset in file is in bno.
/ skip if success, no skip if fail
/ the algorithm only handles a single
/ indirect block. that means that
/ files longer than NDIRIN+128 blocks cannot
/ be loaded.
rmblk:
	add	$2,(sp)
	mov	bno,r0
	cmp	r0,$NDIRIN
	blt	1f
	mov	$NDIRIN,r0
1:
	mov	r0,-(sp)
	asl	r0
	add	(sp)+,r0
	add	$addr+1,r0
	movb	(r0)+,dno
	movb	(r0)+,dno+1
	movb	-3(r0),r0
	bne	1f
	tst	dno
	beq	2f
1:
	jsr	pc,rblk
	mov	bno,r0
	inc	bno
	sub	$NDIRIN,r0
	blt	1f
	ash	$2,r0
	mov	buf+2(r0),dno
	mov	buf(r0),r0
	bne	rblk
	tst	dno
	bne	rblk
2:
	sub	$2,(sp)
1:
	rts	pc

drive	= 0
cyl	= 0.
read	= 70
preset	= 20
go	= 1
fmt22	= 10000

rmcs1	= 176700
rmda	= rmcs1+6
rmcs2	= rmcs1+10
rmds	= rmcs1+12
rmof	= rmcs1+32
rmca	= rmcs1+34

/ rm05 disk driver.
/ low order address in dno,
/ high order in r0.
rblk:
	mov	r1,-(sp)
	mov	dno,r1
	ashc	$1,r0		/ multiply by CLSIZE
	div	$32.*19.,r0
	add	$cyl,r0
	mov	r0,*$rmca
	clr	r0
	div	$32.,r0
	swab	r0
	bis	r1,r0
	mov	$rmda,r1
	mov	r0,(r1)
	mov	$buf,-(r1)
	mov	$WC,-(r1)
	mov	$read+go,-(r1)
1:
	tstb	(r1)
	bge	1b
	mov	(sp)+,r1
	rts	pc

tks = 177560
tkb = 177562
csw = 177570
/ read and echo a teletype character
getc:
	cmp	$0, csw
	bne	2f
	movb	*cp, r0
	inc	cp
	br	putc
2:
	mov	$tks,r0
	inc	(r0)
1:
	tstb	(r0)
	bge	1b
	mov	tkb,r0
	bic	$!177,r0
	cmp	r0,$'A
	blo	1f
	cmp	r0,$'Z
	bhi	1f
	add	$'a-'A,r0
1:

tps = 177564
tpb = 177566
/ print a teletype character
putc:
	tstb	*$tps
	bge	putc
	mov	r0,*$tpb
	cmp	r0,$'\r
	bne	1f
	mov	$'\n,r0
	br	putc
1:
	rts	pc

cp:	defnm
defnm:	<1kboot\r>
end:
inod = ..-1536.		/ change when changing CLSIZE
addr = inod+12.
buf = inod+64.
bno = buf+1024.		/ change when changing CLSIZE
dno = bno+2
names = dno+2
reset = 5
