.TH XNSCourier 3 Cornell
.\" $Header: xnscourier.n,v 1.2 86/12/15 11:26:22 jqj Exp $
.SH NAME
CourierOpen, CourierClose, BDTread, BDTwrite, BDTabort, BDTclosewrite \-
public runtimes for Unix Courier
.SH SYNOPSIS
.nf
.B #include <sys/types.h>
.B #include <netns/ns.h>
.B #include <xnscourier/courier.h>
.B #include <xnscourier/courierconnection.h>
.PP
.B CourierConnection *CourierOpen(destaddr)
.B struct ns_addr *destaddr;
.PP
.B CourierClose(conn)
.B CourierConnection *conn;
.PP
.B int BDTread(conn, buffer, nbytes)
.B CourierConnection *conn;
.B char *buffer;
.B int nbytes;
.PP
.B int BDTwrite(conn, buffer, nbytes)
.B CourierConnection *conn;
.B char *buffer;
.B int nbytes;
.PP
.B BDTclosewrite(conn)
.B CourierConnection *conn;
.PP
.B BDTabort(conn)
.B CourierConnection *conn;
.PP
cc ... -lcourier
.fi
.SH DESCRIPTION
.PP
These functions are part of the runtime library for XNS Courier remote
procedure calls.  They all require 4.3 BSD with XNS network support enabled.
.PP
.I CourierOpen
attempts to open an SPP connection to the address specified.  It returns
0 on failure.
If the port portion of the address is 0, then the standard port for
Courier RPC connections, IDPPORT_COURIER, is used.
.PP
.I CourierClose
closes the SPP connection obtained by CourierOpen by means of the usual
XNS 3-way END/END-REPLY handshake.
.PP
.I BDTread
and
.I BDTwrite
are similar to 
.I read(2)
and
.I write(2)
except that they accept a Courier connection instead of a file descriptor,
and transmit or receive at most one SPP packet (maximum size is thus 534
bytes, which is also the recommended value of 
.IR nbytes ).
These routines should be used only in a Courier server to perform a BDT
data transfer, or in a Courier client from within a BDT callback routine.
.PP
.I BDTclosewrite
and
.I BDTabort
provide a way for a BDT source (i.e. write)
procedure to end a data transfer, either successfully
or unsuccessfully respectively.  In addition, 
.I BDTabort
may be used to terminate a BDT sink (i.e. read) transfer.
.SH FILES
.nf
.fi
.SH SEE ALSO
all the Courier documentation
.SH DIAGNOSTICS
None.
.SH BUGS
Probably lots of them.  Expanding ring broadcast is not yet implemented.
