/* WCS750 definitions 
James, 1998
*/

#ifdef VAX750
#ifdef WCS750

/* NOTES:
The WCS consists of 1k or 2k 80-bit words of control store memory.
Each control word is accessed across CMI as four consecutively-addressed
longword locations. The WCS starts at F00000. The last location of 
the first bank is at F03FFC. The first location of the second 1k bank
is at F04000, and the last location of the second bank is F07FFC.
Only the bottom 20 bits of each longword are used for WCS data. The 
21st bit of any WCS longword is the WCS enable flag. Other bits in the 
longword are unused and read as garbage. 
*/

/* Physical base address of WCS memory on CMI */
#define WCS_BASE 0xF00000
/* Number of control words in each WCS bank */
#define WCS_BANK 1024
/* Number of CMI longwords occupied by a bank of WCS (4096) */
#define WCS_LONGS (WCS_BANK * 4)
/* Number of CMI bytes occupied by a bank of WCS (16384) */
#define WCS_BYTES (WCS_LONGS * 4)
/* Number of pages occupied by a bank of WCS (32) */
#define WCS_PAGES (btop(WCS_BYTES))

/* Start address of PCS memory */
#define PCS_BASE 0xF08000

/* Flag-bits enable register */
#define PCS_FLAGREG 0xF0C000

/* Basic revision of PCS microcode, without patches loaded */
#define PCS_BASEREV 95

/* Mask of control store bits (bottom 20 bits) */
#define WCS_MASK 0xFFFFF

/* Flag to enable WCS (21st bit) */
#define WCS_ENABLE_BIT 0x100000

extern int wcs750_open();
extern int wcs750_close();
extern int wcs750_write();
extern int wcs750_read();
extern int wcs750_ioctl();

#endif
#endif
