/ low core

br4 = 200
br5 = 240
br6 = 300
br7 = 340
wait = 1

. = 0^.
	br	1f
	4

/ trap vectors
	bustrap; br7+0.		/ bus error
	trap; br7+1.		/ illegal instruction
	trap; br7+2.		/ bpt-trace trap
	trap; br7+3.		/ iot trap
	trap; br7+4.		/ power fail
	trap; br7+5.		/ emulator trap
	trap; br7+6.		/ system entry

. = 40^.
.globl	start, dump
1:	jmp	start
	jmp	dump

. = 54^.
	0;0			/count of clock tiks

. = 60^.
	klin; br4
	klou; br4

. = 100^.
	kwlp; br6+1			/set c bit
	kwlp; br6+1			/set c bit

. = 114^.
	trap; br7+7.		/ 11/70 parity

. = 174^.
.globl	_idle
_idle:
	wait
	rts	pc

. = 200^.
	lpou; br4+0.		/ std printer

. = 220^.
	rkio; br5

. = 230^.
	crint; br4

. = 240^.
	trap; br7+7.		/ programmed interrupt
	trap; br7+8.		/ floating point
	trap; br7+9.		/ segmentation violation

/ floating vectors
. = 300^.

	cyin; br6+0.
	cyou; br6+0.

. = 310^.
	djin; br5+0.
	djou; br5+0.

//////////////////////////////////////////////////////
/		interface code to C
//////////////////////////////////////////////////////

.globl	call, trap, bustrap

.globl	_klrint
klin:	jsr	r0,call; _klrint
.globl	_klxint
klou:	jsr	r0,call; _klxint

.globl	_clock
kwlp:
	adc	*$56			/low word of count
	adc	*$54			/high word of count
	jsr	r0,call; _clock


.globl	_lpint
lpou:	jsr	r0,call; _lpint

.globl	_rkintr
rkio:	jsr	r0,call; _rkintr

.globl	_crint
crint:	jsr	r0,call; _crint

.globl	_cyrint
cyin:	jsr	r0,call; _cyrint
.globl	_cyxint
cyou:	jsr	r0,call; _cyxint

.globl	_djrint
djin:	jsr	r0,call; _djrint
.globl	_djxint
djou:	jsr	r0,call; _djxint
