#define	PARALLEL	0
#define	BAUD2400	((11 << 8) + 11)
#define	EVENP	0200
#define	XTABS	02
#define	FLUSH	040	/* flush printer (if applicable) */
#define	NOEJECT	0200	/* no page break */

struct lpdlock
{
	unsigned lpd_pid;	/* pid of the daemon */
	unsigned lpd_uid;	/* owner of currently printing job */
	unsigned lpd_state;	/* state of the daemon */
};

struct printer
{
	char	ident;		/* printer identifying letter */
	char	push;		/* page feeds to push job out of printer */
	int	pagewidth;
	int	pagelength;
	char	translate;	/* whether to translate curly brackets etc */
	char	pagemult;	/* multiplication factor for the page limit */
	int	baudrate;
	int	modes;		/* modes for la180 types, e.g. parity. */
}
printer[]
{
	{ '0', 4, 136, 60, 1, 10, PARALLEL, 0},
	{ '1', 1, 132, 51, 0,  3, BAUD2400, EVENP | XTABS},
	{ '4', 1, 132, 51, 0,  3, BAUD2400, EVENP | XTABS},
};

#define	PR_DFLT	0	/* default printer */
#define NPRINTERS (sizeof printer/sizeof printer[0])

#define	LPDDIR	"/tmp/lpd"

#define	SIGKICK		SIGINS
#define	SIGSTOP		SIGTRC
#define	SIGRESTART	SIGIOT

/*
 * daemon states
 */
#define	IDLE	0	/* waiting for something to do */
#define	PR_OP	1	/* trying to open the printer */
#define	PRINT	2	/* printing */
#define	CLDN	3	/* closing down */

/*
 * control file codes
 */
#define	CF_UID		'I'
#define	CF_LOCAL	'L'
#define	CF_PUSH		'P'
#define	CF_COPIES	'N'
#define	CF_NOSKIP	'Y'
#define	CF_FILE		'F'
#define	CF_RM		'U'
#define	CF_MESG		'M'
#define	CF_PAGES	'S'
