/ assembly language routines for the fortran/macro linker
/ j. n. rottman

indir = 0

/ GETSEC(int *x)
/ returns rsectl______ corresponding to x.

.text

	.globl	_getsec
	.globl	_pcorres

_getsec:	
	mov	2(sp),r1
	mov	r2,-(sp)
	mov	$_pcorres, r2
1:	mov	(r2)+,r0
	mov	4(r0),r0
	cmp	(r0)+,(r1)
	bne	1b
	cmp	(r0),2(r1)
	bne	1b
	mov	-(r2),r0
	mov	(sp)+,r2
	rts	pc


/ GETNAM()
/ gets a radix-50 name (4 bytes) from the
/ input stream, places them in a static buffer,
/ and then returns to pointer to them

	.globl	_getnam
_getnam:
	mov	$4,-(sp)
	mov	$nb,-(sp)
	jsr	pc,_movbyte
	mov	(sp)+,r0
	tst	(sp)+
	rts	pc


/ GETCON()
/ gets a constant (2 bytes) from the
/ input stream, and returns its value

	.globl	_getcon
_getcon:
	mov	$2,-(sp)
	mov	$tb,-(sp)
	jsr	pc,_movbyte
	cmp	(sp)+,(sp)+
	mov	tb,r0
	rts	pc

/ SETUP(pointer, data)
/ places data in the object output buffer
/ this also handles the byte-flag by checking significance.

	.globl	_setup
	.globl	_bytflg,_printf,_whmod,_radout

_setup:
	mov	2(sp),r0
	mov	4(sp),r1
	tst	_bytflg
	bne	1f
	movb	r1,(r0)+
	swab	r1
	movb	r1,(r0)+
	rts	pc
1:	cmp	r1,$377
	blos	1f
	cmp	r1,$-128.
	bhis	1f
	mov	$mesg1,-(sp)
	jsr	pc,_printf
	mov	_whmod,(sp)
	jsr	pc,_radout
	mov	$mesg2,(sp)
	jsr	pc,_printf
	tst	(sp)+
	mov	2(sp),r0
	mov	4(sp),r1
1:	movb	r1,(r0)
	rts	pc

.bss

nb:	.=.+4
tb:	.=.+2

.data

mesg1:	<Illegal byte relocation in \<\0>
mesg2:	<\>\n>
	.even

.text

/ GSEARCH(int *x)
/ returns pointer to x in global-tree or nil.
/ sets up pointers for insertion

	.globl	_gsearch
	.globl	_globalhead

_gsearch:
	mov	$_globalhead,r1
	mov	r2,-(sp)
	mov	4(sp),r2
1:	mov	r1,gs
	mov	(r1),r0
	bne	2f
3:	mov	(sp)+,r2
	rts	pc
2:	cmp	(r2),(r0)
	blo	3f
	bhi	4f
	cmp	2(r2),2(r0)
	beq	3b
	bhi	4f
3:	tst	(r0)+
4:	mov	r0,r1
	add	$10,r1
	br	1b

.bss
gs:	.=.+2
.text

/ GETGLO(int *x)
/ finds global in tree- if not there, creates an entry
/ for it

	.globl	_getglo
	.globl	_getcore
_getglo:
	mov	2(sp),-(sp)
	jsr	pc,_gsearch
	tst	(sp)+
	tst	r0
	bne	1f
	mov	$14.,-(sp)
	jsr	pc,_getcore
	tst	(sp)+
	mov	2(sp),r1
	mov	r0,*gs
	mov	(r1)+,(r0)
	mov	(r1),2(r0)
1:	rts	pc


/ MOVBYTE(where, how many)
/ returns byte count

	.globl	_movbyte
_movbyte:
	mov	2(sp),r0
	mov	4(sp),r1
	sub	r1,_bcount
	bmi	1f
	mov	r2,-(sp)
	mov	_bpoint,r2
	movb	(r2)+,(r0)+
	sob	r1,.-2
	mov	r2,_bpoint
	mov	(sp)+,r2
	mov	4(sp),r0
	rts	pc
1:	add	r1,_bcount
	clr	r0
	rts	pc


/ RADCON(rad, ascii)
/ convert to ascii for output of radix-50 stuff

	.globl	_radcon
	.globl	csv,cret

_radcon:
	jsr	r5,csv
	mov	$2,(sp)
	mov	4(r5),r0
	mov	6(r5),r1
1:	mov	(r0)+,r3
	clr	r2
	div	$50,r2
	mov	r3,r4
	mov	r2,r3
	clr	r2
	div	$50,r2
	movb	ss(r2),(r1)+
	movb	ss(r3),(r1)+
	movb	ss(r4),(r1)+
	dec	(sp)
	bne	1b
	jmp	cret

.data
ss:	< abcdefghijklmnopqrstuvwxyz$. 0123456789>
	.even
.text

/ MOVB(where, count)
/ get as many of count bytes from the object file
/ record as possible. retrun coutn of ones gotten

	.globl	_movb
	.globl	_objbuf

_movb:	tst	_objbuf
	bpl	1f
	clr	r0
	rts	pc
1:	mov	r2,-(sp)
	mov	4(sp),r1
	mov	6(sp),r2
2:	mov	_objbuf+4,r0
	sub	r2,_objbuf+2
	bmi	1f
	movb	(r0)+,(r1)+
	sob	r2,.-2
	mov	r0,_objbuf+4
3:	mov	(sp)+,r2
	mov	4(sp),r0
	rts	pc
1:	add	_objbuf+2,r2
	beq	1f
	movb	(r0)+,(r1)+
	sob	r2,.-2
1:	mov	_objbuf+2,r2
	neg	r2
	mov	$_objbuf+6,_objbuf+4
	mov	_objbuf,r0
	sys	read; _objbuf+6; 512.
	mov	r0,_objbuf+2
	bne	2b
	mov	_objbuf,r0
	sys	close
	mov	r1,-(sp)
	jsr	pc,_opn_next
	mov	(sp)+,r1
	tst	r0
	bne	2b
	sub	r2,6(sp)
	br	3b

	.globl	_opn_next, _bcount, _bpoint, _binbuf

/ SLEWTO(acceptable type)
/ skip input records until exhausted ro one of acceptable
/ type is found.

	.globl	_slewto

_slewto:
	mov	$6,-(sp)
	mov	$cc,-(sp)
	jsr	pc,_movb
4:	tstb	cc			/ extra byte?
	bne	4f			/ no
	mov	(sp)+,r0		/ shift down
	mov	$5,r1
	movb	1(r0),(r0)+		/ one byte
	sob	r1,. -4
	mov	$1,(sp)		/ new count
	mov	$cc+5,-(sp)
	jsr	pc,_movb
	mov	$cc,(sp)
	br	4b
4:	cmp	(sp)+,(sp)+
	cmp	cc+4,2(sp)
	beq	1f		/ join getrec code
	mov	cc+2,r1		/ skip count
	sub	$5,r1		/ include check-sum
2:	sub	r1,_objbuf+2	/ in this record?
	bmi	3f		/ no
	add	r1,_objbuf+4	/ update pointer
	br	_slewto		/ next one
3:	mov	_objbuf+2,r1	/ rubber count
	neg	r1
	mov	$_objbuf+6,_objbuf+4
	mov	_objbuf,r0
	sys	read; _objbuf+6; 512.
	mov	r0,_objbuf+2
	br	2b

/ GETREC()
/ get next object record

	.globl	_getrec
_getrec:
	mov	$6,-(sp)
	mov	$cc,-(sp)
	jsr	pc,_movb
4:	tstb	cc
	bne	4f
	mov	(sp)+,r0
	mov	$5,r1
	movb	1(r0),(r0)+
	sob	r1,.-4
	mov	$1,(sp)
	mov	$cc+5,-(sp)
	jsr	pc,_movb
	mov	$cc,(sp)
	br	4b
4:	cmp	(sp)+,(sp)+
	tst	r0
	bne	1f
	rts	pc
1:	mov	cc+2,r0
	sub	$6,r0
	mov	r0,_bcount
	inc	r0
	mov	r0,-(sp)
	mov	$_binbuf,-(sp)
	jsr	pc,_movb
	mov	(sp)+,_bpoint
	tst	(sp)+
	mov	cc+4,r0
	rts	pc

.bss
cc:	.=.+6
.text


/ OBJWRITE(type, offset, buffer, count)
/ master routine to direct output to object file
/ type	has values:
/	-1		initialize
/	0		text segment
/	1		data segment
/	2		symbol segment
/	3		magic header & close-up

/ The algorithm is roughly as follows:
/ there are three buffers, each with a 512. byte
/ buffer space, and a two word header containing their
/ disk file block number (BN) and usage count (UC).
/ on a write, a buffer is sought with the same block
/ number as is needed. If one is found, it is used.
/ Otherwise, the least used buffer is purged, and
/ converted to a buffer for that Block number.
/ Lots of pointers are kept to minimize the number
/ of unnecessary reads that must be done on paging.

	.globl	_objwrite

	.globl	_ofd
	.globl	_txtsize,_datsize,_symcount

.data

bth:	-1; -1; -1
hb:	-1
os:	0; 20;    0; 20;    0; 0;     0; 0

.bss

bpool:	.=.+[3*516.]
bt:	.=.+4
_ofd:	.=.+2

.text

_objwrite:
	jsr	r5,csv		/get some registers
	mov	4(r5),r4	/ type code
	bpl	1f		/ real write
	mov	$os+10,r2	/ initialize
	add	_txtsize,-2(r2)
	adc	-4(r2)
	add	_datsize,2(r2)
	adc	(r2)+
	add	-4(r2),(r2)
	adc	-(r2)
	add	-4(r2),(r2)+
	mov	(r2),r1
	mov	-(r2),r0
	div	$512.,r0
	mov	r0,bt+2
	add	r0,bth+4
	mov	-(r2),r1
	mov	-(r2),r0
	div	$512.,r0
	mov	r0,bt
	add	r0,bth+2
	com	bpool
	com	bpool+516.
	com	bpool+516.+516.
	jmp	cret

1:	asl	r4		/ into long index
	asl	r4		/ for o_ffs_et table
	mov	6(r5),r1	/ get offset
	mov	os(r4),r0	/ high order
	add	os+2(r4),r1	/ plus natural one
	adc	r0
	div	$512.,r0	/ block number
	mov	r0,r3		/ into r3
	mov	r1,r4		/ byte offset into r4

4:	mov	$bpool,r2	/ get buffer pointer
	cmp	(r2)+,r3	/ BN's match?
	beq	1f		/ yes
	dec	(r2)+
	add	$512.,r2
	cmp	(r2)+,r3
	beq	1f		/ yes
	dec	(r2)+
	add	$512.,r2
	cmp	(r2)+,r3
	beq	1f
	dec	(r2)
	tst	-(r2)

	mov	r2,r1		/ point to a buffer
2:	tst	(r2)		/ look for buffers not in use
	bmi	2f		/ shown by BN = -1
	cmp	2(r2),2(r1)	/ find minimum usage count
	bge	3f		/ not here
	mov	r2,r1		/ new minimum

3:	sub	$516.,r2	/ back up a buffer
	cmp	r2,$bpool	/ through all of them?
	bhis	2b		/ not yet
	mov	r1,r2		/ take the minimum one
	jsr	pc,swrite	/ flush it

2:	mov	r3,(r2)+	/ initialize a buffer
	clr	(r2)+		/ virgin UC
	cmp	r3,bt		/ see if read needed
	bge	5f		/ don't know
	cmp	r3,bth		/ compare with high water mark
	bgt	6f		/ don7t need read
	br	7f		/ need read
5:	cmp	r3,bt+2		/ ditto comments
	bge	5f
	cmp	r3,bth+2
	bgt	6f
	br	7f
5:	cmp	r3,bth+4
	bgt	6f

7:	mov	r2, objr+2
	mov	r3, objs+2

	mov	_ofd,r0;	sys	indir; objs
	mov	_ofd,r0;	sys	indir; objr

6:	tst	-(r2)

1:	mov	r2,r0		/ save pointer to UC
	inc	(r2)+		/ record usage
	add	r4,r2		/ point to next byte
	neg	r4		/ minimum of bytes left/wanted
	add	$512.,r4
	sub	r4,12(r5)	/ from count argument
	bgt	1f
	bne	.+6
	mov	$-2000.,(r0)	/ make unwanted
	add	12(r5),r4	/ plenty left
	clr	12(r5)		/ we will satisfy

1:	mov	10(r5),r1	/ address
	movb	(r1)+,(r2)+	/ into buffer
	sob	r4,.-2		/ to minimum
	tst	12(r5)		/ still need more?
	beq	1f		/ no
	mov	$-2000.,(r0)	/ make unwanted
	inc	r3		/ increment BN
	mov	r1,10(r5)	/ remember address
	br	4b		/ again

1:	cmp	4(r5),$3	/ closing shop?
	bne	1f		/ no
	mov	$bpool, r2
	jsr	pc,swrite	/ write out all buffers
	add	$516.,r2
	jsr	pc,swrite
	add	$516.,r2
	jsr	pc,swrite

	mov	_ofd,r0
	sys	close

1:	jmp	cret

swrite:	mov	(r2)+,r0	/ get block number
	bmi	1f		/ null block
	cmp	r0,bt
	bge	2f
	cmp	r0,bth
	ble	3f
	mov	r0,bth
	br	3f
2:	cmp	r0,bt+2
	bge	2f
	cmp	r0,bth+2
	ble	3f
	mov	r0,bth+2
	br	3f
2:	cmp	r0,bth+4
	ble	3f
	mov	r0,bth+4
3:	mov	r0, objs+2
	mov	_ofd,r0;	sys	indir; objs
	tst	(r2)+

5:	mov	r2,objw+2	/ buffer pointer
	mov	_ofd,r0		/ file descriptor
	sys	indir; objw	/ write it out
	mov	r2,r0		/ now zero buffer
	add	$512.,r2	/ past end
5:	clr	-(r2)		/ wipe buffer
	cmp	r2,r0		/ and
	bhis	5b		/ UC
1:	mov	$-1,-(r2)	/ not in use
	rts	pc		/ then quit

.data

objr:	sys	read; 0; 512.
objw:	sys	write; 0; 512.
objs:	sys	seek; 0; 3
objc:	sys	read; bpool+6; 512.


dbm1:	<gotten = %d\n\0>
	.even
