; The use and distribution of the information
; contained herein may be restricted.
;
title	la,<lexical analyzer>,24,19-jul-74,tph/mhb/jdm

	.csect	la

	.globl	lexan
	.globl	qzr1,perccl
	.globl	frespc,preset,maptok,tokdec,flotim

	.globl	edftch,edstor,econom,spdar0
	.globl	builds,atoi,atof,fix,savreg,resreg
	.globl	tytb,inctab,fltle2,bnt4,zarry4,tokzip
;the following macro ignores its first two arguments and
;builds the rest, in reverse order, into an ascii byte string -
;the first should always be supplied as something innocuos -
;in particular, it must not be =, which destroys the macro

	.macro	bname	protct,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q
	  .ascii  !'q'p'o'n'm'l'k'j'i'h'g'f'e'd'c'b'!
	.endm

;the following macro makes non-function entries in
;the basic permanent symbol table - a counter kept in
;bec is used to provide a unique name for each entry
;(each entry name is prefixed with qx) - next is set to 0
;in the last entry in a bucket, to 1 oterwise - name is
;the name the entry is for (in the form 
;	^"l1,l2,...,ln"
;where the li are the letters of the name) - token
;points at a three byte entry in the toketb table -
;ta is the word to be transmitted to toka

	.macro	bentry	next,name,token,ta
.list
;***********************************************************************

	 .byte	ta,token
	 bname	0,name
.nlist
	 fudge	\bec,\bec+next
	 bec=1+bec
.list

;***********************************************************************
.nlist
	.endm

;generates a table entry used for ambiguity resolution

	.macro	ambig	next,name,token
.list
;*************************************************************************

	 .byte	token
	 bname	0,name
.nlist
	 fudge	\bec,\bec+next
	 bec=bec+1
.list

;*************************************************************************
.nlist
	.endm
	.macro	eentry	next,name,token,ta
.list
;*************************************************************************

	.byte	ta,tkmore,token
	bname	0,name
.nlist
	fudge	\bec,\bec+next
	bec=bec+1
.list

;*************************************************************************
.nlist
	.globl	ta
	.endm
	.macro	fudg1	arg
	  fudg2	arg,\bec
	.endm

	.macro	fudg2	arg1,arg2
.list
qx'arg1'	=qx'arg2'
.nlist
	.endm

;the following macro makes function entries in the basic
;permanent symbol table - similar to the above 
;macro except that the word destined for toka is a pointer
;that points at (1) the push-pop code word (ppop) 
;for the function,(2) a word each two bits of which
;(from right to left) give type information 
;about the function's arguments:
;	faf -- floating
;	fai -- integer
;	fas -- string
;only three of the five function argument type slots
;(a1,a2, & a3) are included in the current macro
;definition

	.macro	fentry	next,name,token,ppop,a1,a2,a3
.list
;**********************************************************************

	 .odd
	 .byte	ppop
.nlist
	 args	a1,a2,a3
	 .byte	token
	 bname	0,name
	 fudge	\bec,\bec+next
	 bec=1+bec
.list

;**********************************************************************
.nlist
	.endm

	.macro	fudge	n1,n2
qx'n1':	  .byte	qx'n2'-.
	.endm
;when a lookup is done in the permanent symbol table, the
;"token" byte (first negative byte above name bytes)
;points relative to toketb at a three byte
;entry in the following table - the first byte of the
;entry goes into toke - the next is used to set some bits
;in the lower byte of stat - the last is used to clear
;some bits in the lower byte of stat

;interspersed throughout the table are single or double bytes
;preceding certain entries, which bytes act as dispatch addresses
;to the ambiguity resolver - in the resolver, an appropriate test
;is made to determine whether to process the symbol as built (using
;the entry following the dispatch address) or to go build a variable
qzr1:	.byte	bastok,0,ctunf+linumf
qzr2:	.byte	bastok,blinef,377-blinef
qzr3:	.byte	bastok,0,0
qzqr2:	.byte	okncun-okncnd	;xor ambiguity resolution
qzr4:	.byte	bastok,ctunf,linumf
qzqr1:	.byte	0		;for ambiguity resolution
qzr5:	.byte	bastok,ctunf,linumf+arf+harf
qzr6:	.byte	bastok,0,ctunf
qzr7:	.byte	bastok,ctunf,0
qzr8:	.byte	bastok,bstatf,linumf
qzqr6:	.byte	okncun-okncnd	;run ambiguity resolution
qzr9:	.byte	bastok,quot1f,linumf
qzqr3:	.byte	okncun-okncnd	;as,dim,stop ambig. resolution
qzr10:	.byte	bastok,0,linumf
qzr11:	.byte	bastok,harf,linumf
qzr12:	.byte	bastok,linumf,ctunf+arf+harf
qzr13:	.byte	bastok,arf,linumf
qzr14:	.byte	bastok,comf,0
qzr15:	.byte	bfs,0,linumf+ctunf
qzqr7:	.byte	oksubt-okncnd,1	;for rnd resolving
qzr16:	.byte	bff,0,linumf+ctunf
qzr18:	.byte	bfi,0,linumf+ctunf
qzqr5:	.byte	oksubt-okncnd,3	;pi ambig. resolution
qzr17:	.byte	dflt,0,varc	;"vars"=0
qzqr4:	.byte	brtbt6-okncnd	;if,pi,tan ambig. resolution
qzr19:	.byte	dint,0,varc	;"vars"=0
toketb:
bec=1			;basic entry counter
	fudg1	end
	bentry  0,,qzr2-toketb,27		;endchr
	fudg1	bm
	bentry  0,-,qzr7-toketb,3		;binary -
	fudg1	ex
	bentry	0,!,qzr14-toketb,200		;exclamation mark
	fudg1	lb
	bentry  0,#,qzr5-toketb,44
	fudg1	amp
	bentry	0,&,qzr4-toketb,134		;& equal print
	fudg1	lpa
	bentry  0,(,qzr5-toketb,24
	fudg1	rpa
	bentry  0,),qzr1-toketb,25
	fudg1	star
	bentry	1,^"*,*",qzr4-toketb,5		;uparrow, fortran style
	bentry  0,*,qzr4-toketb,1
	fudg1	plus
	bentry  0,+,qzr4-toketb,0
	fudg1	coma
	bentry  0,,qzr7-toketb,26		;comma
	fudg1	um
	bentry  0,-,qzr3-toketb,4		;unary -
	fudg1	slas
	bentry  0,/,qzr4-toketb,2
	fudg1	col
	bentry  0,,qzr8-toketb,43		;colon
	fudg1	semi
	bentry  0,,qzr4-toketb,30		;semi-colon
	fudg1	lt
	bentry  1,^"^%<%,>",qzr4-toketb,15
	bentry  1,^"^%<%,=",qzr4-toketb,21
	bentry  0,^"^%<%",qzr4-toketb,20
	fudg1	eq
	bentry  1,^"=,=",qzr4-toketb,22
	bentry  0,=,qzr4-toketb,14
	fudg1	gt
	bentry  1,^">,=",qzr4-toketb,17
	bentry  0,>,qzr4-toketb,16
	fudg1	a
	fentry  1,^"a,b,s",qzr16-toketb,ppabsf,faf
	bentry  1,^"a,n,d",qzr4-toketb,6
	bentry	1,^"a,p,p,e,n,d",qzr9-toketb,tkapnd
	fentry	1,^"a,s,c,i,i",qzr18-toketb,ppasc,fas
	bentry	1,^"a,s,f,i,l,e",qzr4-toketb,303
	fentry  1,^"a,t,n",qzr16-toketb,ppatan,faf
	bentry  0,^"a,s",qzqr3-toketb,317
	fudg1	b
	fentry	1,^"b,u,f,s,i,z",qzr18-toketb,ppbufn,faf
	bentry  0,^"b,y,e",qzr10-toketb,112
	fudg1	c
	eentry	1,^"c,c,o,n,t",qzr1-toketb,tkccon
	bentry  1,^"c,h,a,n,g,e",qzr11-toketb,130
	fentry	1,^"c,h,r,$",qzr15-toketb,ppchr,faf
	bentry  1,^"c,l,o,s,e",qzr4-toketb,174
	bentry  1,^"c,o,m,p,i,l,e",qzr9-toketb,106
	bentry	1,^"c,o,n,t",qzr1-toketb,46
	bentry  1,^"c,o,n",qzr10-toketb,311
	bentry	1,^"c,o,u,n,t",qzr4-toketb,324
	fentry	1,^"c,v,t,%,$",qzr15-toketb,ppcvis,fai
	fentry	1,^"c,v,t,f,$",qzr15-toketb,ppcvfs,faf
	fentry	1,^"c,v,t,$,%",qzr18-toketb,ppcvsi,fas
	fentry	1,^"c,v,t,$,f",qzr16-toketb,ppcvsf,fas
	fentry	1,^"c,v,t,$,$",qzr15-toketb,ppcvss,fas,faf
	fentry	1,^"c,o,s",qzr16-toketb,ppcos,faf
	bentry  0,^"c,h,a,i,n",qzr10-toketb,176
	fudg1	d
	bentry  1,^"d,a,t,a",qzr9-toketb,156
	fentry	1,^"d,a,t,e,$",qzr15-toketb,ppdat$,faf
	bentry  1,^"d,e,f",qzr10-toketb,140
	bentry  1,^"d,e,l,e,t,e",qzr12-toketb,54
	.byte	det,377				;address of determinant
	ambig	1,^"d,e,t",qzr17-toketb
	bentry  0,^"d,i,m",qzqr3-toketb,136
	fudg1	e
	bentry  1,^"e,l,s,e",qzr12-toketb,301
	bentry  1,^"e,n,d",qzr10-toketb,166
	bentry	1,^"e,q,v",qzr4-toketb,13
	.byte	valerr,377			;address of erl's value
	ambig	1,^"e,r,l",qzr19-toketb
	.byte	errval,377			;address of err's value
	ambig	1,^"e,r,r",qzr19-toketb
	fentry  0,^"e,x,p",qzr16-toketb,ppexp,faf
	fudg1	f
	bentry	1,^"f,i,e,l,d",qzr4-toketb,230
	fentry	1,^"f,i,x",qzr16-toketb,ppfixf,faf
	bentry	1,^"f,n,e,n,d",qzr10-toketb,212
	bentry	1,^"f,o,r,i,n,p,u,t,a,s,f,i,l,e",qzr4-toketb,315
	bentry	1,^"f,o,r,o,u,t,p,u,t,a,s,f,i,l,e",qzr4-toketb,316
	bentry	1,^"f,i,l,e,s,i,z,e",qzr4-toketb,325
	bentry	0,^"f,o,r",qzqr1-toketb,146
	fudg1	g
	bentry	1,^"g,e,t",qzr4-toketb,224
	bentry	1,^"g,o,s,u,b",qzr12-toketb,210
	bentry	0,^"g,o,t,o",qzr12-toketb,142
	fudg1	i
	bentry	1,^"i,d,n",qzr10-toketb,310
	ambig	1,^"i,f,o,r",qzqr4-toketb
	bentry	1,^"i,f",qzr5-toketb,144
	bentry	1,^"i,m,p",qzr4-toketb,12
	bentry	1,^"i,n,p,u,t,l,i,n,e",qzr4-toketb,214
	bentry	1,^"i,n,p,u,t",qzr4-toketb,132
	fentry	1,^"i,n,s,t,r",qzr18-toketb,ppinst,faf,fas,fas
	fentry	1,^"i,n,t",qzr16-toketb,ppintf,faf
	bentry	1,^"i,n,v,[",qzr4-toketb,313
	bentry	0,^"i,n,v,(",qzr4-toketb,313
	fudg1	k
	bentry	0,^"k,i,l,l",qzr10-toketb,222
	fudg1	l
	fentry	1,^"l,e,f,t",qzr15-toketb,ppleft,fas,faf
	bentry	1,^"l,e,n,g,t,h",qzr10-toketb,56
	fentry	1,^"l,e,n",qzr18-toketb,pplen,fas
	bentry	1,^"l,s,e,t",qzr4-toketb,232
	bentry	1,^"l,e,t",qzr10-toketb,154
	.byte	curlin,377
	ambig	1,^"l,i,n,e",qzr19-toketb
	bentry	1,^"l,i,s,t,n,h",qzr12-toketb,52
	fentry	1,^"l,o,g,1,0",qzr16-toketb,pplg10,faf
	fentry	1,^"l,o,g",qzr16-toketb,ppln,faf
	bentry	0,^"l,i,s,t",qzr12-toketb,50
	fudg1	m
	bentry	1,^"m,o,d,e",qzr4-toketb,321
	bentry	1,^"m,a,t",qzr13-toketb,126
	fentry	0,^"m,i,d",qzr15-toketb,ppsbs1,fas,faf,faf
	fudg1	n
	bentry	1,^"n,a,m,e",qzr10-toketb,204
	bentry	1,^"n,e,w",qzr9-toketb,60
	bentry	1,^"n,e,x,t",qzr10-toketb,202
	bentry	1,^"n,o,t",qzr4-toketb,11
	fentry	1,^"n,u,m,$",qzr15-toketb,ppnum,faf
	.byte	nv2,377				;address of num2
	ambig	1,^"n,u,m,2",qzr19-toketb
	.byte	nv1,377				;address of num
	ambig	0,^"n,u,m",qzr19-toketb
	fudg1	o
	bentry	1,^"o,l,d",qzr9-toketb,62
	bentry	1,^"o,n,e,r,r,o,r,g,o,t,o",qzr12-toketb,170
	bentry	1,^"o,n",qzr4-toketb,150
	bentry	1,^"o,p,e,n",qzr10-toketb,172
	bentry	0,^"o,r",qzr4-toketb,7
	fudg1	p
	.byte	picon,377			;address of pi
	ambig	1,^"p,i,f,o,r",qzqr5-toketb
	ambig	1,^"p,i,f",qzqr4-toketb
	.byte	picon,377			;address of pi
	ambig	1,^"p,i",qzr17-toketb
	fentry	1,^"p,o,s",qzr18-toketb,pppos,faf
	bentry	1,^"p,u,t",qzr4-toketb,226
	bentry	0,^"p,r,i,n,t",qzr4-toketb,134
	fudg1	r
	fentry	1,^"r,a,d,$",qzr15-toketb,pprad$,faf
	bentry	1,^"r,a,n,d,o,m,i,z,e",qzr10-toketb,124
	bentry	1,^"r,a,n,d,o,m",qzr10-toketb,124
	bentry	1,^"r,e,a,d",qzr10-toketb,206
	bentry	1,^"r,e,c,o,r,d,s,i,z,e",qzr4-toketb,320
	bentry	1,^"r,e,c,o,r,d",qzr4-toketb,323
	.byte	recoun,377			;address of record count
	ambig	1,^"r,e,c,o,u,n,t",qzr19-toketb
	bentry	1,^"r,s,e,t",qzr4-toketb,234
	bentry	1,^"r,e,m",qzr14-toketb,200
	bentry	1,^"r,e,n,a,m,e",qzr9-toketb,64
	bentry	1,^"r,e,p,l,a,c,e",qzr9-toketb,66
	bentry	1,^"r,e,s,t,o,r,e",qzr10-toketb,160
	bentry	1,^"r,e,s,u,m,e",qzr12-toketb,162
	bentry	1,^"r,e,t,u,r,n",qzr10-toketb,152
	fentry	1,^"r,i,g,h,t",qzr15-toketb,ppsbst,fas,faf
	fentry	1,^"r,n,d,[",qzqr7-toketb,pprnd,faf
	fentry	1,^"r,n,d,(",qzqr7-toketb,pprnd,faf
	fentry	1,^"r,n,d",qzr16-toketb,pprnd,0
	bentry	1,^"r,u,n,n,h",qzr9-toketb,72
	bentry	0,^"r,u,n",qzqr6-toketb,70
	fudg1	s
	bentry	1,^"s,a,v,e",qzr9-toketb,76
	eentry	1,^"s,c,a,l,e",qzr1-toketb,tkscal
	bentry	1,^"s,h,e,l,l",qzr10-toketb,tkshel
	bentry	1,^"s,l,e,e,p",qzr4-toketb,tkslep
	fentry	1,^"s,g,n",qzr16-toketb,ppsgnf,faf
	fentry	1,^"s,i,n",qzr16-toketb,ppsin,faf
	fentry	1,^"s,p,a,c,e,$",qzr15-toketb,ppspac,faf
	fentry	1,^"s,q,r",qzr16-toketb,ppsqrt,faf
	fentry	1,^"s,w,a,p,%",qzr18-toketb,ppswap,faf
	.byte	status,377			;address of status's value
	ambig	1,^"s,t,a,t,u,s",qzr19-toketb
	bentry	1,^"s,t,e,p",qzr4-toketb,302
	bentry	1,^"s,t,o,p",qzqr3-toketb,164
	fentry	1,^"s,t,r,i,n,g,$",qzr15-toketb,ppstng,faf,faf
	fentry	0,^"s,y,s",qzr15-toketb,ppuuo,fas
	fudg1	t
	fentry	1,^"t,a,b",qzr15-toketb,pptab,faf
	ambig	1,^"t,a,n,d",qzqr4-toketb
	fentry	1,^"t,a,n",qzr16-toketb,pptan,faf
	bentry	1,^"t,h,e,n",qzr12-toketb,300
	fentry	1,^"t,i,m,e,$",qzr15-toketb,pptim$,faf
	fentry	1,^"t,i,m,e",qzr16-toketb,pptime,faf
	bentry	1,^"t,o",qzr4-toketb,314
	bentry	1,^"t,r,n,[",qzr4-toketb,312
	bentry	0,^"t,r,n,(",qzr4-toketb,312
	fudg1	u
	bentry	1,^"u,n,l,e,s,s",qzr5-toketb,305
	bentry	1,^"u,n,s,a,v,e",qzr9-toketb,102
	bentry	1,^"u,n,l,o,c,k",qzr4-toketb,236
	bentry	1,^"u,s,i,n,g",qzr4-toketb,306
	bentry	0,^"u,n,t,i,l",qzr5-toketb,220
	fudg1	v
	fentry	0,^"v,a,l",qzr16-toketb,ppval,fas
	fudg1	w
	bentry	1,^"w,a,i,t",qzr4-toketb,tkwait
	bentry	0,^"w,h,i,l,e",qzr5-toketb,216
	fudg1	x
	fentry	1,^"x,l,a,t,e",qzr15-toketb,ppxlte,fas,fas
	bentry	0,^"x,o,r",qzqr2-toketb,10
	fudg1	z
	bentry	0,^"z,e,r",qzr10-toketb,307
	fudg1	upar
	bentry	0,,qzr4-toketb,5		;uparrow
qxlast=.
	.even
;this table dispatches the permanent 
;symbol table - the self-relative address of
;the first entry beginning with, say, x is
;located at pertab+2*('x-'(space)) - an entry
;has the form:
;	1-byte self-relative address of next ent beg with x
;	2nd thru last chars of entry name
;	dispatch token into toketb table
;	1 byte or word of token for toka
;	other bytes of data as required (usually none)
;any time the pointer to a table entry is 0,
;that entry does not exist

perbas=pertab-endchr-endchr	;base address of perm symbol table biased by endchr

pertab:	.word	qxend-.		;endchr
	.word	0		;bumchr
	.word	qxbm-.		;binary -
	.word	0		;space
	.word	qxex-.		;!
	.word	0		;"
	.word	qxlb-.		;#
	zskip	2		;$ thru %
	.word	qxamp-.		;&
	.word	0		;'
	.word	qxlpa-.		;(
	.word	qxrpa-.		;)
	.word	qxstar-.	;*
	.word	qxplus-.	;+
	.word	qxcoma-.	;comma
	.word	qxum-.		;unary -
	.word	0		;period
	.word	qxslas-.	;/
	zskip	10.		;0 thru 9
	.word	qxcol-.		;colon
	.word	qxsemi-.	;semi-colon
	.word	qxlt-.		;<
	.word	qxeq-.		;=
	.word	qxgt-.		;>
	zskip	2		;? thru @
	.word	qxa-.		;a
	.word	qxb-.		;b
	.word	qxc-.		;c
	.word	qxd-.		;d
	.word	qxe-.		;e
	.word	qxf-.		;f
	.word	qxg-.		;g
.word 0;	.word	qxh-.		;h
	.word	qxi-.		;i
	.word	0		;j
	.word	qxk-.		;k
	.word	qxl-.		;l
	.word	qxm-.		;m
	.word	qxn-.		;n
	.word	qxo-.		;o
	.word	qxp-.		;p
	.word	0		;q
	.word	qxr-.		;r
	.word	qxs-.		;s
	.word	qxt-.		;t
	.word	qxu-.		;u
	.word	qxv-.		;v
	.word	qxw-.		;w
	.word	qxx-.		;x
	.word	0		;y
	.word	qxz-.		;z
	.word	qxlpa-.		;[ (equivalent to ()
	.word	qxcol-.		;\ (equivalent to :)
	.word	qxrpa-.		;] (equivalent to ))
	.word	qxupar-.	;uparrow
	.word	0		;backarrow
lexan:	mov	r1,r1ring	;save r1 in a readily accessible place
	jsr	r5,savreg	;save r0-r5
	mov	spda,r0		;ro_base address
	mov	stat(r0),r4	;set r4 to status word
	jmask0	eq,r4,blinef,lex1	;beg of line?
	bis	#blins,r4	;yes-set & clr status flags
lex4:	jmask0	eq,r4,quot1f,lex7	;fill the buffer if quot1f is off
	bic	#blinef+blinc-immedf,r4  ;othws, pretend we're in middle of line
	br	lex6		;avoid clearing immedf flag

lex7:	bic	#blinc,r4
lex6:	jsr	pc,fillex	;fill lexical buffer
	bic	#quotf,r4	;make sure quotf flag off
lex1:	jmask0	eq,r4,bstatf,lex2	;beg of statement?
	bis	#bstas,r4	;set & clr status flags
	bic	#bstac,r4
lex2:	mov	clb(r0),r5	;r5_cur lex beg ptr
	add	r0,r5		;bias
	if  (r5),eq,#bumchr,lex6,b  ;get next subline if char a lf
	mov	r4,stat(r0)	;set status from r4
	ifsign  r4,pl,strtim,b	;in a comment?
	if  (r5),ne,#endchr,lex5,b  ;br and skip char if not endchr
	jmp	tabtim		;othws - go look it up

lex5:	inc	clb(r0)		;set up char skip
	br	lex2		;go look at next char
;here we're looking for a string - maybe

strtim:	movb	(r5),r2		;r2_cur first char of lex buffer
	jsr	pc,qtest	;set and clr quotf & quot1f as appropriate
	beq	numtim		;quotf or quot1f set?
;build the string - keeping r4 clean, because it has the status bits
	jmask0	ne,r4,quot1f,str2  ;yes - br if quot1f set
	inc	r5		;yes - skip quote symb in lex buf
str2:	sub	r0,r5		;unbias r5
	jsr	pc,frespc	;r3 _ addr lowest item in heaser area
	mov	r3,r2		;save in r2
	mov	#256.,r3	;make sure there's room for 256 chars
	mov	r1ring,r1	;restore legal stack pointer
	jsr	pc,builds	;build a string on the r1 stack
	add	r0,r2		;bias new header addr+6
	mov	r2,r1		;now make believe its in the r1 stack area
	add	r0,r5		;bias r5
str4:	movb	(r5)+,r2	;get next char for string
	jsr	pc,qtest	;test quote situation
	beq	str5		;branch if done
	movb	r2,(r3)+	;othws, transfer next char to string
	br	str4		;around again

str5:	sub	r0,r5		;unbias r5
	if	r2,eq,unquot(r0),str3,b  ;builds done - branch if r2 the official unquote
	dec	r5		;it isn't so back up lex ptr
str3:	jsr	pc,@(sp)+	;finish up in builds
	mov	r5,(sp)		;replace non-ipc with clb for fixup at tabt2
	mov	#dstr,toke(r0)	;set string data token
	mov	r1,r3		;pointer to would-be string header
	jsr	pc,lished	;put it on header list
	br	tabt7		;exit sequence
;at this point begins the code for processing
;numbers, including line numbers

numtim:	jsr	pc,nmscan	;fix up strings of leading signs & test for number
	jmask0	eq,r4,numbf,tabtim  ;number?
	mov	#fltint,toke(r0)  ;yes - set toke to integer token
	jsr	pc,frespc	;r3_addr lowest byte of table & header area
	mov	r3,r1		;set dummy r1 stack pointer
	mov	clb(r0),r2	;r2_beg of num in lex buffer
	add	r0,r1		;bias r1 & r2
	add	r0,r2
	jmask0	eq,r4,linumf,bnt3  ;br if not possible line number
	jsr	pc,atoi		;try to build an integer
	br	bnt1		;process as the integer it is

bnt3:	jsr	pc,atof		;try to build floating number
	bvc	bnt1		;br if floater o.k.
	post,	pstflt		;othws, post floating error
bnt1:	mov	spda,r0		;reset base register
	mov	r4,r3		;have another use for r4
	mov	stat(r0),r4	;r4 _ status flags
	movb	(r2),r5		;save char following number in r5
	sub	r0,r2		;unbias r2
	mov	r2,clb(r0)	;save beg lex ptr
	if  r5,ne,#'%,bnt2	;branch if num not followed by %
	inc	clb(r0)		;otherwise, skip over %
	bic	#convff,r4	;no more automatic conversion to floating
	br	intim		;and force integer conversion

bnt2:	jmask0	ne,r4,linumf,intim
	jmask0	ne,r3,dotf+expn,flotim  ;decimal pt or exp in number?
	jsr	pc,bnt4			;check for possible integer
	jmask0	eq,r4,outexf+convff,intim  ;integer if inside tlcomf & convff off
;at this point weare processing a floating pt number

flotim:	swab	toke(r0)	;toke _ floating data token
	mov	#onecon,r5	;r5 _ addr floating one
	mov	r5,r3		;ditto r3 - just in case
	add	r0,r5		;bias r5
	mov	r1,r2		;r2 _ addr current floating number
	sub	#fltle2,r2	;point to end+2 of it
	sub	#fltle2,r5	;ditto
flot2:	cmp	-(r2),-(r5)	;the same?
	bne	flot1		;no
	cmp	r2,r1		;done comparing?
	bne	flot2		;not yet
	br	tabt4		;it is a floating 1

flot1:	sub	r0,r1		;no - unbias r1
	mov	r1,nexfre(r0)	;update nexfre to point at lastitem
	br	tabt3		;exit

;at this point we are processing an integer
intim:	jmask0	ne,r4,linumf,intim1
	jsr	pc,fix		;convert number to integer format
	br	flot1

intim1:	ifzero	le,(r1),flot1	;is number nonnegative and nonzero?
	mov	#linum,toke(r0)	;if so, set line number token
	mov	(r1),r1		;standing in for toka, r1_actual line number
	;bis	#lins,r4	;set & clr status for line number
	bic	#linc,r4
	br	lexex		;exit

;this part of the main routine is reached if
;the current lexical item must be looked up
;in the permanent or variable symbol table - it
;is first looked up in the permanent symbol table -
;if not found there, it is checked to see if it is
;a well-formed variable name - then checked against
;the variable symbol table & added to it if not
;already found there

tabtim:	jsr	pc,ccl		;check for ccl first
	mov	#perbas,r4	;r4_addr perm symb table
	jsr	pc,lookup	;look up symbol
	br	persym		;br if symbol found
tabt6:	jsr	pc,decvar	;decode symbol as variable name
	mov	#vartab-'a-'a,r4;r4_addr var symb table
	add	r0,r4		;bias r4
	jsr	pc,lookup	;look up symbol
tabt0:	br	varsym		;br if symbol found
	sub	r0,r3		;unbias r3
tabt1:	jsr	pc,addvar	;if not add to var table
tabt2:	mov	stat(r0),r4	;r4 _ stat
tabt7:	mov	(sp)+,clb(r0)	;advance lex ptr to new value stored on stack by decvar
tabt4:	mov	r3,r1		;toka_addr new value
tabt3:	;bis	#vars,r4	;set & clr status bits
	bic	#varc,r4
tabt5:	jmask0  eq,toke(r0),intgf,lexex  ;lex item an integer variable?
	bic	#convff,r4	;yes - turn off convert to floating flag
lexex:	mov	r1,toka(r0)	;set toka & stat from registers
	mov	r4,stat(r0)
	jsr	r5,resreg	;restore r0-r5
	mov	r1ring,r1	;update r1 stack pointer
	jmp	read0		;spda to r0, rts pc

varsym:	if  r5,eq,(sp),vars1	;br if whole variable name scanned
	add	r0,r5		;bias r5, pointer to next lex char
	if  (r5),ne,toke+1(r0),vars1,b  ;br if whole variable name scanned
	mov	#tabt0,-(sp)	;othws, not true match - dummy return
	br	look1		;	to tabt0 & continue at look1

vars1:	jsr	r1,tmatch	;check tokens
	br	tabt1		;no match-add entry to subtable
	jsr	pc,tokdec	;match-r3_addr of value
	br	tabt2
persym:	mov	stat(r0),r4	;r4 _ status bits for lex analyzer
	movb	(r3),r1		;token used to point r1 into toketb table
	add	#toketb,r1
	ifsign	(r1),pl,resolv,b  ;if toketb token pos, resolve ambiguity
pers1:	mov	r5,clb(r0)	;othws, advance lex ptr to next token
perccl:	movb	(r1)+,toke(r0)	;set token byte
	bisb	(r1)+,r4	;set status bits for symb
	bicb	(r1),r4		;clr status bits for symb
	clr	r1		;no - set rest of token
	bisb	-(r3),r1	;set r1 - r1 is standing in for toka
	movb	-1(r3),xxmore	;save in case of more...
	if  toke(r0),eq,#bastok,lexex,b  ;br if garden variety basic token
	bgt	pers2		;br if system function
	swab	r1		;must be pi or something like that
	bisb	-(r3),r1	;set low byte
	br	tabt5		;exit

pers2:	cmpb	-(r3),-(r3)	;dec perm symb table pointer by 2
	mov	r3,r1		;and return ptr in toka - eventually
	br	tabt5

resolv:	movb	(r1)+,r2	;dispatch to appropriate resolution
	add	r2,pc		;	routine
okncnd:	ifzero	eq,tlcofl(r0),pers1,b  ;symbol o.k. if not inside conditional compilation
okncun:	jmask0	eq,r4,ctunf,pers1  ;symbol o.k. if not in operand slot
brtbt6:	br	tabt6		;go make a variable

oksubt:	movb	(r1)+,r2	;we've gone too far - back up
	sub	r2,r5
	br	pers1		;and use first part of symbol

;looks up lex buf symbol beginning at clb in symbol table
;whose base address is (r4) -
;calling sequence:
;	jsr	pc,lookup
;	success exit (2 bytes)
;	failure return
;in descending locations, table entries have the
;form:
;	1-byte or word self-relative addr of next entry
;	2nd thru last chars of symbol to be matched
;	1-byte negative quantity (may be byte for toke or ptr into toketb)
;	any number of value bytes
;if the search is successful, r3 (still
;biased) points to negative byte, and r5 (unbiased)
;points to next unmatched lex char -
;if the search is unsuccessful, r3 points to the last table entry, and
;there is a one-word skip on exit - jsr pc

lookup:	mov	clb(r0),r1	;r1_beg lex buf
	add	r0,r1		;bias
	movb	(r1)+,r2	;r2_1st char of symbol
	asl	r2
	add	r2,r4		;r4_table base+char offset
look1:	mov	r1,r5		;init lex ptr
	mov	r4,r3		;init table ptr
	if  r3,lo,#qxlast,look7  ;r3 point above permanent symbol table?

look8:	ifzero	eq,(r3),look3	;yes - table entry exist?
	add	(r3),r3		;yes - r3 _ its address
look6:	mov	r3,r4		;save ptr
look2:	ifsign  -(r3),mi,look4,b  ;char in table entry a token?
	if	(r3),eq,(r5)+,look2,b ;table char = lex char?
	br	look1		;no - try next entry

look3:	add	#2,(sp)		;skip on failure
look4:	sub	r0,r5		;unbias r5 
	bis	#tablef,stat(r0)  ;set flag for exit from lookup
	rts	pc
look7:	if	r3,lo,#toketb,look8	;if not in qx table
	ifzero	eq,(r3),look3,b	;byte compare - table entry exist?
	movb	(r3),r3		;yes - r3 _ its address
	add	r4,r3
	br	look6

;routine to immediately follow lookup in user
;symbol table - checks token in table against
;token in toke (built by decvar) - match
;complete only if tokens match - otherwise,
;searchs subtable of symbol built for
;matching token - subtable entries are:
;	1 - byte token
;	1 - byte token again if necessary to make addr even
;	1 - word self-relative addr of next subtable entry
;	any number of value words
;at exit toke contains the token and r3 (unbiased)
;points at the addr word of the last subtable
;entry - if there is a successful match,
;a word is skipped at exit - status in stat(r0) - jsr r1

tmatch:	bic	#1,r3		;dec r3 if r3 odd
tm3:	if	toke(r0),eq,(r3),tm1,b	;table token = (toke)?
	ifzero  eq,-(r3),tm2	;no - next subtable entry exist?
	add	(r3),r3		;r3 _ point at it
	br	tm3

tm1:	tst	-(r3)		;r3 _ value area + 2
	tst	(r1)+		;set skip on success
tm2:	sub	r0,r3		;unbias r3
	bic	#tablef,stat(r0)  ;unset flag for exit from tmatch
	rts	r1

;decodes variable name & checks for well-formedness-
;builds token byte of flags & stores it toke-
;if variable name contains a digit, digit is stored
;at toke+1;  otherwise token is stored at toke+1
;as well as at toke - this fact allows table
;building trick in addvar - if var a fn-var, fn-prefix
;ignored & clb incremented past it = at exit,
;top stack entry points to next logical lex item following
;variable name - destroys r4,r2,r3,r5-
;jsr pc

decvar:	mov	clb(r0),r5	;set lex ptr
	add	r0,r5		;bias
	clr	r4		;clr token
	clr	r3		;used as flag
	bis	#tokf+floatf,r4	;set token & floating flags
	movb	(r5)+,r2	;r2 _ 1st char
	if	r2,ne,#'f,dec1,b  ;poss fn-name?
	movb	(r5)+,r2	;yes - get next char
	if	r2,ne,#'n,dec2,b  ;fn - name?
	bis	#funcf,r4	;yes - set fn & index bits
	add	#2,clb(r0)	;bypass fn-prefix
	movb	(r5)+,r2	;get next char
dec1:	jsr	pc,tst01
	ble	decerr		;a letter?
	movb	(r5)+,r2	;get next char
dec2:	jsr	pc,tst00
	bne	dec3		;a digit?
	cmp	(r3)+,(r3)+	;r3 _ 4, a flag
	movb	r2,toke+1(r0)	;save integer at toke+1
	movb	(r5)+,r2	;get next char
dec3:	if	r2,ne,#'%,dec4,b	;int var?
	bis	#intgf,r4	;yes - set bit
	br	dec5

dec4:	if	r2,ne,#'$,dec6,b	;string var?
	bis	#strinf,r4	;yes - set flag
dec5:	bic	#floatf,r4	;clr floating flag
	movb	(r5)+,r2	;next char
dec6:	if	r2,eq,#'(,dec7,b	;indexed?
	if	r2,eq,#'[,dec7,b	;really indexed??
	jmask0	ne,stat(r0),arf,dec7  ;no - array flag set?
	jmask0  eq,stat(r0),harf,dec8  ;no - float & int array flag set?
	jmask0  ne,r4,strinf,dec8  ;yes - string variable?
dec7:	jmask0	ne,r4,funcf,dec8  ;skip setting indexf if a function
	bis	#indexf,r4	;no - set index flag
dec8:	dec	r5		;back up lex ptr
	sub	r0,r5		;unbias
	movb	r4,toke(r0)	;toke _ token
	add	r3,pc		;skip if integer in name
	movb	r4,toke+1(r0)	;token in both bytes of toke
	jsr	r5,@(sp)+	;save ptr to next logical lex item on stack and exit
decerr:	mov	r1ring,r1	;restore r1 for error routine
	coserr	!fatal		;bad character or symbol error

;adds a variable name to the symbol table (or a new token
;to a variable name's subtable if tablef is not set) -
;at entry, r3 points to the word which must be made
;the pointer to the new entry - at exit,
;r3 points at the lowest value word - destroys r5 - jsr pc

addvar:	mov	r3,r1		;r1 _ addr ptr to new entry
	jsr	pc,frespc	;r3 _ addr last word in table area
	add	r0,r1		;bias r1 & r3
	add	r0,r3
	clr	-(r3)		;clr 1st word in new entry
	mov	r3,(r1)		;set relative pointer to
	sub	r1,(r1)		;new entry
	tst	(r3)+		;back up new entry ptr
	jmask0	eq,stat(r0),tablef,adv1	;table or subtable entry?
	tst	-(r3)		;table - skip 0 address
adv1:	mov	toke(r0),r5	;save toke in r5
	mov	r5,-(r3)	;put toke in new entry
	clr	-(r3)		;clr next subtable ent addr
	jsr	pc,tokdec	;r3 _ (r3) - size of value for name
	jmask0	eq,r5,indexf,adv3  ;br if not an array variable
	bic	#177770,r5	;save string - float - integer bits
	movb	tytb(r5),aryflg(r3)  ;set type info in array header flag byte
	mov	#10.,pdim2(r3)	;make it a nonvector initially
	jsr	pc,zarry4	;so system won't crash on immed arrays
adv3:	jmask0  eq,r5,funcf,lished;function header?
	clr	(r3)		;yes - clear 'referenced' word & fall thru 

;if a new string or array header is pointed at by r3
;and the token in toke indicates that it is indeed
;such a header, it is added to the header list -

lished:	mov	r3,-(sp)		;save r3
	mov	r5,-(sp)		;and r5
	mov	toke(r0),r5		;r5 _ token flag words
	jmask0	eq,r5,funcf,lish2	;function?
	add	#4,r3			;advance function ptr to value
lish2:	jmask0	eq,r5,strinf+indexf,lish1	;no - string or array?
lish3:	mov	r0,r1			;abs address next link
	jmask0	eq,r5,indexf,lish4	;branch if not array
	add	#aryptr,r1		;reorigin a little for array header list
lish4:	add	(r1),r0			;abs address next link
	if	r0,lo,r1corg,lish3	;drop down if next header on r1 stack
	sub	r3,r0			;next relative to new
	mov	r0,(r3)+		;deposit new link
	jmask0	ne,r5,dataf,lish5,b	;br if a data string
	clr	(r3)+			;in memorium, jws
	clr	(r3)			;clear count
lish5:	sub	r0,(r1)			;new link relative to current
	mov	spda,r0			;restore bias (+5v)
lish1:	mov	(sp)+,r5		;restore r5
	mov	(sp)+,r3		;restore r3
	sub	r0,r3			;unbias
	mov	r3,nexfre(r0)		;nexfre_ address last word of new entry
	rts	pc

;sets r3 to point at last word used in variable
;table & header space - checks to see that there are
;sufficient bytes to make a new entry - if not,
;calls the allocator - dangerous, can affect spda - jsr pc

frespc:	mov	spclim(r0),r3	;r3 _ area limit
	add	#slop,r3	;less slop
	if	r3,le,nexfre(r0),fres1  ;enough area left?
	mov	r1,-(sp)	;set up real r1
	mov	r1ring,r1	;for recycl
	jsr	r5,econom	;call storage controller
	+	hdrnom		;for str header space
	mov	(sp)+,r1	;the way they were
fres1:	mov	nexfre(r0),r3	;r3 _ addr last word used
	rts	pc
;the following routine checks for unary plus &
;minus, binary minus, and numberhood -
;moves clb past redundant signs, dummying in a
;unary minus if necessary - changes binary minus
;to bmin, a dummy char - sets numbf flag in r4
;if at number - assumes r5 (absolute) points to,
;and r2 contains,
;next lex char - destroys r2 & r5 - jsr pc

nmscan:	bic	#numbf,r4	;clr number flag
	clr	-(sp)		;clr sign flag
	jmask0	eq,r4,ctunf,nmscx4  ;convert to unary flag on?
nmsc0:	movb	(r5)+,r2	;yes - r2_cur lex char
	if  r2,eq,#'+,nmsc0,b	;unary plus?
	if  r2,ne,#'-,nmscx,b	;no - unary minus?
	com	(sp)		;yes - complement sign flag
	br	nmsc0		;go around again

nmscx:	tstb	-(r5)		;back up r5
nmscx2:	tst	(sp)+		;pop sign flag
	beq	nmscx3		;negative?
	movb	#'-,-(r5)	;yes - dummy a unary minus into lex buf
	movb	(r5),r2		;reset character
nmscx3:	if  r2,eq,#'.,nmscx1,b	;char a decimal point?
	jsr	pc,tst00	;no - 
	bne	nmscx5		;a digit?
nmscx1:	bis	#numbf,r4	;set number flag
nmscx5:	sub	r0,r5		;unbias r5
	mov	r5,clb(r0)	;adjust lex ptr
	rts	pc

nmscx4:	if  r2,ne,#'-,nmscx2,b  ;char a binary minus?
	movb	#bmin,(r5)	;yes - dummy in a special binary minus
	br	nmscx2

;fill the lexical buffer - resets clb to point
;at first char of buffer - destroys r2 -
;destroys r3 & r5 - jsr pc

fillex:	mov	#phlb,r5		;r5 _ beq of buf
	mov	r5,clb(r0)		;beg infinished buf
flx2:	jsr	pc,gchar		;r2 _ next char
	add	r0,r5			;no - bias r5
	movb	r2,(r5)			;stash char in lex buf
	mov	r5,r3			;get pointer into lex buffer
	sub	#phlb,r3		;adjust for increment and make offset
	sub	r0,r3			;rid of damned offset
	clr	r2			;high order
	div	#8.,r2			;into  byte and bit offset
	bicb	bittab(r3),bitbuf(r2)	;first clear bit
	bit	#fileff,r4		;was this originally upper case?
	beq	1$			;no
	bisb	bittab(r3),bitbuf(r2)	;yers - set corresponding  bit
1$:	movb	(r5)+,r2		;get our byte again
	sub	r0,r5			;unbias r5
	if	r2,eq,#endchr,flx1,b	;quit on endchr
	if	r5,lt,#linlen+phlb,flx3	;it's very bad if buffer overflows
	tlcntd	!fatal			;so dont let it happen

flx3:	if	r2,ne,#bumchr,flx2,b	;or lf
flx1:	rts	pc
bittab:	.byte	200,100,40,20,10,4,2,1

	global	<mupper, bitbuf>

mupper:	jsr	r5,savreg		;get some registers
	mov	#bitbuf,r0		;pointer to bit table
	mov	#phlb,r1		;pointer to real characters
	add	spda,r1			;from offset
	mov	#<linlen/8.>,r2		;number of bytes in map
1$:	mov	#8.,r3			;number of bits in byte
	movb	(r0)+,r4		;get the byte
2$:	aslb	r4			;shift out a bit
	bcc	3$			;none there
	bisb	#40,(r1)		;make it lower
3$:	inc	r1			;next byte
	sob	r3,2$			;more bits
	sob	r2,1$			;more bytes
	jsr	r5,resreg		;all done
	rts	pc			;so leave

;gets next char for lexical buffer in r2
;substitutes endchr for cr asclf, altmode, form feed & ctrl z -
;puts appropriate code in user text area for line terminators - throws
;out spaces & tabs unprotected by quotes and all other chars
;with ascii < 40, except line terminators - destroys r3 - jsr pc

gchar:	bic	#fileff,r4	;original innocence
	jsr	pc,read1	; r2 := next entry
gch9:	mov	#cheatr,r3	;set up ptr to table for byte comparisons below
	if  r2,ne,(r3)+,gch4,b	;br if char not a cr
	jsr	pc,read1	;othws - get next char
	if  r2,ne,(r3)+,gch9,b	;br if not a lf
	cmp	(r3)+,(r3)+	;othws - advance r3 by 4 chars
	br	gch7		;and terminate line

gch4:	if  r2,ne,(r3)+,gch2,b	;br if char not a lf
	jsr	pc,edsore	;store it in user text area
	mov	#cheat2,r3	;advance cheat table pointer
gch7:	movb	(r3)+,r2	;get next char
	jsr	pc,edsore	;store away
	movb	(r3)+,r2	;get next char
	jsr	pc,edsore	;store away
	movb	(r3)+,r2	;get char to return
	br	gch3		;return it

gch2:	if  r2,eq,(r3)+,gch5,b	;char an altmode?
	if  r2,eq,#014,gch5,b	;char form feed?
	if  r2,ne,(r3)+,gch6,b	;no - a control  z?
gch5:	jsr	pc,edsore	;put line terminator in user text area
	movb	#endchr,r2	;return endchr
gch3:	rts	pc
gch6:	jsr	pc,qtest		;no - test for quote & unquote
	bpl	gch1			; not quotf
	if	r2,his,(r3)+,gch3,b	;leave spaces and above in quoted strings
	if	r2,eq,#tab,gch3,b	;don't duplicate tabs
	if	r2,lo,(r3)+,edsore,b	;send back unfiltered control chars
gch1:	if	r2,los,#space,gchar,b	;no quote, we never send back controlees, etc
	if	r2,lo,#140,gch3		;nor lower case letters
	bit	#quot1f,r4		;In this case don't convert
	bne	gch3			;to upper case
	bis	#fileff,r4		;we made it upper
	bic	#40,r2			;without making them uppers
	br	gch3			;send char thru


;table of bytes used in comparisons in gchar

cheatr:	.byte	cr
	.byte	asclf
	.byte	alt
	.byte	ctrz
	.byte	space
	.byte	endchr
	.byte	cr
	.byte	asclf
	.byte	endchr
cheat2:	.byte	cr
	.byte	0
	.byte	bumchr
	.even
;gets a char into r2 - also stores it in text
;area unless a line or subline terminator or line for immediate execution -
;at beg of line, ignores chars whose ascii <= 40
;expects status in r4 and r1 stack ptr in r1 (where else?) -
;destroys r3 - jsr pc

read1:	jsr	pc,edftch	;r1 stack gets incoming char
	mov	(r1)+,r2	;save char in r2
	bic	#200,r2		;get rid of sign bit to be safe
	jmask0	ne,r4,blinef,read3	;br if at beg of line
read4:	if  r2,eq,#tab,edsore,b	;send out tabs if they're around
	if  r2,lo,#space,read0,b  ;but no other low guys
edsore:	jmask0	ne,r4,immedf,read0  ;br if immed line
	jsr	pc,edstore	;put char in text *** r1 must be stack ptr for edstore
read0:	jmp	spdar0		;spda to r0, rts pc

read3:	if  r2,los,#space,read1,b  ;spaces & controlees out at beg of line
	bic	#blinef,r4	;no - kill beg line flag
	jsr	pc,tst00
	beq	read4		;char a digit?
	bis	#immedf,r4	;no - set immediate flag
	br	read0
;sets and unsets quotf & quot1f (the quote flags) in the obvious
;way depending on the char in r2 - sets n on quotf -
;and clrs z on quotf or quot1f - assumes status in r4 - jsr pc

qtest:	ifsign r4,mi,qtst1	;quotf flag set?
	if	r2,eq,#quote,qtst2,b	;no-char a quote?
	if	r2,ne,#apos,qtst6,b	;no-an apostrophe?
qtst2:	movb	r2,unquot(r0)		;yes-save char to unquote
	bis	#quotf,r4		;set quotf
	br	qtst3

qtst1:	if	r2,eq,unquot(r0),qtst5,b	;char the unquote char?
qtst6:	if  r2,eq,#bumchr,qtst4,b  ;br if at end of subline
	if	r2,ne,#endchr,qtst3,b	;no-a endchr?
qtst4:	bic	#quot1f,r4	;yes clr quotif
qtst5:	bic	#quotf,r4		;clr quotf
qtst3:	bit	#quotf+quot1f,r4  ;set n on quotf, clr z on quotf or quot1f
	rts	pc

;decrements r3 by an amount equal to the length of the
;data or variable value (or header, etc) associated with
;the token in toke - destroys r2 - jsr pc

tokdec:	jsr	pc,maptok		;decode token
	movb	inctab(r2),r2	;r2_length of item or header
	sub	r2,r3		;adjust r3 for that length
	rts	pc

;maps data and variable tokens into octal digits
;for table dispatching - assumes token in
;toke - returns value in r2 - mapping:
;integer  0	floating 1	string 2
;array	3			intg-valued function 4
;fltg-valued function 5		string-valued function 6
;called with jsr pc

maptok:	clr	r2		;clr  r2
	mov	r5,-(sp)	;save r5
	mov	toke(r0),r5	;r5_token
	bic	#177740,r5	;strip irrelevant bits
	jmask0	eq,r5,funcf,mapt1  ;a function?
	cmp	(r2)+,(r2)+	;yes - set r2 to 4
	bic	#funcf,r5	;knock off function bits
mapt1:	dec	r2		;dec r2 to get off on right foot
mapt2:	inc	r2		;increment value
	asr	r5		;shift a bit off the end
	bne	mapt2		;bits finished?
	mov	(sp)+,r5	;yes - restore r5
	rts	pc		;exit with value in r2
;goes thru the variable table to 0 variables
;saves registers - jsr pc

preset:	jsr	r5,savreg	;save registers
	mov	spda,r0		;set base register
	clr	dumstr(r0)	;in case there are string arrays
	mov	#vartab,r5	;r5_addr first entry
pres2:	if  r5,ne,#vartab+52.,pres1  ;disp table done?
	jsr	r5,resreg	;yes - exit
	rts	pc

pres1:	mov	r5,r1		;r1_rel entry addr
	add	r0,r1		;bias r1
	tst	(r5)+		;r5_addr next disp table entry
pres3:	ifzero  eq,(r1),pres2	;table entry exist?
	add	(r1),r1		;yes - -point at it
	mov	r1,r4
	tst	-(r4)		;r4_addr subtable entry
pres4:	mov	(r4),toke(r0)	;set toke to token
	tst	-(r4)		;r4_addr of link to next subtable entry
	mov	r4,r3
	jsr	pc,tokdec	;r3_addr of value
	jsr	pc,tokzip	;zero the value
	ifzero  eq,(r4),pres3	;next subtable entry exist?
	add	(r4),r4		;yes - r4_addr next subtable entry
	br	pres4
; tstch - tst00, test alphabetic vs numeric in r2
;	registers used - r2
tst00:	cmp	r2,#'0		;check numeric
	blt	tst03		;non-numeric
	cmp	r2,#'9		;check alpha
	bgt	tst01		;non-numeric
	sez			;set zero code if numeric
	rts	pc

tst01:	cmp	r2,#'a		;alphabetic?
	blt	tst03		;no
	cmp	r2,#'z		;alphabetic?
	bgt	tst03		;no
	ccc			;set non-zero code if alphabetic
	rts	pc

tst03:	ccc
	sev			;set
	rts	pc		;overflow if neither

; potential ccl area

	org	ccl

	.end
