/
/ Sequential MODULA (UNIX) I/O Support   78/04/26 (I.D. Cottam)
/
	.globl  init,gdyn / defined in user program
	.globl  flush,getc,putc,fopen,fcreat / UNIX library routines
	.text
nucl:
	mov	$stktop,sp		/ Setup stack pointer
	jmp	init			/ and start user program

pexi:
	jsr	r5,flush		/ Main program finished
	outbuf				/  so tidy up
	clr	r0
	sys	exit			/ end of program

/
/ I/O Buffers
/
	.bss
	.even
.data
outbuf:	1
	.=.+516.
	.even
inbuf:  .=.+518.

/
/ I/O Routines
/
	.text
getch:
	jsr	r5,getc			/ input next char
	inbuf
	bes     1f                      / test for end of file
	movb	r0,g-1			/ ch := next char
	rts	pc
1:	movb	$177777,g-2		/ EOF := true
	rts	pc

putch:
	movb	g-1,r0			/ ch must be in r0
	jsr	r5,putc			/ write character
	outbuf
	rts	pc

openf:
	mov	2(sp),r1		/ addr of string element 0
	mov	4(sp),r2		/ high(string)
	mov	6(sp),r3		/ low (string)
	add	r3,r1			/ start addr of string
	sub	r3,r2			/ r2 :=
	inc	r2			/        no of chars
	mov	$ifname,r3		/ destination
1:	movb	(r1)+,(r3)+		/ move filename
	sob	r2,1b			/  to buffer
	clrb	(r3)			/ Null char to terminate
/  call sequence for UNIX routine
	mov	$ifname,r0
	jsr	r5,fopen
	inbuf
	rts	pc

rewrit:
	mov	2(sp),r1		/ addr of string element 0
	mov	4(sp),r2		/ high(string)
	mov	6(sp),r3		/ low (string)
	add	r3,r1			/ start addr of string
	sub	r3,r2			/ r2 :=
	inc	r2			/        no of chars
	mov	$ofname,r3		/ destination
1:	movb	(r1)+,(r3)+		/ move filename
	sob	r2,1b			/  to buffer
	clrb	(r3)			/ Null char to terminate
/  call sequence for UNIX routine
	mov	$ofname,r0
	jsr	r5,fcreat
	outbuf
	rts	pc



/
/ File names area
/
	.bss
	.even
ofname:
        .=.+32.
	.even
ifname:
	.=.+32.
/
/ Bit mask area
/
	.text
b:	1;2;4;10;20;40;100;200;400
	1000;2000;4000;10000;20000;40000;100000


/
/ Run-time Stack
/
	.bss
	.=.+gdyn+100
stktop:




	.text
/
/ Shift routine
/ 	Result in R0
/
eiss:	tst	r0
	bmi	2f
	beq	4f
1:	asl	r1
	dec	r0
	bne	1b
	br	4f
2:	neg	r0
3:	asr	r1
	dec	r0
	bne	3b
4:	mov	r1, r0
	rts	pc
/
/ Multiply routine
/	Returns R0*R1 in R0
/
eism:	mov	r0, -(sp)
	bpl	1f
	neg	(sp)
	neg	r1
1:	clr	r0
	br	4f
2:	add	r1, r0
3:	asl	r1
4:	clc
	ror	(sp)
	bcs	2b
	bne	3b
	tst	(sp)+
	rts	pc
/
/ Division routine
/	returns r1/r0 in R0,
/	remainder in R1
/
eisd:	mov	r2, -(sp)
	mov	r0, -(sp)
	mov	r1, -(sp)
	bpl	1f
	neg	r1
1:	mov	r0, r2
	bpl	2f
	neg	r2
2:	mov	r2, -(sp)
3:	asl	r2
	bpl	3b
	clc
	ror	r2
	clr	r0
4:	asl	r0
	cmp	r1, r2
	bmi	5f
	inc	r0
	sub	r2, r1
5:	asr	r2
	cmp	r2, (sp)
	bge	4b
	tst	(sp)+
	tst	(sp)+
	bpl	6f
	neg	r0
	neg	r1
6:	tst	(sp)+
	bpl	7f
	neg	r0
7:	mov	(sp)+, r2
	rts	pc


/
/ XOR routine
/   Returns  r0 XOR r1  in r0
/
eisx:
	mov	r2,-(sp)
	mov	r0,r2
	bic	r1,r2
	bic	r0,r1
	bis	r1,r2
	mov	r2,r0
	mov	(sp)+,r2
	rts	pc
/

/
/ DIV routine
/
eisD:
	jsr	pc,eisd
	tst	r1
	bge	1f
	dec	r0
1:	rts	pc

/
/ MOD routine
/
eisM:
	mov	r0,-(sp)
	jsr	pc,eisd
	tst	r1
	bge	1f
	add	(sp),r1
1:	tst	(sp)+
	rts	pc
/
/


/
/ End of Sequential MODULA (UNIX) Nucleus.
/
