



MODULE CharacterIOviaUNIX;
 DEFINE reset, rewrite, readc, writec, eof, 
        readn, readb, writen, writeb, writes,
        newline, newpage, writebits;

 (************************************************************************

    Author: I.D.Cottam
            Dept. of Computer Science,
            University of York,
            Heslington, York, England.

    Purpose:
           Allows Sequential Modula programs running under
           UNIX to read from a file (after calling reset) 
           and to write to a file (following a call of rewrite).

    UNIX Library Routines:
           fopen
           fcreat
           getc
           putc
           flush

    Restrictions:
           One character file names cannot be used as literal
           parameters to reset and rewrite.
           Two or more input (output) files cannot be used 
           simultaneously.

    Notes:
           This module must immediately follow the heading of 
           the main program module.
           Also, the declarations of ch and eof are position
           dependent. i.e. UNIX/Sequential-Modula assumes that
           ch and eof are the first and second global variables.

    **********************************************************************)

 VAR ch:char; (* Current character *)
     eof:boolean; (* True when end of input file read *)

 PROCEDURE reset(filename:ARRAY integer OF char);
    BEGIN
      (*  jmp    reset   *)
    END reset;

 PROCEDURE rewrite(filename:ARRAY integer OF char);
    BEGIN
      (*  jmp    rewrit  *)
    END rewrite;

 PROCEDURE getc;
    BEGIN
      (*  jmp    getc    *)
    END getc;

 PROCEDURE putc;
    BEGIN
      (*   jmp    putc   *)
    END putc;

 PROCEDURE readc(VAR c:char);
     USE ch,getc;
    BEGIN
      getc;
      c := ch
    END readc;

 PROCEDURE writec(c:char);
     USE ch,putc;
    BEGIN
      ch := c;
      putc
    END writec;

 PROCEDURE writes(s:ARRAY integer OF char);
     USE ch,putc;
     VAR l,h:integer;
    BEGIN
      l := low(s); h := high(s);
      REPEAT ch := s[l]; putc; inc(l) UNTIL l>h
    END writes;

 PROCEDURE newline;
     USE ch,putc;
     CONST  lf=12C;
    BEGIN
      ch := lf; putc
    END newline;

 PROCEDURE newpage;
     USE ch,putc;
     CONST ff=14C;
    BEGIN
      ch := ff;
      putc
    END newpage;

 PROCEDURE readb(VAR b:boolean);
     USE ch,eof,getc;
    BEGIN
      ch := ' ';
      WHILE (ch<>'T') AND (ch<>'F') AND NOT eof DO getc END;
      b := ch='T'
    END readb;

 PROCEDURE writeb(b:boolean);
     USE ch,putc;
    BEGIN
      IF b THEN ch := 'T' ELSE ch := 'F' END;
      putc
    END writeb;

 PROCEDURE readn(VAR n:integer);
     USE ch,getc,eof,newline,writes;
     VAR neg:boolean;
         val:integer;
     PROCEDURE digit(c:char):boolean;
        USE ch;
       BEGIN
         digit := ( (ch<='9') AND (ch>='0') )
       END digit;
    BEGIN
      val := 0;
      ch := ' ';
      WHILE (ch<>'+') AND (ch<>'-') AND NOT digit(ch) DO getc END;
      IF ch='-' THEN neg := true; getc
      ELSE neg := false;
           IF ch='+' THEN getc END
      END;
      IF NOT digit 
      THEN newline;
           writes('Digit expected in procedure readn');
           newline
      ELSE
           REPEAT val := 10*val+integer(ch)-integer('0');
                  getc
           UNTIL  NOT digit(ch);
           IF neg THEN val := -val END;
      END;
      n := val
    END readn;

 PROCEDURE writen(n:integer);
    USE ch,putc;
    VAR neg:boolean;
        i,val:integer;
        num:ARRAY 1:5 OF char;
   BEGIN
     val := n;
     IF val<0 THEN neg := true; val := -val
     ELSE neg := false
     END;
     i := 0;
     REPEAT
       inc(i);
       num[i] := char(val MOD 10 + integer('0'));
       val := val/10
     UNTIL val=0;
     IF neg THEN ch := '-'; putc END;
     REPEAT
       ch := num[i]; putc;
       dec(i)
     UNTIL i=0
   END writen;
 
 PROCEDURE writebits(b:bits);
     USE writeb;
     VAR i:integer; 
    BEGIN
      i := 0;
      REPEAT
        writeb(b[i]);
        inc(i)
      UNTIL i>15
    END writebits;


BEGIN
          eof := false
END  CharacterIOviaUNIX;



  
