MODULE quadtest;


DEVICE MODULE camaccrate[5];
DEFINE camd, locd, caml, locl,
       rd1, rd2, wt1, wt2, ss2, sc2, dis, enb;

CONST v = 340B; { base vector address }

VAR naf[160020B]: integer;
    csr[160022B]: bits;
    dbr[160024B]: integer;
    ivr[160032B]: integer;

TYPE camd = integer; { camac device }
     caml = integer; { camac lam }

PROCEDURE locd(VAR d: camd; n, a: integer);
BEGIN
  d := 512*n+32*a
END locd;

PROCEDURE locl(VAR l: caml; n, a: integer);
BEGIN
  l := 512*n+32*a
END locl;

PROCEDURE rd1(d: camd; VAR i: integer);
BEGIN
  naf := d; i := dbr
END rd1;

PROCEDURE rd2(d: camd; VAR i: integer);
BEGIN
  naf := d+1; i := dbr
END rd2;

PROCEDURE wt1(d: camd; i: integer);
BEGIN
  dbr := i; naf := d+16
END wt1;

PROCEDURE wt2(d: camd; i: integer);
BEGIN
  dbr := i; naf := d+17
END wt2;

PROCEDURE ss2(d: camd; i: integer);
BEGIN
  dbr := i; naf := d+19
END ss2;

PROCEDURE sc2(d: camd; i: integer);
BEGIN
  dbr := i; naf := d+23
END sc2;

PROCEDURE dis(l: caml);
BEGIN
  naf := l+24
END dis;

PROCEDURE enb(l: caml);
BEGIN
  naf := l+26
END enb;

BEGIN { camac crate initialization }
  csr[12] := true;    { on-line }
  csr[1] := true;     { Z }
  csr[2] := false;    { Clear I }
  ivr := (v/2+1)*256; { Multiple vector mode }
  csr[6] := true      { Enable interrupts }
END camaccrate;

DEVICE MODULE quadtty[5];
DEFINE input, output;
USE camd, locd, caml, locl, rd1, rd2, wt1, ss2, sc2, enb;

CONST n = 4; { quad tty station }

VAR maskreg, rqstreg: camd;
    quadlam: caml;
    line: ARRAY 1:8 OF
          RECORD
          buffreg: camd;
          mask: integer;
          lam: signal
          END;
    i, j: integer;

PROCEDURE input(kb: integer; VAR c: char);
  VAR ci: integer;
BEGIN
  WITH line[kb] DO
    ss2(maskreg, mask);
    wait(lam);
    rd1(buffreg, ci);
    c := char(ci)
  END
END input;

PROCEDURE output(pr: integer; c: char);
BEGIN
  WITH line[pr] DO
    wt1(buffreg, integer(c));
    ss2(maskreg, mask);
    wait(lam)
  END
END output;

PROCESS quaddriver[354B];
  VAR s: integer;
      csr[160022B]: bits;
BEGIN
  enb(quadlam);
  LOOP
    csr[6] := true;
    doio;
    rd2(rqstreg, s);
    WITH line[s DIV 256] DO
      sc2(maskreg, mask);
      send(lam)
    END
  END
END quaddriver;

BEGIN
  locl(quadlam, n, 0);
  locd(maskreg, n, 13);
  locd(rqstreg, n, 14);
  i := 0; j := 1;
  REPEAT
    inc(i);
    WITH line[i] DO
      locd(buffreg, n, i);
      mask := j
    END;
    j := 2*j
  UNTIL i=8;
  quaddriver
END quadtty;

INTERFACE MODULE circularbuffer;
DEFINE circbuff, init, put, get;

TYPE circbuff = RECORD
                buffer: ARRAY 0:63 OF char;
                in, out, chrs: integer;
                nonempty, nonfull: signal
                END;

PROCEDURE get(VAR b: circbuff; VAR c: char);
BEGIN
  WITH b DO
    IF chrs=0 THEN wait(nonempty) END;
    out := (out+1) MOD 64;
    c := buffer[out]; dec(chrs);
    send(nonfull)
  END
END get;

PROCEDURE put(VAR b: circbuff; c: char);
BEGIN
  WITH b DO
    IF chrs=64 THEN wait(nonfull) END;
    in := (in+1) MOD 64;
    buffer[in] := c; inc(chrs);
    send(nonempty)
  END
END put;

PROCEDURE init(VAR b: circbuff);
BEGIN
  WITH b DO
    in := 0; out := 0; chrs := 0
  END
END init;

END circularbuffer;

VAR buffer: ARRAY 1:8 OF circbuff;

PROCESS receive(VAR buffer: circbuff; kb: integer);
  VAR c: char;
BEGIN
  LOOP
    input(kb, c);
    put(buffer, c)
  END
END receive;

PROCESS transmit(VAR buffer: circbuff; pr: integer);
  VAR c: char;
BEGIN
  LOOP
    get(buffer, c);
    output(pr, c)
  END
END transmit;

PROCESS echo(VAR kb, pr: circbuff);
  VAR c: char;
BEGIN
  LOOP
    get(kb, c);
    put(pr, c)
  END
END echo;

VAR i: integer;

BEGIN { quad tty test }
  i := 0;
  REPEAT
    inc(i);
    init(buffer[i]); init(buffer[i+4]);
    receive(buffer[i], i); transmit(buffer[i+4], i+4);
    echo(buffer[i], buffer[i+4])
  UNTIL i=4
END quadtest.
{
.bp
}
