/*
 *		Borrowed from 	C. Maltby & K. Hill
 *		Modified by M. Rourke & P. Swain
 */ 

#include	<gtty.h>

struct sgttyb sgttyb;

#define	CTRLQ	021
#define	R	04		/* read permission - access system call */

char LSI11[] "/dev/ttyI";	/* 11/34 lives here */ 
int fd;	/* file descriptor for above */ 
char *arg;	/* points to first argument on entered line */ 
int fildes;	/* for the bootstrap and load files */ 
unsigned uid;	/* uid of invoker */ 
int quitchar CTRLQ;	/* quit char from connect mode */ 
int header[3];	/* for the absolute loader */ 
char line[64];	/* line buffer */ 
int buf[300];	/* general purpose buffer */ 

char mon[] "/srce/usr/source/L/modula/tc/work/boot";	/* pathname to default monitor */ 

int icode[]
{
/*	key.s	=	177560		; keyboard status	*/ 
/*	bit7	=	0200					*/ 

	000005, 		/*	reset			*/ 
	012700, 077000, 	/*	mov	#77000,r0	*/ 
	012701, 0177560, 	/*	mov	#key.s,r1	*/ 
	032711, 000200, 	/*test:	bit	#bit7,(r1)	*/ 
	001775, 		/*	beq	test		*/ 
	0116120, 000002, 	/*	movb	2(r1),(r0)+	*/ 
	000772 			/*	br	test		*/ 
};

main()
{
	register c;

	signal(2, 1);
	signal(3, 1);
	uid = getreal();
	if((fd = open(LSI11, 2)) < 0 || gtty(fd, &sgttyb) < 0)
		error();
	sgttyb.ispeed = sgttyb.ospeed = B9600;
	sgttyb.mode = RAW;
	if(stty(fd, &sgttyb) < 0)
		error();
	tty();
	for(; ; )
	{
		prints(2, "> ");	/* prompt */ 
		switch(getline())
		{
		case 'b':
			absboot();
			close(fildes);
			break;

		case 'c':
			copy();
			close(fildes);
			break;

		case 'k':
			sendbrk();
			tty();
			break;
		case 'l':
			load();
			close(fildes);
			break;

		case 't':
			tty();
			break;

		case 'q':
			quitchar = *arg;
			break;

		case 's':
			return 0;

		case '!':
			sh();
			break;
		case '\n':
			break;

		default:
			help();
		}
	}
}

error()
{
	perror(LSI11);
	exit(1);
}

getline()
{
	register n;
	register char *cp;

	if((n = read(0, line, sizeof line)) < 0 || n == sizeof line)
	{
		prints(2, "Too verbose!\n");
		while(read(0, buf, sizeof buf) == sizeof buf);
		return -1;
	}
	if(n == 0)
		exit();
	cp = line;
	if(*cp == '\n')
		return '\n';
	cp[n-1] = 0;
	while(*cp && *cp++ != ' ');
	while(*cp++ == ' ');
	arg = cp-1;
	return line[0];
}

tty()
{
	if(quitchar >= ' ')
		putchar(quitchar);
	else
	{
		putchar('^');
		putchar(quitchar|0100);
	}
	prints(2, " to quit\n");
	if(connect(2, fd, quitchar) < 0)
		error();
	putchar('\n');
}

absboot()
{
	register unsigned n;
	register char *cp;
	int i, oldmode;


	cp = arg;
	if(*cp == 0)
		cp = mon;
	if(access(cp, R) || (fildes = open(cp, 0)) < 0)
	{
		fildes = -1;
		perror(cp);
		return;
	}
	if((n = read(fildes, buf, 16)) == 0)
	{
		prints(2, cp);
		prints(2, " is empty\n");
		return;
	}
	if(n == 16 && buf[0] == 0407)
	{
		n = buf[1]+buf[2];
		if(n > sizeof buf-sizeof icode)
		{
			prints(2, cp);
			prints(2, ": too big (max ");
			printn(sizeof buf-sizeof icode);
			prints(2, " bytes)\n");
			return;
		}
		if(read(fildes, buf, n) != n)
		{
			prints(2, cp);
			prints(2, ": bad header\n");
			return;
		}
	}
	else
	{
		prints(2, cp);
		prints(2, ": illegal file\n");
		return;
	}

	/* feed */

	/* cause delay chars to be recognised (bit7 set = delay) */ 
	gtty(fd, &sgttyb);
	oldmode = sgttyb.mode;
	sgttyb.mode = RAW|ODDP;	
	stty(fd, &sgttyb);

	sendbrk();		/* puts lsi11 into ODT mode */

	/* set page control register to point to console terminal test */
	prints(fd, "177520/\212003406\n\220\r\212");

	/* run terminal test program - clears all of memory */
	prints(fd, "173000G");
	sleep(3);		/* let it finish */
	prints(fd, "y\r\212");

	/* load simple bootstrap - into 70000... */
	prints(fd, "70000/\212");	/* 8 */ 
	for(i = 0; i < sizeof icode>>1; i++)
	{
		printo(icode[i]);
		prints(fd, "\n\220");
	}
	prints(fd, "\r\212");

	/* start up bootstrap to load chars from 77000... (fast) */
	prints(fd, "70000G");

	sgttyb.mode = oldmode;
	stty(fd, &sgttyb);

	write(fd, buf, 513);	/* now get the monitor into it */ 

	/* the last byte will cause a bus error and cause ODT to be entered */

	sleep(2);		/* wait till monitor is loaded */
	prints(fd, "77000G"); 	/* start up monitor routine */

	printn(n);
	prints(2, " bytes\n");
	sleep(1);
	tty();
}

load()
{
	register char *cp;
	register unsigned n, count;
	unsigned bssize;	/* size of BSS area */ 
	unsigned entrypoint;
	unsigned bytes;	/* nr of bytes transferred */ 

	bytes = 0;
	cp = arg;
	fildes = -1;
	if(*cp == 0)
	{
		prints(2, "file?\n");
		return;
	}
	if(access(cp, R) || (fildes = open(cp, 0)) < 0)
	{
		perror(cp);
		return;
	}
	if((n = read(fildes, buf, 16)) == 0)
	{
		prints(2, cp);
		prints(2, " is empty\n");
		return;
	}
	write(fd, "l", 1);	/* enter load routine */ 
	if(n == 16 && buf[0] == 0407)	/* a.out */ 
	{
		count = buf[1]+buf[2];	/* text + init. data */ 
		bssize = buf[3];	/* BSS size */ 
		bytes = count+bssize;
		entrypoint = buf[5];
		header[2] = 0;
		while(count)
		{
			n = count > sizeof buf?sizeof buf:count;
			n = read(fildes, buf, n);
			if(n <= 0)
			{
				if(n)
					perror(cp);
				else
				{
					prints(2, cp);
					prints(2, ": bad header\n");
				}
				return;
			}
			absout(buf, n);
			count =- n;
		}
		cp = buf;
		while(cp != &buf[sizeof buf/2])
			*cp++ = 0;	/* clean up BSS */ 
		while(bssize)
		{
			n = bssize > sizeof buf?sizeof buf:bssize;
			absout(buf, n);
			bssize =- n;
		}
		header[2] = entrypoint;
		absout(0, 0);
	}
	else if(buf[0] == 01)	/* absolute loader format */ 
	{
		if(n == 16)
			n =+ read(fildes, buf+8, sizeof buf-16);	/* rest of first block */ 
		do
		{
			write(fd, buf, n);
			bytes =+ n;
		}
		while(n = read(fildes, buf, sizeof buf));
	}
	else /* some other garbage */ 
	{
		header[2] = 0;
		if(n == 16)
			n =+ read(fildes, buf+8, sizeof buf-16);	/* rest of it */ 
		do
		{
			absout(buf, n);
			bytes =+ n;
		}
		while(n = read(fildes, buf, sizeof buf));
		header[2] = 0;	/* stick on an entry-point at 0 */ 
		absout(0, 0);
	}
	printn(bytes);
	prints(2, " bytes transferred\n");
	entrypoint = 0401;	/* terminate load */ 
	write(fd, &entrypoint, 2);
	tty();
}

copy()
{
	register char *cp;
	register unsigned n;
	register unsigned bytes;	/* nr of bytes transferred */ 

	bytes = 0;
	cp = arg;
	fildes = -1;
	if(*cp == 0)
	{
		prints(2, "file?\n");
		return;
	}
	if(access(cp, R) || (fildes = open(cp, 0)) < 0)
	{
		perror(cp);
		return;
	}
	while((n = read(fildes, buf, sizeof buf)) > 0)
	{
		write(fd, buf, n);
		bytes =+ n;
	}
	printn(bytes);
	prints(2, " bytes transferred\n");
	write(fd, "S9", 2);	/* terminate the load */ 
	tty();
}
absout(b, n)
{
	register char *cp;
	register chksum;
	register i;
	int dummy;

	chksum = 0;
	header[0] = 1;
	header[1] = n+6;
	cp = header;
	i = 6;
	do
		chksum =+ *cp++;
	while(--i);
	write(fd, header, 6);
	if(i = n)
	{
		cp = b;
		do
			chksum =+ *cp++;
		while(--i);
		write(fd, b, n);
		header[2] =+ n;
	}
	dummy = -chksum;
	write(fd, &dummy, 1);
}

printn(n)
register unsigned n;
{
	register unsigned r;

	if(r = n/10)
		printn(r);
	putchar((n%10)+'0');
}

sh()
{
	register pid;

	if((pid = fork()) == -1)
	{
		perror("fork");
		return;
	}
	if(pid == 0)
	{
		if(uid)
			setuid(uid);
		execl("/bin/sh", "sh", "-c", &line[1], 0);
		perror("exec");
		exit();
	}
	while(waitx(&arg) != -1);
}

help()
{
	prints(2, "Commands:\n");
	prints(2, "\tb [file]\tload bootstrap\n");
	prints(2, "\t\t\t(default `");
	prints(2, mon);
	prints(2, "')\n");
	prints(2, "\th\t\thelp listing\n");
	prints(2, "\tl file\t\tload down file\n");
	prints(2, "\tc file\t\tcopy down file with no checking or header\n");
	prints(2, "\tq char\t\tchange quit char\n");
	prints(2, "\tk\t\tkill program running on lsi11 (enter ODT mode)\n");
	prints(2, "\tt\t\ttty\n");
	prints(2, "\ts\t\tstop\n");
	prints(2, "\t!\t\tshell escape\n");
}

putchar(c)
{
	write(2, &c, 1);
}

printo(n)
register unsigned n;
{
	register unsigned r;
	int i;

	if(r = n/8)
		printo(r);
	i = (n%8)+'0';
	write(fd, &i, 1);
}

sendbrk()
/*
 *	Simulate a break - send a long null!
 *	Causes a trap to microcode ODT
 */ 
{
	sgttyb.ospeed = sgttyb.ispeed = B300;
	stty(fd, &sgttyb);
	write(fd, "\000", 1);
	sgttyb.ospeed = sgttyb.ispeed = B9600;
	stty(fd, &sgttyb);
	sleep(1);
}
