#
/*
 */

static char	sccsid[]	"@(#)tty.c	1.7";

/*
 * general TTY subroutines
 */
#include "../param.h"
#include "../lnode.h"
#include "../systm.h"
#include "../user.h"
#include "../tty.h"
#include "../proc.h"
#include "../inode.h"
#include "../file.h"
#include "../reg.h"
#include "../conf.h"

/*
 * Input mapping table-- if an entry is non-zero, when the
 * corresponding character is typed preceded by "\" the escape
 * sequence is replaced by the table value.  Mostly used for
 * upper-case only terminals.
 */
char	maptab[]
{
	000,000,000,000,004,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,'|',000,000,000,000,000,'`',
	'{','}',000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,000,000,000,000,
	000,000,000,000,'\\',000,'~',000,
	000,'A','B','C','D','E','F','G',
	'H','I','J','K','L','M','N','O',
	'P','Q','R','S','T','U','V','W',
	'X','Y','Z',000,000,000,000,000,
};

/*
 * The routine implementing the gtty system call.
 * Just call lower level routine and pass back values.
 */
gtty()
{
	int v[3];
	register *up, *vp;

	vp = v;
	sgtty(vp);
	if (u.u_error)
		return;
	up = u.u_arg[0];
	suword(up, *vp++);
	suword(++up, *vp++);
	suword(++up, *vp++);
}

/*
 * The routine implementing the stty system call.
 * Read in values and call lower level.
 */
stty()
{
	register int *up;

	up = u.u_arg[0];
	u.u_arg[0] = fuword(up);
	u.u_arg[1] = fuword(++up);
	u.u_arg[2] = fuword(++up);
	if (u.u_error)
		return;
	sgtty(0);
}

/*
 * Stuff common to stty and gtty.
 * Check legality and switch out to individual
 * device routine.
 * v  is 0 for stty; the parameters are taken from u.u_arg[].
 * v  is non-zero for gtty and is the place in which the device
 * routines place their information.
 */
sgtty(v)
int *v;
{
	register struct file *fp;
	register struct inode *ip;
	int	dev;

	if ((fp = getf(u.u_ar0[R0])) == NULL)
		return;
	ip = fp->f_inode;
	if ((ip->i_mode&IFMT) != IFCHR) {
		u.u_error = ENOTTY;
		return;
	}
	dev = ip->i_addr[0];
	if (v == (char *) 0			/* is stty */
		&& cdevsw[dev.d_major].d_tty	/* is a terminal (or MX) */
		&& u.u_uid != guid(ip)		/* he doesn't own it */
		&& !suser())			/* and he isn't God */
	{
		u.u_error = EPERM;
		return;				/* so don't let him */
	}
	(*cdevsw[dev.d_major].d_sgtty)(dev, v);
}

/*
 * Wait for output to drain, then flush input waiting.
 */
wflushtty(atp)
struct tty *atp;
{
	register struct tty *tp;

	tp = atp;
	spl5();
	while (tp->t_outq.c_cc) {
		ttstart(tp);
		tp->t_state =| ASLEEP;
		sleep(&tp->t_outq, TTOPRI);
	}
	flushtty(tp);
	spl0();
}

/*
 * flush all TTY queues
 */
flushtty(atp)
struct tty *atp;
{
	register struct tty *tp;
	register int sps;

	tp = atp;
	while (getc(&tp->t_canq) >= 0);
	wakeup(&tp->t_rawq);
	wakeup(&tp->t_outq);
	sps = PS->integ;
	spl5();
	tp->t_state =& ~TTSTOP;
	while (getc(&tp->t_outq) >= 0);
	while (getc(&tp->t_rawq) >= 0);
	tp->t_delct = 0;
	PS->integ = sps;
}

/*
 * transfer raw input list to canonical list,
 * doing erase-kill processing and handling escapes.
 * It waits until a full line has been typed in cooked mode,
 * or until any character has been typed in raw mode.
 */
canon(atp)
struct tty *atp;
{
	register char *bp;
	char *bp1;
	register struct tty *tp;
	register int c;
	int slosh;

	tp = atp;
	spl5();
	while (tp->t_delct==0) {
		if ((tp->t_state&CARR_ON)==0)
		{
			spl0();
			return(0);
		}
		sleep(&tp->t_rawq, TTIPRI);
	}
	spl0();
	bp = canonb;
	slosh = 0;
	while ((c=getc(&tp->t_rawq)) >= 0) {
		if (c==0377) {
			tp->t_delct--;
			break;
		}
			if (!slosh) {
				if (c==tp->t_erase) {
					if (bp > canonb)
						bp--;
					continue;
				}
				if (c==tp->t_kill)
					c = -1;
				else
				if (c==CEOT)
					continue;
				else if (c == '\\')
					slosh++;
			} else {
				slosh = 0;
				if (maptab[c] && (tp->t_flags & (LCASE|TDATA))==LCASE) {
					c = maptab[c];
					bp--;
				} else if (c==tp->t_erase || c==tp->t_kill)
					bp--;
			}
		*bp++ = c;
		if (bp>=canonb+TTYHOG)
			break;
	}
	bp1 = bp;
	while (bp > canonb)
		if (*--bp < 0) {
			bp++;
			break;
		}
	c = &tp->t_canq;
	while (bp<bp1)
	{
		putc(*bp, c);
		*bp++ = 0;
	}
	return(1);
}

/*
 * Place a character on raw TTY input queue, putting in delimiters
 * and waking up top half as needed.
 * Also echo if required.
 * The arguments are the character and the appropriate
 * tty structure.
 */
ttyinput(ac, atp)
struct tty *atp;
{
	register int t_flags, c;
	register struct tty *tp;

	tp = atp;
	ac =& 0377;
	c = ac & 0177;
	if (tp->t_rtype)
	{
		/*
		 * redirection of this port in progress
		 */

		if (tp->t_rtype == TMULTIPLEX)
		{
			struct { int (*func)(); };

			(*tp->t_redir.func)(ac, tp);
			return;
		}

		if (c == tp->t_cchar && tp->t_rtype & TMASTER)
		{
			/*
			 * master terminate character - stop slave & master
			 */
			tp = tp->t_redir;
			tp->t_rtype = tp->t_cchar = 0;
			tp = tp->t_redir;
			tp->t_rtype = tp->t_cchar = 0;
			tp->t_redir = tp->t_redir->t_redir = 0;
			wakeup(&tp->t_rtype);
			return;
		}

		switch (tp->t_rtype)
		{
		case TMASTER+TCONLOG:
		case TCONLOG:
			tp = tp->t_redir;
			if (tp->t_outq.c_cc < TTYHOG)
			{
				putc(c, &tp->t_outq);
				ttstart(tp);
			}
			return;

		case TMASTER+TCONSHARE:
		case TMASTER+TCONGRAB:
			tp = tp->t_redir;
			break;

		case TCONGRAB:
			return;
		}
	}
	t_flags = tp->t_flags;
	if (c=='\r' && t_flags&CRMOD)
		c = '\n';
	if ((t_flags & RAW) == 0)
	{
		if (tp->t_state & TTSTOP)	/* currently stopped */
		{
			if (c == CSTART)	/* got ^Q */
			{
				tp->t_state =& ~TTSTOP;
				ttstart(tp);	/* start up again */
				return;
			}
			if (c == CSTOP)		/* got ^S */
				return;		/* ignore it */
			tp->t_state =& ~TTSTOP;	/* some other char */
			ttstart(tp);		/* so restart & keep char */
		}
		else			/* not stopped */
		{
			if (c == CSTOP)		/* got ^S */
			{
				tp->t_state =| TTSTOP;
				return;		/* stops eventually */
			}
			if (c == CSTART)	/* got ^Q */
				return;		/* ignore it */
		}

		if (c == CINTR || c == CQUIT)
		{
			flushtty(tp);
			signal(tp, c == CINTR ? SIGINT : SIGQIT);
			return;
		}
	}
	if (tp->t_rawq.c_cc >= TTYHOG-1)
		flushtty(tp);
	else
	{
		if (!(t_flags & TDATA))
			if (t_flags&LCASE && c>='A' && c<='Z')
				c =+ 'a'-'A';
		if (t_flags & RAW) {
			if (tp->t_state & RAWSLEEP) {
				tp->t_state =& ~RAWSLEEP;
				wakeup(&tp->t_rawq);
			}
			if (tp->t_flags == RAW)
				c = ac;
			putc(c, &tp->t_rawq);
		}
		else
		{
			putc(c, &tp->t_rawq);
			if (c=='\n' || c==004) {
				wakeup(&tp->t_rawq);
				if (putc(0377, &tp->t_rawq)==0)
					tp->t_delct++;
			}
		}
	}
	if (c<0200 && (partab[c] & 077) != 1)
	if (t_flags&ECHO) {
		ttyoutput(c, tp);
		if (c == '\b' && tp->t_erase == c)	/* echo char delete nicely */
		{
			ttyoutput(' ', tp);
			ttyoutput(c, tp);	/* is BKSP */
		}
		ttstart(tp);
	}
	else
		if (tp->t_rtype == TCONVIEW || tp->t_rtype == TCONSHARE)
		{
			ttyoutput(c, tp->t_redir);
			ttstart(tp->t_redir);
		}
}

/*
 * put character on TTY output queue, adding delays,
 * expanding tabs, and handling the CR/NL bit.
 * It is called both from the top half for output, and from
 * interrupt level for echoing.
 * The arguments are the character and the tty structure.
 */
ttyoutput(c, tp)
register char	c;
register struct tty	*tp;
{
	register union { char *colp;  int flags; } i;
	int ctype;

	if (tp->t_rtype)
	{
		switch (tp->t_rtype)
		{
		case TCONVIEW:
		case TCONSHARE:
			ttyoutput(c, tp->t_redir);
			ttstart(tp->t_redir);
			break;

		case TCONGRAB:
			ttyoutput(c, tp->t_redir);
			ttstart(tp->t_redir);
			return;
		}
	}

	i.flags = tp->t_flags;
	if ((i.flags & RAW) == 0)
		c =& 0177;
	/*
	 * Turn tabs to spaces as required
	 */
	if (c == '\t' && i.flags & XTABS)
	{
		c = 8 - (tp->t_col & 07);
		do
			putc(' ', &tp->t_outq);
		while (--c);
		tp->t_col = (tp->t_col+8) & ~07;
		return;
	}
	/*
	 * for upper-case-only terminals,
	 * generate escapes.
	 */
	if (i.flags & LCASE)
	{
		if (!(i.flags & TDATA))
		{
			i.colp = "({)}!|^~'`";
			while (*i.colp++)
				if (c == *i.colp++)
				{
					putc('\\', &tp->t_outq);
					tp->t_col++;
					c = i.colp[-2];
					break;
				}
			if ('a'<=c && c<='z')
				c =+ 'A' - 'a';
			i.flags = tp->t_flags;
		}
		else
		{
			if ('A'<=c && c<='Z')
				c =+ 'a' - 'A';
		}
	}
	/*
	 * turn <nl> to <cr><lf> if desired.
	 */
	if (c=='\n' && i.flags&CRMOD)
		ttyoutput('\r', tp);
	if (putc(c, &tp->t_outq))
		return;
	if (i.flags == RAW)
		return;		/* true raw only */
	/*
	 * Calculate delays.
	 * The numbers here represent clock ticks
	 * and are not necessarily optimal for all terminals.
	 * The delays are indicated by characters above 0200,
	 * thus (unfortunately) restricting the transmission
	 * path to 7 bits.
	 */
	i.colp = &tp->t_col;
	ctype = partab[c];
	c = 0;
	switch (ctype&077) {

	/* ordinary */
	case 0:
		(*i.colp)++;

	/* non-printing */
	case 1:
		break;

	/* backspace */
	case 2:
		if (*i.colp)
			(*i.colp)--;
		break;

	/* newline */
	case 3:
		ctype = (tp->t_flags >> 8) & 03;
		if(ctype == 1) { /* tty 37 */
			if (*i.colp)
				c = max((*i.colp>>4) + 3, 6);
		} else
		if(ctype == 2) { /* vt05 */
			c = 6;
		}
		*i.colp = 0;
		break;

	/* tab */
	case 4:
		ctype = (tp->t_flags >> 10) & 03;
		if(ctype == 1) { /* tty 37 */
			c = 1 - (*i.colp | ~07);
			if(c < 5)
				c = 0;
		}
		*i.colp =| 07;
		(*i.colp)++;
		break;

	/* vertical motion */
	case 5:
		if(tp->t_flags & VTDELAY) /* tty 37 */
			c = 0177;
		break;

	/* carriage return */
	case 6:
		ctype = (tp->t_flags >> 12) & 03;
		if(ctype == 1) { /* tn 300 */
			c = 5;
		} else
		if(ctype == 2) { /* ti 700 */
			c = 10;
		}
		*i.colp = 0;
		break;

	/* non-delay, echoing */
	case 7:
		break;
	}
	if(c)
		putc(c|0200, &tp->t_outq);
}

/*
 * Restart typewriter output following a delay
 * timeout.
 * The name of the routine is passed to the timeout
 * subroutine and it is called during a clock interrupt.
 */
ttrstrt(tp)
register struct tty	*tp;
{
	tp->t_state =& ~TIMEOUT;
	ttstart(tp);
}

/*
 * Start output on the typewriter. It is used from the top half
 * after some characters have been put on the output queue,
 * from the interrupt routine to transmit the next
 * character, and after a timeout has finished.
 *
 * Assumed to be called at BR5 or greater.
 */
ttstart(tp)
register struct tty	*tp;
{
	if (!(tp->t_state & (TIMEOUT | TTSTOP)))
		(*tp->t_start)(tp);
}

/*
 * Called from device's read routine after it has
 * calculated the tty-structure given as argument.
 * The pc is backed up for the duration of this call.
 * In case of a caught interrupt, an RTI will re-execute.
 */
ttread(tp)
register struct tty	*tp;
{
	if (tp->t_flags & RAW) {
		do {
			spl5();
			while (tp->t_rawq.c_cc == 0)
				if (tp->t_state & CARR_ON) {
					tp->t_state =| RAWSLEEP;
					sleep(&tp->t_rawq, TTIPRI);
				} else
				{
					spl0();
					return;
				}
			spl0();
		} while (passc(getc(&tp->t_rawq)) >= 0);
	} else
	if (tp->t_canq.c_cc || canon(tp))
		while (tp->t_canq.c_cc && passc(getc(&tp->t_canq))>=0);
}

/*
 * Called from the device's write routine after it has
 * calculated the tty-structure given as argument.
 */
ttwrite(tp)
register struct tty	*tp;
{
	register int	*state, c;

	state = &tp->t_state;
	if ((*state & CARR_ON) == 0)
		return;
	while ((c=cpass())>=0) {
		spl5();
		while ((tp->t_outq.c_cc > TTHIWAT) && (((tp->t_speeds & 017) <= B1200) || (tp->t_outq.c_cc > TTHSHIWAT)))
		{
			ttstart(tp);
			*state =| ASLEEP;
			sleep(&tp->t_outq, TTOPRI);
		}
		spl0();
		ttyoutput(c, tp);
	}
	spl5();
	ttstart(tp);
	spl0();
}

/*
 * Common code for gtty and stty functions on typewriters.
 * If v is non-zero then gtty is being done and information is
 * passed back therein;
 * if it is zero stty is being done and the input information is in the
 * u_arg array.
 */
ttystty(tp, v)
register int	*v;
register struct tty	*tp;
{
	if (v)
	{
		*v++ = tp->t_speeds;
		v->lobyte = tp->t_erase;
		v->hibyte = tp->t_kill;
		v[1] = tp->t_flags;
		return(1);
	}
	wflushtty(tp);
	v = u.u_arg;
	tp->t_speeds = *v++;
	tp->t_erase = v->lobyte;
	tp->t_kill = v->hibyte;
	tp->t_flags = v[1];
	return(0);
}

/*
 * Check validity of 'connect' call.
 */
struct tty *
ttyget(arg)
{
	register struct tty	*tp;
	register struct inode	*ip;
	register struct file	*fp;
	int			dev;

	if ((fp = getf(arg)) == NULL)
		return(0);		/* illegal fd passed */

	if ((fp->f_flag & (FREAD|FWRITE)) != (FREAD|FWRITE))
	{
		u.u_error = EACCES;	/* no permission */
		return(0);
	}

	ip = fp->f_inode;
	if ((ip->i_mode & IFMT) != IFCHR)
	{
		u.u_error = ENOTTY;
		return(0);
	}

	dev = ip->i_addr[0];
	if ((tp = cdevsw[dev.d_major].d_tty) == NULL)
	{
		u.u_error = ENREDIR;	/* not capable */
		return(0);
	}

	return(tp + dev.d_minor);
}

/*
 * Connect system call.
 */
ttyconnect()
{
	register struct tty	*mtp, *stp;
	register int		rtype;

	if (!suser())
		return;

	rtype = u.u_arg[0];

	if ((mtp = ttyget(u.u_ar0[R0])) == NULL)
		return;

	if ((stp = ttyget(u.u_ar0[R1])) == NULL)
		return;

	spl5();

	switch (rtype)
	{
	case 0:		/* disconnect */
		if (mtp != stp || mtp->t_rtype == 0)
			u.u_error = EREDIR;
		else
		{
			stp = mtp->t_redir;
			if (stp->t_redir != mtp)
				u.u_error = EREDIR;
			else
			{
				/*
				 * wakeup master tty
				 */
				if (mtp->t_rtype & TMASTER)
					wakeup(&mtp->t_rtype);
				else
					wakeup(&stp->t_rtype);

				mtp->t_rtype = stp->t_rtype = 0;
				mtp->t_cchar = stp->t_cchar = 0;
				mtp->t_redir = stp->t_redir = 0;
			}
		}
		break;

	case TCONLOG:
	case TCONVIEW:
	case TCONGRAB:
	case TCONSHARE:
		if (mtp == stp || mtp->t_rtype || stp->t_rtype)
			u.u_error = EREDIR;	/* already conn */
		else
		{
			mtp->t_rtype = TMASTER+rtype;
			stp->t_rtype = rtype;
			mtp->t_cchar = u.u_arg[1];
			mtp->t_redir = stp;
			stp->t_redir = mtp;

			while (mtp->t_rtype)
				sleep(&mtp->t_rtype, PREDIR);
		}
		break;

	default:
		u.u_error = EINVAL;
		break;
	}

	spl0();
}
