; The use and distribution of the information
; contained herein may be restricted.
;
title	ma,<math common>,24,22-jul-74,<mhb/tph/tge/ld>

;this is the common front for the 2-word and 4-word math package

;for the 2-word math package assemble:
;common,user,syrc,sypp,ma2?,ma,xcma2[,xfma2],end

;for the 4-word  math package assemble:
;common,user,syrc,sypp,ma4?,ma,xcma4[,xfma4],end

;for the 4-word decimal math package assemble:
;common,user,syrc,sypp,ma4d,ma,mad

	.sbttl	push-pops defined

	org	pt,0

	..	ppushf,pushf
	..	ppopf,popf
	..	ppflpf,fpopf
	..	ppflrf,freplf
	..	ppopi,popi
	..	ppfipi,ipopi
	..	ppfiri,irepli
	..	ppops,pops
	..	ppaddf,addf
	..	ppsubf,subf
	..	ppsgnf,sgnf
	..	ppufl0,pushf0
	..	ppufl1,pushf1
	..	ppabsf,absf
	..	pprsbf,rsubf
	..	ppnegf,negf
	..	ppintf,intf
	..	ppflt1,flt1
	..	pppwrf,pwrf
	..	pprnd,rnd
	..	pprand,random
	..	pptime,timef
	..	ppfix0,pushi0
	..	ppmuli,muli
	..	ppdivi,divi
	.if	df	decmap
	..	ppmulf,mulf.s
	..	ppdivf,divf.s
	.iff
	..	ppmulf,mulf
	..	ppdivf,divf
	.endc
	..	ppfix,fix
	..	ppflt,flt
	..	pprinf,printf
	..	pprini,printi
	..	pprins,prints
	..	ppcoma,nxtzon
	..	ppcrlf,crlf
	..	ppexit,exitpp
	..	ppijs,pitjs
	..	ppevf,.ev.f
	..	ppabxf,absf00
	..	pprepf,replf
	..	ppfixf,fixf
	..	ppfid1,iinr1
	..	ppfld1,finr1
	..	ppfir1,iinl1
	..	ppflr1,finl1
	..	ppfid2,iinr2
	..	ppfld2,finr2
	..	ppfir2,iinl2
	..	ppflr2,finl2
	..	ppido1,indo1
	..	ppido2,indo2
	..	ppidr1,indr1
	..	ppidr2,indr2
	..	ppirr1,indl1
	..	ppirr2,indl2
	.sbttl	po - print using overlay this dispatch table

	org	po		;possible overlay by print using
prinu0:	.word	prnfl3
prinu1:	.word	prs01		;a "rts pc"
	.sbttl	math package definitions/globals
	org	ma

	.if	eq	.math.
	.globl	fltle3,fltle5,fltle4,nxtzon,printf,sinf1
	.globl	expdif,indegh,indo3
	.endc

	.globl	fltlen,fltle2,mfltl2,printm,doscal		;internal
	.globl	atof,crlf,prinu2,prnbuf,prnbuc
	.globl	printa,printi,printl,prints,printc
	.globl	pstjs,pushf1,maxsig,indary
	.globl	prinu3,.math.
	.globl	muli,prnf15,prnf05,prnfl3
	.globl	prl14,flt,subf,addf,fix,cmpf
	.globl	indr3,indx90,indo1,indo2,intfun,deffun
	.globl	inctab,pushf2,pushf3
	.globl	pushf,pops1,popf1,prnfl1,prnfl2
	.globl	tokzip,zarry4,bnt4,pntuxp
	.globl	spdar0
	.globl	scatab,scasup,scaini

;external references to other segments

	.globl	crlf0,pos000,maptok
	.globl	atoi,savem,flotim
	.globl	read.,write.,thent,num$00
	.globl	.eq.s,pushs1,pushs2,builds,repls1
	.if	df	decmap
	.globl	gusint,tlendp,edctlh,sso,tlgenp
	.endc
fltle2	=	fltlen*2
fltle3	=	fltlen*3
fltle5	=	fltlen*5
mfltl2	=	-fltle2
fltle4	=	fltlen*4
	.if	eq	.math.
expdif	=	400*40.		;max exp shrink in special matinv pp
maxsig	=	16.		;max number sig. chars available
fltprn	=	6		;max number chars usually printed
maxpow	=	32.		;biggest power of 10 in conv. table
pntuxp	=	'^		;allow ^^^^ for exponents
	.if	eq	fltlen-2
expdif	=	400*18.		;less shrinkage for 2-word
maxsig	=	7		;not as much significance in 2-word
	.endc
	.endc
	.if	ne	.math.
maxsig	=	13.+6.		;19. total digits in this package
pntuxp	=	'-		;disallow ^^^^ for exponents
	.endc
.sbttl	table of one and pi

scatab:				;table of pi & one
	.if	ne	.math.
	.word	000000,000000,000057,167731	;pi
	.word	000000,000000,000017,041100	;one
	.endc
	.if	eq	.math.
	.if	eq	fltlen-2
	.word	040511,007733,000000,000000	;pi
	.word	040200,000000,000000,000000	;one
	.endc
	.if	eq	fltlen-4
	.word	040511,007732,121041,064302	;pi
	.word	040200,000000,000000,000000	;one
	.if	df	decmap
	.word	041373,051721,045251,141363	;pi*10.
	.flt4	1e1
	.word	042235,012142,147252,014730	;pi*100.
	.flt4	1e2
	.word	043104,054573,101124,120115	;pi*1000.
	.flt4	1e3
	.word	043765,067732,061351,144141	;pi*10000.
	.flt4	1e4
	.word	044631,062750,076722,016475	;pi*100000.
	.flt4	1e5
	.word	045477,137542,116506,122214	;pi*1000000.
	.flt4	1e6
	.endc
	.endc
	.endc
	.sbttl	routines for others
; routines and tables for la

	.if	eq	.math.
bnt4:	.if	df	decmap
	mov	r0,-(sp)	;save r0
	mov	scafac,r0	;get scaling pointer
	beq	10$		;no scaling
	.if	df	fpu
	setd
	ldd	(r1),f0		;scaling, get floater
	divd	(r0),f0		;divide for normal number
	std	f0,-(r1)	;store answer
	.iff
	mov	#5$,-(sp)	;set a return address
	jsr	r4,savem	;save r0,r2,r3,r4
	jsr	pc,duplf	;duplicate floater
	jsr	pc,divfr0	;push divisor and divide
	jmp	restem		;restore r0,r2,r3,r4 and return
	.endc
5$:	mov	(r1)+,r0	;save high order of answer
	cmp	(r1)+,(r1)+	;collapse middle part
	mov	r0,(r1)		;now clobber lsb with msb
	br	20$
10$:	mov	(r1),-(r1)	;copy msb onto r1 stack
20$:	mov	(sp)+,r0	;restore r0
	.iff
	mov	(r1),-(r1)	;duplicate the exp
	.endc
	asl	(r1)		;dump sign bit
	cmp	(r1)+,#110000	;check for valid integer range
	blo	bnt5		;o.k.
	mov	#flotim,(sp)	;no, change to floater
bnt5:	rts	pc		;exit
	.endc

fltstf:	.word	fltlen,1.,3.	;lengths (flt,int,str)
	.word	fltlen*11.,1.*11.,3.*11.
	.word	fltlen*121.,1.*121.,3.*121.

tokzip:	jsr	pc,maptok	;decode token
	asl	r2		;r2_2*token code
	add	r2,pc		;dispatch thru zrout modified by token code

	br	zintg		;integer zero
	br	zflt		;floating zero
	br	zstr		;string zero
	br	zarray		;array zero
	br	fzintg		;intg-valued function
	br	fzflt		;fltg-valued function
	clr	10(r3)		;string-valued function - clear count
	rts	pc

fzflt:	cmp	(r3)+,(r3)+	;clr floating function
zflt:	clr	(r3)+		;clr floating number
	fltclr	(r3)+		;clear more if needed
zintg:	clr	(r3)		;clr integer
	rts	pc

zstr:				;clear count in string
fzintg:	clr	4(r3)		;clear integer fncn
	rts	pc
;this routine works on array headers (not iob's)
;thus the bicb below is probably nonsense
zarray:	mov	r3,r2		;copy header address
	bicb	#wrtary,aryflg(r3)	;clear re-write bit
	sub	r0,r2		;make relative
	clr	r0		;make new length 0
	mov	r4,-(sp)	;save tom's pointer
	mov	r3,-(sp)	;save r3 for later
	jsr	pc,thent	;never moves on a colapse
	mov	(sp)+,r3	;restore header pointer
	mov	(sp)+,r4	;and restore the la pointer
zarry4:	mov	r3,r0		;r0 <- abs header address
	movb	aryflg(r3),r2	;get flag byte
	bitb	r2,#dimary	;already dimed array?
	bne	zarry3		;yep
	bic	#-3-1,r2	;get 0 to 2 index
	asl	r2		;now word index
	add	#fltstf,r2	;make pointer
zarry1:	add	#pdim2+2,r3	;go to end of header
	mov	(r2),-(sp)	;save item length on stack
	ifzero	eq,-(r3),zarry2	;br if pdim=0
	add	#6,r2		;othws, go a little further in info
	mov	#10.,(r3)	;& set pdim2=10
zarry2:	mov	#10.,-(r3)	;pdim1=10 always in undimmed case
	mov	(sp)+,-(r3)	;store item length in maxstr
	clr	-(r3)		;clear offset
	clr	-(r3)		;2 words worth
	clr	-(r3)		;& high order limit
	mov	6(r2),-(r3)	;set low order limit
zarry3:	mov	pdim2(r0),dim2(r0)  ;set dim2 from backup
	mov	pdim1(r0),dim1(r0)  ;ditto dim1
	mov	r0,r3		;save absolute pointer as public service
spdar0:	mov	spda,r0		;restore r0 and exit
	rts	pc		;utility tail
inctab:	.byte	2		;integers
	.byte	2*fltlen	;floaters
	.byte	6		;strings
	.byte	arylen		;array headers
	.byte	2+4		;integer functions
	.byte	2*fltlen+4	;floating functions
	.byte	6+4		;string functions
	.even

	.if	eq	.math.
$polsh:	tst	(sp)+		;delete junk from stack
$plshe:	jmp	@(r4)+

dup4:				;same as 'dup2' but for 4-word
dup2:	mov	#$plshe,-(sp)	;set return for polish
	.if	eq	fltlen-2
prinu2:
	.endc
	.endc
duplf:	movflt	fltlen-1*2(r1),-(r1)	;duplicate floating
	rts	pc		;on r1 stack

pushf:	gwtxt	r0		;get the pointer
pushf3:	add	spda,r0		;make it absolute
pushf2:
	.nlist
	afltln=fltlen-1*2
	.rept	fltlen-1
	.list
	mov	afltln(r0),-(r1)	;move to r1 stack
	.nlist
	afltln=afltln-2
	.endr
	.list
	mov	(r0),-(r1)	;move last word
	.if	eq	fltlen-4
prinu2:
	.endc
	rts	pc
; pop a string

pops:	gwtxt	r0		;get address
	mov	spda,r2		;and get spda
	add	r2,r0		;make r0 absolute
pops1:	tst	(r0)+		;skip the link
	add	r1,(r1)		;get abs link
	sub	r2,(r1)		;make relative
	mov	(r1)+,(r2)	;and link it
	add	r1,(r1)		;
	sub	r0,(r1)		;
	br	pops2		;move pointer and link

freplf:	mov	(r1),-(r1)	;copy integer on stack
fpopf:	jsr	pc,flt		;float an integer
popf:	gwtxt	r0		;get address
	add	spda,r0		;make absolute
popf1:	.rept	fltlen-2
	mov	(r1)+,(r0)+	;and move it
	.endr
pops2:	mov	(r1)+,(r0)+	;move one more
	br	popi1		;and go move another

irepli:	jsr	pc,duplf	;duplicate floating
ipopi:	jsr	pc,fix		;fix the floating
popi:	gwtxt	r0		;get address
	add	spda,r0		;make abs.
popi1:	mov	(r1)+,(r0)+	;and move it
	rts	pc

replf:	gwtxt	r0
	add	spda,r0
	movflt	(r1)+,(r0)+
	sub	#fltle2,r1
	rts	pc
indl1:	clr	-(r1)		;set up a second subscript
indl2:	jsr	pc,indx90	;go do funny things common to indx
	bisb	#wrtary,(r4)	;set diddled bit
	bitb	#fixary,(r0)	;see if floating
	bne	indx50		;branch if true
	bitb	#strary,(r0)	;see if string header
	bne	indx60		;branch if string
	movflt	(r1)+,(r3)+	;pop floating
	fltpp	-(r1)		;just kidding; copy - not pop
	rts	pc		;and return

indx50:	mov	(r1),(r3)	;replicate integer
	rts	pc		;and return

indx60:	tstb	(r0)		;see if dsk and string
	bmi	indx42		;branch if the worst case
	mov	r3,r0		;move pointer to r0
	jmp	repls1		;and go to repls

indo1:	clr	-(r1)		;make a phony #2 subscript
indo2:	jsr	pc,indx90	;calculate index into array
indo3:	bitb	#fixary,(r0)	;see if fixed-float-string
	bne	indx10		;branch if push floating
	bitb	#strary,(r0)	;see if fixed-string
	bne	indx20		;branch if push string
	.nlist
	  afltln=2*fltlen-2	;distance to 1st floater
	  .rept	fltlen-1
	.list
	mov	afltln(r3),-(r1)  ;word of floater onto r1 stack
	.nlist
	  afltln=afltln-2
	  .endr
	.list
indx10:	mov	(r3),-(r1)
	rts	pc		;and return

indx20:	tstb	(r0)		;see if disk based
	bmi	indx21		;branch if funny string on disk
	mov	r3,r0		;copy string header address
	mov	spda,r2		;set up for entry to pushs
	jmp	pushs1		;and enter in the middle

indx40:	tstb	(r0)		;see if string is on disk storage
	bmi	indx41		;branch to pick up the messy one(dsk&string)
	mov	r3,r0		;copy header addr to r0
	mov	spda,r2		;set up pda pointer
	br	pops1		;and join forces with pops

indx21:	mov	maxstr-aryflg(r0),r4	;set up max length
	asl	r4		;make byte count
	sub	r2,r3		;make address of string relative
	mov	r3,-(r1)	;save on r1 stack
	mov	r4,r3		;set up maximum length needed
	jsr	pc,builds	;set up to build a string
	mov	(r1)+,r2	;get relative string address back
	add	r0,r2		;make absolute again
indx22:	movb	(r2)+,(r3)+	;move a character
	sob	r4,indx22	;loop if still more
indx23:	tstb	-(r3)		;see if unneeded null
	beq	indx23		;loop if junk
	inc	r3		;else count it
	jsr	pc,@(sp)+	;and return to builds
	mov	(sp)+,r5	;restore ipc
	mov	(r2),(r1)	;set link to first string
	jmp	pushs2		;and insert string in list

indr1:	clr	-(r1)		;make second entry + use indr2
indr2:	jsr	pc,indx90	;calc all kinds of stuff
indr3:	bisb	#wrtary,(r4)	;make sure to write it back out
	bitb	#fixary,(r0)	;see if floating
	bne	indx30		;branch if so
	bitb	#strary,(r0)	;see if a string
	bne	indx40		;branch if so
	  .nlist
	  .rept	fltlen-1
	  .list
	mov	(r1)+,(r3)+	;store floating point
	  .nlist
	  .endr
	  .list
indx30:	mov	(r1)+,(r3)+
indx46:	rts	pc		;and return

indx41:	mov	#pstjs,-(sp)	;when done pop a string
indx42:	mov	maxstr-aryflg(r0),r4	;get maximum length
	asl	r4		;and make byte count
	mov	length(r1),r2	;get length of the string
	beq	indx45		;don't copy anything for null string
	cmp	r2,r4		;see how compared with max allowed
	ble	indx43		;branch if ok
	mov	r4,r2		;else truncate to max length
indx43:	mov	r1,r0		;copy stack so as to not destroy pointer
	add	pntr(r1),r0	;get a pointer to the string proper
indx44:	movb	(r0)+,(r3)+	;store a character
	dec	r4		;decrement for null insertion
	sob	r2,indx44	;loop if more to do
indx45:	dec	r4		;see if nulls needed
	blt	indx46		;branch if done
	clrb	(r3)+		;add a null
	br	indx45		;loop for more if needed
iinr1:	clr	-(r1)		;make second subscript 0
iinr2:	mov	(r1)+,-(sp)	;save #2
	mov	(r1)+,-(sp)	;save #1
iinr3:	jsr	pc,fix		;make value an integer
	mov	(sp)+,-(r1)	;restore #1
	mov	(sp)+,-(r1)	;restore #2
	br	indr2		;make like a well known other op

iinl1:	clr	-(r1)		;make second subscript 0
iinl2:	mov	(r1)+,-(sp)	;save the second subscript
	mov	(r1)+,-(sp)	;and #1 too
	jsr	pc,duplf	;duplicate floating
	br	iinr3		;and go to above

finr1:	clr	-(r1)		;same game #2=0
finr2:	mov	(r1)+,-(sp)	;save #2
	mov	(r1)+,-(sp)	;save #1
finr3:	jsr	pc,flt		;make into floating
	mov	(sp)+,-(r1)	;restore #1
	mov	(sp)+,-(r1)	;restore #2
	br	indr2		;do a another operation

finl1:	clr	-(r1)		;we know what he wants
finl2:	mov	(r1)+,-(sp)	;save #2
	mov	(r1)+,-(sp)	;save #1
	mov	(r1),-(r1)	;duplicate it
	br	finr3		;and resume above

indx90:	gwtxt	r0		;get the dope vector address
indegh:	mov	r0,r2		;copy pointer for possible allocation
	add	spda,r0		;and make absolute
	tst	length(r0)	;see if any array
	bne	indx88		;branch if all there
	tstb	aryflg(r0)	;see if dsk or  core
	bpl	indx83		;branch if core variety
	movb	aryslt(r0),r4	;get the slot number
	ash	#3,r4		;mul by 8
	add	#base+iolen,r4	;r4 is now relative buffer address
	add	spda,r4		;make it absolute
	mov	r4,-(sp)	;save header address
	mov	length(r4),-(sp);first see if it is open
	beq	indx70		;length=0 if not open
	cmp	(sp)+,#512.	;next see if buffer is 1 block long
	bne	indx9e		;if not 512. bytes, then error
	mov	pntr(r4),r3	;pick up the pointer to the buffer
	add	r4,r3		;make it absolute
	sub	r0,r3		;make it relative to dope vector
	mov	r3,pntr(r0)	;store it away here
	br	indx88		;skip core stuff
indx70:	vcoerr	!fatal		;virtual array not open
indx9e:	vcserr	!fatal		;buffer size not 512.

indx83:	mov	arylim(r0),r0	;get the needed length
	asl	r0		;make into byte length
	jsr	pc,thent	;go allocate buffer space
	add	r4,r2		;compute abs pointer to header
	mov	r2,-(sp)	;and save it for a minute
	asr	r0		;compute back to words
	beq	indx72		;skip if no array
	add	pntr(r2),r2	;go to the area proper
indx71:	clr	(r2)+		;clean up a word
	sob	r0,indx71	;loop til done
indx72:	mov	(sp)+,r0	;restore header address
	bitb	#dskary!strary,aryflg(r0)	;see if string headers needed
	ble	indx88		;think about this one
	mov	r0,r2		;copy the header address
	mov	length(r0),r3	;get the length
	add	pntr(r0),r2	;and point to the area
	mov	r2,-(sp)	;save start address
indx73:	mov	#6,(r2)		;store a link
	sub	(r2),r3		;decrement the length
	ble	indx74		;branch if done
	add	(r2),r2		;skip down the chain????
	br	indx73		;and loop for more

indx97:	vcaerr	!fatal		;disk array not on disk

indx99:	sizerr	!fatal		;disk array too big.

indx74:	mov	r4,r3		;copy spda
	add	#dumstr,r3	;dumstr gets it a lot here
	mov	(r3),(r2)	;copy old link
	beq	indx75		;branch if end of the line
	add	r3,(r2)		;make absolute
	sub	r2,(r2)		;now relative to here
indx75:	mov	(sp)+,r2	;get the head of the list
	mov	r2,(r3)		;store it at dumstr
	sub	r3,(r3)		;and make relative
indx88:	mov	#indx8e,-(sp)	;call subroutine by falling thru
indary:	mov	(r1)+,-(sp)	;save index2
	mov	(r1)+,r3	;index1
	mov	dim2(r0),r2	;get dim2
	beq	indx77		;save time if 0
	inc	r2		;to allow indices to start at 0
	mul	r3,r2		;r2,r3 <- index1*(dim2+1)
indx77:	add	(sp)+,r3	;plus index2
	adc	r2		;plus carry
	mov	r3,-(sp)	;save l.s. word
	add	#maxstr,r0	;point at item word length
	clr	r3		;in case  we don't need  multiply
	ifzero	eq,r2,indx78	;br if m.s. word 0
	mov	(r0),r3		;multiplier = item word length
	jsr	pc,arymul	;fast multiply - sometimes
	ifzero	ne,r2,indx99	;error if  too much disk demanded
indx78:	mov	(sp)+,r2	;retrieve l.s. word
	mov	r3,-(sp)	;save part of m.s. word
	mov	(r0),r3		;multiplier = item word length
	jsr	pc,arymul	;fast multiply - sometimes
	add	(sp)+,r2	;add in rest of m.s. word
	bcs	indx99		;br if exorbitant disk demand
	add	-(r0),r3	;add offset for virtual core
	adc	r2		;array 0 if real core array
	add	-(r0),r2	;and finish the high order
	bcs	indx99		;br if too much disk requested
	rts	pc

indx96:	suberr	!fatal		;subscripting error

indx8e:	cmp	r2,-(r0)	;see how the high order parts are
	blt	85$		;branch if ok
	bgt	indx96		;branch if subscripting error
	tst	-(r0)		;go to low order word
	cmp	r3,(r0)+	;see about the low orders
	bhis	indx96		;branch if an error
85$:	tst	-(r0)		;pop over the low order
	tst	-(r0)		;test type - core vs dsk
	bmi	69$		;branch if disk
	mov	r0,r4		;pointer to flags-1
	inc	r4		;now flags in aryhdr
	br	94$		;join up
69$:	clr	-(sp)		;r2 <- block num, (sp)<- displ. in block
	movb	r3,(sp)		;save displacement in block
	clrb	r3		;clear it out
	swab	r3		;l.s. byte of block number
	swab	r2		;juggle m.s. byte into position
	bne	indx99		;complain if more than a word of block num
	bis	r3,r2		;othws, form block number in r2
	inc	r2		;fip goes from 1 to n now
	beq	indx99		;rolled over - bad
	mov	2(sp),r3	;get io header address
	mov	length(r3),bytcnt(r3)	;set up for write and/or read
	mov	pntr(r3),curloc(r3)	;both byte count and address
	movb	flags(r3),r4	;get flags byte into a register
	bpl	indx97		;branch for error if not random access
	bitb	r4,#force	;force type device?
	bne	indx97		;yes, also an error
	tst	curblk(r3)	;virgin since open?
	beq	92$		;if so
	cmp	r2,curblk(r3)	;is the block in core?
	beq	93$		;if so
	aslb	r4		;see if we need to write
	bpl	92$		;branch if no write
.iif	ne	wrtary-100,	.error	;we cannot do this!!
	jsr	pc,write.	;write old block
	bne	98$		;some kind of problem
92$:	mov	r2,curblk(r3)	;set up new block
	jsr	pc,read.	;get it
	beq	1$		;no error
	cmpb	#eof,iosts	;eof is ok
	beq	2$		;eof's aren't real errors
	clr	curblk(r3)	;indicate zilch buffer
98$:	ioterr	!fatal		;die!

2$:	mov	r2,curblk(r3)	;monitor returned its curr, but we want this one
1$:	bicb	#wrtary,flags(r3) ;note that disk and core agree now
93$:	clr	bytcnt(r3)	;signal this was random access
	mov	r3,r4		;save pointer to iob
	add	#flags,r4	;and make it even more useful
	mov	(sp)+,r3	;get displacement (as byte)
	tst	(sp)+		;remove io header address
94$:	asl	r3		;make into byte address
	bvs	indx96		;if overflow better tell him
	bmi	indx96		;if wrong direction too
	add	r0,r3		;go to absolute address
	sub	#aryslt,r3	;sub typfil because r0 is off by typfil
	add	pntr-aryslt(r0),r3	;and move to the buffer itself.
	mov	spda,r2		;and a public service gesture
	inc	r0		;point to the flag byte
	rts	pc
.ev.f:	movflt	(r1)+,-(sp)	;save one floater
	jsr	pc,num$00	;make string version of 2nd
	movflt	(sp)+,-(r1)	;get back original floater
	mov	#.eq.s,-(sp)	;set for string compare
	jmp	num$00		;make string of 1st floater
intfun:	mov	(r5)+,r0	;get specified function pattern
deffun:	mov	(r1)+,r2	;get the invocation pattern
	cmp	r2,r0		;do a quick look see
	beq	func98		;exit now if all ok
	mov	spda,r4		;get a pointer to the data area
	mov	r5,-(sp)	;save the ipc, we aren't moving
	clr	r5		;we'll use r5 to count the # of params
func01:	clr	r3		;r3 becomes the type index
	ror	r2		;get a bit
	rol	r3		;store it in the register
	ror	r2		;get the second bit
	rol	r3		;this is complement obverse
	inc	r5		;tally a param
	asl	r3		;make into a branch offset
	add	r3,pc		;dispatch on type,000-end,010-fixed,100-floating,110-string
	br	func16		;pop them off now
	br	func02		;branch if fixed
	br	func03		;branch if floating
	add	r1,(r1)		;make link absolute
	sub	r4,(r1)		;make it relative to spda
	mov	(r1)+,(r4)	;move it off the plist temporarily
	add	r1,(r1)		;make pointer absolute also-off by two
	mov	(r1)+,-(sp)	;store the pointer
	mov	(r1)+,-(sp)	;and the length also
	mov	#4,-(sp)	;and type it;4=string
	br	func01		;and loop for more

func02:	mov	(r1)+,-(sp)	;save the integer
	clr	-(sp)		;type it;0=fixed
	br	func01		;and go get more goodies

func03:	movflt 	(r1)+,-(sp)	;save floater
	mov	#2,-(sp)	;type it;2=floating
	br	func01		;advance to go loop again

func14:	asl	r0		;move the wanted list over 
	asl	r0		;over two bits for the pop off
	beq	func13		;branch if an error--to get here r3<>0
func16:	bit	#140000,r0	;see if done yet
	beq	func14		;loop if more to do
func04:	clr	r3		;type to be
	rol	r0		;get a bit of the wanted
	rol	r3		;move it to the index area
	rol	r0		;get a second bit
	rol	r3		;make complement obverse index
	asl	r3		;make an index word 
	dec	r5		;toggle the param counter
	ble	func15		;branch if done
	add	r3,pc		;dispatch on new type
	br	func13		;to get here is to err
	br	func08		;branch if float wanted
	br	func05		;branch if fixed wanted
	add	(sp)+,pc	;dispatch on stack type
	br	func13		;oh boy an error
	br	func13		;oh boy an error
	mov	(sp)+,-(r1)	;stack the length
	mov	(sp)+,-(r1)	;move the pointer
	sub	r1,(r1)		;remember how sloppy we were storing it?
	mov	(r4),-(r1)	;set former first string
	add	r4,(r1)		;make absolute
	sub	r1,(r1)		;make a link from here
	mov	r1,(r4)		;set up new first pointer
	sub	r4,(r4)		;make relative ot spda
	br	func04		;go finish the job

func05:	add	(sp)+,pc	;see what is there
	br	func06		;all ok just copy it
	br	func07		;must fix it first
	br	func13		;he made a mistake

func06:	mov	(sp)+,-(r1)	;put it back silly
	br	func04		;loop for more

func07:	movflt	(sp)+,-(r1)	;return the floater
	jsr	pc,fix		;fix it
	br	func04		;loop again

func08:	add	(sp)+,pc	;dispatch on stored type
	br	func10		;branch if flt needed
	br	func09		;branch if straight copy
func13:	funerr	!fatal		;function error

func09:	movflt	(sp)+,-(r1)	;move the number back
	br	func04		;loop for more

func10:	mov	(sp)+,-(r1)	;copy the integer
	jsr	pc,flt		;make a man out of him
	br	func04		;loop to finish maybe

func15:	mov	(sp)+,r5	;restore the ipc
	tst	r3		;see if the right number of them
	bne	func13		;must be zero else an error
func98:	rts	r5		;and back we go
muli:	mov	(r1)+,r3	;get first number
	mul	(r1),r3		;multiply by second number
	mov	r3,(r1)		;store the result onto the stack
	rts	pc		;and return

;assuming r3 contains a power of 2
;or 3!!!
arymul:	mov	r4,-(sp)	;save r4
	clr	r4		;m.s. word of product starts @ 0
	br	aryml2		;start in middle of shift loop

aryml1:	asl	r2		;double shift product words left
	rol	r4		;that's what we're doing
aryml2:	ror	r3		;dump a bit
	bcc	aryml1		;around again if not rid of one
	beq	aryml3		;it was a power of 2
	mov	r2,r3		;else save value times 1
	asl	r2		;now times 2
	rol	r4		;save overflows
	add	r3,r2		;make it times 3 now
	adc	r4		;watch for overflows...
aryml3:	mov	r2,r3		;othws, l.s. word into r3
	mov	r4,r2		;copy high order
	mov	(sp)+,r4	;restore r4
	rts	pc		;and return

divi:	mov	(r1)+,r4	;pick up the divisor
	mov	(r1)+,r3	;pick up the dividend
	sxt	r2		;extend the sign
	div	r4,r2		;perform the divide
	mov	r2,-(r1)	;move the quotient to the stack
	mov	r3,r2		;move the remainder to r2
	bcc	10$		;branch if no division by zero error
	post,	pstdv0		;show division by 0
10$:	rts	pc
;the sgn function
sgnf:	jsr	r5,intfun	;demand a floating arg
	+faf
	.if	eq	.math.
	ifzero	eq,(r1),rtslc1	;branch out if zero
	mov	r1,r0		;copy r1 pointer into r0
	bic	#77777,(r0)	;save the sign
	.if	ndf	decmap
	bis	#40200,(r0)+	;and superimpose 1st word of one
	clr	(r0)+		;make it a floating one
	.iff
	mov	scafac,r2	;get pointer to a "one"
	bne	1$		;non-zero
	mov	#scatab+<4*2>,r2;get a real one
1$:	bis	(r2)+,(r0)+	;superimpose 1st word on sign
	mov	(r2)+,(r0)+	;and copy next word
	.endc
	fltclr	(r0)+
	.endc
	.if	ne	.math.
	jsr	pc,fltest	;check for 0
	beq	pushf0		;if 0, then keep it 0
pusdf1:	mov	#041100,-(r1)	;set up a 1.000000
	mov	#000017,-(r1)
	clr	-(r1)
	mov	-(r1),-(sp)	;save old sign
	clr	(r1)		;final clear for 1.000000
sgnext:	tst	(sp)+		;negate it?
	bmi	negf		;yes
	.endc
rtslc1:	rts	pc
	.if	eq	.math.
rtsloc:	.word	rtslc1		;for dummying polish returns

;replace current floater with zero
sinf1:	fltpp	(r1)+		;up the r1 stack & fall thru
	.endc

;push a floating zero
pushf0:	fltclr	-(r1)		;some clears
	clr	-(r1)
pushi0:	clr	-(r1)		;push integer zero
	rts	pc

;push a floating one
pushf1:	.if	eq	.math.
	fltclr	-(r1)		;some clears
	.if	ndf	decmap
	clr	-(r1)
	mov	#40200,-(r1)	;the leading word
	rts	pc
	.iff
	mov	scafac,r0	;get floating one pointer
	bne	1$		;non-zero
	mov	#scatab+<4*2>,r0;get a real one
1$:	mov	2(r0),-(r1)	;set 2nd word
	mov	(r0),-(r1)	;set top word
	rts	pc
	.endc
	.endc
	.if	ne	.math.
	clr	mfltl2(r1)	;insure a +1.000000
	br	pusdf1		;and do it
	.endc
;exits internal pushpop mode
exitpp:	mov	(sp)+,r5	;get ready to
	rts	r5		;restore and exit to interpreter

	.if	ne	.math.
fltest:	mov	(r1)+,-(sp)	;save 1st word
	asl	(sp)		;put sign in carry and save rest of it
	bis	(r1)+,(sp)	;now check all of it
	bis	(r1)+,(sp)
	bis	(r1)+,(sp)+	;final check
	bne	fltes0		;non-0
	bcc	fltes0		;0 and o.k.
	post,	pstflt		;that special wierdo is here again
	clr	mfltl2(r1)	;make it a 0
fltes0:	rts	pc		;exit
	.endc
	.if	ne	.math.
absfsv:	mov	(sp),-(sp)	;resave return address
	mov	(r1),2(sp)	;save sign of number
	br	absf00		;now take abs value of it
	.endc
;the absolute function
absf:	jsr	r5,intfun	;demand a floater
	+faf
absf00:	.if	eq	.math.
	bic	#100000,(r1)	;that's all there is to it
	.endc
	.if	ne	.math.
	tst	(r1)		;need sign reversing
	bmi	negf		;yes
	.endc
	rts	pc

;the reverse subtract
rsubf:	jsr	pc,subf		;subtract & fall thru to complement

;the negate
negf:	.if	eq	.math.
	ifzero	eq,(r1),negf01	;negate 0 as 0
	add	#100000,(r1)	;just complement the sign
	.endc
	.if	ne	.math.
	jsr	pc,fltest	;check for 0
	beq	pushf0		;keep 0 a 0
	neg	-(r1)		;negate it
	adc	-(r1)
	bcs	1$
	neg	(r1)
1$:	adc	-(r1)
	bcs	2$
	neg	(r1)
2$:	adc	-(r1)
	bcs	negf01
	neg	(r1)
	.endc
negf01:	rts	pc
;the basic int function
intf:	.if	df	decmap
	jsr	pc,dsctst	;get 'faf' arg and check for scaling
	.iff
	jsr	r5,intfun	;demand a floating arg
	args	faf
	.endc
	ifsign	(r1),pl,fixf11	;out fast for nonnegative numbers
	mov	r1,r0		;save r1 pointer
	movflt	(r0)+,-(sp)	;make a comparison copy of arg
	jsr	pc,fixf1	;fix the number
	movflt	(sp)+,-(r1)	;get the comparison copy
	jsr	pc,cmpf		;compare them
	beq	rtslc1		;exit if they were equal
	fltclr	-(r1)		;othws, put 1.0 on r1 stack
	clr	-(r1)
	mov	#40200,-(r1)
	jmp	subf		;then subtract and exit

fixf11:	jmp	fixf1		;jump to the fix routine


flt1:	movflt	(r1)+,-(sp)	;save top floater
	jsr	pc,flt		;float the integer below
	movflt	(sp)+,-(r1)	;restore top floater
	rts	pc
	.if	eq	.math.
;raises 2nd number on r1 stack to 1st number power - 2nd number
;must be nonnegative unless exponent is an integer <= 31
pwrf:	.if	df	decmap
	mov	scafac,r0	;get scaling pointer
	beq	10$		;none
	.if	df	fpu
	setd
	ldd	(r1)+,f0	;get exponent
	ldd	(r1),f1		;get number to raise
	divd	(r0),f1		;correct number to raise
	std	f1,(r1)		;and put it back on stack
	divd	(r0),f0		;correct exponent
	std	f0,-(r1)	;and put it back on stack
	.iff
	movflt	(r1)+,-(sp)	;save exponent
	jsr	pc,divfr0	;correct the number to raise
	movflt	(sp)+,-(r1)	;restore exponent
	jsr	pc,divfsc	;correct exponent
	.endc
	mov	#dscdne,-(sp)	;remember to re-scale on exit
10$:
	.endc
	mov	r1,r0		;r0 points at exponent
	movflt	(r0)+,-(sp)	;save exponent
	mov	(r1),r2		;m.s. word of exponent
	rol	r2		;get rid of sign
	if  r2,hi,#103000,pwr5	;do it crummy if exponent >= 32
	jsr	pc,duplf	;copy exponent
	.if	ndf	decmap
	jsr	pc,fix		;integer part of exponent
	mov	(r1),-(sp)	;onto sp stack
	jsr	pc,flt		;refloat integer part
	.iff
	jsr	r4,$ri		;get integer of exponent
	.word	20$,$ir,30$
20$:	mov	(r1),(sp)	;save exponent as integer
	jmp	@(r4)+
30$:
	.endc
	jsr	pc,subf		;to find fractional part
	.rept	fltlen-2
	mov	(r1)+,(r1)	;move the top word up a little
	.endr
	mov	(r1)+,(r1)+	;test top word & pop two words
	bne	pwr4		;br if not pure integer exponenet
	ifsign	(sp),pl,pwr0	;br if exponent nonnegative
	mov	r1,r2		;save stack pointer
	jsr	pc,duplf	;move num to exponentiate out on stack
	mov	#40200,(r2)+	;and a floating one where it was
	clr	(r2)+
	fltclr	(r2)+
	jsr	pc,divf		;reciprocal of number to exponentiate
	neg	(sp)		;and negate the exponent
pwr0:	asr	(sp)		;set carry if exponent odd
	mov	r1,r0		;save the stack pointer
	movflt	(r0)+,-(sp)	;save the number
	bcs	pwr1		;if expon odd, leave number on stack
	fltclr	-(r0)		;othws, push a one in its place
	clr	-(r0)
	mov	#40200,-(r0)
pwr1:	ifzero	eq,2*fltlen(sp),pwr3  ;br if done
pwr2:	movflt	(sp)+,-(r1)	;othws, push some power of number
	jsr	pc,duplf	;duplicate it
	jsr	pc,mulf		;square it
	asr	(sp)		;set carry if square to be multiplied in
	movflt	(r1)+,-(sp)	;save square
	bcc	pwr2		;br if square not multiplied in
	fltpp	-(r1)		;othws, recover square
	jsr	pc,mulf		;and multiply it in
	br	pwr1
pwr3:	add	#4*fltlen+2.,sp	;clean the stack
	rts	pc		;just exit

;when we get here, the number to exponentiate had better be nonnegative

pwr4:	tst	(sp)+		;get rid of integer part of exponent
	br	pwr8		;skip the r1 pointer setup
pwr5:	mov	r0,r1		;r1 points to number to exponentiate
pwr8:	ifzero	ne,(r1),pwr6	;br if number to exponentiate nonzero
	ifsign	2*fltlen-2(sp),pl,pwr7  ;br if exponent nonneg
	logerr			;if exp negative, answer is infinity
pwr7:	fltpp	(sp)+		;othws, clean stack & return 0
	rts	pc		;exit

pwr6:	jmp	xf		;do it the long way...

	org	xf

xf:	errerr			;no extended functions
	jmp	pwr7		;so say error and exit

	org	ma
	.endc
	.if	ne	.math.
pwrf:	jsr	pc,duplf	;duplicate exponext on stack
	jsr	pc,fix		;now fix the exponent
	mov	(r1),-(sp)	;save value of fixed exponent
	jsr	pc,flt		;now re-float it
	jsr	pc,subf		;and subtract (flt(fix(exp))) from (exp)
	jsr	pc,fltest	;check for true zero
	beq	1$		;it is true 0
	tst	(sp)+		;dump saved exponent
	add	#fltle2,r1	;and pop number
	errerr			;missing special feature
	br	pushf0		;return a floating zero

1$:	tst	(sp)		;exponent negative??
	bpl	pwr2		;nope, o.k.
	mov	r1,r2		;save r1 stack
	jsr	pc,duplf	;dup floater
	fltclr	(r2)+		;make a 1.000000
	mov	#000017,(r2)+
	mov	#041100,(r2)+
	jsr	pc,divf		;by dividing
	neg	(sp)		;and reverse exp sign
	bvc	pwr2		;o.k.
	clr	(sp)		;make -32768 be 0
pwr2:	mov	r1,r2		;copy r1 stack
	asr	(sp)		;get even/odd into carry
	movflt	(r2)+,-(sp)	;save number
	bcs	pwr3		;if odd, then keep number
	mov	r2,r1		;else make it a 1.000000
	jsr	pc,pushf1
pwr3:	tst	fltle2(sp)	;end?
	beq	pwr9		;yes
pwr4:	movflt	(sp)+,-(r1)	;no, get number
	jsr	pc,duplf	;duplicate it
	jsr	pc,mulf		;and square it
	asr	(sp)		;set carry for later
	movflt	(r1)+,-(sp)	;save the square
	bcc	pwr4		;no addition
	fltpp	-(r1)		;grab back the square
	jsr	pc,mulf		;and multiply it in
	br	pwr3		;check for end

pwr9:	add	#fltle2+2,sp	;collapse sp stack
	rts	pc		;and exit
	.endc
rnd:	tst	(r1)		;no args is ok
	beq	rnd01		;branch if no args
	jsr	r5,intfun	;else collect ours
	+faf			;only one number please
	tst	(r1)+		;dump at lease one word
	.if	eq	fltlen-4
	cmp	(r1)+,(r1)+	;possible to dump 2 more
	.endc
rnd01:	tst	(r1)+		;final 1 word dump
	mov	spda,r4		;get a data area pointer
	mov	rndm(r4),r2	;get the last number
	mov	#31747.,r3	;3968*8+3--magic huh?
	mul	r3,r2		;unsigned multiply here
	mov	r3,rndm(r4)	;save the result
	.if	eq	.math.
	asl	r3		;dump sign to conform with 3-word
	mov	#201,r2		;set up exponent
rndnrm:	dec	r2		;normalize loop
	asl	r3		;left bit into carry
	bcc	rndnrm		;keep working if m.s. bit not passed
	swab	r2		;exponent into high byte
	swab	r3		;switch mantissa bytes
	bisb	r3,r2		;high mantissa byte with exponent
	clrb	r3		;next byte at top of r3
	ror	r2		;adjust m.s. word for sign insertion
	ror	r3		;overflow into next m.s. word
	fltclr	-(r1)		;maybe some zeroes for 4-word
	mov	r3,-(r1)	;next m.s. word
	mov	r2,-(r1)	;m.s. word
	.if	ndf	decmap
	rts	pc
	.iff
	tst	scafac		;scaling?
	beq	rndrts		;no
	jmp	scacr1		;yes, correct
	.endc
	.endc
	.if	ne	.math.
	bic	#100000,r3	;make it +
	mov	r3,-(r1)	;and set it on stack
	clr	-(r1)		;as a floater
	fltclr	-(r1)		;all of it
	mov	#100000,-(r1)	;push .032768
	clr	-(r1)
	fltclr	-(r1)
	jmp	divf		;divide and exit
	.endc

random:	mov	spda,r4		;get a data area pointer
	.date			;get time -- this is not a good algorithm
	add	xrb+xrloc,rndm(r4)	;most such numbers give short cycles
	bis	#1,rndm(r4)	;make it odd
rndrts:	rts	pc		;and return
;print it absolutely for sure
prnbuf=40.
prnbuc=prnbuf-fltle5-2

	.if	eq	.math.
prinu3:	.if	eq	fltlen-2
	cmp	(r1)+,(r1)+	;clear junk on r1 stack
	.endc
printa:	jsr	pc,ftoa		;get the initial scan
prnfl1:	mov	fltle5(r1),r4	;get the scale factor
	mov	#-fltprn,r0	;-max number of digits
	.if	ne	maxsig-fltprn-1
	tst	(sp)		;called from print using?
	bne	prnf20		;if not, then normal
	mov	#-maxsig+1,r0	;if so, then give him the max
	.endc
prnf20:	mov	r1,r2		;copy the stack pointer
	sub	#prnbuc,r2	;make room for the entire string
	mov	r2,-(sp)	;save the pointer start
	mov	r1,r3		;copy input buffer pointer
	cmpb	(r3),#'0	;see if leading zero
	bne	prnf19		;if not, do not increment
	inc	r3		;if so, increment by one
prnf19:	sub	r0,r3		;move down the buffer
	cmpb	(r3),#'4	;see if rounding is needed
	bgt	prnf17		;go to round
prnf18:	cmpb	(r1),#'0	;see if one leading zero
	bne	prnf01		;branch if significant digit
	dec	r4		;adjust the scale factor
	inc	r1		;pop over the digit
prnf01:	inc	r4		;make a final adjustment to scale factor
	ifzero	eq,2(sp),prnf08	;no sign out if called from print using
	movb	prnbuf-3(r2),r3	;get the sign indicator
	bne	prnf09		;skip if negative number
	movb	#40,r3		;leading space instead of a minus sign
prnf09:	movb	r3,(r2)+	;output the sign
prnf08:	mov	r1,r3		;save start of string
	sub	r0,r1		;go to tail end of the string
prnf02:	cmpb	-(r1),#'0	;see if trailing zero
	bne	prnf03		;branch if not 
	inc	r0		;reduce sigfigs count
	bne	prnf02		;branch of more to test
	dec	r0		;one digit for number = 0
	inc	r4		;and make the scale factor 1
prnf03:	jmp	@prinu0		;dispatch to "prnfl3" or print using
prnfl3:	cmp	r4,#fltprn	;see if too big to print
	bgt	prnf10		;branch if e format required
	tst	r4		;see if negative
	bgt	prnf05		;if positive output some now
	add	r4,r0		;compute field length
	cmp	r0,#-fltprn	;see if too long
	blt	prnf10		;branch for e format
	sub	r4,r0
	movb	#'.,(r2)+	;start littles with .
	tst	r4		;see if any leading 0 needed
prnf04:	bpl	prnf05		;if ready go put out digits
	movb	#'0,(r2)+	;store a space holdin 0
	inc	r4		;adjust scale factor upwards
	br	prnf04		;loop for more

prnf05:	movb	(r3)+,(r2)+	;move a really digit
	dec	r4		;reduce the count
	bgt	prnf05		;branch if still good numbers to go
	bne	prnf06		;branch if filling up space
	cmp	r3,r1		;see if end of significance
	bhi	prnf07		;exit if all done
	movb	#'.,(r2)+	;store a .
	br	prnf05		;loop for more goodness

prnf06:	cmp	r3,r1		;see if goodness remains
	blos	prnf05		;branch if too soon to quit
prnf07:	jsr	pc,@prinu1	;dispatch to a "rts pc" or print using
prnfl5:	movb	#40,(r2)+	;insert trailing space
	clrb	(r2)+		;trailing null for printl
	mov	(sp)+,r2	;restore data pointer
	mov	r2,r1		;r2 is a good guess
	add	#prnbuf,r1	;now we have it
	rts	pc		;and return with it on the stack

prnf10:	movb	#'.,(r2)+	;output a leading .
prnf11:	movb	(r3)+,(r2)+	;move a digit
	cmp	r3,r1		;see if done
	blos	prnf11		;loop if more digits
prnfl2:	movb	#'e,(r2)+	;store the e thing
	tst	r4		;see if + or -
	bpl	prnf12		;branch if + or 0
	movb	#'-,(r2)+	;make it minus when it prints
	neg	r4		;and back to +
	br	prnf13		;skip following statement
prnf12:	movb	#40,(r2)+	;output the sign(positive)
prnf13:	mov	r2,-(sp)	;save our place please mister
	mov	r2,r1		;for ftoa tail end
	clr	r3		;high order of r4
	mov	#prnf14,-(sp)	;return address
	.if	eq	fltlen-4
	clr	r2		;higher order of r4
	clr	-(sp)		;higher order of r4
	.endc
	mov	#3,-(sp)	;counter for ftoa06
	mov	#atofth,r0	;table start
	jmp	ftoa09		;go find the exponent

prnf16:	cmpb	-(r3),#'9	;see if current digit can be incr.
	beq	prnf17		;if not, branch out
	incb	(r3)		;increment digit
	br	prnf18		;branch back

prnf17:	movb	#'0,(r3)	;store zero as digit
	br	prnf16		;go to increment previous digit

prnf14:	mov	(sp)+,r2	;restore our position
	clr	r4		;for prnf05 stuff
	mov	r2,r1
	mov	r1,r3		;just fixing up the various registers
	add	#3.,r1		;for prnf05 loop
	jsr	pc,@prinu1	;dispatch to a "rts pc" or print using
prnf15:	cmpb	(r3),#'0	;see if leading zero
	bne	prnf05		;exit if found the end
	inc	r3		;pop pointer
	br	prnf15		;loop there must be one!!
	.endc
	.if	ne	.math.
prinu3:				;always 4 word
printa:	jsr	pc,ftoa		;convert to ascii
prnfl1:	mov	fltle5(r1),r4	;get the scale counter
	mov	r1,r2		;copy the r1 stack
	sub	#prnbuc,r2	;make room for the entire string
	mov	r2,-(sp)	;save r2 for later
	mov	r1,r0		;copy pointer to digit start
prnf10:	cmpb	(r1),#'0	;delete leading 0's
	bne	prnf11		;non-zero
	inc	r1		;go to next digit
	dec	r4		;one less digit before dot
	cmp	r4,#-6.		;watch out for true 0
	bgt	prnf10		;still o.k.
	mov	#1,r4		;if true 0, say 0
	mov	r0,r1		;and start at the top
prnf11:	ifzero	eq,2(sp),prnf08	;print using no sign check
	movb	prnbuf-3(r2),r3	;get sign
	bne	prnf09		;it is -
	mov	#40,r3		;if +, make it space
prnf09:	movb	r3,(r2)+	;set sign
prnf08:	mov	r1,r3		;copy pointer
	mov	r0,r1		;get pointer to start
	add	#maxsig,r1	;then go to the tail end+1
prnf02:	cmpb	-(r1),#'0	;trailing 0?
	bne	prnf03		;nope
	cmp	r1,r0		;true 0 check again
	bhi	prnf02		;still o.k.
prnf03:	jmp	@prinu0		;print using check
prnfl3:	tst	r4		;decimals?
	bgt	prnd05		;nope
	movb	#'.,(r2)+	;yes, set it
	tst	r4		;0's?
prnf04:	bpl	prnd05		;nope
	movb	#'0,(r2)+	;yes
	inc	r4		;correct counter
	br	prnf04		;and continue

prnd05:	movb	(r3)+,(r2)+	;move digit
	dec	r4		;more?
	bgt	prnd05		;yes
	bne	prnf06		;decimal?
	cmp	r3,r1		;end?
	bhi	prnf07		;yes
	movb	#'.,(r2)+	;set decimal point
	br	prnd05		;continue

prnf06:	cmp	r3,r1		;end?
	blos	prnd05		;nope
prnf07:	movb	#40,(r2)+	;trailing space
	clrb	(r2)+		;and null
	mov	(sp)+,r2	;restore r2
	mov	r2,r1		;set r1
	add	#prnbuf,r1	;and correct it
	rts	pc		;then exit

prnf05:
prnf15:
prnfl2:	halt			;just in case!!
	.endc
pstjs:	mov	spda,r3		;get spda pointer
	add	r1,(r1)		;make the link absolute
	mov	(r1)+,(r3)	;store the new start of the chain
	sub	r3,(r3)		;and make it relative
	tst	(r1)+		;pop the length and pointer
pitjs:	tst	(r1)+		;pop integer off the stack
	rts	pc		;and return

printi:	jsr	pc,flt		;float an integer
printf:	jsr	pc,printa	;call for conversion
	br	printl		;and print it

;	comma operator routine

nxtzon:	jsr	pc,pos000	;get current position
	mov	(r1)+,r4	;place it in r4
	mov	#14.,r2		;handy zone (14.) counter
	sub	r2,r0		;initial correction
cmma01:	sub	r2,r0		;out of room?
	ble	crlf		;if so, then return carriage
	sub	r2,r4		;find fill factor
	bpl	cmma01		;still more...
	mov	#40,r2		;space is the character
cmma03:	jsr	pc,printc	;so print one
	inc	r4		;another?
	bne	cmma03		;yep
prs01:	rts	pc		;and return

;	print string routine

prints:	mov	r1,r2		;copy the stack pointer
	add	pntr(r2),r2	;point to the string
	jsr	pc,pstjs	;get rid of the string
	mov	-2(r1),r4	;but recover the string's length
	ble	prs00		;avoid trying to print null strings
	jsr	pc,printl	;else print the string
prs00:	rts	pc		;and exit

; note that "printl" looks at the return address of "prs00"!!!!!
crlf:	mov	#crlf0,r2	;output a <cr><lf>
printl:	jsr	r4,savem	;save r4,r3,r2,r0
1$:	mov	spda,r3		;get the location of the pda
	add	currio(r3),r3	;get the address of the buffer header
	bisb	#wrtary,flags(r3)	;set meddled bit
	mov	length(r3),r0	;get the length of it
	sub	bytcnt(r3),r0	;compute the bytes remaining
	mov	r3,r4		;copy the header address
	add	curloc(r4),r4	;point to the current position
10$:	dec	r0		;see if any more room
	bge	3$		;yes, skip output this time
	bitb	#force,flags(r3);force type?
	bne	20$		;yep
	clr	curblk(r3)	;serial write
20$:	mov	length(r3),bytcnt(r3)	;whole buffer
	jsr	pc,prl14	;write it
	br	1$		;back around

3$:	cmpb	#12,(r2)
	bne	4$
	clr	positn(r3)
4$:	cmpb	#10,(r2)
	bne	6$
	dec	positn(r3)
	bmi	8$
6$:	cmpb	#'	,(r2)
	bne	7$
	add	#8.,positn(r3)
	bic	#7,positn(r3)
7$:	bitb	#140,(r2)
	beq	5$
8$:	inc	positn(r3)
5$:	movb	(r2)+,(r4)+	;move a character
	cmp	10(sp),#prs00	;is this the special "prints" call?
	bne	30$		;nope, so check for end of asciz string
	dec	6(sp)		;yep, more to go?
	bgt	10$		;more to go, so send them
	br	40$		;no more, so all done

30$:	tstb	(r2)		;see if more to do
	bne	10$		;if not null then go again
40$:	sub	r3,r4		;make it relative
	mov	r4,curloc(r3)	;store the updated count
	mov	length(r3),bytcnt(r3)	;get ready for the final calc.
	sub	r0,bytcnt(r3)	;compute the byte count used
	beq	2$		;impossible - <>0 bytcnt reqd for closer
	bitb	#force,flags(r3);see if output now or later
	beq	2$		;only on eob elsewise
	jsr	pc,prl14	;output the buffer now
2$:	br	restem		;restore the registers
prl14:	mov	pntr(r3),curloc(r3)	;set up to start at the beginning
	bicb	#wrtary,flags(r3)	;clear rewrite bit
	jsr	pc,write.		;write it
	beq	1$			;no errors
	clr	bytcnt(r3)		;empty buffer on errors
	ioterr	!fatal

1$:	clr	bytcnt(r3)		;with the buffer empty
	rts	pc

printc:	jsr	r4,savem	;save the regs
	clr	-(sp)		;clear the "line"
	movb	r2,(sp)		;store the whole line
	mov	sp,r2		;set up for printl
	jsr	pc,printl	;go output a "line"
	tst	(sp)+		;remove the output area
;	br	restem

restem:	mov	(sp)+,r0	;restore r4,r3,r2,r0 and exit
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	rts	pc
atof:	clr	-(r1)
	clr	-(r1)		;set number to be to zero
	fltclr	-(r1)		;some more clears?
	clr	-(sp)		;count of sig. digits
	clr	-(sp)		;exponent
	.if	df	decmap
	movb	scaupv,(sp)	;preset scaling factor
	.endc
	clr	-(sp)		;switches in a byte
				; sig,minus,*,sign,dot,exp,*,dig
	.if	df	fpv
	seti
	.if	eq	fltlen-4
	setd
	.iff
	setf
	.endc
	.endc
atof01:	movb	(r2)+,r3	;get a character
	bic	#-177-1,r3	;clear parity and side effect
	cmpb	r3,#'0		;compare it with ascii 0
	blt	atof05		;if less than zero check special characters
	cmpb	r3,#'9		;compare with ascii 9
	bgt	atof05		;if greater than nine check for others
	bisb	#1,(sp)		;say some digit found
	sub	#'0,r3		;convert to binary
	bne	atof02		;it is non-zero
	bitb	#200,(sp)	;actual digit yet?
	bne	atof02		;if so, then call if sig.
	bitb	#10,(sp)	;seen decimal point yet?
	beq	atof01		;if no, then complete ignore
	dec	2(sp)		;if yes, then *10^-1 less
	br	atof01		;and continue
atof02:	bitb	#10,(sp)	;after decimal point
	beq	atof03		;no, so it is times 10 and add
	.if	eq	.math.
	cmp	4(sp),#maxsig	;if after decimal, is this too much
	bge	atof01		;if so, then ignore more
	.endc
	.if	ne	.math.
	cmp	2(sp),#-6	;check for too many decimals
	ble	atof01		;start ignoring
	.endc
	dec	2(sp)		;else *10^-1 less
atof03:	inc	4(sp)		;count as sig digit
	.if	ndf	fpv
	mov	r2,-(sp)	;save the input pointer
	.if	eq	.math.
	mov	r3,r4		;save the number
	fltclr	-(r1)		;push a floating 10
	clr	-(r1)
	mov	#41040,-(r1)
	.if	eq	fltlen-2
	jsr	r4,$mlr
	.word	1$,$ir,$adr,2$
	.iff
	jsr	r4,$mld
	.word	1$,$ir,$add,2$
	.iftf
1$:	mov	(sp)+,-(r1)	;put digit on stack
	jmp	@(r4)+
2$:
	.endc
	.endc
	.if	ne	.math.
	mov	r3,-(sp)	;save the number
	jsr	pc,m10		;*10.
	add	#fltle2,r1	;now point to bottom+2
	add	(sp)+,-(r1)	;and add in the new digit
	adc	-(r1)		;then carry
	adc	-(r1)		; and carry
	adc	-(r1)		;  and carry...
	.endc
	mov	(sp)+,r2	;restore the input pointer
	.endc
	.if	df	fpv
	.if	eq	fltlen-4
	ldcid	r3,f0		;f0 contains current digit
	ldd	atofta,f1	;f1 contains floating ten
	muld	(r1)+,f1	;multiply accumulated sum by 10
	addd	f1,f0		;add in digit
	std	f0,-(r1)	;store result on r1 stack
	.endc
	.if	ne	fltlen-4
	ldcif	r3,f0		;f0 contains current digit
	ldf	atofta,f1	;f1 contains floating ten
	mulf	(r1)+,f1	;multiply accumulated sum by 10
	addf	f1,f0		;add in digit
	stf	f0,-(r1)	;store result on r1 stack
	.endc
	.endc
	bisb	#201,(sp)	;set significance
	br	atof01		;get next character
atof05:	cmpb	r3,#40		;see if a <sp>
	beq	atof01		;ignore spaces
	cmpb	r3,#011		;see if a <tab>
	beq	atof01		;ignore tabs
	cmpb	r3,#'.		;compare with decimal point
	beq	atof10		;go on point
	cmpb	r3,#'-		;compare with minus sign
	beq	atof06		;branch if a - sign
	.if	eq	.math.
	cmpb	r3,#'e		;compare with an "e"
	beq	atof11		;branch if an "e"
	.endc
	cmpb	r3,#'+		;compare with a plus sign
	bne	atof12		;if not special then quit the scan
	clc			;show a + sign
	br	atof07		;handle like -

atof06:	sec			;set - sign seen
atof07:	bitb	#231,(sp)	;no numbers(s),signs(a), or decimal pt(d)
	bne	atof12		;if any are on that's and error
	bisb	#20,(sp)	;set the a switch
	bcc	atof01		;if + then next character please
	bisb	#100,(sp)	;minus fraction bit 
	br	atof01		;go get more

atof10:	bitb	#10,(sp)	;no decimal points
	bne	atof12		;branch if error
	bisb	#10,(sp)	;show decimal pt found
	br	atof01		;could be more to come

	.if	eq	.math.
atof21:	bicb	#201,(sp)	;signal error to atof12
	br	atof22		;continue at atof22

atof11:	bitb	#1,(sp)		;see if any numbers typed
	beq	atof12		;no numbers no dice
	bisb	#4,(sp)		;show e found
	jsr	pc,atoi		;go collect the exponent
	bvs	atof21		;branch if two signs or too big
	bit	#2,r4		;see if any #'s typed
	bne	atof22		;branch if o.k.
	bicb	#4,(sp)		;clear the exp flag cause its an error
	dec	r2		;so as to not be past "e"
	clr	(r1)		;and call exponent 0
atof22:	inc	r2		;pop character pointer to fix atoi exit
	add	(r1)+,2(sp)	;acculmulate exponent
	bvc	atof12		;addition is o.k.
	bicb	#201,(sp)	;else signal error
	.endc
atof12:	mov	(sp)+,r4	;get the switches
	beq	atof14		;if nothing the ans=0.
	bitb	r4,#201		;if any switches then must be digits
	beq	atof13		;no is an error
	.if	eq	.math.
	bmi	atof08		;if sig digits then continue
	clr	(sp)		;else say true 0
atof08:	bitb	r4,#100		;see if minus fraction
	beq	atof14		;if positive omit next step
	jsr	pc,negf		;make negative
atof14:	mov	(sp)+,(sp)	;get exponent
	beq	atof16		;exit if no adjustment
	bpl	atof18		;branch if positive exponent
	mov	#atoftb+mfltl2,r0  ;negative powers of 10
	neg	(sp)		;make exponent positive
	br	atof20		;make like positvesville

atof18:	mov	#atofta+mfltl2,r0  ;positive powers of 10
atof19:	cmp	(sp),#maxpow+6	;an upper limit
	bhi	atof23		;branch if out of range
atof20:	tst	(sp)		;see if any bits are left
	beq	atof16		;exit if done
	.if	ndf	fpv
	fltpp	(r0)+		;go to next element
	asr	(sp)		;get the low order bit
	bcc	atof20		;if not set don't multiply
	jsr	pc,pushf2	;push the table value
	mov	r0,-(sp)	;save the pointer
	mov	r2,-(sp)	;save the input pointer
	mov	r4,-(sp)	;save the switches
	jsr	pc,mulf		;multiply
	mov	(sp)+,r4	;restore the switches
	mov	(sp)+,r2	;restore the input pointer
	mov	(sp)+,r0	;get the pointer back
	.endc
	.if	df	fpv
	.if	eq	fltlen-4
	tstd	(r0)+		;go to next element
	asr	(sp)		;get the low order bit
	bcc	atof20		;if not set don't multiply
	ldd	(r0),f0		;load with table value
	muld	(r1)+,f0	;multiply
	std	f0,-(r1)	;store result on r1 stack
	.endc
	.if	ne	fltlen-4
	tstf	(r0)+		;go to next element
	asr	(sp)		;get the low order bit
	bcc	atof20		;if not set don't multiply
	ldf	(r0),f0		;load with table value
	mulf	(r1)+,f0	;multiply
	stf	f0,-(r1)	;store result on r1 stack
	.endc
	.endc
	br	atof20		;loop for more to do
	.endc
	.if	ne	.math.
atof14:	mov	(sp)+,(sp)	;get exponent
	add	#6.,(sp)	;correct it
	beq	atof20		;no more corrections
	tstb	r4		;any digits?
	bpl	atof16		;no, so really 0
	mov	r4,-(sp)	;save flag register
	mov	r2,-(sp)	;and input pointer
1$:	jsr	pc,m10		;multiply by 10.
	dec	4(sp)		;again?
	bne	1$		;yes
	mov	(sp)+,r2	;restore input pointer
	mov	(sp)+,r4	;and flag register
atof20:	bit	r4,#100		;negate it?
	beq	atof16		;no
	jsr	pc,negf		;yes
	br	atof16		;then exit
	.endc

atof13:	tst	(sp)+		;pop the extra word
atof17:	bis	#40000,r4	;signal the error
atof16:	tst	(sp)+		;clean up the stack
	.if	df	decmap
	tst	scafac		;scaling?
	beq	1$		;nope
	.if	ndf	fpu
	mov	r2,-(sp)	;save input pointer
	mov	r4,-(sp)	;and flags
	.iff
	ldd	(r1),f0		;get the result
	.iftf
	jsr	pc,scafix	;correct number
	.ift
	mov	(sp)+,r4	;restore flags
	mov	(sp)+,r2	;and input pointer
	.endc
1$:
	.endc
	dec	r2		;return pointing to the first bad character
	asl	r4		;set v and c as needed
	rts	pc

atof23:	post,	pstflt		;post floating point error
	mov	r1,r0		;copy r1 to r0
	clr	(r0)+		;clear a word
	clr	(r0)+		;clear another, so atof returns 0
	.if	eq	fltlen-4
	clr	(r0)+		;clear another
	clr	(r0)+		;clear another, in 4-word case
	.endc
	br	atof17		;and exit
.if	ne	.math.

m10:	mov	#fltlen,r4	;get # words to do
	add	#fltle2,r1	;point to bottom+2 of number
	clr	r2		;no current carry initially
1$:	mov	r2,-(sp)	;save the current carry
	mov	-(r1),r2	;get next to multiply
	beq	3$		;handle zero quickly
	bmi	4$		;special case ones >=32768.
	mul	#10.,r2		;r2,r3 gets x*10.
2$:	add	r3,(sp)		;add low order to current carry
	adc	r2		;if carry carries then carry
3$:	mov	(sp)+,(r1)	;load new resultant word
	sob	r4,1$		;do all of the words...
	rts	pc		;done

4$:	bic	#100000,r2	;make >=32768. into (x-32768.) [<32768.]
	mul	#10.,r2		;r2,r3 gets (x-32768.)*10.
	add	#10./2,r2	;now add in 32768.*10.
	br	2$		;and continue

	.endc
	.if	eq	.math.
;	the following is a table of powers of ten of the form
;	10^(2^n) where n is an integer

	.if	eq	fltlen-2
atofta:	.flt2	1.e1		;10^1
	.flt2	1.e2		;10^2
	.flt2	1.e4		;10^4
	.flt2	1.e8		;10^8
	.flt2	1.e16		;10^16
	.flt2	1.e32		;10^32
	.endc
	.if	eq	fltlen-4
atofta:	.flt4	1.e1		;10^1
	.flt4	1.e2		;10^2
	.flt4	1.e4		;10^4
	.flt4	1.e8		;10^8
atofti:	.flt4	1.e16		;10^16
	.flt4	1.e32		;10^32
	.endc
atoftc	=	.
;	the following is a table of powers of ten of the form
;	10^-(2^n) where n is an integer

	.if	eq	fltlen-2
atoftb:	.flt2	1.e-1		;10^-1
	.flt2	1.e-2		;10^-2
	.flt2	1.e-4		;10^-4
	.flt2	1.e-8		;10^-8
	.flt2	1.e-16		;10^-16
	.flt2	1.e-32		;10^-32
	.endc
	.if	eq	fltlen-4
atoftb:	.flt4	1.e-1		;10^-1
	.flt4	1.e-2		;10^-2
	.flt4	1.e-4		;10^-4
	.flt4	1.e-8		;10^-8
	.flt4	1.e-16		;10^-16
	.flt4	1.e-32		;10^-32
	.endc
atoftd	=	.
;	miscellaneous constants and tables
	.if	eq	fltlen-2
atoftg:	.word	000230,113200	;10000000
	.word	000017,041100	;1000000
	.word	000001,103240	;100000
	.word	000000,023420	;10000
atofth:	.word	000000,001750	;1000
	.word	000000,000144	;100
	.word	000000,000012	;10
atofte:	.flt2	1.e6		;10^6
atofti:	.flt2	1.e7		;10^7
	.endc
	.if	eq	fltlen-4
atoftg:	.word	000043,103362,067701,000000	;10000000000000000
	.word	000003,106576,122306,100000	;1000000000000000
	.word	000000,055363,010172,040000	;100000000000000
	.word	000000,004430,047162,120000	;10000000000000
	.word	000000,000350,152245,010000	;1000000000000
	.word	000000,000027,044166,164000	;100000000000
	.word	000000,000002,052013,162000	;10000000000
	.word	0,0,035632,145000		;1000000000
	.word	0,0,002765,160400		;100000000
	.word	0,0,000230,113200		;10000000
	.word	0,0,000017,041100		;1000000
	.word	0,0,000001,103240		;100000
	.word	0,0,000000,023420		;10000
atofth:	.word	0,0,000000,001750		;1000
	.word	0,0,000000,000144		;100
	.word	0,0,000000,000012		;10
atofte:	.flt4	1.e15				;10^15
	.endc
ftoa03:	mov	#atoftd+mfltl2,r0  ;table of neg powers of 10
	mov	#-maxpow,r2	;and the starting exponent value
	.if	ndf	fpv
ftoa05:	jsr	pc,pushf2	;push the number
	mov	r2,-(sp)	;save the exponent
	mov	r0,-(sp)	;and the pointer
	jsr	pc,cmpf		;do the compare
	bgt	ftoa15		;branch if no adjustment
	mov	(sp),r0		;get the pointer
	add	#atofta-atoftb,r0	;find the inverse
	jsr	pc,pushf2	;and put it on the stack
	jsr	pc,mulf		;multiply
	add	2(sp),4(sp)	;update the exponent
ftoa15:	mov	(sp)+,r0	;restore the pointer
	mov	(sp)+,r2	;restore the current exponent
	fltpp	-(r0)		;go to next item
	asr	r2		;adjust and check for the end
	bcc	ftoa05		;loop if more to do
	mov	#atofti,r0	;multiplier for here
	.endc
	.if	df	fpv
	.if	eq	fltlen-4
	setd
ftoa05:	ldd	(r0),f0		;load with the selected item
	cmpd	(r1),f0		;do the compare
	cfcc
	bgt	ftoa15		;branch if no adjustment
	mov	r0,-(sp)	;copy pointer to sp
	add	#atofta-atoftb,(sp)	;point to the inverse 
	ldd	@(sp)+,f0	;load with the inverse
	muld	(r1)+,f0	;multiply
	std	f0,-(r1)	;save product on r1 stack
	add	r2,(sp)		;update the exponent
ftoa15:	tstd	-(r0)		;go to next item
	asr	r2		;adjust and check for the end
	bcc	ftoa05		;loop if more to do
	ldd	atofti,f1	;multiplier for here
	.endc
	.if	ne	fltlen-4
	setf
ftoa05:	ldf	(r0),f0		;load with the selected item
	cmpf	(r1),f0		;do the compare
	cfcc
	bgt	ftoa15		;branch if no adjustment
	mov	r0,-(sp)	;copy pointer to sp
	add	#atofta-atoftb,(sp)	;point to the inverse
	ldf	@(sp)+,f0	;load with the inverse
	mulf	(r1)+,f0	;multiply
	stf	f0,-(r1)	;save product on r1 stack
	add	r2,(sp)		;update the exponent
ftoa15:	tstf	-(r0)		;go to next item
	asr	r2		;adjust and check for the end
	bcc	ftoa05		;loop if more to do
	ldf	atofti,f1	;multiplier for here
	.endc
	.endc
	br	ftoa16		;else go finish up like normal
ftoa:	.if	df	decmap
	mov	scafac,r0	;scaling?
	beq	1$		;nope
	.if	df	fpu
	setd
	ldd	(r1),f0		;get number
	divd	(r0),f0		;correct number
	std	f0,(r1)
	.iff
	jsr	pc,divfr0	;correct number
	.endc
1$:
	.endc
	clr	-(sp)		;sign control word
	tst	(r1)		;see if the number needs work done
	beq	ftoa12		;if zero maybe??
	bpl	ftoa01		;if positive no work needed
	jsr	pc,negf		;else make sure it's positive
	com	(sp)		;toggle the sign management word
ftoa01:	clr	-(sp)		;this word becomes the scale factor
	jsr	pc,ftoa90	;get exponent
	cmpb	r0,#200		;check to see if big or little
	blos	ftoa03		;branch if a fraction
	mov	#atoftc+mfltl2,r0  ;address of powers of ten table
	mov	#maxpow,r2	;and the first exponent
	.if 	ndf	fpv
ftoa02:	jsr	pc,pushf2	;push the selected item
	mov	r2,-(sp)	;save the exponent value
	mov	r0,-(sp)	;and the pointer
	jsr	pc,cmpf		;see which side of the fence he's on
	blt	ftoa04		;branch if no adjustment needed
	mov	(sp),r0		;get the table pointer
	add	#atoftb-atofta,r0	;point to the inverse value
	jsr	pc,pushf2	;push the inverse value
	jsr	pc,mulf		;multiplying by the inverse saves dividing
	add	2(sp),4(sp)	;adjust the scale factor accordingly
ftoa04:	mov	(sp)+,r0	;get the pointer back
	mov	(sp)+,r2	;get exponent back
	fltpp	-(r0)		;and go to next entry
	asr	r2		;see if done
	bcc	ftoa02		;loop if not quite done
	inc	(sp)		;get a real good estimate
	mov	#atofte,r0	;address of estimate
ftoa16:	jsr	pc,pushf2	;put it on the stack
	jsr	pc,mulf		;multiply to get big integer
	.endc
	.if	df	fpv
	.if	eq	fltlen-4
	setd
ftoa02:	ldd	(r0),f0		;load with the selected item
	cmpd	(r1),f0		;see which side of the fence he's on
	cfcc
	blt	ftoa04		;branch if no adjustment needed
	mov	r0,-(sp)	;copy pointer to sp
	add	#atoftb-atofta,(sp)	;point to the inverse value
	ldd	@(sp)+,f0	;load with the inverse value
	muld	(r1)+,f0	;multiplying by the inverse value saves dividing
	std	f0,-(r1)	;store product on r1 stack
	add	r2,(sp)		;adjust the scale factor accordingly
ftoa04:	tstd	-(r0)		;go to the next entry
	asr	r2		;see if done
	bcc	ftoa02		;loop if not quite done
	inc	(sp)		;get a real good estimate
	ldd	atofte,f1	;load with estimate
ftoa16:	muld	(r1)+,f1	;multiply to get big integer
	std	f1,-(r1)	;store result on r1
	.endc
	.if	ne	fltlen-4
	setf
ftoa02:	ldf	(r0),f0		;load with the selected item
	cmpf	(r1),f0		;see which side of the fence he's on
	cfcc
	blt	ftoa04		;branch if no adjustment needed
	mov	r0,-(sp)	;copy pointer to sp
	add	#atoftb-atofta,(sp)	;point to the inverse value
	ldf	@(sp)+,f0	;load with the inverse value
	mulf	(r1)+,f0	;multiplying by the inverse saves dividing
	stf	f0,-(r1)	;store product on r1 stack
	add	r2,(sp)		;adjust the scale factor accordingly
ftoa04:	tstf	-(r0)		;go to the next entry
	asr	r2		;see if done
	bcc	ftoa02		;loop if not quite done
	inc	(sp)		;get a real good estimate
	ldf	atofte,f1	;load with estimate
ftoa16:	mulf	(r1)+,f1	;multiply to get big integer
	stf	f1,-(r1)	;store result on r1
	.endc
	.endc
	.if	eq	fltlen-2
	mov	#230,r2		;the exponent for double precision
	clr	r3
	bisb	(r1),r3		;get the high order fraction
	bis	#200,r3		;set bit for unhidden normalization
	jsr	pc,ftoa90	;pick up exponent
	tst	(r1)+		;pop r1
	mov	(r1)+,r4	;get the low order fraction
	sub	r0,r2		;calculate the shift needed
	.endc
	.if	eq	fltlen-4
	mov	#270,-(sp)	;the exponent for double precision
	jsr	pc,ftoa90	;pick up exponent
	sub	r0,(sp)		;calculate the shift needed
	clr	r0
	bisb	(r1),r0		;get the high order fraction
	bis	#200,r0		;set bit for unhidden normalization
	tst	(r1)+		;pop r1
	mov	(r1)+,r2	;get second word of magnitude
	mov	(r1)+,r3	;get third word of magnitude
	mov	(r1)+,r4	;get fourth word of magnitude
	tst	(sp)		;check shift needed
	.endc
	beq	ftoa11		;branch if none to be done
	.if	ne	fltlen-4
ftoa06:	asr	r3		;move the high part one bit
	ror	r4		;and put it in the low order
	dec	r2		;count down one
	.endc
	.if	eq	fltlen-4
ftoa06:	asr	r0		;move the high part one bit
	ror	r2		;and put in the lower parts
	ror	r3
	ror	r4
	dec	(sp)		;count down one
	.endc
	bgt	ftoa06		;loop if more to do
ftoa11:
	.if	eq	fltlen-4
	tst	(sp)+		;remove counter from sp
	.endc
	mov	(sp)+,-(r1)	;copy the scale factor over
	tst	(sp)+		;see about the sign
	beq	ftoa07		;branch if positive
	mov	(pc)+,-(r1)	;set - sign in odd byte
	.byte	0,'-
	br	ftoa08		;rejoin the main stream code

	.if	eq	fltlen-2
ftoa12:	tst	(sp)+		;get rid of sign word
	tst	(r1)+		;pop one of two zero words
	.endc
	.if	eq	fltlen-4
ftoa12:	tst	(sp)+		;get rid of sign word
	add	#6,r1		;pop three of four zero words
	clr	r0
	clr	r2
	.endc
	clr	r3		;clear the number
	clr	r4		;high and low order

ftoa07:	clr	-(r1)		;store a zero for a sign
ftoa08:	clr	-(r1)		;clear a
	clr	-(r1)		;  small output
	clr	-(r1)		;    buffer
	clr	-(r1)		
	fltclr	-(r1)		;do some clearing?
	.if	eq	fltlen-4
	clr	-(r1)
	clr	-(r1)
	clr	-(r1)
	mov	r0,-(sp)
	.endc
	mov	#maxsig,-(sp)	;start a counter
	mov	#atoftg,r0	;integer powers of ten stuff
	.if	ne	fltlen-4
ftoa09:	mov	#-1,r2		;quotient register
ftoa10:	inc	r2		;count the subtractions
	sub	(r0),r3		;do a double
	sub	2(r0),r4	;  precision
	sbc	r3		;    subtraction
	bpl	ftoa10		;loop if no overdraw
	add	(r0)+,r3	;else correct 
	add	(r0)+,r4	;the error
	adc	r3		;with a double add
	add	#'0,r2		;convert to ascii
	movb	r2,(r1)+	;and store it
	.endc
	.if	eq	fltlen-4
ftoa09:	mov	#-1,-(sp)	;quotient register
ftoa10:	inc	(sp)		;count the subtractions
	mov	4(sp),-(sp)	;save the current value
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	r4,-(sp)
	sub	6(r0),r4	;do
	sbc	r3		;  a
	sbc	r2
	sbc	12.(sp)
	sub	4(r0),r3	;    multiple
	sbc	r2		;      precision
	sbc	12.(sp)
	sub	2(r0),r2	;        subtract
	sbc	12.(sp)
	sub	(r0),12.(sp)
	bmi	ftoa13		;branch if overdrawn
	add	#8.,sp		;reset sp
	br	ftoa10		;loop back again
ftoa13:	mov	(sp)+,r4	;restore previous value
	mov	(sp)+,r3
	mov	(sp)+,r2
	mov	(sp)+,4(sp)
	add	#8.,r0		;move to next value in table
	add	#'0,(sp)	;convert to ascii
	movb	(sp)+,(r1)+	;and store it
	.endc
	dec	(sp)		;see if more to do
	bgt	ftoa09		;if + go again
	add	#'0,r4		;finish up the last digit
	movb	r4,(r1)+	;and store it away
	clrb	(r1)		;clear next byte
	sub	#maxsig+1,r1	;go back to the top of r1
	.if	eq	fltlen-4
	cmp	(sp)+,(sp)+	;get rid of counter and mag word
	.endc
	.if	ne	fltlen-4
	tst	(sp)+		;get rid of counter
	.endc
	rts	pc

ftoa90:	mov	(r1),r0		;pick up exponent word
	asl	r0		;shift off sign bit
	clrb	r0		;clear mag bits
	swab	r0		;move exponent to right of word
	rts	pc		;return
	.endc
.enabl	lsb

printm:	mov	#printf,-(sp)	;print magnitude
fltmag:
.if	eq	.math.
	jsr	pc,flt		;float it
	tst	(r1)		;is it pseudo negative?
	bpl	1$		;no
	mov	#addf,-(sp)	;yes, so add two floaters after
fltbig:	fltclr	-(r1)		;pushing a floating
	clr	-(r1)
	mov	#44200,-(r1)	;+65536 decimal
	.if	df	decmap
	mov	scafac,r0	;get scaling pointer
	beq	1$		;none
	jsr	pc,mulfr0	;make +65536. into scaled value
	.endc
1$:	rts	pc
.endc
.if	ne	.math.
	clr	-(r1)		;msb is always zero
fltbig:	clr	-(sp)		;insure number stays positive
	br	flt.02		;now go float it
.endc

.dsabl	lsb

;time frame definition
time01:	.time			;get timing data
	dec	r2		;make 1, 2, 3, 4 into 0, 1, 2, 3
	asl	r2		;make 0, 1, 2, 3 into 0, 2, 4, 6
	bic	#-6-1,r2	;insure range
	mov	xrb(r2),-(r1)	;move lsb of answer onto r1 stack as integer
	bit	r2,#2		;was it 2(con) or 6(dev)??
	bne	fltmag		;yes, so just float it and exit
	.if	eq	.math.
	mov	xrb+10(r2),-(sp);no, so save msb of 0(cpu) or 4(kct's)
	jsr	pc,fltmag	;now float magnitude of lsb
	jsr	pc,fltbig	;put a 65536. on r1 stack
	mov	(sp)+,-(r1)	;put the msb onto r1 stack
	mov	#addf,-(sp)	;add lsb and msb after
	mov	#mulf,-(sp)	;multiplying r1 stack items after
	br	fltmag		;floating magnitude of msb
	.endc
	.if	ne	.math.
	mov	xrb+10(r2),-(r1);no, put msb on r1 stack also
	br	fltbig		;now float it
	.endc

timef:	jsr	r5,intfun	;call function arbitrator
	+fai			;get an integer
	mov	(r1)+,r2	;pop if off
	bne	time01		;branch if not 0
	.date			;get time into xrb+xrbc and xrb+xrloc(byte)
	.if	ndf	fpv
	mov	#60.,-(r1)	;number of minutes in an hour
	jsr	pc,flt		;float it
	mov	#1440.,-(r1)	;number of minutes in a day
	sub	xrb+xrbc,(r1)	;see how many left
	jsr	pc,flt		;float for multiplying
	.if	ndf	decmap
	jsr	pc,mulf		;make into seconds
	.iff
	jsr	pc,mulf.s	;make into seconds
	.endc
	mov	#60.,-(r1)	;seconds in a minute
	clr	-(r1)		;make for a funny movb
	movb	xrb+xrloc,(r1)	;seconds till next minute
	sub	(r1)+,(r1)	;and make from instead of to
	jsr	pc,flt		;float for adding
	br	addf		;and away we go
	.endc
	.if	df	fpv
	seti
	.if	eq	fltlen-4
	setd
	ldcid	#60.,f0		;number of minutes in an hour
	mov	#1440.,-(r1)	;number of minutes in a day
	sub	xrb+xrbc,(r1)	;see how many left
	ldcid	(r1)+,f1	;convert for multiplying
	muld	f0,f1		;make into seconds
	mov	#60.,-(r1)	;seconds in a minute
	clr	-(r1)		;make for a funny movb
	movb	xrb+xrloc,(r1)	;seconds till next minute
	sub	(r1)+,(r1)	;and make from instead of to
	ldcid	(r1)+,f0	;convert for adding
	addd	f0,f1		;add
	.if	df	decmap
	mov	scafac,r0	;get scaling pointer
	beq	1$		;none
	muld	(r0),f1		;one
1$:
	.endc
	std	f1,-(r1)	;and store on r1
	rts	pc		;return
	.endc
	.if	ne	fltlen-4
	setf
	ldcif	#60.,f0		;number of minutes in an hour
	mov	#1440.,-(r1)	;number of minutes in a day
	sub	xrb+xrbc,(r1)	;see how many left
	ldcif	(r1)+,f1	;convert for multiplying
	mulf	f0,f1		;make into seconds
	mov	#60.,-(r1)	;seconds in a minute
	clr	-(r1)		;make for a funny movb
	movb	xrb+xrloc,(r1)	;seconds till next minute
	sub	(r1)+,(r1)	;and make from instead of to
	ldcif	(r1)+,f0	;convert for adding
	addf	f0,f1		;add
	.if	df	decmap
	mov	scafac,r0	;get scaling pointer
	beq	1$		;none
	mulf	(r0),f1		;one
1$:
	.endc
	stf	f1,-(r1)	;and store on r1
	rts	pc		;return
	.endc
	.endc
	org	dm
.if	df	decmap
.sbttl	decimal (scaling) math routines

; function enter

.enabl	lsb

dsctst:	jsr	r5,intfun	;get a floating arg
	args	faf
	mov	scafac,r0	;get scaling pointer
	.if	df	fpu
	beq	1$		;none
	setd
	ldd	(r1),f0		;get arg
	divd	(r0),f0		;and correct it
	std	f0,(r1)		;restore arg
	.iff
	bne	1$		;one
	rts	pc		;none

1$:	jsr	pc,divfr0	;divide by correction
	.iftf
	jsr	pc,@(sp)+	;call function as co-routine
dscdne:
	.ift
scacr1:	setd
	ldd	(r1),f0		;get result
	muld	@scafac,f0	;correct result
scafix:	modd	#1.0,f0		;get integer part
	std	f1,(r1)		;and store it on r1 stack
1$:	rts	pc
	.iff
scacr1:	jsr	pc,mulfsc	;correct result
	jmp	scafix		;get integer part
	.endc

.dsabl	lsb
;routine to process scale command, with or without arg

	.iftf
doscal:
	.iff
	errerr	!fatal		;no scaling
	.ift
	jsr	pc,gusint	;get a non-negative integer
	bne	10$		;no integer there for us
	mov	(r1)+,-(sp)	;save scale factor on sp stack
	jsr	pc,tlgenp	;is next eol?
99$:	sasyne	!fatal		;no is error
	cmp	(sp),#6		;is scale factor 0 to 6 ??
	bhi	99$		;nope, error
	movb	(sp)+,scaval	;yep, so set new factor
5$:	jmp	edctlh		;and exit to editor again

10$:	jsr	pc,tlendp	;is this eol?
	br	99$		;no is an error
	cmp	toka(r0),#endol	;yes, but is it ":"?
	bne	99$		;this command must end with real eol
	clr	-(r1)		;all o.k., select channel #0
	jsr	pc,sso		; for outputting the message
	movb	scaval,r2	;get user settable scale factor value
	add	#'0,r2		;now make it into ascii
	jsr	pc,printc	;and print it
	movb	scaupv,r4	;now get program's scale factor value
	add	#'0,r4		;and make it ascii also
	cmp	r2,r4		;do scale factors match?
	beq	20$		;yes
	mov	#',,r2		;no, so separate them with a comma
	jsr	pc,printc	; and print that comma
	mov	r4,r2		;now set program's scalue value
	jsr	pc,printc	;and print that
20$:	jsr	pc,crlf		;finally restore the carriage
	br	5$		;and exit
.sbttl	scaling set up

scainx:	movb	r2,scaval	;set scaling value
	.iftf
scaini:	movb	r2,scaupv	;set user program scale factor
	.ift
	ash	#4,r2		;scale times 16. for table offset
	.iftf
	mov	r2,scafac	;set scaling pointer
	.ift
	beq	1$		;no scaling, leave pointer=0
	add	#scatab+<4*2>,scafac;scaling, make ptr abs to "one"
1$:
	.endc
	rts	r5		;now exit

scasup:	.if	ne	.math.
	decb	(r1)+		;must = .math. (which = 1)
	beq	20$		;o.k.
	.endc
	.if	eq	.math.
	.if	ndf	decmap
	tstb	(r1)+		;check scaling factor
	beq	20$		;=0 is o.k.
	.iff
	movb	(r1)+,r2	;get scaling factor
	neg	r2		;it is stored negative...
	bge	scainx		;o.k. if >=0 now
	.endc
	.endc
	tst	(r5)+		;take error exit
20$:	rts	r5		;take o.k. exit

	org	ma
.sbttl	math initialize and exception traps

	tmporg	mi
.if	df	fpu
	ldfps	#7400		;init fpu
	.sig
	+	sigfpt
	+	fpp.in
.endc
.if	df	fis
	.sig
	+	sigfpt
	+	fis.in
.endc
	rts	pc
	unorg

xxx.in:	flterr		;an error for floating point processor
	jmp	ederrf	;call it fatal
.globl	ederrf
