#include	"../h/local.h"
#include	"opt00.h"
#include	"optex.h"
#include	"../h/em1.h"

pass_3() {
	register line_t *lnp;
	register mnem_t *mnem;
	register instr;

	/*
	 * write out compact code
	 */

	pass = 3;
	for (lnp= line; lnp <= last_line; lnp++) {
		instr = lnp->instr_num&0377;
		if (instr == op_PSEU && lnp->type1 == PSEUDO)
			print_list(lnp->ad.ad_i);
		else {
			if (lnp->type1 == PSEUDO) {
				continue;
			}
			if (instr == op_loc && lnp->ad.ad_i<0 && lnp->ad.ad_i>= -255) {
				/*
				 * make lnc instruction
				 */
				instr = op_lnc;
				lnp->ad.ad_i = -lnp->ad.ad_i;
			}
			mnem = &mnemon[instr];
			curmnem = mnem;
			if (instr == op_lab)
				outlab(lnp->ad.ad_lp);
			else
				gen(instr,lnp->type1,lnp->ad.ad_i);
		}
	}
}

outlab(lbp) locl_t *lbp; {
	register num;

	/*
	 * write out local label.
	 */
	num = lbp->l_num;
	if (num < sp_nilb0)
		outbyte(sp_filb0+num);
	else if (num <= 255) {
		outbyte(sp_ilb1);
		outbyte(num);
	} else {
		outbyte(sp_ilb2);
		outbyte(num&0377);
		outbyte(num>>8);
	}
}

gen(instr,type,addr) {
	addr_u ad;

	ad.ad_i = addr;
	outbyte(instr=& 0377);
	if ((mnemon[instr].m_flags&MNXYZ) != MNZ)
	switch(type) {
	case LOCSYM:
		ad.ad_i = ad.ad_lp->l_num;
		/* fall through */
	case CONST:
		pr_int(ad.ad_i,outbyte);
		break;
	case PROCNAME:
		pr_str(sp_pnam,ad.ad_pp->p_name,outbyte);
		break;
	case GLOSYM:
		pr_glo(ad.ad_gp->g_name,outbyte);
		break;
	default:fatal("bad type during output");
	}
}
