;;;	/ p o p / u s r / l i b / N e w p o s i t i o n . p
;;;	Aaron Sloman				December 1977
;;;	A version of function Newposition from Steve Hardy's turtle program.
;;;	for use with the tektronix graphics package.
;;;	Uses real numbers instead of integers.
;;;	see library functions cos and sin in /pop/lib
;;;	see also /pop/usr/lib/Costable.p
vars xposition;	;;;	A number representing the x - position of the turtle
vars yposition;
0 -> xposition; 0 -> yposition;
vars heading;	;;;	The angle the turtle would have to turn, in a clockwise direction, 
		;;;	to be facing along the x - axis, to the right.
0 ->heading;

Uses Costable;
function Newposition(amount) => newx newy;
	(xposition + amount * cos(heading)) -> newx;
	(yposition + amount * sin(heading)) -> newy;
end;
function jump(amount);
	Newposition(amount) -> yposition -> xposition;
end;

function jumpto(newx, newy);
	newx -> xposition;
	newy -> yposition;
end;

function jumpby(dx, dy);
	xposition + dx -> xposition;
	yposition + dy -> yposition;
end;

;;;	These function all move the turtle without altering the picture

function turn(angle);
	heading + angle -> heading;
	while heading >= 360 then heading - 360 -> heading close;
	while heading < 0 then heading + 360 -> heading close;
end;
;;;	This function alters the turtles heading
