/
/	gtcod -- convert to code
/
/	(xr)		      object to be converted
/	jsr	pc,gtcod      call to convert to code
/	.word	loc	      transfer loc if convert impossible
/	(xr)		      pointer to resulting cdblk
/	(xl,wa,wb,wc,ra)      destroyed
/
/	if a spitbol error occurs during compilation or pre-
/	evaluation, control is passed via error section to exfal
/	without returning to this routine.
/
gtcod:	/prc	e,1		 / entry point
	cmp	(xr),$bzcds	 / jump if already code
	beq	gtcd1
	cmp	(xr),$bzcdc	 / jump if already code
	beq	gtcd1
/
/	here we must generate a cdblk by compilation
/
	mov	xr,-(sp)	 / stack argument for gtstg
	jsr	pc,gtstg	 / convert argument to string
		gtcd2		 / jump if non-convertible
	mov	flptr,gtcef	 / save fail ptr in case of error
	mov	rzcod,rzgtc	 / also save code ptr
	mov	xr,rzcim	 / else set image pointer
	mov	wa,scnil	 / set image length
	clr	scnpt		 / set scan pointer
	mov	$stgxc,stage	 / set stage for execute compile
	jsr	pc,cmpil	 / compile string
	mov	$stgxt,stage	 / reset stage for execute time
/
/	merge here if no convert required
/
gtcd1:	add	$1*2,(sp)	 / give normal gtcod return
	rts	pc
/
/	here if unconvertible
/
gtcd2:	mov	*(sp)+,pc	 / give error return
	/enp			 / end procedure gtcod
/
/	gtexp -- convert to expression
/
/	(xr)		      input value to be converted
/	jsr	pc,gtexp      call to convert to expression
/	.word	loc	      transfer loc if convert impossible
/	(xr)		      pointer to result exblk or seblk
/	(xl,wa,wb,wc,ra)      destroyed
/
/	if a spitbol error occurs during compilation or pre-
/	evaluation, control is passed via error section to exfal
/	without returning to this routine.
/
gtexp:	/prc	e,1		 / entry point
	cmp	(xr),$bzezz	 / jump if already an expression
	blos	gtex1
	mov	xr,-(sp)	 / store argument for gtstg
	jsr	pc,gtstg	 / convert argument to string
		gtex2		 / jump if unconvertible
/
/	here we convert a string by compilation
/
	mov	xr,rzcim	 / set input image pointer
	clr	scnpt		 / set scan pointer
	mov	wa,scnil	 / set input image length
	clr	wb		 / set code for normal scan
	mov	flptr,gtcef	 / save fail ptr in case of error
	mov	rzcod,rzgtc	 / also save code ptr
	mov	$stgev,stage	 / adjust stage for compile
	jsr	pc,expan	 / build tree for expression
	clr	scnrs		 / reset rescan flag
	cmp	scnpt,scnil	 / error if not end of image
	bne	gtex2
	clr	wb		 / set ok value for cdgex call
	mov	xr,xl		 / copy tree pointer
	jsr	pc,cdgex	 / build expression block
	clr	rzcim		 / clear pointer
	mov	$stgxt,stage	 / restore stage for execute time
/
/	merge here if no conversion required
/
gtex1:	add	$1*2,(sp)	 / return to gtexp caller
	rts	pc
/
/	here if unconvertible
/
gtex2:	mov	*(sp)+,pc	 / take error exit
	/enp			 / end procedure gtexp
/
/	gtint -- get integer value
/
/	gtint is passed an object and returns an integer after
/	performing any necessary conversions.
/
/	(xr)		      value to be converted
/	jsr	pc,gtint      call to convert to integer
/	.word	loc	      transfer loc for convert impossible
/	(xr)		      resulting integer
/	(wc,ra)		      destroyed
/	(wa,wb)		      destroyed (only on conversion err)
/	(xr)		      unchanged (on convert error)
/
gtint:	/prc	e,1		 / entry point
	cmp	(xr),$bzicl	 / jump if already an integer
	beq	gtin2
	mov	wa,gtina	 / else save wa
	mov	wb,gtinb	 / save wb
	jsr	pc,gtnum	 / convert to numeric
		gtin3		 / jump if unconvertible
	cmp	wa,$bzicl	 / jump if integer
	beq	gtin1
/
/	here we convert a real to integer
/
	mov	xr,-(sp)	 / load real value
	add	$rcval*2,(sp)
	jsr	pc,ldr
	jsr	pc,rtin		 / convert to integer (err if ovflow)
	jsr	pc,icbld	 / if ok build icblk
/
/	here after successful conversion to integer
/
gtin1:	mov	gtina,wa	 / restore wa
	mov	gtinb,wb	 / restore wb
/
/	common exit point
/
gtin2:	add	$1*2,(sp)	 / return to gtint caller
	rts	pc
/
/	here on conversion error
/
gtin3:	mov	*(sp)+,pc	 / take convert error exit
	/enp			 / end procedure gtint
/
/	gtnum -- get numeric value
/
/	gtnum is given an object and returns either an integer
/	or a real, performing any necessary conversions.
/
/	(xr)		      object to be converted
/	jsr	pc,gtnum      call to convert to numeric
/	.word	loc	      transfer loc if convert impossible
/	(xr)		      pointer to result (int or real)
/	(wa)		      first word of result block
/	(wb,wc,ra)	      destroyed
/	(xr)		      unchanged (on convert error)
/
gtnum:	/prc	e,1		 / entry point
	mov	(xr),wa		 / load first word of block
	cmp	wa,$bzicl	 / jump if integer (no conversion)
	bne	.+6
	jmp	gtn34
	cmp	wa,$bzrcl	 / jump if real (no conversion)
	bne	.+6
	jmp	gtn34
/
/	at this point the only possibility is to convert a string
/	to an integer or real as appropriate.
/
	mov	xr,-(sp)	 / stack argument in case convert err
	mov	xr,-(sp)	 / stack argument for gtstg
	jsr	pc,gtstg	 / convert argument to string
		gtn36		 / jump if unconvertible
/
/	initialize numeric conversion
/
	mov	intv0,ia	 / initialize integer result to zero
	tst	wa		 / jump to exit with zero if null
	bne	.+6
	jmp	gtn32
	mov	ia,gtnex	 / initialize exponent to zero
	clr	gtnnf		 / tentatively indicate result +
	clr	gtnsc		 / zero scale in case real
	clr	gtndf		 / reset flag for dec point found
	clr	gtnrd		 / reset flag for digits found
	mov	$reav0,-(sp)	 / zero real accum in case real
	jsr	pc,ldr
	cmp	(xr)+,(xr)+	 / point to argument characters
/
/	gtnum (continued)
/
/	merge back here after ignoring leading blank
/
gtn01:	clr	wb		 / load first character
	bisb	(xr)+,wb
	cmp	wb,$chzd0	 / jump if not digit
	blo	gtn02
	cmp	wb,$chzd9	 / jump if first char is a digit
	blos	gtn06
/
/	here if first digit is non-digit
/
gtn02:	cmp	wb,$chzbl	 / jump if non-blank
	bne	gtn03
gtna2:	sob	wa,gtn01	 / else decr count and loop back
	br	gtn07		 / jump to return zero if all blanks
/
/	here for first character non-blank, non-digit
/
gtn03:	cmp	wb,$chzpl	 / jump if plus sign
	beq	gtn04
	cmp	wb,$chzht	 / horizontal tab equiv to blank
	beq	gtna2
	cmp	wb,$chzmn	 / jump if not minus (may be real)
	bne	gtn12
	mov	sp,gtnnf	 / if minus sign, set negative flag
/
/	merge here after processing sign
/
gtn04:	dec	wa		 / jump if chars left
	bne	gtn05
	jmp	gtn36		 / else error
/
/	loop to fetch characters of an integer
/
gtn05:	clr	wb		 / load next character
	bisb	(xr)+,wb
	cmp	wb,$chzd0	 / jump if not a digit
	blo	gtn08
	cmp	wb,$chzd9	 / jump if not a digit
	bhi	gtn08
/
/	merge here for first digit
/
gtn06:	mov	ia,gtnsi	 / save current value
	mul	$10.,ia		  / current*10-(new dig) jump if ovflow
	sub	$48.,wb
	sub	wb,ia
	bvc	.+6
	jmp	gtn35
	mov	sp,gtnrd	 / set digit read flag
	sob	wa,gtn05	 / else loop back if more chars
/
/	gtnum (continued)
/
/	here to exit with converted integer value
/
gtn07:	tst	gtnnf		 / jump if negative (all set)
	beq	.+6
	jmp	gtn32
	neg	ia		 / else negate
	bvs	.+6
	jmp	gtn32
	jmp	gtn36		 / else signal error
/
/	here for a non-digit character while attempting to
/	convert an integer, check for trailing blanks or real.
/
gtn08:	cmp	wb,$chzbl	 / jump if a blank
	beq	gtn09
	cmp	wb,$chzht	 / jump if horizontal tab
	beq	gtn09
	jsr	pc,itr		 / else convert integer to real
	jsr	pc,ngr		 / negate to get positive value
	br	gtn12		 / jump to try for real
/
/	here we scan out blanks to end of string
/
gtn09:	clr	wb		 / get next char
	bisb	(xr)+,wb
	cmp	wb,$chzht	 / jump if horizontal tab
	beq	gtna9
	cmp	wb,$chzbl	 / error if non-blank
	beq	.+6
	jmp	gtn36
gtna9:	sob	wa,gtn09	 / loop back if more chars to check
	br	gtn07		 / return integer if all blanks
/
/	loop to collect mantissa of real
/
gtn10:	clr	wb		 / load next character
	bisb	(xr)+,wb
	cmp	wb,$chzd0	 / jump if non-numeric
	blo	gtn12
	cmp	wb,$chzd9	 / jump if non-numeric
	bhi	gtn12
/
/	merge here to collect first real digit
/
gtn11:	sub	$chzd0,wb	 / convert digit to number
	mov	$reavt,-(sp)	 / multiply real by 10.0
	jsr	pc,mlr
	bvc	.+6
	jmp	gtn36
	mov	$gtnsr,-(sp)	 / save result
	jsr	pc,str
	mov	wb,ia		 / get new digit as integer
	jsr	pc,itr		 / convert new digit to real
	mov	$gtnsr,-(sp)	 / add to get new total
	jsr	pc,adr
	add	gtndf,gtnsc	 / increment scale if after dec point
	mov	sp,gtnrd	 / set digit found flag
	sob	wa,gtn10	 / loop back if more chars
	br	gtn22		 / else jump to scale
/
/	gtnum (continued)
/
/	here if non-digit found while collecting a real
/
gtn12:	cmp	wb,$chzdt	 / jump if not dec point
	bne	gtn13
	tst	gtndf		 / if dec point, error if one already
	beq	.+6
	jmp	gtn36
	mov	$1,gtndf	 / else set flag for dec point
	sob	wa,gtn10	 / loop back if more chars
	br	gtn22		 / else jump to scale
/
/	here if not decimal point
/
gtn13:	cmp	wb,$chzle	 / jump if e for exponent
	beq	gtn15
	cmp	wb,$chzld	 / jump if d for exponent
	beq	gtn15
/
/	here check for trailing blanks
/
gtn14:	cmp	wb,$chzbl	 / jump if blank
	beq	gtnb4
	cmp	wb,$chzht	 / jump if horizontal tab
	beq	gtnb4
	jmp	gtn36		 / error if non-blank
/
gtnb4:	clr	wb		 / get next character
	bisb	(xr)+,wb
	sob	wa,gtn14	 / loop back to check if more
	br	gtn22		 / else jump to scale
/
/	here to read and process an exponent
/
gtn15:	clr	gtnes		 / set exponent sign positive
	mov	intv0,ia	 / initialize exponent to zero
	mov	sp,gtndf	 / reset no dec point indication
	dec	wa		 / jump skipping past e or d
	bne	gtn16
	jmp	gtn36		 / error if null exponent
/
/	check for exponent sign
/
gtn16:	clr	wb		 / load first exponent character
	bisb	(xr)+,wb
	cmp	wb,$chzpl	 / jump if plus sign
	beq	gtn17
	cmp	wb,$chzmn	 / else jump if not minus sign
	bne	gtn19
	mov	sp,gtnes	 / set sign negative if minus sign
/
/	merge here after processing exponent sign
/
gtn17:	dec	wa		 / jump if chars left
	bne	gtn18
	br	gtn36		 / else error
/
/	loop to convert exponent digits
/
gtn18:	clr	wb		 / load next character
	bisb	(xr)+,wb
/
/	gtnum (continued)
/
/	merge here for first exponent digit
/
gtn19:	cmp	wb,$chzd0	 / jump if not digit
	blo	gtn20
	cmp	wb,$chzd9	 / jump if not digit
	bhi	gtn20
	mul	$10.,ia		  / else current*10, subtract new digit
	sub	$48.,wb
	sub	wb,ia
	bvs	gtn36
	sob	wa,gtn18	 / loop back if more chars
	br	gtn21		 / jump if exponent field is exhausted
/
/	here to check for trailing blanks after exponent
/
gtn20:	cmp	wb,$chzbl	 / jump if blank
	beq	gtnc0
	cmp	wb,$chzht	 / jump if horizontal tab
	beq	gtnc0
	br	gtn36		 / error if non-blank
/
gtnc0:	clr	wb		 / get next character
	bisb	(xr)+,wb
	sob	wa,gtn20	 / loop back till all blanks scanned
/
/	merge here after collecting exponent
/
gtn21:	mov	ia,gtnex	 / save collected exponent
	tst	gtnes		 / jump if it was negative
	bne	gtn22
	neg	ia		 / else complement
	bvs	gtn36
	mov	ia,gtnex	 / and store positive exponent
/
/	merge here with exponent (0 if none given)
/
gtn22:	tst	gtnrd		 / error if not digits collected
	beq	gtn36
	tst	gtndf		 / error if no exponent or dec point
	beq	gtn36
	mov	gtnsc,ia	 / else load scale as integer
	sub	gtnex,ia	 / subtract exponent
	bvs	gtn36
	tst	ia		 / jump if we must scale up
	blt	gtn26
/
/	here we have a negative exponent, so scale down
/
	mov	ia,wa		 / load scale factor, err if ovflow
/
/	loop to scale down in steps of 10**10
/
gtn23:	cmp	wa,$10.		  / jump if 10 or less to go
	blos	gtn24
	mov	$reatt,-(sp)	 / else divide by 10**10
	jsr	pc,dvr
	sub	$10.,wa		  / decrement scale
	br	gtn23		 / and loop back
/
/	gtnum (continued)
/
/	here scale rest of way from powers of ten table
/
gtn24:	tst	wa		 / jump if scaled
	beq	gtn30
	mov	$cfpzr,wb	 / else get indexing factor
	mov	$reav1,xr	 / point to powers of ten table
	asl	wa		 / convert remaining scale to byte ofs
/
/	loop to point to powers of ten table entry
/
gtn25:	add	wa,xr		 / bump pointer
	sob	wb,gtn25	 / once for each value word
	mov	xr,-(sp)	 / scale down as required
	jsr	pc,dvr
	br	gtn30		 / and jump
/
/	come here to scale result up (positive exponent)
/
gtn26:	neg	ia		 / get absolute value of exponent
	bvs	gtn36
	mov	ia,wa		 / acquire scale, error if ovflow
/
/	loop to scale up in steps of 10**10
/
gtn27:	cmp	wa,$10.		  / jump if 10 or less to go
	blos	gtn28
	mov	$reatt,-(sp)	 / else multiply by 10**10
	jsr	pc,mlr
	bvs	gtn36
	sub	$10.,wa		  / else decrement scale
	br	gtn27		 / and loop back
/
/	here to scale up rest of way with table
/
gtn28:	tst	wa		 / jump if scaled
	beq	gtn30
	mov	$cfpzr,wb	 / else get indexing factor
	mov	$reav1,xr	 / point to powers of ten table
	asl	wa		 / convert remaining scale to byte ofs
/
/	loop to point to proper entry in powers of ten table
/
gtn29:	add	wa,xr		 / bump pointer
	sob	wb,gtn29	 / once for each word in value
	mov	xr,-(sp)	 / scale up
	jsr	pc,mlr
	bvs	gtn36
/
/	gtnum (continued)
/
/	here with real value scaled and ready except for sign
/
gtn30:	tst	gtnnf		 / jump if positive
	beq	gtn31
	jsr	pc,ngr		 / else negate
/
/	here with properly signed real value in (ra)
/
gtn31:	jsr	pc,rcbld	 / build real block
	br	gtn33		 / merge to exit
/
/	here with properly signed integer value in (ia)
/
gtn32:	jsr	pc,icbld	 / build icblk
/
/	real merges here
/
gtn33:	mov	(xr),wa		 / load first word of result block
	add	$2,sp		 / pop argument off stack
/
/	common exit point
/
gtn34:	add	$1*2,(sp)	 / return to gtnum caller
	rts	pc
/
/	come here if overflow occurs during collection of integer
/
gtn35:	mov	gtnsi,ia	 / reload integer so far
	jsr	pc,itr		 / convert to real
	jsr	pc,ngr		 / make value positive
	jmp	gtn11		 / merge with real circuit
/
/	here for unconvertible to string or conversion error
/
gtn36:	mov	(sp)+,xr	 / reload original argument
	mov	*(sp)+,pc	 / take convert-error exit
	/enp			 / end procedure gtnum
/
/	gtnvr -- convert to natural variable
/
/	gtnvr locates a variable block (vrblk) given either an
/	appropriate name (nmblk) or a non-null string (scblk).
/
/	(xr)		      argument
/	jsr	pc,gtnvr      call to convert to natural variable
/	.word	loc	      transfer loc if convert impossible
/	(xr)		      pointer to vrblk
/	(wa,wb)		      destroyed (conversion error only)
/	(wc)		      destroyed
/
gtnvr:	/prc	e,1		 / entry point
	cmp	(xr),$bznml	 / jump if not name
	bne	gnv02
	mov	nmbas*2(xr),xr	 / else load name base if name
	cmp	xr,state	 / skip if vrblk (in static region)
	blos	gnv07
/
/	common error exit
/
gnv01:	mov	*(sp)+,pc	 / take convert-error exit
/
/	here if not name
/
gnv02:	mov	wa,gnvsa	 / save wa
	mov	wb,gnvsb	 / save wb
	mov	xr,-(sp)	 / stack argument for gtstg
	jsr	pc,gtstg	 / convert argument to string
		gnv01		 / jump if conversion error
	tst	wa		 / null string is an error
	beq	gnv01
	mov	xl,-(sp)	 / save xl
	mov	xr,-(sp)	 / stack string ptr for later
	mov	xr,wb		 / copy string pointer
	add	$schar*2,wb	 / point to characters of string
	mov	wb,gnvst	 / save pointer to characters
	mov	wa,wb		 / copy length
	add	$1,wb		 / get number of words in name
	asr	wb
	mov	wb,gnvnw	 / save for later
	jsr	pc,hashs	 / compute hash index for string
	mov	$hshnb,-(sp)	 / compute hash offset by taking mod
	jsr	pc,rmi
	mov	ia,wc		 / get as offset
	asl	wc		 / convert offset to bytes
	add	hshtb,wc	 / point to proper hash chain
	sub	$vrnxt*2,wc	 / subtract offset to merge into loop
/
/	gtnvr (continued)
/
/	loop to search hash chain
/
gnv03:	mov	wc,xl		 / copy hash chain pointer
	mov	vrnxt*2(xl),xl	 / point to next vrblk on chain
	tst	xl		 / jump if end of chain
	beq	gnv08
	mov	xl,wc		 / save pointer to this vrblk
	tst	vrlen*2(xl)	 / jump if not system variable
	bne	gnv04
	mov	vrsvp*2(xl),xl	 / else point to svblk
	sub	$vrsof*2,xl	 / adjust offset for merge
/
/	merge here with string ptr (like vrblk) in xl
/
gnv04:	cmp	wa,vrlen*2(xl)	 / back for next vrblk if lengths ne
	bne	gnv03
	add	$vrchs*2,xl	 / else point to chars of chain entry
	mov	gnvnw,wb	 / get word counter to control loop
	mov	gnvst,xr	 / point to chars of new name
/
/	loop to compare characters of the two names
/
gnv05:	cmp	(xr),(xl)	 / jump if no match for next vrblk
	bne	gnv03
	add	$2,xr		 / bump new name pointer
	add	$2,xl		 / bump vrblk in chain name pointer
	sob	wb,gnv05	 / else loop till all compared
	mov	wc,xr		 / we have found a match, get vrblk
/
/	exit point after finding vrblk or building new one
/
gnv06:	mov	gnvsa,wa	 / restore wa
	mov	gnvsb,wb	 / restore wb
	add	$2,sp		 / pop string pointer
	mov	(sp)+,xl	 / restore xl
/
/	common exit point
/
gnv07:	add	$1*2,(sp)	 / return to gtnvr caller
	rts	pc
/
/	not found, prepare to search system variable table
/
gnv08:	clr	xr		 / clear garbage xr pointer
	mov	wc,gnvhe	 / save ptr to end of hash chain
	cmp	wa,$9.		  / cannot be system var if length gt 9
	bhi	gnv14
	mov	wa,xl		 / else copy length
	asl	xl		 / convert to byte offset
	mov	vsrch(xl),xl	 / point to first svblk of this length
/
/	gtnvr (continued)
/
/	loop to search entries in standard variable table
/
gnv09:	mov	xl,gnvsp	 / save table pointer
	mov	(xl)+,wc	 / load svbit bit string
	mov	(xl)+,wb	 / load length from table entry
	cmp	wa,wb		 / jump if end of right length entires
	bne	gnv14
	mov	gnvnw,wb	 / get word counter to control loop
	mov	gnvst,xr	 / point to chars of new name
/
/	loop to check for matching names
/
gnv10:	cmp	(xr),(xl)	 / jump if name mismatch
	bne	gnv11
	add	$2,xr		 / else bump new name pointer
	add	$2,xl		 / bump svblk pointer
	sob	wb,gnv10	 / else loop until all checked
/
/	here we have a match in the standard variable table
/
	clr	wc		 / set vrlen value zero
	mov	$vrsiz*2,wa	 / set standard size
	br	gnv15		 / jump to build vrblk
/
/	here if no match with table entry in svblks table
/
gnv11:	add	$2,xl		 / bump past word of chars
	sob	wb,gnv11	 / loop back if more to go
	clc			 / remove uninteresting bits
	ror	wc
	ash	$61.,wc
/
/	loop to bump table ptr for each flagged word
/
gnv12:	mov	bits1,wb	 / load bit to test
	mov	wc,-(sp)	 / test for word present
	com	(sp)
	bic	(sp)+,wb
	tst	wb		 / jump if not present
	beq	gnv13
	add	$2,xl		 / else bump table pointer
/
/	here after dealing with one word (one bit)
/
gnv13:	clc			 / remove bit already processed
	ror	wc
	tst	wc		 / loop back if more bits to test
	bne	gnv12
	br	gnv09		 / else loop back for next svblk
/
/	here if not system variable
/
gnv14:	mov	wa,wc		 / copy vrlen value
	mov	$vrchs,wa	 / load standard size -chars
	add	gnvnw,wa	 / adjust for chars of name
	asl	wa		 / convert length to bytes
/
/	gtnvr (continued)
/
/	merge here to build vrblk
/
gnv15:	jsr	pc,alost	 / allocate space for vrblk (static)
	mov	xr,wb		 / save vrblk pointer
	mov	$stnvr,xl	 / point to model variable block
	mov	$vrlen*2,wa	 / set length of standard fields
	asr	wa		 / set initial fields of new block
	mov	(xl)+,(xr)+
	sob	wa,.-2
	mov	gnvhe,xl	 / load pointer to end of hash chain
	mov	wb,vrnxt*2(xl)	 / add new block to end of chain
	mov	wc,(xr)+	 / set vrlen field, bump ptr
	mov	gnvnw,wa	 / get length in words
	asl	wa		 / convert to length in bytes
	tst	wc		 / jump if system variable
	beq	gnv16
/
/	here for non-system variable -- set chars of name
/
	mov	(sp),xl		 / point back to string name
	add	$schar*2,xl	 / point to chars of name
	asr	wa		 / move characters into place
	mov	(xl)+,(xr)+
	sob	wa,.-2
	mov	wb,xr		 / restore vrblk pointer
	br	gnv06		 / jump back to exit
/
/	here for system variable case to fill in fields where
/	necessary from the fields present in the svblk.
/
gnv16:	mov	gnvsp,xl	 / load pointer to svblk
	mov	xl,(xr)		 / set svblk ptr in vrblk
	mov	wb,xr		 / restore vrblk pointer
	mov	svbit*2(xl),wb	 / load bit indicators
	add	$svchs*2,xl	 / point to characters of name
	add	wa,xl		 / point past characters
/
/	skip past keyword number (svknm) if present
/
	mov	btknm,wc	 / load test bit
	mov	wb,-(sp)	 / and to test
	com	(sp)
	bic	(sp)+,wc
	tst	wc		 / jump if no keyword number
	beq	gnv17
	add	$2,xl		 / else bump pointer
/
/	gtnvr (continued)
/
/	here test for function (svfnc and svnar)
/
gnv17:	mov	btfnc,wc	 / get test bit
	mov	wb,-(sp)	 / and to test
	com	(sp)
	bic	(sp)+,wc
	tst	wc		 / skip if no system function
	beq	gnv18
	mov	xl,vrfnc*2(xr)	 / else point vrfnc to svfnc field
	add	$2*2,xl		 / and bump past svfnc, svnar fields
/
/	now test for label (svlbl)
/
gnv18:	mov	btlbl,wc	 / get test bit
	mov	wb,-(sp)	 / and to test
	com	(sp)
	bic	(sp)+,wc
	tst	wc		 / jump if bit is off (no system labl)
	beq	gnv19
	mov	xl,vrlbl*2(xr)	 / else point vrlbl to svlbl field
	add	$2,xl		 / bump past svlbl field
/
/	now test for value (svval)
/
gnv19:	mov	btval,wc	 / load test bit
	mov	wb,-(sp)	 / and to test
	com	(sp)
	bic	(sp)+,wc
	tst	wc		 / all done if no value
	bne	.+6
	jmp	gnv06
	mov	(xl),vrval*2(xr) / else set initial value
	mov	$bzvre,vrsto*2(xr) / set error store access
	jmp	gnv06		 / merge back to exit to caller
	/enp			 / end procedure gtnvr
/
/	gtpat -- get pattern
/
/	gtpat is passed an object in (xr) and returns a
/	pattern after performing any necessary conversions
/
/	(xr)		      input argument
/	jsr	pc,gtpat      call to convert to pattern
/	.word	loc	      transfer loc if convert impossible
/	(xr)		      resulting pattern
/	(wa)		      destroyed
/	(wb)		      destroyed (only on convert error)
/	(xr)		      unchanged (only on convert error)
/
gtpat:	/prc	e,1		 / entry point
	cmp	(xr),$pzaaa	 / jump if pattern already
	bhis	gtpt5
/
/	here if not pattern, try for string
/
	mov	wb,gtpsb	 / save wb
	mov	xr,-(sp)	 / stack argument for gtstg
	jsr	pc,gtstg	 / convert argument to string
		gtpt2		 / jump if impossible
/
/	here we have a string
/
	tst	wa		 / jump if non-null
	bne	gtpt1
/
/	here for null string. generate pointer to null pattern.
/
	mov	$ndnth,xr	 / point to nothen node
	br	gtpt4		 / jump to exit
/
/	gtpat (continued)
/
/	here for non-null string
/
gtpt1:	mov	$pzstr,wb	 / load pcode for multi-char string
	cmp	wa,$1		 / jump if multi-char string
	bne	gtpt3
/
/	here for one character string, share one character any
/
	cmp	(xr)+,(xr)+	 / point to character
	clr	wa		 / load character
	bisb	(xr),wa
	mov	wa,xr		 / set as parm1
	mov	$pzans,wb	 / point to pcode for 1-char any
	br	gtpt3		 / jump to build node
/
/	here if argument is not convertible to string
/
gtpt2:	mov	$pzexa,wb	 / set pcode for expression in case
	cmp	(xr),$bzezz	 / jump to build node if expression
	blos	gtpt3
/
/	here we have an error (conversion impossible)
/
	mov	*(sp)+,pc	 / take convert error exit
/
/	merge here to build node for string or expression
/
gtpt3:	jsr	pc,pbild	 / call routine to build pattern node
/
/	common exit after successful conversion
/
gtpt4:	mov	gtpsb,wb	 / restore wb
/
/	merge here to exit of no conversion required
/
gtpt5:	add	$1*2,(sp)	 / return to gtpat caller
	rts	pc
	/enp			 / end procedure gtpat
/
/	gtrea -- get real value
/
/	gtrea is passed an object and returns a real value
/	performing any necessary conversions.
/
/	(xr)		      object to be converted
/	jsr	pc,gtrea      call to convert object to real
/	.word	loc	      transfer loc if convert impossible
/	(xr)		      pointer to resulting real
/	(wa,wb,wc,ra)	      destroyed
/	(xr)		      unchanged (convert error only)
/
gtrea:	/prc	e,1		 / entry point
	mov	(xr),wa		 / get first word of block
	cmp	wa,$bzrcl	 / jump if real
	beq	gtre2
	jsr	pc,gtnum	 / else convert argument to numeric
		gtre3		 / jump if unconvertible
	cmp	wa,$bzrcl	 / jump if real was returned
	beq	gtre2
/
/	here for case of an integer to convert to real
/
gtre1:	mov	icval*2(xr),ia	 / load integer
	jsr	pc,itr		 / convert to real
	jsr	pc,rcbld	 / build rcblk
/
/	exit with real
/
gtre2:	add	$1*2,(sp)	 / return to gtrea caller
	rts	pc
/
/	here on conversion error
/
gtre3:	mov	*(sp)+,pc	 / take convert error exit
	/enp			 / end procedure gtrea
/
/	gtsmi -- get small integer
/
/	gtsmi is passed a snobol object and returns an address
/	integer in the range (0 le n le dnamb). such a value can
/	only be derived from an integer in the appropriate range.
/	small integers never appear as snobol values. however,
/	they are used internally for a variety of purposes.
/
/	-(sp)		      argument to convert (on stack)
/	jsr	pc,gtsmi      call to convert to small integer
/	.word	loc	      transfer loc for not integer
/	.word	loc	      transfer loc for lt 0, gt dnamb
/	(xr,wc)		      resulting small int (two copies)
/	(sp)		      popped
/	(ra)		      destroyed
/	(wa,wb)		      destroyed (on convert error only)
/	(xr)		      input arg (convert error only)
/
gtsmi:	/prc	n,2		 / entry point
.bss
gtsmiret:	.=.+2
.text
	mov	(sp)+,gtsmiret
	mov	(sp)+,xr	 / load argument
	cmp	(xr),$bzicl	 / skip if already an integer
	beq	gtsm1
/
/	here if not an integer
/
	jsr	pc,gtint	 / convert argument to integer
		gtsm2		 / jump if convert is impossible
/
/	merge here with integer
/
gtsm1:	mov	icval*2(xr),ia	 / load integer value
	mov	ia,wc		 / move as one word, jump if ovflow
	cmp	wc,dnamx	 / or if too large *f014*
	bhis	gtsm3
	mov	wc,xr		 / copy result to xr
	add	$2*2,gtsmiret	 / return to gtsmi caller
	mov	gtsmiret,pc
/
/	here if unconvertible to integer
/
gtsm2:	mov	*gtsmiret,pc	 / take non-integer error exit
/
/	here if out of range
/
gtsm3:	add	$1*2,gtsmiret	 / take out-of-range error exit
	mov	*gtsmiret,pc
	/enp			 / end procedure gtsmi
/
/	gtstg -- get string
/
/	gtstg is passed an object and returns a string with
/	any necessary conversions performed.
/
/	-(sp)		      input argument (on stack)
/	jsr	pc,gtstg      call to convert to string
/	.word	loc	      transfer loc if convert impossible
/	(xr)		      pointer to resulting string
/	(wa)		      length of string in characters
/	(sp)		      popped
/	(ra)		      destroyed
/	(xr)		      input arg (convert error only)
/
gtstg:	/prc	n,1		 / entry point
.bss
gtstgret:	.=.+2
.text
	mov	(sp)+,gtstgret
	mov	(sp)+,xr	 / load argument, pop stack
	cmp	(xr),$bzscl	 / jump if already a string
	bne	.+6
	jmp	gts30
/
/	here if not a string already
/
gts01:	mov	xr,-(sp)	 / restack argument in case error
	mov	xl,-(sp)	 / save xl
	mov	wb,gtsvb	 / save wb
	mov	wc,gtsvc	 / save wc
	mov	(xr),wa		 / load first word of block
	cmp	wa,$bzicl	 / jump to convert integer
	beq	gts05
	cmp	wa,$bzrcl	 / jump to convert real
	beq	gts10
	cmp	wa,$bznml	 / jump to convert name
	beq	gts03
/
/	here on conversion error
/
gts02:	mov	(sp)+,xl	 / restore xl
	mov	(sp)+,xr	 / reload input argument
	mov	*gtstgret,pc	 / take convert error exit
/
/	gtstg (continued)
/
/	here to convert a name (only possible if natural var)
/
gts03:	mov	nmbas*2(xr),xl	 / load name base
	cmp	xl,state	 / error if not natural var (static)
	bhis	gts02
	add	$vrsof*2,xl	 / else point to possible string name
	mov	sclen*2(xl),wa	 / load length
	tst	wa		 / jump if not system variable
	bne	gts04
	mov	vrsvo*2(xl),xl	 / else point to svblk
	mov	svlen*2(xl),wa	 / and load name length
/
/	merge here with string in xr, length in wa
/
gts04:	clr	wb		 / set offset to zero
	jsr	pc,sbstr	 / use sbstr to copy string
	jmp	gts29		 / jump to exit
/
/	come here to convert an integer
/
gts05:	mov	icval*2(xr),ia	 / load integer value
	mov	$1,gtssf	 / set sign flag negative
	tst	ia		 / skip if integer is negative
	blt	gts06
	neg	ia		 / else negate integer
	clr	gtssf		 / and reset negative flag
/
/	gtstg (continued)
/
/	here with sign flag set and sign forced negative as
/	required by the cvd instruction.
/
gts06:	mov	gtswk,xr	 / point to result work area
	mov	$nstmx,wb	 / initialize counter to max length
	cmp	(xr)+,(xr)+	 / prepare to store (right-left)
	add	wb,xr
/
/	loop to convert digits into work area
/
gts07:	jsr	pc,cvd		 / convert one digit into wa
	movb	wa,-(xr)	 / store in work area
	dec	wb		 / decrement counter
	tst	ia		 / loop if more digits to go
	bne	gts07
/
/	merge here after converting integer or real into work
/	area. wb is set to nstmx - (number of chars in result).
/
gts08:	mov	$nstmx,wa	 / get max number of characters
	sub	wb,wa		 / compute length of result
	mov	wa,xl		 / remember length for move later on
	add	gtssf,wa	 / add one for negative sign if needed
	jsr	pc,alocs	 / allocate string for result
	mov	xr,wc		 / save result pointer for the moment
	cmp	(xr)+,(xr)+	 / point to chars of result block
	tst	gtssf		 / skip if positive
	beq	gts09
	mov	$chzmn,wa	 / else load negative sign
	movb	wa,(xr)+	 / and store it
/
/	here after dealing with sign
/
gts09:	mov	xl,wa		 / recall length to move
	mov	gtswk,xl	 / point to result work area
	cmp	(xl)+,(xl)+	 / point to first result character
	add	wb,xl
	movb	(xl)+,(xr)+	 / move chars to result string
	sob	wa,.-2
	mov	wc,xr		 / restore result pointer
	jmp	gts29		 / jump to exit
/
/	gtstg (continued)
/
/	here to convert a real
/
gts10:	mov	xr,-(sp)	 / load real
	add	$rcval*2,(sp)
	jsr	pc,ldr
	clr	gtssf		 / reset negative flag
	jsr	pc,fts		 / skip if zero
	bne	.+6
	jmp	gts31
	jsr	pc,fts		 / jump if real is positive
	bge	gts11
	mov	$1,gtssf	 / else set negative flag
	jsr	pc,ngr		 / and get absolute value of real
/
/	now scale the real to the range (0.1 le x lt 1.0)
/
gts11:	mov	intv0,ia	 / initialize exponent to zero
/
/	loop to scale up in steps of 10**10
/
gts12:	mov	$gtsrs,-(sp)	 / save real value
	jsr	pc,str
	mov	$reap1,-(sp)	 / subtract 0.1 to compare
	jsr	pc,sbr
	jsr	pc,fts		 / jump if scale up not required
	bge	gts13
	mov	$gtsrs,-(sp)	 / else reload value
	jsr	pc,ldr
	mov	$reatt,-(sp)	 / multiply by 10**10
	jsr	pc,mlr
	sub	intvt,ia	 / decrement exponent by 10
	br	gts12		 / loop back to test again
/
/	test for scale down required
/
gts13:	mov	$gtsrs,-(sp)	 / reload value
	jsr	pc,ldr
	mov	$reav1,-(sp)	 / subtract 1.0
	jsr	pc,sbr
	jsr	pc,fts		 / jump if no scale down required
	blt	gts17
	mov	$gtsrs,-(sp)	 / else reload value
	jsr	pc,ldr
/
/	loop to scale down in steps of 10**10
/
gts14:	mov	$reatt,-(sp)	 / subtract 10**10 to compare
	jsr	pc,sbr
	jsr	pc,fts		 / jump if large step not required
	blt	gts15
	mov	$gtsrs,-(sp)	 / else restore value
	jsr	pc,ldr
	mov	$reatt,-(sp)	 / divide by 10**10
	jsr	pc,dvr
	mov	$gtsrs,-(sp)	 / store new value
	jsr	pc,str
	add	intvt,ia	 / increment exponent by 10
	br	gts14		 / loop back
/
/	gtstg (continued)
/
/	at this point we have (1.0 le x lt 10**10)
/	complete scaling with powers of ten table
/
gts15:	mov	$reav1,xr	 / point to powers of ten table
/
/	loop to 