/*
 *   This is a version of 'tp' modified by Ian Johnstone (AGSM)
 *   in PDP-11 assembler.
 *   Translated to C : Robert Elz, Melb Uni, Oct 78.
 *   Further massaged by Kevin Hill, April 1980.
 *	... and again Dec 1980 to run under level 7.
 *	Note: this is only so that level 6 dtp dumps can be read.
 *	This program is TOTALLY UNSUITABLE for a level 7 system.
 */

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
struct stat statb;
#define	L6S_IFMT	060000	/* the tape is written with level 6 modes */
#define	L6S_IFREG	000000	/* IFDIR, IFBLK, and IFCHR are the same */
#define	L6S_LOCK	002000	/* locked file */
#define	L6S_ALOK	002010	/* auto-locked */
#include	<time.h>
#include	<errno.h>	/* for EEXIST */

/*
 *	TU16 flags an OPI error if an IRG is not written within 0.7 secs
 *	of command initiation. At 800 bpi, 45 ips, this works out as
 *	about 49 blocks.  The closest power of 2 is ...
 */
#define NBLKS 32			/* blocks, which is .... */
#define NBYTES (NBLKS * 512)		/* or 16384 bytes */
#define TAPESIZE 2400			/* default tape length (feet) */

/*
 *	Record lengths (inches) at 800 and 1600 bpi resp. (rounded up).
 *	Certain magic numbers pop up here to allow for the tape IRG
 *	(I have yet to find them in the manual).
 */
#define	IRG800	534		/* 800th's of an inch */
#define	IRG1600	1067		/* 1600th's of an inch */
#define	NRZRECLEN	((NBYTES+IRG800+799)/800)
#define	PERECLEN	((NBYTES+IRG1600+1599)/1600)
int	recordln = NRZRECLEN;	/* default 800 bpi tape */

char	tape[] = "/dev/rmt0";
char	ntape[] = "/dev/rnmt0";
#define	DENS	6		/* char offset to density letter */
#define	NDENS	7
#define	UNIT	8		/* char offset to unit number */
#define	NUNIT	9
char	*mt = tape;		/* default is rmt0 */

char	tfilename[] = "/tmp/temp.dtp.xxxxx";
#define	LO	14		/* start of x's */
#define	HI	18		/* end of x's */

char	sflag, cflag, vflag, qflag, iflag;
long	seltim;
int	narg, rnarg;
char	**parg;
int	nused;
int	dirlast	= -1;		/* count of level of empty directories */
int	tmpfd;			/* file desc. of temp. file */
int	(*command)();
int	tapfd;			/* tape file desc. */
int	tpsize = TAPESIZE;
long	tapad;			/* 32 bit address for extract; else 16 */
char	tapeb[NBYTES];		/* tape i/o into here */
char	*ebufpt;
int	exta;			/* for 32 bit address */
char	obuf[BUFSIZ];		/* output buffer */
time_t	timep[2];

struct fudge		/* that I must sink to such depths.... */
{
	int f_hiwd, f_lowd;
};

struct grot
{
	char g_lobyt, g_hibyt;
};

#define	PATHL	114	/* max. pathname allowed */

struct			/* note that this structure is 128 bytes long */
{
	char	t_path[PATHL];		/* it must be a power of 2 and */
	int	t_mode;			/* a factor of 512 */
	int	t_uid;
	long	t_size;
	long	t_mtime;
	unsigned t_tapea;	/* 512-byte block address of file on tape relative to end of tape directory */
}
	tapdir;

struct			/* first 128 bytes on tape */
{
	int	h_nfiles;
	long	h_dumptime;
	int	h_ndirblks;	/* this will be zero under old format */
				/* pad out 120 chars */
}
	tapeheader;

#define	digit(c)	(c >= '0' && c <= '9')


main(argc,argv)
char **argv;
{
	register char *p, c;
	register i;
	long time();
	int cmr(), cmt(), cmx(), intr();

	setbuf(stdout, obuf);
	if (argc < 2)
		useerr();
	time(&tapeheader.h_dumptime);
	ebufpt = &tapeb[sizeof tapdir];	/* leave room for tape header */
	rnarg = narg = argc;
	argv++;			/* skip pgm. name */
	p = *argv++;
	parg = argv;

	while (c = *p++)
		switch(c)
		{
	    case '-':	break;

	    case '0':
	    case '1':
	    case '2':
	    case '3':		/* tape unit nr. */
	    case '4':
	    case '5':
	    case '6':
	    case '7':	tape[UNIT] = c;
			ntape[NUNIT] = c;
			break;

	    case 'm':	tape[DENS] = c;		/* 800 bpi */
			ntape[NDENS] = c;
			recordln = NRZRECLEN;
			break;

	    case 'h':	tape[DENS] = c;		/* 1600 bpi */
			ntape[NDENS] = c;
			recordln = PERECLEN;
			break;

	    case 'n':	mt = ntape;		/* no-rewind tape */
			break;

	    case 'f':	if (! digit(*p))	/* length of tape (feet) */
				useerr();
			i = 0;
			do
				i = i * 10 + *p++ - '0';
			while digit(*p);
			tpsize = i;
			break;

	    case 'o':	if ((rnarg = --narg) < 1)	/* output to named file instead of tape */
				useerr();
			mt = *parg++;
			break;

	    case 'x':	setcom(&cmx);		/* extract files */
			umask(0);
			break;

	    case 'r':	setcom(&cmr);		/* new tape creation */
			break;

	    case 't':	setcom(&cmt);		/* list tape contents */
			break;

	    case 's':	sflag++;		/* selective (incremental) dump */
			if (! digit(*p))
				useerr();
			i = 0;
			do
				i = i * 10 + *p++ - '0';
			while digit(*p);
			seltim = tapeheader.h_dumptime - 3600L * i;
			break;

	    case 'c':	cflag++;		/* create directories */
			break;

	    case 'v':	vflag++;		/* verbose */
			break;

	    case 'q':	qflag++;		/* question each file (y-n-x) */
			break;

	    case 'i':	iflag++;		/* ignore tape errors */
			break;

	    default:	useerr();

		}

	if (command == 0)
	{
		fprintf(stderr, "No function specified\n");
		useerr();
	}
	if (qflag == 0)	/* don't need input, but do need file descriptors */
		close(0);
	opentap();

	i = getpid();
	for (c = HI; c >= LO; c--)
	{
		tfilename[c] = i % 10 + '0';
		i /= 10;
	}
	if ((tmpfd = creat(tfilename, 0600)) < 0 ||
	    close(tmpfd) < 0 ||
	    (tmpfd = open(tfilename, 2)) < 0)
	{
		fprintf(stderr, "Can't create %s\n", tfilename);
		exit(0);
	}
	unlink(tfilename);	/* will not disappear until closed */

	(*command)();
	exit(0);
}

setcom(cmd)
int (*cmd)();
{
	if (command)
		useerr();
	command = cmd;
}

opentap()
{
	int cmr();

	if (command == &cmr)
		tapfd = creat(mt, 0600);
	else
		tapfd = open(mt, 0);
	if (tapfd < 0)
	{
		fprintf(stderr, "Can't open %s\n", mt);
		exit(0);
	}
}

useerr()
{
	fprintf(stderr, "Usage: dtp [-][rtx][mh][n][0-7][foscvqi] [name] ...\n");
	exit(0);
}

cmr()
{
	register i;
	long tlen, temp;

	if (cflag)
		useerr();
	getfiles();
	tlen = tapeheader.h_nfiles;
	tlen = tlen * sizeof tapdir;
	tlen = (tlen + NBYTES - 1) / NBYTES;	/* size of tape directory */
	temp = tapad;
	temp = (temp + NBLKS - 1) / NBLKS;	/* size of file space */
	tlen = tlen + temp;
	tlen = tlen * recordln;
	tlen = (tlen + 11) / 12;		/* size of tape in feet */

	if (tlen > tpsize)
	{
		fprintf(stderr, "Tape too small for files\n%D' tape required\n", tlen);
		exit(0);
	}

	make();
	fprintf(stderr, "%4d tape block%s\n", nused, nused == 1 ? "" : "s");
	fprintf(stderr, "%4d file%s on tape\n", tapeheader.h_nfiles,
		tapeheader.h_nfiles == 1 ? "" : "s");
}

cmt()
{
	int taboc();

	if (cflag || qflag || sflag)
		useerr();
	rddir();

	fprintf(stdout, " This dump initiated on   %s",
		ctime(&tapeheader.h_dumptime));
	if (vflag)
		fprintf(stdout,
			"    mode     uid      size   date    time name\n");
	gettape(&taboc);
}

cmx()
{
	int xtract();

	if (sflag)
		useerr();
	rddir();
	tread();		/* get first tape data block */
	gettape(&xtract);
}

rddir()
{
	register i;
	register char *p, *q;

	tread();		/* read first tape block into tapeb */
	dwrite();
	p = tapeb;
	q = &tapeheader.h_nfiles;
	for (i = 0; i < sizeof tapeheader; i++)
		*q++ = *p++;
	i = tapeheader.h_ndirblks;

	while (--i)
	{
		if (tread() == 0)		/* Tape Mark */
		{
			if (tapeheader.h_ndirblks == 0)	/* old format */
				return;
			fprintf(stderr, "Unexpected tape mark in directory\n");
			exit(0);
		}
		dwrite();
	}
}

wrdir()
{
	register int i;
	register char *p, *q;
	long temp;

	lseek(tmpfd, 0L, 0);
	dread();
	fstat(tmpfd, &statb);
	temp = statb.st_size;
	temp = temp + NBYTES - 1;
	temp = temp / NBYTES;
	tapeheader.h_ndirblks = temp.f_lowd;
	p = &tapeheader;
	q = tapeb;
	for (i = 0; i < sizeof tapeheader; i++)
		*q++ = *p++;

	do
		twrite();
	while dread();
}

tread()		/* read one tape block */
{
	register i;

	i = read(tapfd, tapeb, NBYTES);
	if (i == 0 || i == NBYTES)
		return(i);		/* 0 ==> Tape Mark */
	trderr();
	return(1);
}

trderr()
{
	register char *cp;

	fprintf(stderr, "Tape read error\n");
	if(!iflag)
		exit(0);
	for(cp = tapeb; cp < &tapeb[sizeof tapeb]; *cp++ = 0);
}

dread()
{
	register i;

	if ((i = read(tmpfd, tapeb, NBYTES)) < 0 || i & (sizeof tapdir-1) )
		drderr();
	return(i);
}

drderr()
{
	fprintf(stderr, "Directory file read error\n");
	exit(0);
}

eread()
{
	register i;

	if ((i = read(tmpfd, &tapdir, sizeof tapdir)) < 0 || i & ~sizeof tapdir)
		drderr();
	return(i);
}

twrite()		/* write one tape block */
{
	nused++;
	if (write(tapfd, tapeb, NBYTES) != NBYTES)
		twrerr();
}

twrerr()
{
	fprintf(stderr, "Tape write error\n");
	exit(0);
}

dwrite()
{
	if (write(tmpfd, tapeb, NBYTES) != NBYTES)
		dwrerr();
}

dwrerr()
{
	fprintf(stderr, "Directory file write error\n");
	exit(0);
}

ewrite(f)
{
	register char *p, *q;
	register i;

	if (f)
		dirlast = 0;
	if ((q = ebufpt) >= &tapeb[NBYTES])
	{
		dwrite();
		q = tapeb;
	}
	p = &tapdir;
	for (i = 0; i < sizeof tapdir; i++)
		*q++ = *p++;
	ebufpt = q;
}

verify(c)
register c;
{
	register ch;

	if (qflag)
	{
		fprintf(stdout, "%c %s ? ", c, tapdir.t_path);
		fflush(stdout);
		c = ch = getchar();
		while (ch != '\n')
			ch = getchar();
		if (c == 'x')
			exit(0);
		return(c == 'y');
	}
	if (vflag)
	{
		fprintf(stdout, "%s\n", tapdir.t_path);
		fflush(stdout);
	}
	return(1);
}

getfiles()
{
	register char *p, *q;
	register i;

	if (narg == 2)
	{
		tapdir.t_path[0] = '.';	/* default current dir. */
		tapdir.t_path[1] = 0;
		callout();
	}
	else while (narg-- > 2)
	{
		p = *parg++;
		q = tapdir.t_path;
		while (*q++ = *p++);
		callout();
		dirlast = -1;
	}
	if ((i = (ebufpt - tapeb)) != 0 && write(tmpfd, tapeb, i) != i)
		dwrerr();
}

expand()
{
	register char *p, *q;
	register i;
	char *r;
	int dfd;
	struct
	{
		int d_ino;
		char d_name[14];
		char d_nul;
	} catlb;

	catlb.d_nul = 0;
	if ((dfd = open(tapdir.t_path, 0)) < 0)
	{
		fserr();
		return;
	}
	while ((i = read(dfd, &catlb, 16)) != 0)
	{
		if (i < 0)
		{
			fserr();
			return;
		}
		if (catlb.d_ino == 0)
			continue;
		if (catlb.d_name[0] == '.' &&
		    (catlb.d_name[1] == 0 ||
		      catlb.d_name[1] == '.' && catlb.d_name[2] == 0))
			continue;

		p = tapdir.t_path;
		while (*p++);
		r = --p;
		if (p[-1] != '/')
			*p++ = '/';
		q = catlb.d_name;
		while (*p++ = *q++);
		callout();
		*r = 0;
	}
	close(dfd);
}

callout()
{
	register i;
	long temp;

	if (stat(tapdir.t_path, &statb) < 0)
	{
		fserr();
		return;
	}

	i = statb.st_mode & S_IFMT;
	if (i != S_IFDIR)
	{
		if (sflag && statb.st_mtime < seltim)
			return;
		if (! verify('a'))
			return;
		if (i == S_IFREG)	/* plain file - convert mode to L6 mode */
			statb.st_mode &= ~S_IFREG;
	}
	else if (qflag && ! verify('a'))
		return;
	tapeheader.h_nfiles++;
	tapdir.t_size = 0L;
	tapdir.t_uid = statb.st_uid;
	tapdir.t_mtime = statb.st_mtime;
	tapdir.t_tapea = tapad;		/* tapad is a long */
	tapdir.t_mode = statb.st_mode;	/* the level 6 mode */

	if (i == S_IFREG)		/* plain file */
	{
		temp = statb.st_size;
		tapdir.t_size = temp;
		temp = temp + 511;
		temp = temp >> 9;
		tapad = tapad + temp.f_lowd;	/* tapad is a long */
		ewrite(1);
		return;
	}
	if (i == S_IFCHR || i == S_IFBLK)
	{
		tapdir.t_size = statb.st_rdev;
		ewrite(1);
		return;
	}
	if (i != S_IFDIR)		/* one of those funny bloody things */
		return;
	/*
	 *	It's a directory.
	 *	Search for files to dump - add directory entry to tape
	 *	directory but delete it if no files dumped from it.
	 *	As directories are left open while descending, can go no
	 *	deeper than 15 - hence the magic number 15 below.
	 */
	if (dirlast <= 0 &&		/* last thing put in was dir. */
	    ebufpt > &tapeb[NBYTES - 15 * sizeof tapdir])
	{
		i = ebufpt - tapeb;
		if (write(tmpfd, tapeb, i) != i)
			dwrerr();
		ebufpt = tapeb;
	}

	ewrite(0);
	dirlast++;
	expand();
	if (dirlast != 0)	/* no files dumped from this dir */
	{
		tapeheader.h_nfiles--;
		dirlast--;
		ebufpt -= sizeof tapdir;
		if (qflag)
		{
			qflag = 0;		/* no questions */
			verify('d');
			qflag++;
		}
	}
}

gettape(fn)
int (*fn)();
{
	register char *p, *q;
	register unsigned n;
	int i;
	char **tparg;
	int *hit;
	static null[] "";
	int cmx();

	exta = 0;
	tapdir.t_tapea = 0;
	if (tapeheader.h_nfiles == 0)
	{
		fprintf(stderr, "Tape empty?\n");
		exit(0);
	}
	lseek(tmpfd, (long)sizeof tapdir, 0);	/* skip tape header */
	if ((narg -= 2) <= 0)		/* full extract/list? */
	{
		narg = 1;
		parg = &null;		/* dummy arg list */
	}
	hit = p = malloc(narg * 2);
	if (p == 0)
	{
		fprintf(stderr, "Out of core\n");
		exit(1);
	}
	for (n = 0; n < narg * 2; n++)
		*p++ = 0;
	for (i = 0; i < tapeheader.h_nfiles; i++)
	{
		n = tapdir.t_tapea;	/* address of last file */
		if (eread() == 0)	/* next file */
			drderr();
		if (n > tapdir.t_tapea)	/* ovflw into next 16 bits? */
			exta++;		/* full 32 bit address */
		tparg = parg;
		for (n = 0; n < narg; tparg++, n++)	/* search for this entry amongst args */
		{
			p = *tparg;
			if (rnarg != 2)
			{
				q = tapdir.t_path;
				while (*p && *p == *q)
				{
					p++;
					q++;
				}
				if (*p || (*q && *q != '/'))
					continue;
			}
			(*fn)();
			hit[n]++;
			break;
		}
	}
	i = 0;
	for (n = 0; n < narg; n++)
		if (hit[n] == 0)
			fprintf(stderr, "dtp: %s: not found\n", parg[n]);
		else
			i += hit[n];
	if (command == &cmx)
		fprintf(stderr, "%d files extracted\n", i);
}

unsigned ttbloksiz = NBYTES;	/* accessed in make and phserr */
unsigned ttapeb = tapeb;	/* accessed in make and phserr */
unsigned lastread;		/* accessed in make and phserr */
int blks;			/* accessed in make and phserr */

make()
{
	register fd, i;
	long lsize;

	wrdir();		/* write out tape directory */
	lseek(tmpfd, (long)sizeof tapdir, 0);
	while (eread())		/* read one entry from temp. file */
	{
		if ((tapdir.t_mode & L6S_IFMT) != L6S_IFREG)	/* not a plain file */
			continue;
		lsize = tapdir.t_size;
		lsize = lsize + 511;
		blks = lsize >> 9;
		if ((fd = open(tapdir.t_path, 0)) < 0)
		{
			phserr('O');	/* writes blks blocks of nulls to tape */
			continue;
		}
		for (;;)
		{
			lastread = i = read(fd, ttapeb, ttbloksiz);
			if (i < 0)
			{
				phserr('R');	/* write nulls for rest of file */
				break;
			}
			ttapeb += i;
			if (ttapeb < &tapeb[NBYTES])	/* finished? */
				break;
			blks -= (ttbloksiz >> 9);
			if (blks < 0)		/* file has grown */
			{
				phserr('B');
				i = -1;
				break;
			}
			if (blks == 0)	/* file (maybe) the same - stop here! */
			{
				i = -1;
				twrite();
				ttapeb = tapeb;
				ttbloksiz = NBYTES;
				break;
			}
			ttapeb = tapeb;
			ttbloksiz = NBYTES;
			twrite();
		}
		close(fd);
		if (i < 0)
			continue;
		blks -= (i + 511) >> 9;
		if (blks)
		{
			if (blks < 0)
				phserr('B');	/* file now bigger */
			else
				phserr('S');	/* file now smaller */
			continue;
		}
		if (i.g_lobyt != tapdir.t_size.f_lowd.g_lobyt)
		{
			phserr('S');	/* not necessarily... */
			continue;
		}
		ttapeb = (((ttapeb - tapeb) + 0777) & ~0777) + tapeb;
		ttbloksiz = &tapeb[NBYTES] - ttapeb;
		if (ttapeb == &tapeb[NBYTES])
		{
			twrite();
			ttapeb = tapeb;
			ttbloksiz = NBYTES;
		}
	}
	if (ttapeb != tapeb)
	{
		twrite();
		ttapeb = tapeb;
		ttbloksiz = NBYTES;
	}
}

/*
 *	Recover from phase errors
 *
 *		O - open error
 *		R - Read error
 *		B - file is now bigger
 *		S - file is now smaller
 */
phserr(c)
{
	register char *n;
	register unsigned m;

	if (c == 'B')
	{
		m = lastread & 0777;
		n = ttapeb;
		if (m)
			n = n - m + 512;	/* round up */
		n += blks << 9;
	}
	else
	{
		if (c == 'S')
		{
			m = lastread & 0777;
			n = ttapeb;
			if (m)
			{
				do
					*n++ = 0;
				while (++m & 01000) == 0;
				if (n >= &tapeb[NBYTES])
				{
					twrite();
					n = tapeb;
				}
			}
		}
		else		/* O and R errors */
			n = ttapeb;
		while (blks-- > 0)
		{
			for (m = 0; m < 512; m++)
				*n++ = 0;
			if (n >= &tapeb[NBYTES])
			{
				twrite();
				n = tapeb;
			}
		}
	}
	ttapeb = n;
	ttbloksiz = &tapeb[NBYTES] - n;
	fprintf(stderr, "Phase error %c: %s\n", c, tapdir.t_path);
}

/*
 *	called from gettape to list a directory entry
 */

taboc()
{
	register struct tm *tp;
	long temp;

	if (vflag)
	{
		pmode(tapdir.t_mode);
		fprintf(stdout, "%4d ", tapdir.t_uid);

		switch(tapdir.t_mode & L6S_IFMT)
		{
	    case L6S_IFREG:	fprintf(stdout, "%9D", tapdir.t_size);
				break;

	    case S_IFDIR:	fprintf(stdout, "         ");
				break;

	    case S_IFBLK:
	    case S_IFCHR:	fprintf(stdout, "  %3d,%3d",
					tapdir.t_size.f_lowd.g_hibyt,
					tapdir.t_size.f_lowd.g_lobyt);
				break;
		}

		tp = localtime(&tapdir.t_mtime);
		fprintf(stdout, " %02d/%02d/%02d %02d:%02d ",
			tp->tm_mday,
			tp->tm_mon + 1,
			tp->tm_year,
			tp->tm_hour,
			tp->tm_min);
	}
	fprintf(stdout, "%s\n", tapdir.t_path);
}

struct m
{
	int	m_mask;
	char	m_char;
	char	m_index;
}
m[]
{
	{ S_IFDIR,	'd',	0 },
	{ S_IFCHR,	'c',	0 },
	{ S_IFBLK,	'b',	0 },
	{ S_IREAD,	'r',	1 },
	{ S_IWRITE,	'w',	2 },
	{ S_IEXEC,	'x',	3 },
	{ S_ISUID,	's',	3 },
	{ S_IREAD >> 3,	'r',	4 },
	{ S_IWRITE >> 3,	'w',	5 },
	{ S_IEXEC >> 3,	'x',	6 },
	{ S_IREAD >> 6,	'r',	7 },
	{ S_IWRITE >> 6,	'w',	8 },
	{ S_IEXEC >> 6,	'x',	9 },
	{ S_ISVTX,	'T',	10 },
	{ L6S_LOCK,	'L',	10 },
	{ L6S_ALOK,	'A',	10 },
};

#define	MSIZ		(sizeof m / sizeof m[0])

pmode(mode)
register mode;
{
	register struct m *mp;
	register char *cp;
	char string[13];	/* last one null */

	for (cp = string; cp < &string[10]; *cp++ = '-');
	*cp++ = ' ';
	*cp++ = ' ';
	*cp = 0;
	cp = string;
	for (mp = m; mp < &m[MSIZ]; mp++)
		if ((mode & mp->m_mask) == mp->m_mask)
			cp[mp->m_index] = mp->m_char;
	fprintf(stdout, cp);
}

/*
 *	Unlink file iff not directory
 */
xunlnk()
{
	if (stat(tapdir.t_path, &statb) >= 0 &&
	    (statb.st_mode & S_IFMT) != S_IFDIR)
		unlink(tapdir.t_path);
}

/*
 *	Called from gettape to process a directory entry
 */
xtract()
{
	register char *p, *q;
	register m;
	char *r;
	unsigned i;
	long temp;
	char namewk[PATHL];
	extern errno;

	if (((m = tapdir.t_mode) & L6S_IFMT) != L6S_IFREG && cflag)
	{
		if ((m & L6S_IFMT) == S_IFDIR)
			i = 0;
		else
			i = tapdir.t_size;
		if (! verify('c'))
			return;
		xunlnk();
		m &= ~0100000;		/* turn off L6 ialloc bit */
		if (mknod(tapdir.t_path, m, i) < 0)
		{
			if (errno != EEXIST || (m & L6S_IFMT) != S_IFDIR)
			{
				crterr(0);
				return;
			}
			stat(tapdir.t_path, &statb);
			if ((statb.st_mode & S_IFMT) != S_IFDIR)
			{
				crterr(0);
				return;
			}
		}
		if ((m & L6S_IFMT) == S_IFDIR)	/* link . and .. */
		{
			p = tapdir.t_path;
			r = p+1;
			q = namewk;
			while (*q++ = *p)
				if (*p++ == '/')
					r = p;
			q[-1] = '/';
			*q++ = '.';
			*q = 0;
			link(tapdir.t_path, namewk);
			*q++ = '.';
			*q = 0;
			q = *--r;
			*r = 0;
			link(tapdir.t_path, namewk);
			*r = q;
		}
	}
	else
	{
		if ((m & L6S_IFMT) != L6S_IFREG)
			return;		/* ignore since -c not given */
		if (! verify('x'))
			return;
		temp.f_hiwd = exta;
		temp.f_lowd = tapdir.t_tapea;
		temp.f_lowd &= ~(NBLKS - 1);
		temp = temp - tapad;
		if (temp < 0)
			/*
			 * This is impossible since the tape directory
			 * is in order - it must be mangled to get here
			 */
			abort();
		if (temp > 0)	/* must seek tape unit */
		{
			i = temp / NBLKS;
			do
			{
				tread();
				tapad = tapad + NBLKS;
			} while --i;
		}
		xunlnk();
		m &= ~L6S_LOCK;	/* don't muck around with these */
		i = m & ~070;		/* ignore group bits */
		i |= ((m & 07) << 3);	/* make group perm. = others perm. */
		m = i;
		if ((i = creat(tapdir.t_path, m)) < 0)
		{
			close(i);
			crterr(1);
			return;
		}
		m = tapdir.t_tapea;
		for (;;)
		{
			m = (m & (NBLKS - 1)) << 9;
			p = &tapeb[m];
			r = m = NBYTES - m;
			tapdir.t_size = tapdir.t_size - m;
			if (tapdir.t_size < 0)
			{
				m += tapdir.t_size.f_lowd;
				r = m;
				if (m == 0)
					break;
				m = 0;
			}
			if (write(i, p, r) != r)	/* probably out of space */
			{
				close(i);
				crterr(1);
				return;
			}
			if (m <= 0)
				break;
			tread();
			tapad = tapad + NBLKS;
			m = tapad;
		}
		close(i);
	}
	chown(tapdir.t_path, tapdir.t_uid, tapdir.t_uid);
	timep[0] = tapeheader.h_dumptime;
	timep[1] = tapdir.t_mtime;
	utime(tapdir.t_path, timep);
}

crterr(f)
{
	if (f)
	{
		timep[0] = timep[1] = 0;
		utime(tapdir.t_path, timep);
	}
	fprintf(stderr, "dtp: %s -- create/write error\n", tapdir.t_path);
}

fserr()
{
	fprintf(stderr, "dtp: can't open %s\n", tapdir.t_path);
}
