
#include <local-system>
#include <passwd.h>
#include <sgtty.h>
#include <time.h>
#include <stdio.h>
#include <stat.h>

#define	etcttys		"/etc/ttys"
#define	costfile	"/usr/adm/costfile"
#define	bookingfile	"/usr/adm/bookfile"
#define	evictprog	"/etc/bin/doevict"

#define AMPM				/* print out times in am/pm format */
#ifdef vax
#define NUMTERMS	56		/* terminal numbers range 1..NUMTERMS. (must not exceed 255) */
#else vax
#define NUMTERMS	22
#endif vax

#define dayofwk		tm_wday
#define	TBULIMIT	32000		/* max size of bookfile in blocks */

#define DEFCOST		5		/* default cost of period */
#define RATEPERIOD	8		/* period over which rate limit operates */
#define PERIODSINHOUR	2		/* number of time slots in an hour (min 1) */
#define USAGEMAX	(48 * 7)	/* max user usage figure (this is effectively a weeks initial credit) (max 65535) */
#define DEFFREE		10		/* default forval for "free" */
#define NUMBLKS		5		/* number of 512 byte period buffers (minimum 3) */

/*
 * Command types
 */
enum command
{
	Book,
	Unbook,
	List,
	Free,
	Cunbook,
	Evict
};

/*
 * Command line symbols
 */
enum symbol
{
	Video = 1,
	Hardcopy = 2,
	Sunday,
	Monday,
	Tuesday,
	Wednesday,
	Thursday,
	Friday,
	Saturday,
	Tomorrow,
	Today,
	Here,
	Now,
	User,
	For,
	Tty,
	Logname,
	To,
	Am,
	Pm,
/*
 * Command line symbol "types"
 */
	Int,
	Long,
	String,
	Time,
	Eof
};

typedef char bool;
#define longoffset(structtag)	(long)&(((bookfile *)0)->structtag)
#define is(com)			(thiscommand == com)
#define inrange(a, b, c)	((a) >= (b) && (a) <= (c))
#define unsign(a)		((a) & 0377)
#define not			!
#define su			(uid == 0)
#define class			(pe.pw_flags & CLASSACC)
#define true			1
#define BIG			32767
#define false			0

#define TERMMIN			1		/* smallest terminal number */
#define TERMMAX			(TERMMIN + NUMTERMS - 1)

#define timetoperiod(day, time)	((day) * NUMPERIODS + (time))
#define NUMPERIODS		(24 * PERIODSINHOUR)	/* number of periods in a day */
#define TOTALPERIODS		(NUMPERIODS * 7)
#define SECSINPERIOD		(60 * MINSINPERIOD)
#define MINSINPERIOD		(60 / PERIODSINHOUR)

#define COSTMAX		120		/* max cost for a period */

#define READ 		0		/* modes for open */
#define WRITE 		1
#define READWRITE	2

#define INPUT		0		/* file descriptors */
#define OUTPUT		1
#define ERROROUT	2

struct
{
	char		*com;
	enum command	comval;
}
	comlist[] =
{
	"book",		Book,
	"unbook",	Unbook,
	"booked",	List,
	"unbooked",	Free,
	"evict",	Evict,
	"cunbook",	Cunbook
};
#define NUMCOMS	6
struct
{
	char		*key;
	enum symbol	keyval;
}
	keylist[] =
{
	"am",	Am,
	"for",	For,
	"fri",	Friday,
	"har",	Hardcopy,
	"her", 	Here,
	"mon",	Monday,
	"now",	Now,
	"pm",	Pm,
	"sat",	Saturday,
	"sun",	Sunday,
	"thu",	Thursday,
	"to",	To,
	"tod",	Today,
	"tom",	Tomorrow,
	"tty",	Tty,
	"tue",	Tuesday,
	"use",	User,
	"vid",	Video,
	"wed",	Wednesday
};
#define NUMKEYS 19

/*
 * The booking file structure.
 * The header part is always brought into core (in init())
 * The periods part is brought in a few blocks at a time (by getperiod())
 */


typedef union
{
	ushort	whole;
	struct
	{
	/* a bug in C compilers for the pdp11 means the structure must be this shape */
		int	t_booked: 1;	/* whether booked or not */
		int	t_class	: 1;	/* bit for class bookings */
		int	t_uid	: 14;
	} bits;
} termtype;

typedef struct
{
	termtype	terms[NUMTERMS];
	short		timecost;	/* cost of a time period (-1 means unbookable) */
} periodtype;

typedef struct
{
	periodtype	times[NUMPERIODS];
} daytype;

typedef struct
{
	daytype	days[7];
} periods;

typedef short usagetype;

typedef struct
{
	usagetype	val[NUSERS];		/* per user usage figure */
} userusage;

typedef struct
{
	char	t_name[16];		/* terminal name */
	char	t_type;			/* Hardcopy or Video */
	bool	t_usable;
} terminfo;

#define EXPRESS	04		/* express terminal flag */

typedef struct
{
	long	u_costfile;		/* time of last costfile update */
	long	u_etcttys;		/* time of last /etc/ttys update */
	long	u_bookfile;		/* time bookings last cleared out */
} updatetimes;

typedef struct
{
	terminfo	tinfo[NUMTERMS];
	updatetimes	utimes;
} header;

typedef struct
{
	periods		b_period;
	userusage	b_usage;
	header		b_header;
} bookfile;

char *daylist[7] =
{
	"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};



