/*
 *	Memory special file
 *	minor device 0 is physical memory
 *	minor device 1 is kernel memory
 *	minor device 2 is EOF/RATHOLE
 *
 *	Uses the 5th kernel data-space page to map the desired area.
 *	It is assumed that this page is used to map the buffer pool,
 *	and therefore contains no variables.
 */

#include <param.h>
#include <dir.h>
#include <signal.h>
#include <user.h>
#include <conf.h>
#include <buf.h>
#include <seg.h>
#include <errno.h>

extern struct user u;
extern char b[];

#define	MEM	0
#define	KMEM	1
#define	NUL	2

mmopen(dev)
{
	switch(minor(dev))
	{
	case MEM:
	case KMEM:
	case NUL:
		return;
	}
	u.u_error = ENXIO;
}

mmread(dev)
{
	if (minor(dev) == NUL)
		return;
	mmio(dev, B_READ);
}

mmwrite(dev)
{
	if (minor(dev) == NUL)
	{
		u.u_count = 0;
		return;
	}
	mmio(dev, B_WRITE);
}

mmio(dev, flag)
{
	register n, bn, on;

	do
	{
		bn = u.u_offset >> 6;
		if (minor(dev) == KMEM)
			bn = (ka6-6)->r[(bn >> 7) & 07] + (bn & 0177);
		on = u.u_offset & 077;
		n = min(64 - on, u.u_count);
		ka5->r[0] = bn;
		iomove(&b[on], n, flag);
	} while (u.u_error == 0 && u.u_count);
}
