/*
 * Global defines used by the system ei driver, and by batch.
 */

#define	Q(c)	(c | 0200)	/* turn the top bit on for attention */

/*
 * Control characters etc.
 */
#define	THIS_SITE	0160
#define	THIS_STATION	0141
#define	SOH		0001
#define	EOT		0003
#define	ESC		0076
#define	NAK		0030		/* u-200 */
#define	SYNC		0026		/* u-200 */
#define	ERROR		0025		/* u-200 */
#define	RD		0023		/* u-200 */
#define	ACK		0006		/* u-200 */
#define	WRT		0021		/* u-200 */
#define	CWRT		0022		/* u-200 */
#define	RWRT		0014		/* u-200 */
#define	POLL		0005		/* u-200 */
#define	ALERT		0007		/* u-200 */
#define	LOWBCD		0040
#define	HIGHBCD		0137
/*
 * escaped characters
 */
#define	EOI		0126		/* cyber */	/* 'W' */
#define	EOFL		0054		/* cyber */	/* '*' */
#define	EOR		0127		/* cyber */	/* 'X' */
#define	CEOL		0120		/* cyber */	/* ' ' */
#define	CCR		0101		/* cyber */	/* '1' */
#define	E1		0102				/* '2' */
#define	E2		0040				/* '-' */
#define	E3		0041				/* 'J' */
/*
 * Carriage control characters - downlink
 */
#define	SPACE3		0040		/* cyber */	/* '-' */
#define	SPACE2		0112		/* cyber */	/* '0' */
#define	SPACE1		0120		/* cyber */	/* ' ' */
#define	SPACE0		0060		/* cyber */	/* '+' */
#define	EJECT		0101		/* cyber */	/* '1' */
#define	SKIPC4		0105		/* cyber */	/* '5' */
#define	SKIPC3		0106		/* cyber */	/* '6' */
#define	EJOFF		0050		/* cyber */	/* 'Q' */
#define	EJON		0051		/* cyber */	/* 'R' */

/*
 * Buffer sizes dictated by u200 protocol
 */
#define	MAXCARDS 12		/* max. cards sent to cyber per transfer */
#define	CARDCOL	80		/* columns per card */
#define	PROTOCOL 4		/* bytes of protocol added for packet */
#define	XBUFSIZ	(MAXCARDS*CARDCOL + MAXCARDS + PROTOCOL)
#define	RBUFSIZ	1050		/* max. job length from cyber (u200) */
#define	CBUFSIZ	18		/* max. command length to cyber */

/*
 * The line error message (batch needs to know it too)
 */
#define	LINERR	"linerr XXX"

/*
 * Character compression escapes
 */
#define	BLEXP	0377		/* escape for blank expansion */
#define	ZREXP	0376		/* escape for zero expansion */

/*
 * Commands
 */
#define	RCMD	'r'		/* read jobs in card reader */
#define	GCMD	'g'		/* continue reading after a suspension */
#define	CCMD	'c'		/* continue printing after a suspend */
#define	LCMD	'l'		/* login to the cyber */
#define	BCMD	'b'		/* logoff the cyber */
#define	SCMD	's'		/* suspend printing */
