#
#define ff 014
#define cr 015
#include "const.h"
#include "memory.h"
/*
 *	read the calling line and initialise parameters and memory.
 *	routines here are:
 *		readin(argc,argv)
 *		readflags(ptr)
 *		readint(ptr)
 *		readhex(fdh)
 *		readsmem(fds,sname)
 *		answer()
 */
readin(argc,argv)
int	argc;
register char	**argv;
{
	int	i;
	FILE *fdh, *fds;
	int	ctemp,hexname,sname;

	printf("\f >>>>>>>> D MACHINE		UNSW 26 Oct 78.\n");
	fdh = 0;	/* hex listing file descriptor	*/
	fds = stdin;	/* s-memory file descriptor	*/
	hexname = FALSE;	/* hex file flag */
	sname = FALSE;
	start = 0;	/* default starting address */
	maxclk = 1000;	/* maximum clocks for simulation */
	outnm = 1;	/* number of clock periods between register dumps */
	outsrt = -1;	/* starting address for register dumps */
	outstp = -1;	/* end of register dumps */
	outflags = 040;	/* dump on, no output lines */
	trace = -1;	/* trace off */
	BREAK = 9999;	/* break off */

	for( i=1 ; i<argc ; i++ )
	{
		if( argv[i][0] == '-' )	readflags(argv[i]);

		else		/* not a flag, must be a file name!? */
		{
			if( !hexname )
			{
				fdh = fopen(argv[i], "r");
				if( fdh > 0 )
				{
					hexname = TRUE;
					printf("Hex to be read from %s\n",argv[i]);
				}
				else		/* not a file name after all */
				{
					printf("Cannot open %s\n",argv[i]);
					/* FIX 1 */ fdh = 0;
				}
			}

			else
			{
				if( !sname )
				{
					fds = fopen(argv[i], "r");
					if( fds != NULL )
					{
						sname = TRUE;
						printf("S memory to be read from %s\n",argv[i]);
					}
					else
					{
						printf("Cannot open %s\n",argv[i]);
						/* FIX 1 */ fds = 0;
					}
				}

				else
				{
					printf("Excess arguments ignored\n");
					break;
				}
			}
		}
	}

	if( !hexname )
	{
		printf("Are you REALLY going to type in the hex? ");
		if( !answer() )
		{
			printf("\nWhat is the name of your hex file");
			while( !hexname )
			{
				printf("? ");
				fflush(stdout);
				ctemp = readline(stdin, buf);
				if( outflags & 0400 )	printf("%s\n",buf);
				if( ctemp > 0 )
				{
					buf[ctemp-1] = 0;
					fdh = fopen(buf, "r");
					if( fdh != NULL ) hexname = TRUE;
					else	fdh = stdin;
				}
				else {fprintf(stdout,"\nBye Bye!\n"); exit(0);}
			}
		}
		else	printf("\nEnter hex terminated by 4000\n");
	}
	readhex(fdh);

	if( !sname )
	{
		printf("\nDo you REALLY want to type in the s-memory? ");
		if( !answer() )
		{
			printf("\nWhat file is the s-memory on");
			while( !sname )
			{
				printf("? ");
				fflush(stdout);
				ctemp = readline(stdin, buf);
				if( outflags & 0400 )	printf("%s\n",buf);
				fprintf(stdout,buf);
				if( ctemp > 0 )
				{
					buf[ctemp-1] = 0;
					fds = fopen(buf, "r");
					if( fds != NULL )	sname = TRUE;
					else	fds = stdin;
				}
				else {fprintf(stdout,"\nBye Bye!\n"); exit(0);}
			}
		}
		else	printf("\nEnter s-memory in blocks.\n");
	}
	readsmem(fds,sname);

	if( fdh > 0 )	fclose(fdh);
	if( fds != stdin )	fclose(fds);
	return;
}
/*
 *	routine to process call flags.
 */
readflags(ptr)
register char	*ptr;
{
#define SETLN0 01
#define SETLN1 02
#define SETLN2 04
#define SETLN3 010
#define SETLN4 020
#define SETALL 037
#define DUMPOFF 0737
/*
 *	ptr points to a string of options.
 */
	while( *ptr )
	{
		switch( *ptr++ )
		{
		case 'f':
			outflags |= 0400;	/* echo input (input on file) */
			break;
		case 't':
			trace = readint(ptr);
			outflags |= SETLN0;
			break;
		case 'd':
			outflags |= 0100;	/* register dumps in decimal */
			break;
		case 'o':
			outflags &= 0477;	/* register dumps in octal/*/
			break;
		case 'h':
			outflags = (outflags & 0477) | 0200;	/* register dumps in hex */
			break;
		case 'n':
			outflags &= DUMPOFF;
			break;
		case 's':
			start = readint(ptr);
			break;
		case 'c':
			maxclk = readint(ptr);
			break;
		case 'r':
			switch( *ptr++ )
			{
			case 'b':
				outsrt = readint(ptr);
				if(outstp == -1) outstp = 1024;
				break;
			case 'e':
				outstp = readint(ptr);
				break;
			}
			if( *ptr )	ptr++;
			break;
		case 'b':
			BREAK = readint(ptr);
			break;
		case 'p':
			outnm = readint(ptr);
			break;
		case 'l':
			while( *ptr >= '0' && *ptr <= '5' )
			{
				switch( *ptr++ )
				{
				case '0':
					outflags |= SETLN0;
					break;
				case '1':
					outflags |= SETLN1;
					break;
				case '2':
					outflags |= SETLN2;
					break;
				case '3':
					outflags |= SETLN3;
					break;
				case '4':
					outflags |= SETLN4;
					break;
				case '5':
					outflags |= SETALL;
				}
			}
		}
	}
	return;
}
/*
 *	read an unsigned integer (overflow is checked).
 */
readint(ptr)
register char	*ptr;
{
	register int	tempval;
#define DIGIT (*ptr>='0')&&(*ptr<='9')

	tempval = 0;

	while( DIGIT )
	{
		if( (tempval < 3276) || (*ptr <= 7) )	/* maximum integer is 32767 */
		{
			tempval = (tempval * 10) + *ptr++ - '0';
		}
		else
		{
			printf("Integer overflow. Parameter truncated to %d\n",tempval);
			break;
		}
	}
	return( tempval );
}
/*
 *	routine to read the hex listing of the microprogram.
 */
readhex(fdh)
FILE	*fdh;
{
	int	count,err,tempb[4],flag,j;
	extern	int	inchrs;
	register int	*temp,*mpmp;
	register char	*p1;

#define	mask6	077
#define mask10	01777

	count = 0;
	err = 0;
	mpmp = mpm;
	nan1 = nanobts;
/*
 *	now we try to read a line of the hex file....
 */
	while( (flag = readline(fdh,buf)) > 0 )
	{
		p1 = buf;
		temp = tempb;
		if( flag == FALSE )	return( 0 );
		if( flag >= 12 )
		{
/*
 *	got it!
 */
			p1 += 8;
			*mpmp = atoh(p1);
			count++;
			if( *mpmp == 0x4000 )	return( 0 );
			if( ((*mpmp++) & 0xF000) == 0xF000 )
/*
 *	type 1 instruction.
 *	read in the nano instruction.
 */
			{
				for( j=0 ; j<4 ; j++ )
				{
					p1 += 8;
					if( *p1 )
					{
						*temp++ = atoh(p1);
					}
					else	*temp++ = 0;
				}
/*
 *	now move nano instructions into a more usable form.
 */
				nan1->a = tempb[0];
				nan1->b = (tempb[1] >> 1);
				nan1->c = (tempb[1] << 10) | ((tempb[2] >> 6) & mask10);
				nan1->d = (tempb[2] << 6) | ((tempb[3] >> 10) & mask6);
				nan1++;

			}

			if( count > 1024 )
			{
				printf(" Too much micro-code.\nLimit is 1024 lines.\n");
				return( -1 );
			}
		}
		else
		{
/*
 *	read attempt bombed out - probably garbage on the so-called hex file
 */
			printf("EH??\n");
			err++;
		}
	}
	if( err )
	{
		printf("I found %d error",err);
		if( err > 1 )	putchar('s');
		printf(" on your hex listing file.\n");
		return( -1 );
	}
	return( 0 );
}
/*
 *	routine to read in s-memory
 */
readsmem(fds,sname)
int	sname;
FILE *fds;
{
	extern	long	lpack();
	int	addr1,addr2,i;
	register long	*sptr;
	register char	*p1;
	int negflag;

	sptr = smem;

	for( i=0 ; i<SLIMIT ; i++ )	*sptr++ = 0;

	for(;;)
	{
		printf("Starting address");
		if( !sname )	printf("? ");
		i = readline(fds,p1 = buf);
		if( i == '\0' )
		{
			printf("End of input file.\n");
			if( !sname )
			{
				printf("Further input requests ignored.\n");
				outflags &= 0737;	/* dump off */
			}
			return;
		}
		if( sname || (outflags & 0400) )	printf(" %s",buf);

		while( (*p1 == ' ') || (*p1 == '	') )	p1++;

		addr1 = atoi(p1);
		if( addr1 == 9999 )	return;

		printf("Finishing address");
		if( !sname )	printf("? ");
		i = readline(fds,p1 = buf);
		if( i == '\0' )
		{
			printf("\nWARNING - Premature end of S-Memory file.\n");
			exit( 0 );
		}
		if( sname || (outflags & 0400) )	printf(" %s",buf);

		while( (*p1 == ' ') || (*p1 == '	') )	p1++;

		addr2 = atoi(p1);
		if( (addr1 > SLIMIT) || (addr2 > SLIMIT) )	continue;

		sptr = &smem[addr1];
		p1 = buf;

		while( addr1 <= addr2 )
		{
			printf("smem(%d)= ",addr1++);
			i = readline(fds,p1 = buf);
			if( i == '\0' )
			{
				printf("\nWARNING - Premature end of S-Memory file.\n");
				exit( 0 );
			}
			if( sname || (outflags & 0400) )	printf("%s",buf);

			while( (*p1 == ' ') || (*p1 == '	') )	p1++;
			if(*p1 == '-') {negflag = TRUE; p1++;} else negflag = FALSE;

/*
 *	convert the ascii input to long integer
 */
			if( (*p1 > '0') && (*p1 <= '9') )
				if(negflag == TRUE)
					*sptr = -(atoli(p1));
				else
					*sptr = atoli(p1);
			else
			{
				if( *p1 == '0' )	*sptr = atolo(++p1);	/* handles both hex and octal */
				else	if( *p1 != '\n' )	*sptr = lpack(p1);
			}
			sptr++;
		}
	}
}
/*
 *	a simple routine to get a simple answer...
 */
answer()
{
	register char	*ptr;
	int	a;

	for(;;)
	{
		fflush(stdout);
		a = readline(stdin, buf);
		if( a > 0 )
		{
			if( outflags & 0400 )	printf("%s\n",buf);
			ptr = buf;

			while( *ptr )
			{
				if( *ptr == 'y' || *ptr == 'Y' )	return( TRUE );
				if( *ptr == 'n' || *ptr == 'N' )	return( FALSE );
				ptr++;
			}
/*
 *	in case someone is a little dense........
 */
			printf("A simple yes or no will do!!\n");
		}
		else
		{
			printf("Read error on input.\n");
			exit( 0 );
		}
		printf("Try again : ");
	}
}
