.pl 12i
.ll 80
.lt 80
.po 10
.nh
.ce
.ul
Use of the Macro Monitor
.sp 2
The first line of the program should contain 
.sp
.ti +12
\&.globl	getc, putc, flush, exit, rdump, dump
.sp
At the end of the program a ".end" is required:
.sp
.ti +12
jmp	exit
.ti +12
\&.end
.sp 2
The routines provided may be classified into two main groups:
.sp 2
.in +4
.ti -4
.ul
System Interface Routines
.sp
These provide the following primitives:
.sp
.ti -4
getc:
.br
Returns the next character on standard input in r0;
on EOF a zero will be returned.
If the program fails to detect this and continues
to read an error will be generated.
Use:
.sp
.ti +8
jsr	pc, getc
.sp 2
.ti -4
putc:
.br
Puts the character in r0 onto the standard output.
Unprintable characters are printed as '?'.
Linelength and page overflows are detected and generate errors.
Even if the character is unprintable, r0 is returned unchanged.
Use:
.sp
.ti +8
jsr	pc, putc
.sp 2
.ti -4
flush:
.br
Flushes the (internal) buffer onto output.
Main use is to debug programs that die before the buffer
is flushed by a normal exit.
Use:
.sp
.ti +8
jsr	pc, flush
.sp 2
.ti -4
exit:
.br
Flushes the buffer and terminates execution.
Use:
.sp
.ti +8
jmp	exit
.bp
.ti -4
.ul
Debugging Aids
.sp
The following debugging aids are provided.
Note that none of them alter the registers,
the processor status word,
or low memory,
and hence they may be freely inserted in a program.
They will however use the stack - hence
lower-numbered stack locations from the current position
will be altered.
.sp
.ti -4
rdump:
.br
Gives a dump of the current values of the registers
and the processor status word.
Use:
.sp
.ti +8
jsr	pc, rdump
.sp 2
.ti -4
dump:
.br
Prints out the section of memory between
first and last (in the example below),
which must be word addresses.
The output is a column of addresses and their contents.
Use:
.sp
.ti +8
jsr	pc, dump
.ti +8
\&.word	first, last
.sp 2
.in -4
