;;; Written by Stephen Webb - UNSW Thu Nov 29 15:47:08 1979
;;;	Set up a pipe - return a device record for each end of the pipe.
;;;	The writable end of the pipe is on top of the stack,
;;;	and the readable end under that.
;;;	(A device record corresponds to a UNIX file descriptor.)
function mkpipe();
	popmess([%Pipe%])
end;
;;; 	Return a character generator corresponding to the device record
;;;	passed to the procedure.
function chargen(drrd) => result;
	Getc(%drrd%) -> result;
	gensym("infile") -> fnprops(result);
end;
;;; 	Return a character consumer  corresponding to the device record
;;;	passed to the function.
function charcon(drwr) => result;
	Putc(%drwr%) -> result;
	gensym("outfile") -> fnprops(result);
end;

;;; Some examples of how they are used.
;;; 
;;; mkpipe()-> drin -> drout;
;;; if not( popmess([%Fork%]) ) then
;;; 	popmess([%Close, 0%]);
;;; 	popmess([% Dup, drin %]);
;;; 	popmess([%Close, drout%]);
;;; 	popmess([%Close, 2%]);
;;; 	popmess([%Creat, coderrs, 300%]);
;;; 	popmess([%Exec, '/user3/EECF-Maint/pop/bin/pop11'%]);
;;; 	[error - return from exec] =>
;;; close;
;;; discin( coderrs ) -> popoutput;
;;; charcon(drout) ->pout;
;;; popmess([%Close, drin%]);
;;; function writepipe(s);
;;;     vars cucharout;
;;; 	pout -> cucharout;
;;; 	prstring( s );
;;; end;
;;; 
