/*
**	mc [-line_width] [+blank_count] [filename ...]
**
**	split files across as many columns as will fit.
**
**	Rewritten:	Piers Lauder
**	Date:		March '80
*/

#include	<stdio.h>

char		tempf[]		= "/tmp/mcXXXXXX";
short		line_width	= 79;
short		blank_count	= 1;
short		longest;
short		file_arg;
short		nonempty;
char *		name;
FILE *		tmpfd;

#define		max(A,B)	(A>B?A:B)




main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	if ( (tmpfd = fopen(mktemp(tempf), "w+")) == NULL )
	{
		openerr(tempf);
		return 1;
	}
	unlink(tempf);

	name = argv[0];

	while ( argc-- > 1 )
	{
		register char *	arg;
		register FILE *	afd;

		switch ( *(arg = *++argv) )
		{
		 case '-':
			line_width = atoi(arg+1);
			break;

		 case '+':
			blank_count = atoi(arg+1);
			break;

		 default:
			if ( (afd = fopen(arg, "r")) == NULL )
			{
				openerr(arg);
			}
			else
			{
				readin(afd);
				fclose(afd);
			}
			file_arg++;
		}
	}

	if ( !file_arg )
		readin(stdin);

	if ( nonempty )
	{
		char	buf[BUFSIZ];

		rewind(tmpfd);
		setbuf(stdout, buf);
		output();
		fflush(stdout);
	}

	return 0;
}




openerr(s)
	char *		s;
{
	fprintf(stderr, "%s: open fail on %s\n", name, s);
}




readin(fd)
	register FILE *	fd;
{
	register	c;
	register	col = 0;
	register	rcol = 0;

	while ( (c = getc(fd)) != EOF )
	{
		if ( col >= line_width && c != '\n' )
			continue;

		switch ( c )
		{
		 case '\n':
		 case '\r':
			longest = max(longest, rcol);
			rcol = col = 0;
			break;

		 case '\t':
			col |= 7;
			col++;
			continue;

		 case '\b':
			col--;
			rcol--;
			break;

		 case ' ':
			col++;
			continue;

		 default:
			col++;
			if ( c < ' ' || c == '\0177' )
				continue;
			rcol++;
			break;
		}

		while ( rcol < col )
		{
			rcol++;
			if ( putc(' ', tmpfd) == EOF )
			{
				outerr();
				return;
			}
		}

		if ( putc(c, tmpfd) == EOF )
		{
			outerr();
			return;
		}

		nonempty = 1;
	}

	if ( rcol )
		if ( putc('\n', tmpfd) == EOF )
			outerr();
}




outerr()
{
	fprintf(stderr, "%s: write error\n", name);
	exit(2);
}




output()
{
	register	c;
	register	rcol = 0;
	register	col = 0;
	register	ncols = 0;
	register	cols;

	longest += blank_count;
	cols = (line_width+blank_count)/longest;

	while ( (c = getc(tmpfd)) != EOF )
	{
		switch ( c )
		{
		 case '\n':
			if ( ++ncols < cols )
			{
				col = ncols * longest;
				continue;
			}
			else
				ncols = rcol = col = 0;
			break;

		 case '\r':
			col = ncols * longest;
			while ( rcol > col )
			{
				rcol--;
				if ( putc('\b', stdout) == EOF )
				{
					outerr();
					return;
				}
			}
			continue;

		 case '\b':
			if ( col > (ncols*longest) )
			{
				col--;
				rcol--;
				break;
			}
			continue;

		 case ' ':
			col++;
			continue;

		 default:
			col++;
			rcol++;
			break;
		}

		while ( rcol < col )
		{
			rcol++;
			if ( putc(' ', stdout) == EOF )
			{
				outerr();
				return;
			}
		}

		if ( putc(c, stdout) == EOF )
		{
			outerr();
			return;
		}
	}

	if ( rcol )
		if ( putc('\n', stdout) == EOF )
			outerr();
}
