/*
 * One file structure is allocated
 * for each open/creat/pipe call.
 * Main use is to hold the read/write
 * pointer associated with each open
 * file.
 */
struct	file
{
	char	f_flag;
	char	f_count;	/* reference count */
	struct inode *f_inode;	/* pointer to inode structure */
	off_t	f_offset;	/* read/write character pointer */
};

/* flags (char) - see fcntl.h for others */
#define	FREAD	1
#define	FWRITE	2

#define	FMASK	0377	/* flags mask before passing to device open routine */
