#include	"mas0.h"


extern	struct segment segopt;
extern	undef, spc;
extern	numsym;
char	bcd1();
char	bcd2();
extern FILE *list;
extern	struct symbol symtab[];
extern	char line[], *linep;
extern	opt_sym;



lcomm()			/* for comments at end-of-lines */
{
	register n;
	register char *l;

	l = &line[l_ADR];
	n = spc >> 8;
	n =& 0377;
	*l++ = bcd1(n);
	*l++ = bcd2(n);
	n = spc & 0377;
	*l++ = bcd1(n);
	*l++ = bcd2(n);
	lcoml();						/* mod022 */
}



lcoml()						/* for comment lines */
{

	while (getch() != NL);
	lcopy();
}



lcopy()						/* mod020, 021 - removed arg */
{
	register char *l;

	if (list == NULL) return;
	for (l = line; l < linep; ) putc(*l++, list);
	for (l = line; l < &line[l_LAB];) *l++ = SP;
	linep = l;					/* mod021 */
}


lcode1(opc)
{
	register n;
	register char *l;

	l = &line[l_C1];
	*l++ = bcd1(n = opc);
	*l++ = bcd2(n);
}



lcode2(ran, posn)			/* mod014 */
{
	register n;
	register char *l;

	l = &line[l_C2 + (posn == 1 ? 0 : posn ? 3 : -3)];	/* mod014 */
	n = ran & 0377;
	*l++ = bcd1(n);
	*l++ = bcd2(n);
}



lcode3(opc)
{
	register n;
	register char *l;

	l = &line[l_C2];
	n = opc >> 8;
	n =& 0377;
	*l++ = bcd1(n);
	*l++ = bcd2(n);
	n = opc & 0377;
	*l++ = bcd1(n);
	*l++ = bcd2(n);
}



lglobals()						/* mod020 */
{
	int qcompar();

	if (list == NULL || opt_sym == SYMOFF) return;	/* mod014,020 */
	if (segopt.segcount == 0) putc(PAGE, list);
	qsort(&symtab[1], numsym-1, sizeof symtab[0], qcompar);
	lsymtab(0, 2);
}



qcompar(s1, s2)
register char *s1, *s2;
{
	register char c;

	while ((c = *s1++) == *s2++) if ( c == '\0' ) return(0);
	return(c < *--s2 ? -1 : 1);
}




llocals(seg)						/* mod020 */
{
	register k;

	if (list == NULL || opt_sym == SYMOFF) return;			/* mod014 */
	for (k = 0; k < 4; k++) putc(NL, list);
	lsymtab(seg, 1);
	putc(PAGE, list);
}



lsymtab(seg, type)
{
	register struct symbol *sym;
	register char *s;
	register k;
	int n, z;

	n = numsym - 1;
	sym = &symtab[1];
	z = 0;
	while (n--)
	{
		if (sym->s_seg == seg)
		{
			s = &sym->s_name[0];
			if (z) { putc(TAB, list); putc(TAB, list); }
			if (segopt.segtype == type) putc(segopt.segchar, list);		/* mod009 */
			do
				putc(*s++, list);
			while (*s);
			putc(TAB, list); putc(SP, list);
			if (sym->s_def == UND) putc('u', list);
			else
			{
				k = sym->s_pc >> 8 & 0377;
				putc(bcd1(k), list);
				putc(bcd2(k), list);
				k = sym->s_pc & 0377;
				putc(bcd1(k), list);
				putc(bcd2(k), list);
			}
			if (z++ == 2)
			{
				putc(NL, list);
				z = 0;
			}
		}
		sym++;
	}
	if (z) putc(NL, list);
}



/*
 *	This version of "printf" is considerably smaller
 *	than the c_library version.
 *
 *	Provides "%s" and "%d", (all numbers unsigned).
 *	An optional field width (default 1) may follow the '%'
 */

printf(s, a)
register char *s;
{
	register char c;
	register *p;
	char *tp;		/* temporary pointer for substrings */
	char fw;

	p = &a;
	while (c = *s++)
	{
		if (c == '%')
		{
			fw = 1;			/* default field width */
			if ((c = *s++) <= '9' && c >= '0')
			{
				fw = c - '0';
				c = *s++;
			}
			switch (c)
			{
		    case 's':	tp = *p++;
				while (c = *tp++) putchar(c);
				continue;

		    case 'd':	printl(*p++, fw);
				continue;

		    case 0:	return;

			}
		}
		putchar(c);
	}
}



printl(n, fw)
register unsigned n;
{
	register i;
	char a[10];

	i = 0;
	do
		a[i++] = n % 10 + '0';
	while (n =/ 10);
	while (i < fw) a[i++] = ' ';
	do
		putchar(a[--i]);
	while (i);
}


