	jsr	pc,backspace
	tst	r0
	jmi	eh1
	cmp	k,savk
	blo	1f
	mov	k,r2
	asl	r2
	sub	savk,r2
	mov	k,savk
	br	2f
1:
	mov	savk,r2
2:
	jsr	pc,add0
	jsr	pc,sqrt
	mov	savk,r0
	jsr	pc,putchar
	jsr	pc,push
	jmp	loop
/
/
sqz:
	mov	savk,r0
	jsr	pc,putchar
	jsr	pc,push
	jmp	loop
.bss
sqtemp:	.=.+2
.text
/
/
/	case [ for subroutine definition
/
case133:
	clr	-(sp)
	clr	r0
	jsr	pc,allocate
	jsr	pc,push
1:	jsr	pc,readc
	cmp	r0,$']
	bne	3f
	tst	(sp)
	beq	1f
	dec	(sp)
	br	2f
3:
	cmp	r0,$'[
	bne	2f
	inc	(sp)
2:
	jsr	pc,putchar
	br	1b
/
1:	tst	(sp)+
	jmp	loop
/
/
/	case x for execute top of stack
/
case170:
	jsr	pc,in170
	jmp	loop
/
in170:
	jsr	pc,pop
	jes	eh
	mov	r1,-(sp)
	tst	*readptr
	beq	1f
	mov	*readptr,r1
	cmp	r(r1),w(r1)
	bne	1f
	jsr	pc,release
	br	2f
1:
	add	$2,readptr
	cmp	readptr,$readtop
	bhis	1f
2:	mov	(sp)+,r1
	mov	r1,*readptr
	beq	2f
	jsr	pc,rewind
	rts	pc
2:
	jsr	pc,readc
	cmp	r0,$'\n
	beq	3f
	mov	r0,savec
3:
	rts	pc
1:
nderr:
	mov	$1,r0
	sys	write; 1f; 2f-1f
	jmp	reset
1:	<Nesting depth.\n>
2:	.even
/
.data
readptr: readstack
.bss
readstack: .=.+100.
readtop:
.text
/
/	case ? for apl box function
/
case077:
	add	$2,readptr
	cmp	readptr,$readtop
	bhis	nderr
	clr	*readptr
in077:
	mov	source,-(sp)
	clr	source
	jsr	pc,readc
	cmp	r0,$'!
	bne	1f
	jsr	pc,in041
	mov	(sp)+,source
	br	in077
1:
	mov	r0,savec
	clr	r0
	jsr	pc,allocate
2:
	jsr	pc,readc
	jsr	pc,putchar
1:
	jsr	pc,readc
	jsr	pc,putchar
	cmp	r0,$'\\
	beq	2b
	cmp	r0,$'\n
	bne	1b
	mov	(sp)+,source
	mov	r1,*readptr
	jmp	loop
/
/
/	case < for conditional execution
/
case074:
	jsr	pc,in074
	ble	neg074
	jmp	aff074
/
/
/	case !< for conditional execution
/
in74a:
	jsr	pc,in074
	bgt	inneg
	jmp	inaff
/
in074:
	jsr	pc,in055	/go subtract
	jsr	pc,pop
	jsr	pc,length
	tst	r0
	beq	1f
	jsr	pc,fsfile
	jsr	pc,backspace
	jsr	pc,backspace
	tst	r0
1:
	rts	pc
/
aff074:
	jsr	pc,release
	jsr	pc,in154	/load from register
	jmp	case170
/
neg074:
	jsr	pc,release
	jsr	pc,readc
	jmp	loop
/
/
/	case = for conditional execution
/
case075:
	jsr	pc,in074
	beq	aff074
	jmp	neg074
/
/
/	case != for conditional execution
/
in75a:
	jsr	pc,in074
	bne	inaff
	jmp	inneg
/
/
/	case > for conditional execution
/
case076:
	jsr	pc,in074
	bge	neg074
	jmp	aff074
/
/
/	case !> for conditional execution
/
in76a:
	jsr	pc,in074
	blt	inneg
	jmp	inaff
/
inaff:
	jsr	pc,release
	jsr	pc,in154
	jsr	pc,in170
	rts	pc
/
inneg:
	jsr	pc,release
	jsr	pc,readc
	rts	pc
/
err:
	mov	$1,r0
	sys	write; 1f; 2f-1f
	jmp	reset
1:	<Fatal error\n>; 2: .even
/
eh1:
	jsr	pc,release
eh:
	movb	ch,1f+2
	mov	$1,r0
	sys	write; 1f; 2f-1f
	mov	$readstack,readptr
	mov	errstack,sp
	jmp	loop
.data
1:	<(  ) ?\n>
2:	.even
.text
/
/
/	routine to read and convert a number from the
/	input stream.  Numbers beginnig with 0 are
/	converted as octal.  Routine converts
/	up to next nonnumeric.
/
/
readin:
	clr	dp
	clr	dpt
	clr	r0
	jsr	pc,allocate
	mov	r1,-(sp)
	mov	strptr,r1
	jsr	pc,create
	jsr	pc,readc
1:
	cmpb	ch,$'0
	blt	3f
	cmpb	ch,$'9
	bgt	3f
	mov	ch,r0
	sub	$'0,r0
4:
	tst	dp
	beq	8f
	cmp	dpt,$99.
	beq	5f
	inc	dpt
8:
	mov	chptr,r1
	jsr	pc,create
	tst	r0
	beq	2f
	jsr	pc,putchar
2:	mov	r1,chptr
	mov	(sp),r3
	mov	inbas,r2
	jsr	pc,mul3
	mov	r1,(sp)
	mov	r3,r1
	jsr	pc,release
	mov	(sp),r3
	mov	chptr,r2
	jsr	pc,add3
	mov	r1,(sp)
	mov	r3,r1
	jsr	pc,release
5:
	jsr	pc,readc
	mov	r0,ch
	br	1b
3:
	cmpb	ch,$'A
	blt	1f
	cmpb	ch,$'F
	bgt	1f
	mov	ch,r0
	sub	$67,r0
	br	4b
1:
	cmpb	ch,$134		/backslash
	bne	1f
	jsr	pc,readc
	br	5b
1:
	cmpb	ch,$'.
	bne	1f
	tst	dp
	bne	1f
	inc	dp
	clr	dpt
	br	5b
1:
	mov	r0,savec
/
/	scale up or down
2:
	tst	dp
	bne	1f
	mov	(sp)+,r1
	clr	r0
	jsr	pc,putchar
	rts	pc
1:
	mov	(sp),r1
	jsr	pc,scale
	mov	dpt,r0
	jsr	pc,putchar
	tst	(sp)+
	rts	pc
/
.bss
dp:	.=.+2
dpt:	.=.+2
.text
/
scale:
	mov	dpt,r2
	jsr	pc,add0
	mov	r1,-(sp)
	mov	$1,r0
	jsr	pc,allocate
	mov	dpt,r0
	jsr	pc,putchar
	mov	r1,r3
	mov	inbas,r2
	jsr	pc,exp3
	mov	r1,-(sp)
	mov	r3,r1
	jsr	pc,release
	mov	(sp)+,r2
	mov	(sp)+,r3
	jsr	pc,div3
	mov	r1,-(sp)
	mov	r2,r1
	jsr	pc,release
	mov	r3,r1
	jsr	pc,release
	mov	r4,r1
	jsr	pc,release
	mov	(sp)+,r1
	rts	pc
/
/	routine to read another character from the input
/	stream.  If the caller does not want the character,
/	it is to be placed in the cell savec.
/	The routine exits to the system on end of file.
/	Character is returned in r0.
/
/	jsr	pc,readc
/	movb	r0,...
/
/
readc:
	tst	savec
	beq	1f
	movb	savec,r0
	bic	$177400,r0
	clr	savec
	rts	pc
1:
	tst	*readptr
	bne	1f
2:	mov	source,r0
	sys	read; ch; 1
	bes	eof
	tst	r0
	beq	eof
	movb	ch,r0
	bic	$177400,r0
	rts	pc
1:
	mov	r1,-(sp)
	mov	*readptr,r1
	jsr	pc,getchar
	bes	eof1
	bic	$177400,r0
	mov	r0,ch
	mov	(sp)+,r1
	rts	pc
/
eof:
	tst	source
	beq	1f
	clr	source
	br	2b
1:
	sys	exit
/
eof1:
	mov	*readptr,r1
	beq	2f
	jsr	pc,release
2:
	sub	$2,readptr
	mov	(sp)+,r1
	jmp	readc
/
/
/	case p for print
/
case160:
	cmp	r5,$pdl
	jeq	eh
	jsr	pc,in160
	jmp	loop
/
/
in160:
/	mov	$1,r0
/	sys	write; sphdr; 4
	br	1f
/
sphdr:	<    >
	.even
/
1:	cmp	r5,$pdl
	bne	1f
	mov	$1,r0
	sys	write; qm; 1
	mov	$1,r0
	sys	write; nl; 1
	rts	pc
/
/	do the conversion
/
1:
	mov	-2(r5),r1
	jsr	pc,printf
	rts	pc
/
/
/	case f for print the stack
/
case146:
	mov	r5,-(sp)
1:
	cmp	r5,$pdl
	beq	2f
1:
	jsr	pc,in160
	jsr	pc,pop
	cmp	r5,$pdl
	bne	1b
2:
	mov	$stable-2,r2
1:
	tst	(r2)+
	cmp	r2,$stable+254.
	bhi	1f
/
	mov	(r2),r3
	beq	1b
	movb	$'0,7f+3
	mov	r2,r0
	sub	$stable,r0
	asr	r0
	movb	r0,7f+1
3:
	mov	$1,r0
	sys	write; 7f; 8f-7f
.data
7:	<" (0)">
8:	.even
.text
	mov	2(r3),r1
	jsr	pc,printf
	tst	(r3)
	beq	1b
	incb	7b+3
	mov	(r3),r3
	br	3b
1:
	mov	(sp)+,r5
	jbr	loop
/
/
/	routine to convert to decimal and print the
/	top element of the stack.
/
/	jsr	pc,printf
/
/
printf:
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	r1,-(sp)
	mov	r0,-(sp)
	clr	-(sp)
	jsr	pc,rewind
2:
	jsr	pc,getchar
	bes	2f
	cmp	r0,$143
	blos	2b
	cmp	r0,$-1
	beq	2b
	bis	$1,(sp)
	br	2b
2:
	tst	(sp)+
	beq	2f
	jsr	pc,length
	mov	r0,0f
	mov	a(r1),3f
	mov	$1,r0
	sys	0; 9f
.data
9:
	sys	write; 3:.=.+2; 0:.=.+2
.text
	jbr	prout
2:
	jsr	pc,fsfile
	jsr	pc,backspace
	bec	1f
	mov	$1,r0
	sys	write; asczero; 1
	jbr	prout
1:
	jsr	pc,length
	mov	r1,-(sp)
	jsr	pc,allocate
	mov	(sp),r0
	mov	r1,(sp)
	jsr	pc,move
	mov	ll,count
/	inc	count
	jsr	pc,fsfile
	jsr	pc,backspace
	mov	r0,savk
	dec	w(r1)
	jsr	pc,backspace
	cmpb	r0,$-1
	bne	2f
	mov	basptr,r1
	jsr	pc,fsfile
	jsr	pc,backspace
	cmp	r0,$-1
	beq	2f
	mov	(sp),r1
	jsr	pc,chsign
	mov	$'-,ch
	jsr	pc,wrchar
	br	1f
2:
/	mov	$' ,ch
/	jsr	pc,wrchar
1:
	mov	strptr,r1
	jsr	pc,create
	mov	basptr,r1
	jsr	pc,length
	cmp	r0,$1
	jlo	dingout
	bne	1f
	jsr	pc,rewind
	jsr	pc,getchar
	cmp	r0,$1.
	jeq	unout
	cmp	r0,$-1
	jeq	dingout
	cmp	r0,$10.
	jeq	tenout
1:
	mov	log10,r1
	mul	savk,r1
	mov	r1,r2
	clr	r0
	div	$10.,r0
	mov	r0,r1
	add	r2,r1	/log10 should be 3.3
	clr	r0
	div	logo,r0
	mov	r0,dout
	clr	ct
1:
	mov	(sp),r3
	mov	savk,r2
	jsr	pc,getdec
	mov	r1,decimal
	clr	dflg
	mov	(sp),r1
	mov	savk,r2
	jsr	pc,removc
	mov	r1,(sp)
1:
	mov	(sp),r3
	mov	basptr,r2
	jsr	pc,div3
	mov	r1,r2
	mov	(sp),r1
	jsr	pc,release
	mov	r2,(sp)
	mov	r4,r1
	jsr	pc,*outdit
	mov	(sp),r1
	jsr	pc,length
	bne	1b
/
	mov	strptr,r1
	jsr	pc,fsfile
1:
	jsr	pc,backspace
	bes	1f
	mov	r0,ch
	jsr	pc,wrchar
	br	1b
1:
	mov	(sp)+,r1
	jsr	pc,release
	tst	savk
	bne	1f
	mov	decimal,r1
	jsr	pc,release
	br	prout
1:
	mov	dot,ch
	jsr	pc,wrchar
	mov	strptr,r1
	jsr	pc,create
	mov	decimal,-(sp)
	inc	dflg
1:
	mov	(sp),r3
	mov	basptr,r2
	jsr	pc,mul3
	mov	r1,(sp)
	mov	r3,r1
	jsr	pc,release
	mov	(sp),r3
	mov	savk,r2
	jsr	pc,getdec
	mov	r1,(sp)
	mov	r3,r1
	mov	savk,r2
	jsr	pc,removc
	jsr	pc,*outdit
	mov	strptr,r1
	inc	ct
	cmp	ct,dout
	blo	1b
	mov	(sp)+,r1
	jsr	pc,release
	mov	strptr,r1
	jsr	pc,rewind
1:
	jsr	pc,getchar
	bes	1f
	mov	r0,ch
	jsr	pc,wrchar
	br	1b
1:
/
/	cleanup, print new line and return
/
prout:	mov	$1,r0
	sys	write; nl; 1
	mov	(sp)+,r0
	mov	(sp)+,r1
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	rts	pc
/
/
/
/	r2 = count
/	r3 = pointer (not released)
/
.bss
dflg:	.=.+2
dout:	.=.+2
logo:	.=.+2
log10:	.=.+2
decimal:	.=.+2
.text
getdec:
	mov	r3,-(sp)
	mov	r3,r1
	jsr	pc,rewind
	jsr	pc,length
	jsr	pc,allocate
	mov	r1,-(sp)
1:
	cmp	r2,$1
	blt	1f
	mov	2(sp),r1
	jsr	pc,getchar
	mov	(sp),r1
	jsr	pc,putchar
	mov	r1,(sp)
	sub	$2,r2
	br	1b
1:
	tst	r2
	beq	1f
	mov	tenptr,r2
	mov	(sp),r3
	jsr	pc,mul3
	mov	r1,(sp)
	mov	r3,r1
	jsr	pc,length
	jsr	pc,release
	mov	r0,r3
	jsr	pc,allocate
	mov	r1,-(sp)
	mov	2(sp),r1
	jsr	pc,rewind
2:
	tst	r3
	beq	2f
	jsr	pc,getchar
	mov	(sp),r1
	jsr	pc,putchar
	mov	r1,(sp)
	dec	r3
	mov	2(sp),r1
	br	2b
2:
	clr	r0
	mov	(sp),r1
	jsr	pc,putchar
	mov	2(sp),r1
	jsr	pc,release
	mov	(sp),r3
	mov	tenptr,r2
	jsr	pc,div3
	mov	r1,(sp)
	mov	r3,r1
	jsr	pc,release
	mov	r4,r1
	jsr	pc,release
	mov	(sp)+,r1
	tst	(sp)+
	mov	(sp)+,r3
	rts	pc
1:
	mov	(sp)+,r1
	mov	(sp)+,r3
	rts	pc
tenout:
	mov	savk,ct
	mov	$2,r0
	jsr	pc,allocate
	mov	r1,-(sp)
	mov	2(sp),r1
	jsr	pc,fsfile
	jsr	pc,backspace
	mov	r0,r3
	clr	r2
	dvd	$10.,r2
	beq	1f
3:
	add	$60,r2
	mov	r2,r0
	mov	(sp),r1
	jsr	pc,putchar
	mov	r1,(sp)
1:
	mov	(sp),r1
	add	$60,r3
	mov	r3,r0
	jsr	pc,putchar
	mov	2(sp),r1
1:
	jsr	pc,backspace
	bec	2f
	mov	(sp),r1
	jsr	pc,length
	cmp	r0,ct
	beq	4f
	blo	5f
	sub	ct,r0
	mov	r0,ct
1:
	jsr	pc,getchar
	mov	r0,ch
	jsr	pc,wrchar
	dec	ct
	bne	1b
	jsr	pc,getchar
	bes	6f
	jsr	pc,backspace
4:
	movb	dot,ch
	jsr	pc,wrchar
1:
	jsr	pc,getchar
	bes	1f
	mov	r0,ch
	jsr	pc,wrchar
	br	1b
5:
	sub	r0,ct
	movb	dot,ch
	jsr	pc,wrchar
	mov	$60,ch
5:
	jsr	pc,wrchar
	dec	ct
	bne	5b
	br	1b
1:
6:
	mov	(sp)+,r1
	jsr	pc,release
	mov	(sp)+,r1
	jsr	pc,release
	jbr	prout
2:
	mov	r0,r3
	clr	r2
	dvd	$10.,r2
	br	3b
dot:	<.>
	.even
ct:	.=.+2
/
/
dingout:
	clr	-(sp)
	br	1f
unout:
	mov	$1,-(sp)
1:
	mov	2(sp),r1
	mov	savk,r2
	jsr	pc,removc
	mov	r1,2(sp)
	mov	strptr,r1
	jsr	pc,create
	mov	$-1,r0
	jsr	pc,putchar
	mov	r1,r3
1:
	mov	2(sp),r1
	jsr	pc,length
	beq	1f
	mov	r1,r2
	jsr	pc,add3
	mov	r1,2(sp)
	mov	r2,r1
	jsr	pc,release
	mov	$1,r0
	tst	(sp)
	beq	2f
	mov	$'1,ch
	jsr	pc,wrchar
	br	1b
2:
	tst	delflag
	jne	in177
	sys	write; ding; 3
	br	1b
1:
	tst	(sp)+
	mov	(sp)+,r1
	jsr	pc,release
	jmp	prout
/
ding:	<>			/<bell prefix form feed>
sp5:	<\\\n     >
minus:	<->
one:	<1>
	.even
.bss
count:	.=.+2
.text
/
bigout:
	mov	r1,-(sp)	/big digit
	tst	dflg
	beq	1f
	clr	r0
	jsr	pc,allocate
	mov	r1,tptr
1:
	mov	strptr,r1
	jsr	pc,length
	add	fw,r0
	dec	r0
	mov	r0,-(sp)	/end of field
	clr	-(sp)		/negative
	mov	4(sp),r1
	jsr	pc,length
	bne	2f
	mov	$'0,r0
	tst	dflg
	beq	3f
	mov	tptr,r1
	jsr	pc,putchar
	mov	r1,tptr
	br	1f
3:
	mov	strptr,r1
	jsr	pc,putchar
	br	1f
2:
	mov	4(sp),r1	/digit
	jsr	pc,fsfile
	jsr	pc,backspace
	bpl	2f
	mov	$1,(sp)		/negative
	jsr	pc,chsign
2:
	mov	4(sp),r3	/digit
	mov	r3,r1
	jsr	pc,length
	beq	1f
	mov	tenptr,r2
	jsr	pc,div3
	mov	r1,4(sp)	/digit
	mov	r3,r1
	jsr	pc,release
	mov	r4,r1
	jsr	pc,rewind
	jsr	pc,getchar
	jsr	pc,release
	add	$'0,r0
	tst	dflg
	beq	3f
	mov	tptr,r1
	jsr	pc,putchar
	mov	r1,tptr
	br	2b
3:
	mov	strptr,r1
	jsr	pc,putchar
	br	2b
1:
	tst	dflg
	beq	4f
	mov	tptr,r1
	jsr	pc,length
	cmp	r0,fw1
	bhis	2f
	mov	fw1,r1
	sub	r0,r1
	mov	r1,-(sp)
	mov	strptr,r1
3:
	mov	$'0,r0
	jsr	pc,putchar
	dec	(sp)
	bne	3b
	tst	(sp)+
2:
	mov	tptr,r1
	jsr	pc,fsfile
2:
	mov	tptr,r1
	jsr	pc,backspace
	bes	2f
	mov	strptr,r1
	jsr	pc,putchar
	br	2b
2:
	mov	tptr,r1
	jsr	pc,release
	br	1f
4:
	mov	strptr,r1
	jsr	pc,length
	cmp	r0,2(sp)	/end of field
	bhis	1f
	mov	$'0,r0
	jsr	pc,putchar
	br	1b
1:
	tst	(sp)		/negative
	beq	1f
	mov	$'-,r0
	mov	strptr,r1
	dec	w(r1)
	jsr	pc,putchar
1:
	mov	strptr,r1
	mov	$' ,r0
	jsr	pc,putchar
	tst	(sp)+
	tst	(sp)+
	mov	(sp)+,r1
	jsr	pc,release
	rts	pc
/
.bss
tptr:	.=.+2
tenptr:	.=.+2
.text
/
/
/
hexout:
	mov	r1,-(sp)
	jsr	pc,rewind
	jsr	pc,getchar
	cmp	r0,$16.
	blo	1f
	jmp	err
1:
	add	$60,r0
	cmp	r0,$'9
	blos	2f
	add	$'A-'9-1,r0
2:
	mov	strptr,r1
	jsr	pc,putchar
	mov	(sp)+,r1
	jsr	pc,release
	rts	pc
/
/
wrchar:
	tst	delflag
	jne	in177
	mov	$1,r0
	tst	count
	bne	7f
	sys	write; sp5; 2
	mov	ll,count
	mov	$1,r0
7:
	dec	count
	sys	write; ch; 1
	rts	pc
/
/
/	case P for print an ascii string
/
/
case120:
	jsr	pc,pop
	jes	eh
	jsr	pc,length
	mov	r0,0f
	mov	a(r1),3f
	mov	$1,r0
	sys	0; 9f
	jsr	pc,release
	jmp	loop
.data
9:	sys	write; 3:.=.+2; 0:.=.+2
.text
/
/
/	here for unimplemented stuff
/
junk:
	movb	r0,1f
	mov	$1,r0
	sys	write; 1f; 2f-1f
	jmp	loop
.data
1:	<0 not in switch.\n>
2:	.even
.text
/
/
/
/	routine to place one word onto the pushdown list
/	Error exit to system on overflow.
/
/
push:
	mov	r1,(r5)+
	cmp	r5,$pdltop
	bhis	pdlout
	rts	pc
/
pdlout:
	mov	$1,r0
	sys	write; 1f; 2f-1f
	jmp	reset
1:	<Out of pushdown.\n>
2:	.even
/
/
/	routine to remove one word from the pushdown list
/	carry bit set on empty stack
/
/
/	jsr	pc,pop
/
pop:
	cmp	r5,$pdl
	bhi	1f
	clr	r1
	sec
	rts	pc
1:	mov	-(r5),r1
	clc
	rts	pc
/
/
/
/
.data
outdit:	hexout
.bss
source: .=.+2
savec:	.=.+2
ch:	.=.+2
.text
nl:	<\n>
asczero:	<0>
qm:	<?\n>
	.even
/
.bss
chptr:	.=.+2
strptr:	.=.+2
basptr:	.=.+2
scalptr:	.=.+2
errstack:.=.+2
/
stable:	.=.+512.
.text
casetab:
	case012; 012	/nl
	loop;    040	/sp
	case041; 041	/!
	case045; 045	/%
	case052; 052	/*
	case053; 053	/+
	case055; 055	/-
	case060; 056	/.
	case057; 057	//
	case060; 060	/0
	case060; 061	/1
	case060; 062	/2
	case060; 063	/3
	case060; 064	/4
	case060; 065	/5
	case060; 066	/6
	case060; 067	/7
	case060; 070	/8
	case060; 071	/9
	case072; 072	/:
	case073; 073	/;
	case074; 074	/<
	case075; 075	/=
	case076; 076	/>
	case077; 077	/?
	case060; 101	/A
	case060; 102	/B
	case060; 103	/C
	case060; 104	/D
	case060; 105	/E
	case060; 106	/F
	case111; 111	/I
	case113; 113	/K
	case114; 114	/L
	case117; 117	/O
	case120; 120	/P
	case121; 121	/Q
	case123; 123	/S
	case166;  126	/V
	case130; 130	/X	scale of top of stack
	case132; 132	/Z	length of top of stack
	case133; 133	/[
	case136; 136	/^
	case137; 137	/_
	case143; 143	/c
	case144; 144	/d
	case146; 146	/f
	case151; 151	/i
	case153; 153	/k
	case154; 154	/l
	case157; 157	/o
	case160; 160	/p
	case161; 161	/q
	case163; 163	/s
	case166; 166	/v
	case170; 170	/x
	case172; 172	/z
	0;0
/
.bss
pdl:	.=.+100.
pdltop:
.text

reset:
	clr	r0
	sys	seek; 0; 2
1:
	clr	r0
	sys	read; rathole; 1
	bes	1f
	tst	r0
	beq	1f
	cmpb	rathole,$'q
	bne	1b
1:
	sys	exit
.bss
rathole:	.=.+2
.text
stack
	case132; 132	/Z	length of top of stack
	case133; 133	/[
	case136; 136	/^
	case137; 137	/_
	case143; 143	/c
	case144; 144	/d
	case146; 146	/f
	case151; 151	/i
	case153; 153	/k
	case154; 154	/l
	c/
/
/	routine to add the two centennial numbers
/	pointed to by r2 and r3.
/	a pointer to the result is returned in r1
/	r2 and r3 are preserved
/
/	mov	ptr1,r2
/	mov	ptr2,r3
/	jsr	pc,add3
/	mov	r1,...
/
add3:	mov	r0,-(sp)
	mov	r4,-(sp)
	mov	r5,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
/
/	allocate a new string whose length is
/	the max of the two addends.
/
	mov	w(r2),r0
	sub	a(r2),r0
	mov	w(r3),r4
	sub	a(r3),r4
	cmp	r0,r4
	bgt	1f
	mov	r4,r0
1:	mov	r0,r4
	jsr	pc,allocate
	mov	r1,-(sp)
/
/	get everything ready
/
	mov	2(sp),r1
	jsr	pc,rewind
	mov	4(sp),r1
	jsr	pc,rewind
	clr	carry
/
/	now add them
/
2:	dec	r4
	blt	3f
	mov	2(sp),r1	/r2
	jsr	pc,getchar
	mov	r0,r5
	mov	4(sp),r1	/r3
	jsr	pc,getchar
	add	r5,r0
	add	carry,r0
	clr	carry
	cmp	r0,$100.
	blt	1f
	sub	$100.,r0
	mov	$1,carry
1:
	tstb	r0
	bpl	1f
	add	$100.,r0
	mov	$-1,carry
1:	mov	(sp),r1		/r1
	jsr	pc,putchar
	br	2b
/
/	perhaps there is an extra digit
/
3:	mov	carry,r0
	beq	2f
	mov	(sp),r1		/r1
	jsr	pc,putchar
/
/	strip leading zeros
/
2:
	jsr	pc,fsfile
2:	jsr	pc,backspace
	bes	2f
	beq	2b
	inc	r(r1)
2:	mov	r(r1),w(r1)
/
/	strip leading 99's
/
	jsr	pc,fsfile
	jsr	pc,backspace
	cmpb	r0,$-1
	bne	1f
2:
	jsr	pc,backspace
	bes	2f
	cmpb	r0,$99.
	beq	2b
	jsr	pc,getchar
2:
	mov	$-1,r0
	jsr	pc,alterchar
	mov	r(r1),w(r1)
/
/	restore and return
/
1:
	mov	(sp)+,r1
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r5
	mov	(sp)+,r4
	mov	(sp)+,r0
	rts	pc
/
.bss
carry:	.=.+2
.text
/
/
/	routine to change the sign of the centennial number
/	pointed to by r1.
/	negative numbers are stored in 100's complement form with
/	-1 as the high order digit; the second digit is not 99.
/
/	mov	...,r1
/	jsr	pc,chsign
/
chsign:
	mov	r1,-(sp)
	mov	r0,-(sp)
	jsr	pc,rewind
	clr	chcarry
/
1:
	jsr	pc,lookchar
	bes	1f
	negb	r0
	sub	chcarry,r0
	mov	$1,chcarry
	add	$100.,r0
	cmpb	$100.,r0
	bgt	2f
	sub	$100.,r0
	clr	chcarry
2:
	jsr	pc,alterchar
	br	1b
/
1:
	clr	r0
	sub	chcarry,r0
	beq	2f
	jsr	pc,putchar
	jsr	pc,fsfile
	jsr	pc,backspace
	jsr	pc,backspace
	cmp	r0,$99.
	bne	1f
	mov	r(r1),w(r1)
	mov	$-1,r0
	jsr	pc,putchar
	br	1f
/
2:
	jsr	pc,fsfile
	jsr	pc,backspace
	bne	1f
	mov	r(r1),w(r1)
/
1:
	mov	(sp)+,r0
	mov	(sp)+,r1
	rts	pc
/
.bss
chcarry: .=.+2
.text
/
/
/
/
/	routine to multiply the two centennial numbers
/	pointed to by r2 and r3.
/	a pointer to the result is returned in r1
/	r2 and r3 are preserved
/
/	mov	ptr1,r2
/	mov	ptr2,r3
/	jsr	pc,mul3
/	mov	r1,...
/
/	save registers and make space for temps
/
mul3:
	mov	r5,-(sp)
	mov	r3,-(sp)	/arg2
	mov	r2,-(sp)	/arg1
	mov	r0,-(sp)
	tst	-(sp)		/result
	tst	-(sp)		/arg1
	tst	-(sp)		/arg2
	tst	-(sp)		/carry
/
/	compute sign of result and make args positive
/
	clr	outsign
	mov	r2,r1
	jsr	pc,fsfile
	jsr	pc,backspace
	bmi	2f
	mov	r2,4(sp)	/arg1
	br	1f
2:
	jsr	pc,length
	jsr	pc,allocate
	mov	r1,4(sp)
	mov r2,r0
	jsr	pc,move
	jsr	pc,chsign
	com	outsign
1:
	mov	r3,r1
	jsr	pc,fsfile
	jsr	pc,backspace
	bmi	2f
	mov	r3,2(sp)	/arg2
	br	1f
2:
	mov	r3,r1
	jsr	pc,length
	jsr	pc,allocate
	mov	r1,2(sp)
	mov	r3,r0
	jsr	pc,move
	jsr	pc,chsign
	com	outsign
1:
/
/	compute the length of the result and
/	allocate space for it
/
	mov	w(r2),r0
	sub	a(r2),r0
	add	w(r3),r0
	sub	a(r3),r0
	jsr	pc,allocate
	jsr	pc,zero
	mov	r1,6(sp)	/result
	clr	offset
	mov	2(sp),r1	/arg2
	jsr	pc,rewind
/
/	work on next digit of arg2, starting over on arg1
/
1:	mov	4(sp),r1	/arg1
	jsr	pc,rewind
	mov	2(sp),r1	/arg2
	jsr	pc,getchar
	bes	3f
	mov	r0,r2
	mov	6(sp),r1	/result
	jsr	pc,rewind
	add	offset,r(r1)
	clr	0(sp)		/carry
/
/	work on next digit of arg3
/	form the product of the two digits,
/	add to what is already there and add in old carry
/	to generate new dit and new carry.
/
2:	mov	4(sp),r1	/arg1
	jsr	pc,getchar
	bes	2f
	mov	r0,r3
	mpy	r2,r3
	add	(sp),r3		/carry
	mov	6(sp),r1	/result
	jsr	pc,lookchar
	add	r0,r3
	mov	r3,r1
	clr	r0
	dvd	$100.,r0
	mov	r0,(sp)		/carry
	mov	r1,r0
	mov	6(sp),r1	/result
	jsr	pc,alterchar
	br	2b
/
2:
	inc	offset
	tst	(sp)		/carry
	beq	1b
	mov	6(sp),r1	/result
	jsr	pc,lookchar
	add	(sp),r0		/carry
	jsr	pc,alterchar
	br	1b
/
3:
/
/	change sign of result if necessary
/
	tst	outsign
	bpl	1f
	mov	6(sp),r1	/result
	jsr	pc,chsign
/
/	release dregs if necessary
/
1:
	cmp	2(sp),14(sp)
	beq	1f
	mov	2(sp),r1
	jsr	pc,release
1:
	cmp	4(sp),12(sp)
	beq	1f
	mov	4(sp),r1
	jsr	pc,release
1:
/
/	restore registers and return
/
	tst	(sp)+
	tst	(sp)+
	tst	(sp)+
	mov	(sp)+,r1
	mov	(sp)+,r0
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r5
	rts	pc
/
.bss
outsign: .=.+2
offset:	.=.+2
k:	.=.+2
kptr:	.=.+2
.text
/
sqrt:
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	r0,-(sp)
/
/	check for zero or negative
/
	mov	w(r1),r2
	sub	a(r1),r2
/
/	look at the top one or two digits
/
	mov	r1,r3
	jsr	pc,fsfile
	jsr	pc,backspace
	mov	r0,r4
	bit	$1,r2
	bne	2f
	mov	r4,r1
	mul	$100.,r1
	mov	r1,r4
	mov	r3,r1
	jsr	pc,backspace
	add	r0,r4
2:
/
/	allocate space for result
/
	inc	r2
	asr	r2
	mov	r2,r0
	jsr	pc,allocate
	jsr	pc,zero
	mov	r2,r0
	jsr	pc,seekchar
	mov	r1,r2
/
/	get high order digit of arg and square root it
/
	mov	$1,r0
2:	sub	r0,r4
	blt	2f
	add	$2,r0
	br	2b
2:	inc	r0
	asr	r0
	mov	r0,r4
	mov	r2,r1
	jsr	pc,fsfile
	jsr	pc,backspace
	cmp	r4,$100.
	blt	1f
	sub	$100.,r4
	mov	r4,r0
	jsr	pc,alterchar
	mov	$1,r0
	jsr	pc,putchar
	br	2f
1:
	mov	r4,r0
	jsr	pc,alterchar
2:
	mov	r1,-(sp)
	mov	r3,-(sp)
/
/	get successive approx. from Newton
/
1:	mov	(sp),r3		/arg
	mov	2(sp),r2	/approx
	jsr	pc,div3
	mov	r1,r3
	jsr	pc,add3
	mov	r1,-(sp)
	mov	r3,r1
	jsr	pc,release
	mov	r4,r1
	jsr	pc,release
	mov	(sp)+,r1
	mov	sqtemp,r2
	mov	r1,r3
	jsr	pc,div3
	mov	r1,-(sp)
	mov	r3,r1
	jsr	pc,release
	mov	r4,r1
	jsr	pc,release
	mov	(sp)+,r3
	mov	2(sp),r1
	jsr	pc,length
	jsr	pc,allocate
	mov	2(sp),r0
	jsr	pc,move
	jsr	pc,chsign
	mov	r1,r2
	jsr	pc,add3
	jsr	pc,fsfile
	jsr	pc,backspace
	jsr	pc,release
	mov	r2,r1
	jsr	pc,release
	tst	r0
	bpl	2f
/
/	loop if new < old
	mov	2(sp),r1
	jsr	pc,release
	mov	r3,2(sp)
	br	1b
/
2:
	mov	r3,r1
	jsr	pc,release
	mov	(sp)+,r1
	jsr	pc,release
	mov	(sp)+,r1
	mov	(sp)+,r0
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	rts	pc
	jsr	pc,div3
	mov	r1,-(sp)
	mov	r3,r1
	jsr	pc,release
	mov	r4,r1
	jsr	pc,release
	mov	(sp)+,r3
	mov	2(sp),r1
	jsr	pc,length
	jsr	pc,all/
/
/	routine to divide the two centennial numbers pointed
/	to by r2 (the divisor) and r3 (the dividend).
/	A pointer to the result is returned in r1.  All other
/	registers are preserved.  If the divisor is zero, zero
/	is returned and the carry bit is set.
/	Remainder is returned in r4 and has the sign
/	of the dividend.
/
/
/	mov	divisor,r2
/	mov	dividend,r3
/	jsr	pc,div3
/	mov	r1,result
/	mov	r4,remainder
/
/
div3:
	mov	r5,-(sp)
	mov	r3,-(sp)	/dividend
	mov	r2,-(sp)	/divisor
	mov	r0,-(sp)
	tst	-(sp)	/result
/
/	allocate space for result; allocate temps if necessary
/
	clr	r0
	jsr	pc,allocate
	mov	r1,0(sp)	/result
/
/
/	check for divisor zero
/
	mov	4(sp),r2	/divisor
	mov	w(r2),r0
	sub	a(r2),r0
	bne	1f
	jmp	eh
1:
/
/	compute sign of result and make arguments positive
/
	clr	divsign
	mov	r2,r1
	jsr	pc,length
	jsr	pc,allocate
	mov	r1,divisor
	mov	r2,r0
	jsr	pc,move
	jsr	pc,fsfile
	jsr	pc,backspace
	bpl	1f
2:
	jsr	pc,chsign
	mov	r1,divisor
	com	divsign
1:
	clr	remsign
	mov	r3,r1
	jsr	pc,length
	jsr	pc,allocate
	mov	r1,dividend
	mov	r3,r0
	jsr	pc,move
	jsr	pc,fsfile
	jsr	pc,backspace
	bpl	1f
2:
	jsr	pc,chsign
	mov	r1,dividend
	com	divsign
	com	remsign
1:
/
/
/	find out how many digits in the quotient result
/
1:
	mov	dividend,r2
	mov	divisor,r3
	mov	w(r2),r0
	sub	a(r2),r0
	add	a(r3),r0
	sub	w(r3),r0
	jlo	bugout
	mov	r0,divoffset
	mov	0(sp),r1	/result
	inc	r0
	jsr	pc,seekchar
	clr	r0
	mov	dividend,r1
	jsr	pc,putchar
/
/	load r5 with binary divisor for finding
/	trial quotient digits. If leading digit of
/	divisor is <10, it is scaled
/
	clr	magic
	mov	divisor,r1
	jsr	pc,fsfile
	jsr	pc,backspace
	mov	r0,r5
	cmp	r5,$10.
	bge	2f
	inc	magic
2:
	mpy	$100.,r5
	jsr	pc,backspace
	add	r0,r5
	tst	magic
	beq	2f
	mov	r5,r4
	mpy	$100.,r4
	jsr	pc,backspace
	add	r0,r5
	adc	r4
	asl	r5
	rol	r4
	dvd	$25.,r4
	mov	r4,r5
2:
/
/	compute trial quotient digit
/
1:
	mov	dividend,r1
	jsr	pc,fsfile
	jsr	pc,backspace
	bec 9f; 4; 9:
	mov	r0,r3
	mpy	$100.,r3
	mov	r3,r2
	jsr	pc,backspace
	add	r0,r2
	mpy	$100.,r2
	jsr	pc,backspace
	add	r0,r3
	adc	r2
	tst	divoffset
	bne	2f
	add	$1,r3
	adc	r2
2:
/
	tst	magic
	beq	3f
	ashc	$3,r2
3:
	mov	r5,r0
	tst	divoffset
	beq	2f
	inc	r0
2:
	dvd	r0,r2
	mov	r2,trial
/
/
/	multiply divisor by trial digit
/
	mov	divisor,r1
	jsr	pc,rewind
	jsr	pc,length
	inc	r0
	mov	divxyz,r1
	jsr	pc,rewind
	clr	-(sp)
2:
	mov	divisor,r1
	jsr	pc,getchar
	bes	2f
	mov	r0,r3
	mpy	trial,r3
	add	(sp),r3		/carry
	clr	r2
	dvd	$100.,r2
	mov	r2,(sp)		/carry
	mov	r3,r0
	mov	divxyz,r1
	jsr	pc,alterchar
	br	2b
2:
	mov	divxyz,r1
	mov	(sp)+,r0
	jsr	pc,alterchar
3:
/
/	and subtract from dividend
/
	jsr	pc,rewind
	mov	divoffset,r0
	mov	dividend,r1
	jsr	pc,seekchar
	clr	-(sp)
/
2:	mov	dividend,r1
	jsr	pc,lookchar
	bes	2f
	mov	r0,r2
/
	mov	divxyz,r1
	jsr	pc,getchar
	sub	r0,r2
	sub	(sp),r2
	clr	(sp)
	mov	r2,r0
	bpl	3f
	add	$100.,r0
	mov	$1.,(sp)
3:	mov	dividend,r1
	jsr	pc,alterchar
	br	2b
/
/	put away the quotient digit
/
2:
	mov	(sp)+,divcarry
	mov	0(sp),r1	/result
	jsr	pc,backspace
	mov	trial,r0
	jsr	pc,alterchar
	jsr	pc,backspace
/
/	and go for another digit
/
	dec	divoffset
	bmi	1f
	mov	dividend,r1
	dec	w(r1)
	cmp	w(r1),a(r1)
	bhis 9f; 4; 9:
	jmp	1b
/
/	fix up the result
/
1:
	tst	divcarry
	beq	1f
	mov	trial,r0
	dec	r0
	jsr	pc,alterchar
	mov	dividend,r1
	mov	$-1,r0
	jsr	pc,alterchar
	mov	divisor,r2
	mov	dividend,r3
	jsr	pc,add3
	mov	r1,-(sp)
	mov	r3,r1
	jsr	pc,release
	mov	(sp)+,dividend
1:
	mov	0(sp),r1	/result
	jsr	pc,rewind
	clr	divcarry
1:
	jsr	pc,lookchar
	bes	1f
	bic	$!377,r0
	add	divcarry,r0
	clr	divcarry
	cmp	r0,$100.
	blt	2f
	sub	$100.,r0
	inc	divcarry
2:	jsr	pc,alterchar
	br	1b
/
1:
	tst	divcarry
	beq	1f
	mov	$1.,r0
	jsr	pc,alterchar
1:
	jsr	pc,fsfile
1:
	jsr	pc,backspace
	bes	1f
	bne	1f
	mov	r(r1),w(r1)
	br	1b
1:
/
/	change sign of result if necessary
/
	tst	divsign
	bpl	1f
	jsr	pc,chsign
1:
	mov	dividend,r1
	jsr	pc,fsfile
1:
	jsr	pc,backspace
	bes	1f
	bne	1f
	mov	r(r1),w(r1)
	br	1b
1:
bugout:
	tst	remsign
	bpl	1f
	mov	dividend,r1
	jsr	pc,chsign
/
/	clean up junk, restore registers, and return
/
1:
	mov	divisor,r1
	jsr	pc,release
	mov	(sp)+,r1
	mov	(sp)+,r0
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	dividend,r4
	mov	(sp)+,r5
	clc
	rts	pc
/
/
/
/
.bss
divisor: .=.+2
dividend: .=.+2
divxyz:	.=.+2
divoffset:.=.+2
divcarry: .=.+2
divsign: .=.+2
trial:	.=.+2
remsign: .=.+2
magic:	.=.+2
.text
/
/
/
/	routine to exponentiate the two centennial numbers
/	pointed to by r2 (the base) and r3 (the exponent).
/	A pointer to the result is returned in r1.
/
/	mov	base,r2
/	mov	exp,r3
/	jsr	pc,exp3
/	mov	r1,...
/
/
/	save registers
/
exp3:
	mov	r3,-(sp)	/exponent
	mov	r2,-(sp)	/base
	mov	r0,-(sp)
/
/
1:
	mov	$1,r0
	jsr	pc,allocate
	mov	r1,-(sp)	/accumulated result
	mov	$1,r0
	jsr	pc,putchar
/
	mov	r2,r1
	jsr	pc,length
	jsr	pc,allocate
	mov	r1,-(sp)	/powers of the base
	mov	r2,r0
	jsr	pc,move
/
	mov	r3,r1
	jsr	pc,length
	jsr	pc,allocate
	mov	r1,-(sp)	/exponent
	mov	r3,r0
	jsr	pc,move
	jsr	pc,fsfile
	clr	exptemp
	jsr	pc,backspace
	bpl	1f
	inc	exptemp
	jsr	pc,chsign
/
1:
	mov	0(sp),r1
	jsr	pc,length
	beq	1f
	mov	sqtemp,r2
	mov	0(sp),r3
	jsr	pc,div3
	mov	r1,0(sp)
	mov	r3,r1
	jsr	pc,release
	mov	r4,r1
	jsr	pc,length
	jsr	pc,release
	tst	r0
	beq	2f
/
/
/
	mov	2(sp),r2
	mov	4(sp),r3
	jsr	pc,mul3
	mov	r1,4(sp)
	mov	r3,r1
	jsr	pc,release
2:
	mov	2(sp),r3
	mov	r3,r1
	jsr	pc,length
	jsr	pc,allocate
	mov	r1,r2
	mov	r3,r0
	jsr	pc,move
	jsr	pc,mul3
	mov	r1,2(sp)
	mov	r3,r1
	jsr	pc,release
	mov	r2,r1
	jsr	pc,release
	br	1b
1:
	tst	exptemp
	beq	1f
	mov	10(sp),r1
	jsr	pc,length
	bne	2f
	jmp	eh
2:
	cmp	r0,$1
	blos	2f
	mov	4(sp),r1
	jsr	pc,create
	br	1f
2:
	jsr	pc,rewind
	jsr	pc,getchar
	cmp	r0,$1
	bgt	2f
	mov	4(sp),r1
	jsr	pc,create
	jsr	pc,putchar
	br	1f
2:
	mov	4(sp),r1
	jsr	pc,create
1:
	mov	(sp)+,r1
	jsr	pc,release
	mov	(sp)+,r1
	jsr	pc,release
	mov	(sp)+,r1
/
	mov	(sp)+,r0
	mov	(sp)+,r2
	mov	(sp)+,r3
	rts	pc
/
.bss
exptemp: .=.+2
.text
/
jsr	pc,mul3
	mov	r1,2(sp)
	mov	r3,r1
	jsr	pc,release
	mov	r2,r1
	jsr	pc,release
	br	1b
1:
	tst	exptemp
	beq	1f
	mov	10(sp),r1
	jsr	pc,length
	bne	2f
	jmp	eh
2:
	cmp	r0,$1
	blos	2f
	mov	4(sp),r1
	jsr	pc,create
	br	1f
2:
	jsr	pc,rewind
	jsr	pc,getchar
	cmp	r0,$.globl	getchar
.globl	stats
.globl	lookchar
.globl	fsfile
.globl	seekchar
.globl	backspace
.globl	putchar
.globl	alterchar
.globl	move
.globl	rewind
.globl	create
.globl	zero
.globl	allocate
.globl	release
.globl	collect
.globl	getword, putword
.globl	length, position
.globl	w, r, a, l
/
testing = 0
/
/
/	routine to return the length of a string
/
/	mov	...,r1
/	jsr	pc,length
/	mov	r0,...
/
length:
	mov	w(r1),r0
	sub	a(r1),r0
	rts	pc
/
/
/	routine to return the read pointer position
/
/	mov	...,r1
/	jsr	pc,position
/	mov	r0,...
/
position:
	mov	r(r1),r0
	sub	a(r1),r0
	rts	pc
/
/
/
/
/	routine to get a word from the string
/	mov	...,r1
/	jsr	pc,getword
/	mov	r0,...
/
getword:
	jsr	pc,getchar
	bes	noch
	movb	r0,nchar
	jsr	pc,getchar
	bec	2f
	dec	r(r1)
	br	noch
2:	movb	r0,nchar+1
	mov	nchar,r0
	tst	r0		/tst clears c-bit
	rts	pc
/
/
/	routine to put a word onto the string
/	mov	...,r1
/	mov	...,r0
/	jsr	pc,putword
/
putword:
	jsr	pc,putchar
	swab	r0
	jsr	pc,putchar
	swab	r0
	rts	pc
/
.bss
nchar:	.=.+2
.text
/
/
/
/	routine to read next character from string
/	pointed to by r1;  character returned in r0
/	c-bit set if character not available (end of file)
/	r1 is preserved
/
/	mov	...,r1
/	jsr	pc,getchar
/	movb	r0,...
/
getchar:
	jsr	pc,lookchar
	bec	2f
	rts	pc
2:	inc	r(r1)
	tst	r0		/tst clears c-bit
	rts	pc
/
noch:	clr	r0
	sec
	rts	pc
/
/	routine to look at next character from string
/	pointed to by r1;  character returned in r0
/	c-bit set if character not available (end of file)
/	r1 is preserved
/
/	mov	...,r1
/	jsr	pc,lookchar
/	movb	r0,...
/
lookchar:
	.if	testing
	jsr	pc,plausible
	inc	stats+6.
	.endif
	cmp	w(r1),r(r1)
	blos	noch
	movb	*r(r1),r0
	clc
	rts	pc
/
plausible:
	cmp	r1,$headers
	bhis 9f; 4; 9:
	cmp	r1,$headend
	blo 9f; 4; 9:
	rts	pc
/
/
/
/	routine to move the read pointer of a string to a
/	specified point.  If the string is not long enough,
/	the string is extended
/
/	mov	position,r0
/	mov	...,r1
/	jsr	pc,seekchar
/
seekchar:
	mov	r1,-(sp)
	mov	r0,-(sp)
	.if	testing
	jsr	pc,plausible
	inc	stats+10.
	.endif
1:
	mov	(sp),r0
	add	a(r1),r0
	cmp	r0,l(r1)
	bhi	3f
	mov	r0,r(r1)
	cmp	r0,w(r1)
	blo	1f
	mov	r0,w(r1)
	br	1f
3:
	mov	(sp),r0
	jsr	pc,allocate
	mov	2(sp),r0
	jsr	pc,move
	jsr	pc,swap
	jsr	pc,release
	mov	2(sp),r1
	br	1b
1:
	mov	(sp)+,r0
	mov	(sp)+,r1
	rts	pc
/
/
/	routine to move read pointer of string to end of string
/
/	mov	...,r1
/	jsr	pc,fsfile
/
fsfile:
	.if	testing
	jsr	pc,plausible
	inc	stats+10.
	.endif
	mov	w(r1),r(r1)
	rts	pc
/
/
/	routine to read a string backwards
/	the read pointer is decremented before reading
/
/	mov	...,r1
/	jsr	pc,backspace
/	mov	r0,...
/
backspace:
	.if	testing
	jsr	pc,plausible
	inc	stats+6.
	.endif
	cmp	a(r1),r(r1)
	bhis	noch
	dec	r(r1)
	movb	*r(r1),r0
	clc
	rts	pc
/
/
/
/
/	routine to put a character into the string
/	pointed to by r1;  character in r0
/	r0 and r1 are preserved.
/
/	movb	ch,r0
/	mov	...,r1
/	jsr	pc,putchar
/
putchar:
	mov	r1,-(sp)
	mov	r0,-(sp)
	.if	testing
	jsr	pc,plausible
	inc	stats+8.
	.endif
1:	cmp	w(r1),l(r1)
	blt	3f
	mov	w(r1),r0
	inc	r0
	sub	a(r1),r0	/W-A+1
	jsr	pc,allocate
	mov	2(sp),r0	/r1
	jsr	pc,move
	jsr	pc,swap
	jsr	pc,release
	mov	2(sp),r1	/r1
	cmp	w(r1),l(r1)
	blt	3f
	jmp	err
/
3:	movb	(sp),*w(r1)
	inc	w(r1)
	mov	(sp)+,r0
	tst	(sp)+
	rts	pc
/
/
swap:
	mov	w(r1),-(sp)
	mov	w(r0),w(r1)
	mov	(sp),w(r0)
	mov	r(r1),(sp)
	mov	r(r0),r(r1)
	mov	(sp),r(r0)
	mov	a(r1),(sp)
	mov	a(r0),a(r1)
	mov	(sp),a(r0)
	mov	l(r1),(sp)
	mov	l(r0),l(r1)
	mov	(sp)+,l(r0)
	rts	pc
/
/
/	routine to alter a character in the string
/	pointed to by r1;  character in r0
/	r0 and r1 are preserved.
/
/	movb	ch,r0
/	mov	...,r1
/	jsr	pc,alterchar
/
alterchar:
	mov	r1,-(sp)
	mov	r0,-(sp)
	.if	testing
	jsr	pc,preposterous
	inc	stats+8.
	.endif
1:	cmp	r(r1),l(r1)
	blt	3f
	mov	l(r1),r0
	inc	r0
	sub	a(r1),r0	/W-A+1
	jsr	pc,allocate
	mov	2(sp),r0	/r1
	jsr	pc,move
	jsr	pc,swap
	jsr	pc,release
	mov	2(sp),r1	/r1
	cmp	r(r1),l(r1)
	blt	3f
	jmp	err
/
3:	movb	(sp),*r(r1)
	inc	r(r1)
	cmp	r(r1),w(r1)
	ble	1f
	mov	r(r1),w(r1)
1:
	mov	(sp)+,r0
	tst	(sp)+
	rts	pc
/
/
/	routine to move the contents of one string
/	to another.
/
/	mov	source,r0
/	mov	dest,r1
/	jsr	pc,move
/
/	on return, r1 points to the new string and should
/	be saved.  r0 is preserved.
/
move:
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	r1,-(sp)
	mov	r0,-(sp)
	mov	w(r0),r2
	sub	a(r0),r2	/W-A
	mov	l(r1),r3
	sub	a(r1),r3	/L-A
	cmp	r2,r3
	ble	1f
	mov	r2,r0
	jsr	pc,allocate
	mov	2(sp),r0	/r1
	jsr	pc,swap
	jsr	pc,release
	mov	r0,r1
	mov	0(sp),r0	/r0
/
1:	mov	a(r0),(r0)
	mov	a(r1),(r1)
1:	dec	r2
	blt	1f
	movb	*(r0),*(r1)
	inc	(r0)
	inc	(r1)
	br	1b
/
/	fix up read ptr of new string
/
1:	mov	r(r0),r2
	sub	a(r0),r2
	add	a(r1),r2
	mov	r2,r(r1)
/
/	restore and return
/
	mov	(sp)+,r0
	mov	(sp)+,r1
	mov	(sp)+,r2
	mov	(sp)+,r3
	rts	pc
/
/
/	routine to rewind read pointer of string
/	pointed to by r1
/
/	mov	...,r1
/	jsr	pc,rewind
/
rewind:
	.if	testing
	jsr	pc,plausible
	inc	stats+10.
	.endif
	mov	a(r1),r(r1)
	rts	pc
/
/	routine to rewind write pointer of string
/	pointed to by r1
/
/	mov	...,r1
/	jsr	pc,create
/
create:
	.if	testing
	jsr	pc,plausible
	inc	stats+10.
	.endif
	mov	a(r1),w(r1)
	mov	a(r1