/* double.c - Double operand instrcutions. */


#include "defines.h"


/* mov() - Move Instruction.  Move operations with registers as the source
 * and/or destination have been inlined. */

void
mov()
{
    uint16_t data;

    if (SRC_MODE) {
	load_src(&data);
    } else {
	data = regs[SRC_REG];
    }

    CHG_CC_N(data);
    CHG_CC_Z(data);
    CLR_CC_V();

    if (DST_MODE) {
	store_dst(data);
    } else {
	regs[DST_REG] = data;
    }
}


/* cmp() - Compare Instruction. */

void
cmp()
{
    uint16_t data1;
    uint16_t data2;
    uint16_t data3;
    unsigned long temp;

    load_src(&data1);
    load_dst(&data2);

    data3 = ~data2;
    temp = ((unsigned long) data1) + ((unsigned long) (data3)) + 1;
    data3 = LOW16(temp);

    CHG_CC_N(data3);
    CHG_CC_Z(data3);
    CHG_CC_VC(data1, data2, data3);	/* was CHG_CC_V */
    CHG_CC_IC(temp);
}


/* add() - Add Instruction. */

void
add()
{
    uint16_t data1;
    uint16_t data2;
    uint16_t data3;
    unsigned long temp;

    load_src(&data1);
    load_dst(&data2);

    temp = ((unsigned long) data1) + ((unsigned long) data2);
    data3 = LOW16(temp);

    CHG_CC_N(data3);
    CHG_CC_Z(data3);
    CHG_CC_V(data1, data2, data3);
    CHG_CC_C(temp);

    store_dst_2(data3);
}


/* Subtract Instruction. */

void
sub()
{
    uint16_t data1;
    uint16_t data2;
    uint16_t data3;
    unsigned long temp;

    load_src(&data1);
    load_dst(&data2);

    data3 = ~data1;
    temp = ((unsigned long) data2) + ((unsigned long) data3) + 1;
    data3 = LOW16(temp);

    CHG_CC_N(data3);
    CHG_CC_Z(data3);
    CHG_CC_VS(data1, data2, data3);	/* was CHG_CC_V */
    CHG_CC_IC(temp);

    store_dst_2(data3);
}


/* bit() - Bit Test Instruction. */

void
bit()
{
    uint16_t data1;
    uint16_t data2;

    load_src(&data1);
    load_dst(&data2);

    data2 = data1 & data2;

    CHG_CC_N(data2);
    CHG_CC_Z(data2);
    CLR_CC_V();
}


/* bic() - Bit Clear Instruction. */

void
bic()
{
    uint16_t data1;
    uint16_t data2;

    load_src(&data1);
    load_dst(&data2);

    data2 = (~data1) & data2;
    CHG_CC_N(data2);
    CHG_CC_Z(data2);
    CLR_CC_V();

    store_dst_2(data2);
}


/* bis() - Bit Set Instruction. */

void
bis()
{
    uint16_t data1;
    uint16_t data2;

    load_src(&data1);
    load_dst(&data2);

    data2 = data1 | data2;

    CHG_CC_N(data2);
    CHG_CC_Z(data2);
    CLR_CC_V();

    store_dst_2(data2);
}


/* movb() - Move Byte Instruction.  Move operations with registers as the
 * source and/or destination have been inlined. */

void
movb()
{
    uint8_t data;

    if (SRC_MODE) {
	loadb_src(&data);
    } else {
	data = LOW8(regs[SRC_REG]);
    }

    CHGB_CC_N(data);
    CHGB_CC_Z(data);
    CLR_CC_V();

    /* move byte to a register causes sign extension */

    if (DST_MODE) {
	storeb_dst(data);
    } else {
	if (data & SIGN_B)
	    regs[DST_REG] = 0177400 + data;
	else
	    regs[DST_REG] = data;
    }
}


/* cmpb() - Compare Byte Instruction. */

void
cmpb()
{
    uint8_t data1;
    uint8_t data2;
    uint8_t data3;
    unsigned short temp;

    loadb_src(&data1);
    loadb_dst(&data2);

    data3 = ~data2;
    temp = ((unsigned short) data1) + ((unsigned short) (data3)) + 1;
    data3 = LOW8(temp);

    CHGB_CC_N(data3);
    CHGB_CC_Z(data3);
    CHGB_CC_VC(data1, data2, data3);
    CHGB_CC_IC(temp);
}


/* bitb() - Bit Test Byte Instruction. */

void
bitb()
{
    uint8_t data1;
    uint8_t data2;

    loadb_src(&data1);
    loadb_dst(&data2);

    data2 = data1 & data2;

    CHGB_CC_N(data2);
    CHGB_CC_Z(data2);
    CLR_CC_V();
}


/* bicb() - Bit Clear Byte Instruction. */

void
bicb()
{
    uint8_t data1;
    uint8_t data2;

    loadb_src(&data1);
    loadb_dst(&data2);

    data2 = (~data1) & data2;

    CHGB_CC_N(data2);
    CHGB_CC_Z(data2);
    CLR_CC_V();

    storeb_dst_2(data2);
}


/* bisb() - Bit Set Byte Instruction. */

void
bisb()
{
    uint8_t data1;
    uint8_t data2;

    loadb_src(&data1);
    loadb_dst(&data2);

    data2 = data1 | data2;

    CHGB_CC_N(data2);
    CHGB_CC_Z(data2);
    CLR_CC_V();

    storeb_dst_2(data2);
}
