/*
 *	@(#)log.c	1.1 04/09/29
 *
 *	debug_log(), debug_syslog()
 *
 *	Send debugging messages to a log, or the syslog.
 */

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#ifndef lint
static char sccsid[] = "@(#)log.c	1.1 04/09/29 ";
#endif

extern int debug, foreground;
extern FILE *logfile;


void log_msg(int level, const char *fmt, ...)
{
	va_list ap;
	int log_level;

	if (debug >= level) {
		va_start(ap, fmt);
		if (foreground) {
			vfprintf(logfile, fmt, ap);
			fprintf(logfile, "\n");
			fflush(logfile);
		} else {
			log_level = LOG_DAEMON | (level > 0 ? LOG_DEBUG : LOG_ERR);
			vsyslog(log_level, fmt, ap);
		}
		va_end(ap);
	}

	return;
}


void hex_dump(int level, unsigned char *p, long length)
{
	long i;
	short x;
	int log_level;
	char buffer[128];
	char text[17];

	if (debug >= level) {
		log_level = LOG_DAEMON | (level > 0 ? LOG_DEBUG : LOG_ERR);

		strcpy(buffer, "--------------------------------- HEX DUMP ---------------------------------");

		if (foreground) {
			fprintf(logfile, "%s\n", buffer);
			fflush(logfile);
		} else 
			syslog(log_level, "%s", buffer);
	
		buffer[0] = '\0';

		for (i = 0, x = 0; i < length; i++, x++) {
			if (i % 16 == 0) {
				if (i) {
					text[x] = '\0';
					sprintf(&buffer[strlen(buffer)], "  %s", text);
					if (foreground) {
						fprintf(logfile, "%s\n", buffer);
						fflush(logfile);
					} else
						syslog(log_level, "%s", buffer);
					x = 0;
					buffer[0] = '\0';
				}
				sprintf(&buffer[strlen(buffer)], "%8.8lx: ", i);
			}
			sprintf(&buffer[strlen(buffer)], "%2.2x ", (unsigned char)p[i]);
			if (p[i] >= 32 && p[i] < 128)
				text[x] = p[i];
			else
				text[x] = '.';
		}
	
		text[x] = '\0';
		sprintf(&buffer[strlen(buffer)], "%*s  %s", (16 - x) * 3, "", text);
		if (foreground) {
			fprintf(logfile, "%s\n", buffer);
			fflush(logfile);
		} else
			syslog(log_level, "%s", buffer);
	
		strcpy(buffer, "--------------------------------- HEX DUMP ---------------------------------");
		if (foreground) {
			fprintf(logfile, "%s\n", buffer);
			fflush(logfile);
		} else
			syslog(log_level, "%s", buffer);
	}

	return;
}
