#include <stdio.h>
#include "cci.h"

#include "mosaic.h"
extern mo_window *current_win;


/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/* This module contains bindings between the new cci code and the browser  */
/* If you are retrofitting the cci on to your browser strip out everything */
/* except the function headers and the return values and stick in the      */
/* appropriate calls for your browser.                                     */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/


void MCCIRequestGetURL(retCode,retText,url,output,additionalHeader)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
char *url;
int output;
char *additionalHeader; 	/* currently additional header ignored */
{
mo_status moStatus;

#ifdef DEBUG
	printf("MCCIRequestGetURL(url=\"%s\",output=%d,header=\"%s\")\n",
			url,output,additionalHeader);
#endif

	/*do it */
	if (!strchr (url, ':')) {
		url = mo_url_canonicalize_local (url);
		}

	switch (output) {
	    case MCCI_OUTPUT_CURRENT:
		moStatus = mo_load_window_text (current_win, url, NULL);
		if (moStatus == mo_succeed) {
			*retCode = MCCIR_GET_OK;
			strcpy(retText,"Got the URL");
			}
		else {
			*retCode = MCCIR_GET_FAILED;
			sprintf(retText,"Couldn't get URL %s",url);
			}
			break;
	    case MCCI_OUTPUT_NEW:
		if (!mo_open_another_window(current_win,url,NULL,NULL)) {
			*retCode = MCCIR_GET_FAILED;
			sprintf(retText,"Couldn't get URL %s",url);
			}
		else {
			*retCode = MCCIR_GET_OK;
			strcpy(retText,"Got the URL");
			}
		break;
	    case MCCI_OUTPUT_NONE:
		*retCode = MCCIR_GET_FAILED;
		strcpy(retText,"Sorry, OUTPUT to no where not supported yet");
		break;
	    default:
		*retCode = MCCIR_GET_FAILED;
		strcpy(retText,"Send output where???");
		break;
	    }

	return;
}

void MCCIRequestSendAnchor(retCode,retText,client,on)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
MCCIPort client;
int on;		/* boolean value....turn on - true, off - false */
/* anchor replies may be sent back using MCCISendAnchorHistory(client,url)*/
{

#ifdef DEBUG
		printf("MCCIRequestSendAnchor(%d)\n",on);
#endif

	if (on) {
		*retCode = MCCIR_SEND_ANCHOR_OK;
		strcpy(retText,"Send Anchor enabled");
		MoCCISendAnchor(client,1);
		}
	else {
		MoCCISendAnchor(client,0);
		*retCode = MCCIR_SEND_A_STOP_OK;
		strcpy(retText,"Send Anchor disabled");
		}
	return;
}

void MCCIRequestSendOutput(retCode,retText,client,on,type)
int *retCode;
char *retText; /* must be less MCCI_MAX_RETURN_TEXT*/
MCCIPort client;
int on;		/* boolean value....turn on - true, off - false */
char *type;	/* if null, assume all types */
{

#ifdef DEBUG
		printf("MCCIRequestSendOutput(%d,%s)\n",on,type);
#endif
	if (on) {
		MoCCISendOutput(client,1,type);
		*retCode = MCCIR_SEND_OUTPUT_OK;
		strcpy(retText,"Send OUTPUT enabled");
		}
	else {
		MoCCISendOutput(client,0,type);
		*retCode = MCCIR_SEND_O_STOP_OK;
		strcpy(retText,"Send OUTPUT disabled");
		}
	return;
}
