1	EXTEND		! BADBLK.BAS == Check for bad blocks
2	! Check any disk type for bad blocks.  Hard errors are reported.	&
	! Soft errors are logged to the error log file.				&
	!									&
	! Author:	Mike Mayfield, Northwest Digital Software Inc.		&
	! Created:	1-Apr-85 MEM						&
	! Modified:	1-Apr-85 MEM						&
	!									&
	! Variables Used:							&
	! BLKCNT%	Number of blocks to read during fast read pass		&
	! BUFSIZE%	Number of bytes in disk buffer				&
	! DSKCHN%	Channel number for disk					&
	! TEMP$		Temporary variable					&
	! BLKNUM	Current large transfer block number			&
	! BADCNT%	Number of bad blocks found				&
	! TEMP		Temporary variable					&
	! SUBBLK	Current small transfer block number (0 if large xfer)	&

10	BLKCNT%=50%  &
\	BUFSIZE%=BLKCNT%*512%  &
\	DSKCHN%=1%  &
\	INPUT "Disk to check"; TEMP$  &
\	TEMP$=CVT$$(TEMP$,-1%)  &
\	TEMP$=TEMP$+":"  IF INSTR(1%,TEMP$,":")=0%  &
\	OPEN TEMP$ FOR INPUT AS FILE DSKCHN%, RECORDSIZE BUFSIZE%, MODE 128%  &
\	ON ERROR GOTO 1000  &
\	PRINT  &
\	PRINT "Checking "; TEMP$; " for bad blocks."  &
\	BLKNUM= -BLKCNT%  &
\	BADCNT%=0%  &
	! Init constants.  Ask for disk name.  Append a colon if not given.  &
	! Open the disk with a very large buffer.  Print our banner.  &

20	BLKNUM=BLKNUM+BLKCNT%  &
\	PRINT BLKNUM; CHR$(13%);  &
\	GET #DSKCHN%, BLOCK BLKNUM, COUNT BUFSIZE%  &
\	GOTO 20  &
	! Read using many blocks per transfer to do fast transfers.  Print  &
	! our block number as an odometer while reading.  Errors will vector  &
	! to line 1000 and be handled by the routine at line 30.  EOF exits  &
	! after printing a trailer.  &

30	IF SUBBLK=0.0 THEN  &
	  TEMP=BLKNUM  &
	ELSE  &
	  TEMP=SUBBLK+1.0  &
\	  PRINT "Bad block found at block:"; SUBBLK  &
\	  BADCNT%=BADCNT%+1%  &
	! If this is the original entry into this routine, start at the  &
	! block number for this large transfer.  Else, report the bad block  &
	! error and continue at next block.  &

50	FOR SUBBLK=TEMP TO BLKNUM+BLKCNT%-1%  &
\	  GET #DSKCHN%, BLOCK SUBBLK, COUNT 512%  &
\	NEXT SUBBLK  &
\	SUBBLK=0.0  &
\	GOTO 20  &
	! Read all blocks in large transfer one at a time.  Errors will  &
	! vector to line 1000 and from there to line 30 for reporting.  &
	! When finished, flag that we are not in small transfer mode and  &
	! continue with next large transfer.  &

100	PRINT "Finished. "; BADCNT%; "bad block";  &
\	PRINT "s";  if BADCNT%<>1%  &
\	PRINT " found."  &
\	GOTO 32767  &
	! Print a trailer and finish.  &

1000	IF ERR=11% THEN  &
	  RESUME 100  &
	ELSE  &
	  IF ERR=13% THEN  &
	    RESUME 30  &
	  ELSE  &
	    ON ERROR GOTO 0  &
	! If error is end of file, go print banner and leave.  Else, if error  &
	! is "?User data error on device" then go check for individual blocks.  &
	! All other errors are fatal.  &

32767	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               