struct textline inline ;
	extern int kblun,lowlim,highlim,maxlen ;
	register struct textline *tp ;
	register int lineno ;
	int kbin,status ;

	status = sys_normal ;
	kbin = ( lun == kblun ) ;
	for (lineno=lowlim; lineno<=highlim && status==sys_normal; lineno++ ) {
		tp = textpointer(lineno) ;
		if ( kbin )
		  then	{
			sxprintf(inline.c,"%6d )",lineno) ;
			inline.len = app(inline.c,8,tp->c,tp->len) ;
			inline.c[ cvtstring(inline.c,inline.len,04) ] = 0 ;
			if ((inline.len=getprm(inline.c,inline.c,maxlen))==0)
			  then status = 0 ;
			  else status = sys_normal ;
			}
		  else	status = getline(lun,inline.c,&inline.len) ;
		if ( status == sys_normal )
		  then	{
			tp->len = app(tp->c,tp->len,inline.c,inline.len) ;
			if (!kbin) then echoline(kblun,tp,lineno) ;
			}
		}
}


	
cduplicate()
{
	extern struct textline inline ;
	extern struct textline *textpointer() ;
	register struct textline *tp ;
	extern int kblun,lowlim,highlim ;
	register int i ;

	for (i=lowlim; i<=highlim; i++ ) {
		tp = textpointer(i) ;
		scopy(inline.c,tp->c,tp->len) ;
		inline.len = tp->len ;
		tp->len = app(tp->c,tp->len,inline.c,inline.len) ;
		echoline(kblun,tp,i) ;
		}
}


ctxtappend()
{
	extern struct textline *textpointer() ;
	register struct textline *tp ;
	extern int kblun,lowlim,highlim,cmdlun ;
	register int lineno ;
	char s[100] ;
	int size ;

	size = getprm(s,"Text to append ? ",100) ;
	if ( size && (size=cvtstring(s,size,04)) !=0 )
	  then	{
		s[size++] = CR ;
		s[size++] = LF ;
		for ( lineno=lowlim; lineno<=highlim; lineno++ ) {
			tp = textpointer(lineno) ;
			tp->len = app(tp->c,tp->len,s,size) ;
			if ( verbose ) then echoline(kblun,tp,lineno) ;
			}
		}
}
	


ctrim()
{
	extern int kblun,lowlim,highlim,target ;
	extern struct textline *textpointer() ;
	register struct textline *tp ;
	register int lineno,len ;

	if ( target == 0 ) then target = 80 ;

	for (lineno=lowlim; lineno <= highlim; lineno++ ) {
		tp = textpointer(lineno) ;
		if ( tp->len > target ) then tp->len = target ;
		len = cvtstring(tp->c,tp->len,0204) ;
		txtmod() ;
		tp->c[len++] = CR ;
		tp->c[len++] = LF ;
		tp->len = len ;
		if ( verbose) then echoline(kblun,tp,lineno) ;
	}
}




static app(s1,len1,s2,len2)
char *s1 ;
register char *s2 ;
int len1,len2 ;
{
	register int i ;
	register char *dp ;
	int len ;

	txtmod() ;
	len = cvtstring(s1,len1,04) ;
	dp = &s1[len] ;
	for (i=len2; i>0; i--) *dp++ = *s2++ ;
	return(len+len2) ;
}



static insert(s,size,new,newsize)
char *s,*new ;
int size,newsize ;
{
	register char *cp,*dp ;
	register int i ;

	cp = &s[size] ;
	dp = &s[size+newsize] ;
	for ( i=size; i > 0 ; i-- ) *(--dp) = *(--cp) ;
	cp = new ;
	dp = s ;
	for ( i=newsize; i > 0 ; i-- ) *dp++ = *cp++ ;
}

static remove(s,size,amount)
char *s ;
int size,amount ;
{
	register char *cp, *dp ;
	register int i ;

	cp = s ;
	dp = &s[amount] ;
	for ( i=size-amount; i>0; i-- ) *cp++ = *dp++ ;
}


static getoldpat(s)
char *s ;
{
	extern struct textline *textpointer();
	struct textline *tp ;
	int size,status ;
	extern int cmdlun,target ;
	register int i ;
	register char *cp,*dp ;

	if ( target )
	  then	{
		tp = textpointer(target) ;
		cp = tp->c ;
		dp = s ;
		for (i=tp->len; i>0; i--) *dp++ = *cp++ ;
		return(cvtstring(s,tp->len,04)) ;
		}
	  else	{
		if ( (size=getprm(s,"Search pattern ? ",64)) != 0 )
		  then	return( cvtstring(s,size,04) ) ;
		  else	return( status ) ;
		}
}		


static getnewpat(s)
register char *s ;
{
	register int status ;
	int size ;

	if ( (size=getprm(s,"Replacement text ? ",64)) != 0 )
	  then	return( cvtstring(s,size,04) ) ;
	  else	return( -1 ) ;
}

static echoline(lun,tp,lineno)
struct textline *tp ;
int lineno,lun ;
{
	extern int p_lines,kblun ;

	if (p_lines && lun == kblun) then plinenumber(lineno) ;
	putline(lun,tp->c,tp->len) ;

}


static scopy(d,s,len)
int len ;
register char *d,*s ;
{
	register int i ;
	for (i=len; i>0 ;i--) *d++ = *s++ ;
}
EDLOOKC  [.050036]EDLOOK.C  [.050036]   J       	                                                       X1               4                                                                                                                                                                                                                                                                                                              |H [4;  I  k(  &   '  (	k߫H&  P  `    \RrP P2PPz  PP{   PPPPP2P~  \  $     \\TD 0D	\~  h   i  )	+\	^(	n^(np\^txY  \^ˀ   \!  k        Vk<\  F˰ < ˴ ˬ      \   VVkˤ   1` @lP ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@<SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @   @                                                
      (" @$ $ # 0$ # $ 8$ % $ % (% $       !             
                @                                                "                     FORRTL                                                        LIBRTL                                                                                                                                                                                                         