$! BIGACC.COM - Display P1 accounts using P2 or
$!              more blocks
$!
$! Parameters:
$!
$!      P1 = Account-spec to select
$!           (default = _SY:[*,*])
$!      P2 = Minimum blocks to select
$!           (default = 1)
$!
$! BIGACC.COM produces a listing of all accounts
$! matching the P1 account-spec with P2 or more
$! blocks allocated.
$!
$! This COM file is dependent on the format of the
$! SHOW ACCOUNT command. It expects that account
$! lines are listed with "[" in the first column,
$! and each account's allocation value is located
$! starting at position 25, length 10.
$!
$
$ _On Control_C then _Goto EXIT
$ _On warning then _Goto EXIT
$
$! Define constants
$ Alloc_Pos = 25
$ Alloc_Len = 10
$ Alloc_End = Alloc_Pos + Alloc_Len - 1
$ Indent = "     "
$
$! Set up defaults for parameters
$ P1 = F$Parse(P1,"_SY:[*,*]")
$ P2 = +P2
$ _If P2 .le. 0 then -
                 P2 = 1
$
$! Build temp file-spec (TEMPnn.TMP)
$ Temp_File = "TEMP" -
                       + F$Right(100+F$Job,2) -
                       + ".TMP"
$
$! Tell user to wait (this could take a while)
$ _Write 0 "Creating data file ..."
$
$! Build SHOW ACCOUNT listing file
$ _Show account/brief/output='Temp_File' 'P1'
$
$! Initialize counters
$ Total_Blocks = 0
$ Total_Accts  = 0
$
$! Open SHOW ACCOUNT output file
$ _Close 1
$ _Open/read 1 'Temp_File'
$
$! Read lines from SHOW ACCOUNT file
$READ:
$ _Read/end_of_file=END 1 Rec
$ _If F$Left(Rec,1) .nes. "[" then -
                _Goto READ
$ Size = +F$Mid(Rec,Alloc_Pos,Alloc_Len)
$ _If Size .lt. P2 then -
                _Goto READ
$ Total_Blocks = Total_Blocks + Size
$ _If Total_Accts .gt. 0 then -
                _Goto CONT
$ _Write 0 ""
$ _Write 0 "Accounts ",P1," using ", -
                      P2," or more blocks:"
$ _Write 0 ""
$
$CONT:
$ _Write 0 indent,F$Left(Rec,Alloc_End)
$ Total_Accts = Total_Accts + 1
$ _Goto READ
$
$END:
$ _If Total_Accts .eqs. 0 then -
                _Write 0 "%No ",P1," accounts using " -
                         ,P2," blocks or more"
$
$ _Write 0 ""
$ Text = "Total     ''Total_Accts' account"
$ _If Total_Accts .ne. 1 then -
                 Text = Text + "s"
$ Spaces = Alloc_End - F$Len(F$String(Total_Blocks))
$ Text = F$Left(Text + "                ",Spaces)
$ _Write 0 Indent,Text,Total_Blocks
$
$EXIT:
$! Close/delete temporary SHOW ACCOUNT data file
$ _Close 1
$ _Delete/nowarn/nolog 'Temp_File'
$
$ _Exit

                                                       