$! CHKERR.COM - Check Error Log for Error Limits
$!
$! This command file checks the ERRDIS summary report
$! file to see if:
$!
$!     1) The error file is using 80% or more of its
$!        allocated blocks (percent can be changed),
$!
$! or  2) One or more of the error types has reached
$!        its limit and cannot report any more errors.
$!
$! If either of the above conditions occur, then CHKERR
$! does the following:
$!
$!     1) Stores the full error report as file
$!        'yymmdd.ERR' in the account defined by the
$!        symbol ERRLOG_ACCT, 
$!
$!     2) Zeros the error log,
$!
$!     3) Deletes any other *.ERR files in account
$!        ERRLOG_ACCT that are more than two weeks old,
$!
$!     4) Sends a mail message to the persons defined
$!        by the symbol CONTACT, indicating that a full
$!        error log was created and the reason(s) why.
$!
$! This command file is executed each day as part of
$! the standard [1,2]DAILY.COM file processing.
$!
$! This command file can only be run under BATCH.
$!
$! ===================================================
$!
$!                           NOTE
$!
$! This command file relies on the format of the report
$! created by the ERRDIS utility.  Any changes to that
$! utility's report format could cause this command file
$! to save and zero the error log prematurely.
$!
$! ===================================================
$!
$ ErrLog_Acct = "W:[1,3]"
$!      Define account to store error reports
$
$ Pcnt_Full = 80
$!      Define % blocks used to consider file "full"
$
$ Contact = "LABA,OPERATIONS"
$!      Define people to send mail to
$!      (Null or undefined symbol to skip mail)
$
$! ===================================================
$
$ _On Error Then _Goto EXIT
$
$! Make sure we're running under batch
$
$ _If F$Access() .nes. "BATCH" -
                 Then _Write 0 "?CHKERR must be run under BATCH"
$
$! Define some useful commands
$
$ Output = "Write 1"
$ Skip_Line = Output + " """""
$ Stars = "**************************************"
$ Splats = Output + " """ + Stars + Stars + """"
$
$! Define action based on value of symbol "Contact."
$
$ Send_Mail = "_Goto FINISH"
$ _If F$Type(Contact) .eqs. "STRING" then -
                 _If Contact .nes. "" Then -
                     Send_Mail = ""
$
$! Save our node name (minus ::)
$
$ Node = F$Node
$ Node = F$Left(Node,F$Len(Node)-2)
$
$! Build error report file name
$
$ Err_File = F$Cvtime()
$ Err_File = ErrLog_Acct -
                           + F$Left(Err_File,2) -
                           + F$Mid(Err_File,4,2) -
                           + F$Mid(Err_File,7,2) -
                           + ".ERR"
$
$! Create summary report in file ERRDIS.SUM
$
$ _Set Data
$ _Run ERROR$:ERRDIS
           ERROR$:ERRLOG.FIL
           ERRDIS.SUM
           Summary
           No
           No
$ _Eod
$
$! Create report file ERRDIS.MSG
$
$ _Close/All
$ _Open/Write/Replace 1 ERRDIS.MSG
$
$ _On error Then _Goto FINISH
$
$! Write report heading
$
$ Splats
$ Skip_Line
$ Output "    ",F$Time
$ Skip_Line
$ Output "    A full report of the errors that occured on"
$ Output "    node ''Node' has been created and saved in"
$ Output "    file ''Node'::''Err_File'."
$ Skip_Line
$ Splats
$
$ Skip_Line
$ Output "    The above report was created because one or"
$ Output "    more of the following conditions occurred:"
$ Skip_Line
$ Output "      1) The error file was more than ", -
                                              Pcnt_Full,"% full,"
$ Output "      2) An error type reached its limit."
$ Skip_Line
$ Output "    These conditions are indicated by an arrow"
$ Output "    prefix (-->) on the corresponding lines."
$ Skip_Line
$ Splats
$ Skip_Line
$
$! Open summary report for reading
$! Show no error type overflow or File full
$! Disable Verify while in loop
$
$ _Open/Read 2 ERRDIS.SUM
$ Overflow := False
$ File_Full := False
$ _Set NoVerify
$
$LOOP:
$! Read next line from file
$
$ _Read/End_Of_File=EOF 2 Line
$
$! Check line for error type overflow
$
$ _If F$instr(1,Line,"*") .le. 1 -
                 Then _Goto CHECK_FULL
$ _If F$Mid(Line,26,1) .nes. "/" -
                 Then _Goto CHECK_FULL
$ _If F$Mid(Line,23,3) .eqs. "REC" -
                 Then _Goto CHECK_FULL
$ _If F$Mid(Line,22,4) .le. F$Mid(Line,27,4) -
                 Then _Goto CHECK_FULL
$
$! Error type did overflow error limit
$! Write line with prefix arrow
$! Set overflow flag
$! Go get another line
$
$ Output "--> ",Line
$ Overflow := TRUE
$ _Goto LOOP
$
$CHECK_FULL:
$! Check if line contains blocks used info
$
$ _If F$Instr(1,Line,"have been") .eq. 0 -
                 Then _Goto WRITE_LINE
$ Loc_1 = F$Instr(1,Line," out of")
$ _If Loc_1 .eq. 0 Then _Goto WRITE_LINE
$
$! Compute percent of blocks used
$! Set flag if more than percent allowed
$
$ Used = +F$Left(Line,Loc_1-1)
$ Loc_2 = F$Instr(Loc_1+8,Line," ")
$ Total = +F$Mid(Line,Loc_1+8,Loc_2-Loc_1-8)
$ Pcnt_Actual = (Used * 100) / Total
$ File_Full = (Pcnt_Actual .gt. Pcnt_Full)
$ _If .not. File_Full Then _Goto WRITE_LINE
$
$! File is "full"
$! Write line with arrow prefix & actual %
$! Go get another line
$
$ Output "--> ",Line, "  (''Pcnt_Actual'% full)"
$ _Goto LOOP
$
$WRITE_LINE:
$! Write current line to file
$! Then go get another line
$!
$ Output "    ",Line
$ _Goto LOOP
$
$EOF:
$! Resume here on EOF while reading report
$! Re-enable Verify and close any open channels
$
$ _Set Verify
$ _Close/All
$
$! Check if overflow or file full condition occurred
$! If not, skip to finish up
$!
$ _If .not. (File_Full .or. Overflow) Then _Goto FINISH
$
$! Create full report minus the tape drive errors
$! Store report temporarily in file ERRDIS.FUL
$
$ _Set Data
$ _Run ERROR$:ERRDIS
           ERROR$:ERRLOG.FIL
           ERRDIS.FUL
           FULL
           ALL


           YES
$ _Eod
$
$! Now copy the file we just created to the
$! file "yymmdd.ERR" in account "ErrLog_Acct"
$
$ _Copy ERRDIS.FUL 'Err_File'
$
$! Delete any versions of ERRDIS that are more than
$! 2 weeks old
$
$ _Delete/Before=-14DAYS/Log/Nowarn 'ErrLog_Acct'*.ERR
$
$! Send mail based on value of symbol "Contact"
$! (Skip to finish if null or undefined)
$
$ Send_Mail
$
$ _Set Data
$ _Mail SEND -
                     /NOEDIT -
                     /NOQUERY -
                     /SUBJECT="Full ERRDIS report created" -
                   ERRDIS.MSG to 'Contact'
$ _Eod
$
$FINISH:
$! Close any channels
$! Re-enable verify
$! Delete all the temporary error files
$
$ _Close/All
$ _Set Verify
$ _Set Noon
$ _Delete/Nowarn -
                 ERRDIS.SUM, -
                 ERRDIS.FUL, -
                 ERRDIS.MSG
$
$! All finished, so just exit
$
$EXIT:
$ _Exit

                                                                                                                                                                                                                                                                