$! DATE.COM - Display Date in "Pretty" Format
$!
$! Parameters:
$!
$!      P1 = Date string (in F$Cvtime format)
$!      P2 = Global symbol to assign day name
$!           (If null, display date only)
$!
$! DATE.COM displays date passed in format:
$!
$!          Tuesday, April 7th, 1987
$!
$! If P2 not null, then also assigns name of
$! day (in uppercase) to global symbol P2
$
$! Build array of total days before each month
$ Mon_Days_1  = 0
$ Mon_Days_2  = 31
$ Mon_Days_3  = 59
$ Mon_Days_4  = 90
$ Mon_Days_5  = 120
$ Mon_Days_6  = 151
$ Mon_Days_7  = 181
$ Mon_Days_8  = 212
$ Mon_Days_9  = 243
$ Mon_Days_10 = 273
$ Mon_Days_11 = 304
$ Mon_Days_12 = 334
$
$! Build array of month names
$ Month_1  = "January"
$ Month_2  = "February"
$ Month_3  = "March"
$ Month_4  = "April"
$ Month_5  = "May"
$ Month_6  = "June"
$ Month_7  = "July"
$ Month_8  = "August"
$ Month_9  = "September"
$ Month_10 = "October"
$ Month_11 = "November"
$ Month_12 = "December"
$
$! Build array of day names
$ Day_0 = "Sunday"
$ Day_1 = "Monday"
$ Day_2 = "Tuesday"
$ Day_3 = "Wednesday"
$ Day_4 = "Thursday"
$ Day_5 = "Friday"
$ Day_6 = "Saturday"
$
$! Build date string using F$Cvtime
$ _Set NoOn
$ _Set NoEcho/NoWarning
$ Date_Time = F$Cvtime("''P1'")
$ Error = .not. $Severity
$ _Set Echo
$ _Set On
$ _If Error then -
                _Write 0 "?''P1' is not a valid date"
$
$! Save year, month and day values
$ Yr  = +F$Left(Date_Time,2)
$ Mon = +F$Mid(Date_Time,4,2)
$ Day = +F$Mid(Date_Time,7,2)
$
$! Compute day index in year
$ Day_of_Yr = Day + Mon_Days_'Mon'
$ Leap_Yr = (Yr .and. 3) .eq. 0
$ _If Leap_Yr then -
                _If Mon .gt. 2 then -
                    Day_of_Yr = Day_of_Yr + 1
$
$! Compute no. years since 1970
$ Yrs_Aft_70 = Yr - 70
$
$! Compute no. leap years since 1970
$ Leap_Yrs_Aft_70 = (Yrs_Aft_70 + 2) / 4 - Leap_Yr
$
$! Compute no. days since 1970
$ Days_Aft_70 = 365 * (Yrs_Aft_70) -
                           + Leap_Yrs_Aft_70 + Day_of_Yr
$
$! Compute day index in week (0=Sunday,...)
$ Day_of_Week = Days_Aft_70 + 3 -
                         - (7 * ((Days_Aft_70 + 3) / 7))
$
$! Build day ordinal string (1st, 2nd, ...)
$ Ord = +F$Right(10+Day,2)
$ _If Day/10 .eq. 1 then Ord = 4
$ _If (Ord .lt. 1) .or. (Ord .gt. 4) then -
                   Ord = 4
$ Ord = "''Day'" + F$Mid("stndrdth",2*Ord-1,2)
$
$! Display date (e.g., Tuesday, April 7th, 1987)
$ _Write 0 Day_'Day_of_Week',", ", -
                      Month_'Mon'," ",Ord,", ",1900+Yr
$
$! Save U/C name-of-day if any global symbol P2
$ _If P2 .nes. "" then -
                 'P2' == F$Edit(Day_'Day_of_Week',32)
$
$ _Exit

                                                                                                                                                                                                                                                                                                                                                                          