1	EXTEND
2	! MTDIR == DOS and ANSI Label Magtape Directory Utility			&
	!									&
	! This program displays a directory of a magtape containing one or	&
	! both of DOS and/or ANSI labeled records.  Magtape errors that occur	&
	! during processing are displayed, but the directory continues.		&
	!									&
	! Command Format:							&
	!  MTDIR> [MTn:]/OUTPUT=filespec						&
	!									&
	! Author:								&
	!  Michael Mayfield							&
	!									&
	! Edit History:								&
	!  00 08-Oct-85 MEM	Original version				&
	!  01 19-May-86 MEM	General cleanup for distribution		&
	!									&
	! RSTS Version:								&
	!  V8.0, V9.0, V9.1							&
	!									&
	! Variable Usage:							&
	!  CREDAT$		Creation date for current file			&
	!  CUR.LABEL.TYPE$	Last label type displayed			&
	!  FILCNT		Number of files on tape (running total)		&
	!  FILNAM$		File name for current file			&
	!  FILNAM1$		Filename for current file, word 1		&
	!  FILNAM2$		Filename for current file, word 2		&
	!  FILSIZ		Size of the current file in tape blocks		&
	!  FILTYP$		Filetype for current file			&
	!  KBCHN%		Channel number for TI: I/O			&
	!  LAB.NUM$		ANSI label number				&
	!  LAB.TYP$		ANSI label type 				&
	!  LABEL$		Combined ANSI label type and number		&
	!  LABEL.TYPE%		Label type for current file (DOS or ANSI)	&
	!  MTCHN%		Channel number for magtape I/O			&
	!  OUTCHN%		Channel number for report output		&
	!  PROG$		Programmer number for current file		&
	!  PROJ$		Project number for current file			&
	!  PROT$		Protection code for current file		&
	!  RECLEN%		Label record length, in bytes			&
	!  TOTFILSIZ		Total number of blocks on tape (running tot)	&
	!  Z$,Z%		Temporary variables				&

10	PRINT "MTDIR == Magtape Directory Utility"  &
\	PRINT  &
\	MTCHN%=1%  &
\	OUTCHN%=2%  &
\	KBCHN%=3%  &
\	ON ERROR GOTO 32000  &
\	OPEN "KB:MTDIR.KB" FOR INPUT AS FILE KBCHN%  &
	! Print our banner.  Assign constants.  Open our keyboard.  &

100	PRINT #KBCHN%, "MTDIR> ";  &
\	INPUT LINE #KBCHN%, Z$  &
\	Z$=CVT$$(Z$,-1%)  &
\	MTFIL$=Z$  IF LEN(Z$)<>0%  &
\	Z%=INSTR(1%,Z$,"/")  &
\	IF Z% THEN  &
	  MTFIL$=LEFT(Z$,Z%-1%)  &
\	  Z%=INSTR(Z%,Z$,"=")  &
\	  IF Z% THEN  &
	    OUTFIL$=RIGHT(Z$,Z%+1%)  &
	  ELSE  &
	    PRINT "?Invalid switch: Missing equal sign."  &
\	    GOTO 100  &
	! Print our prompt.  Get the command line.  Assume all they entered  &
	! was a magtape name.  Search for /OUTPUT=.  If found, use the  &
	! specified output filename.  &

110	MTFIL$="MT0:"  IF MTFIL$=""  &
\	OUTFIL$="KB:MTDIR.TXT"  IF OUTFIL$=""  &
\	OPEN OUTFIL$ FOR OUTPUT AS FILE OUTCHN%  &
\	OPEN MTFIL$ FOR INPUT AS FILE MTCHN%, RECORDSIZE 20%*512%  &
\	Z%=MAGTAPE(3%,0%,MTCHN%)  &
\	PRINT #OUTCHN%, "[  PPn  ]  Name .Typ   Size  Prot  Creation  Format"  &
	! Default to MT0: if no magtape name entered.  Default to KB:MTDIR.TXT  &
	! if no output file specified.  Open tape and output files.  Rewind  &
	! the tape.  Print our header line.  &

120	GET #MTCHN%  &
\	RECLEN%=RECOUNT
130	IF RECLEN%=14% THEN  &
	  FIELD #MTCHN%,2% AS FILNAM1$,  &
			2% AS FILNAM2$,  &
			2% AS FILTYP$,  &
			1% AS PROG$,  &
			1% AS PROJ$,  &
			1% AS PROT$,  &
			1% AS FILLER$,  &
			2% AS CREDAT$,  &
			2% AS FILLER$  &
\	  LABEL.TYPE$="DOS"  &
\	  PROJ%=ASCII(PROJ$)  &
\	  PROG%=ASCII(PROG$)  &
\	  FILNAM$=RAD$(SWAP%(CVT$%(FILNAM1$)))+RAD$(SWAP%(CVT$%(FILNAM2$)))+  &
		"."+RAD$(SWAP%(CVT$%(FILTYP$)))  &
\	  PROT%=ASCII(PROT$)  &
\	  CREDAT$=DATE$(SWAP%(CVT$%(CREDAT$)))  &
\	  GOTO 200
140	!ELSE  &
	  IF RECLEN%<>14% THEN  &
	    FIELD #MTCHN%,	 3% AS LAB.TYP$,  &
				 1% AS LAB.NUM$,  &
				10% AS FILNAM$,  &
				27% AS FILLER$,  &
				 6% AS CREDAT$  &
	  ELSE  &
	    PRINT #OUTCHN%, "%Invalid record length for file label (";  &
		NUM1$(RECLEN%); " bytes).  File skipped."  &
\	    Z%=MAGTAPE(4%,32767%,MTCHN%)  UNTIL  &
		(MAGTAPE(7%,0%,MTCHN%) AND 128%)=0%  &
\	    GOTO 180
150	  LABEL$=LAB.TYP$+LAB.NUM$  &
\	  IF LAB.TYP$="VOL" THEN  &
	    FIELD #MTCHN%,     44% AS FILLER$,  &
				3% AS PROJ$,  &
				3% AS PROG$  &
\	    ANSI.PROJ%=VAL(PROJ$)  &
\	    ANSI.PROG%=VAL(PROG$)  &
\	    GOTO 120
160	  !ELSE  &
	    IF LABEL$="HDR1" THEN  &
	      LABEL.TYPE$="ANSI"  &
\	      PROJ%=ANSI.PROJ%  &
\	      PROG%=ANSI.PROG%  &
\	      FILNAM$=FILNAM$+""  &
\	      PROT%=0%  &
\	      Z=VAL(CREDAT$)-70000.  &
\	      CREDAT$=DATE$(Z)  &
\	      Z%=MAGTAPE(4%,32767%,MTCHN%)  &
\	      GOTO 200
170	    !ELSE  &
	      GOTO 300  IF LAB.TYP$="EOV"
180	      Z%=MAGTAPE(4%,32767%,MTCHN%)  &
\	      GOTO 180  UNLESS (MAGTAPE(7%,0%,MTCHN%) AND 128%)  &
\	      GOTO 120  &
	! Get the file label.  Tell us if it's probably garbage, but continue  &

200	FILSIZ=0.0  &
\	IF LABEL.TYPE$="ANSI" AND (ANSI.PROJ% OR ANSI.PROG%)=0% THEN  &
	  PRINT #OUTCHN%, USING "          \        \  "  &
		FILNAM$;  &
	ELSE  &
	  PRINT #OUTCHN%, USING "[###!###] \        \  "  &
		PROJ%, ",", PROG%, FILNAM$;  &
	! Init file size.  Print filename in DOS or ANSI format.  &

210	Z=MAGTAPE(4%,32767%,MTCHN%)  &
\	FILSIZ=FILSIZ+32767.0-Z  &
\	GOTO 210  UNLESS (MAGTAPE(7%,0%,MTCHN%) AND 128%)  &
\	FILSIZ=FILSIZ-1.0  &
	! Skip to end of file and count the number of records skipped.  &
	! Don't count the tape mark as a record in the file.  &

220	Z$=""  &
\	Z$=LABEL.TYPE$  IF LABEL.TYPE$<>CUR.LABEL.TYPE$  &
\	CUR.LABEL.TYPE$=LABEL.TYPE$  &
\	IF LABEL.TYPE$="DOS" THEN  &
	  PRINT #OUTCHN%, USING "#####  <###> \       \  \   \",  &
		FILSIZ, PROT%, CREDAT$, Z$  &
	ELSE  &
	  PRINT #OUTCHN%, USING "#####        \       \  \   \",  &
		FILSIZ, CREDAT$,Z$
230	FILCNT=FILCNT+1.0  &
\	TOTFILSIZ=TOTFILSIZ+FILSIZ  &
\	GOTO 120  &
	! Print PPN, filename, filetype, size, protection, and creation date.  &
	! Repeat for the next file on the tape.  &

300	Z%=MAGTAPE(3%,0%,MTCHN%)  &
\	PRINT #OUTCHN%  &
\	PRINT #OUTCHN%, "Total of"; TOTFILSIZ; "blocks in"; FILCNT; "files"  &
\	PRINT #OUTCHN%  &
\	CLOSE #MTCHN%, #OUTCHN%  &
\	GOTO 100  &
	! At EOT: Rewind the tape, close the channel and do it all again.  &
32000	IF ERR=11% THEN  &
	  RESUME 32767  IF ERL=100  &
\	  RESUME 300  &
	! If EOF: ^Z on keyboard or rewind the tape, close the channel and exit  &

32010	ON ERROR GOTO 0  IF ERR<>13% OR (ERL<>120 AND ERL<>210)  &
\	IF ERL=120 THEN  &
	  RECLEN%=RECOUNT  &
\	  PRINT "%Tape error while reading file label for following file:"  &
\	  RESUME 130  &
	! If ?User data error on device:  &
	! Report error reading file label and try to use the data anyway.  &

32020	IF ERL=210 THEN  &
	  PRINT  IF CCPOS(0%)  &
\	  PRINT "%Tape error while determining file size."  &
\	  IF MAGTAPE(7%,0%,MTCHN%) AND 128% THEN  &
	    RESUME 120  &
	  ELSE  &
	    RESUME 180  &
	! Report error skipping thru file.  If at end of file, start next  &
	! file info, else skip to end of file and then start next file.  &

32767	END
                                                                                                                                                                                           