1	EXTEND
2	! SILSYM  ==  List symbols in .SIL image				&
	!									&
	! This program lists the symbols in a SIL image file in a format	&
	! similar to a load map.  The SIL image may be a monitor image		&
	! (eg. RSTS80.SIL), a runtime system (eg. BASIC.RTS), a resident	&
	! library (eg. RMSLIB.LIB), or a task image built in SIL format to	&
	! allow use of global symbol names in ONLPAT (eg. CTOS.TSK).		&
	!									&
	! This program is provided by Northwest Digital Software Inc. as a	&
	! service to the RSTS community.  It is provided "AS IS" with no	&
	! warranties, expressed or implied.					&
	!									&
	! Author:								&
	!  Michael Mayfield							&
	!									&
	! Variable Usage:							&
	!  IDENT1$		Current module IDENT, word 1 of 2 (RAD50)	&
	!  IDENT2$		Current module IDENT, word 2 of 2 (RAD50)	&
	!  LINCNT%		Number of entries printed on current line	&
	!  LOAD.ADDR$		Current module load address (SWAP%(CVT$%))	&
	!  MOD.LOOP%		Current module number				&
	!  MODCNT$		SWAP%(CVT$%) form of MODCNT%			&
	!  MODCNT%		Number of modules in SIL			&
	!  MODULE.SIZE$		Size of current module (SWAP%(CVT$%) format)	&
	!  NAME1$		Current module name, word 1 of 2 (RAD50)		&
	!  NAME2$		Current module name, word 2 of 2 (RAD50)	&
	!  RPTCHN%		Report output channel number			&
	!  SILBLK%		Current block number is SIL			&
	!  SILCHN%		SIL file channel number				&
	!  SILFIL$		Current SIL file name				&
	!  SYM.LOOP%		Current symbol number				&
	!  SYMCNT$		SWAP%(CVT$%) form of SYMCNT%			&
	!  SYMCNT%		Number of symbols in current module		&
	!  SYMNAM1$()		Symbol names in block, word 1 of 2 (RAD50)	&
	!  SYMNAM2$()		Symbol names in block, word 2 of 2 (RAD50)	&
	!  SYMOFF$		SWAP%(CVT$%) form of SYMOFF%			&
	!  SYMOFF%		Symbol entry offset in current symbol block	&
	!  SYMVAL$()		Symbol value in SWAP%(CVT$%) form		&
	!  OVRNUM$()		Symbol overlay number in SWAP%(CVT$%) form	&
	!  XFER.ADDR$		Current module transfer address (SWAP%(CVT$%))	&
	!									&
	! Function Usage:							&
	!  FNC.OCT$(INTVAL%)	Convert integer value to 6-digit octal string	&
	!   C.OCT%(0..6)	 ASCII array for building octal string		&
	!   INTVAL%		 Integer value to convert			&
	!									&
	! Edit History:								&
	!  00 15-Aug-84 MEM	Original version					&
	!  01 16-Aug-84 MEM	Optimize string handling in FNC.OCT$()		&
	!  02 18-Jun-87 MEM	Modified for extended SIL index for V9.0	&

10	DIM	SYMNAM1$(255),  !02&
		SYMNAM2$(255),  !02&
		OVRNUM$(255),  !02&
		SYMVAL$(255)  !02&
\	SILCHN%=1%  &
\	RPTCHN%=2%  &
\	ON ERROR GOTO 30000  &
	! Define channel numbers.  Trap all errors.				&

100	PRINT  IF CCPOS(0%)  &
\	PRINT "Input file";  &
\	INPUT LINE SILFIL$  &
\	SILFIL$=CVT$$(SILFIL$,39%)  &
\	OPEN SILFIL$ FOR INPUT AS FILE SILCHN%,  &
		RECORDSIZE 2048%,  !02&
		MODE 4096%  &
\	FIELD #SILCHN%,  &
		2% AS MODCNT$		!Number of modules		&
\	GET #SILCHN%, RECORD 1%  &
\	MODCNT%=SWAP%(CVT$%(MODCNT$))  &
\	FIELD #SILCHN%, Z%*8% AS Z$,  &
		2% AS SYMNAM1$(Z%),	!Symbol name 1/2 (RAD50)	&
		2% AS SYMNAM2$(Z%),	!Symbol name 2/2 (RAD50)	&
		2% AS OVRNUM$(Z%),	!Overlay descriptor number	&
		2% AS SYMVAL$(Z%)	!Symbol value			&
			FOR Z%=0% TO 255%  &
\	PRINT  IF CCPOS(0%)  &
\	PRINT "Output to <KB:>";  &
\	INPUT Z$  &
\	Z$=CVT$$(Z$,-1%)  &
\	Z$="KB:"  IF Z$=""  &
\	OPEN Z$ FOR OUTPUT AS FILE RPTCHN%  &
	! Ask for input file.  Open it and field first entry.  Get module	&
	! from SIL index block.  Field symbol table entries as entire record.	&
	! Ask for output device and open it.					&

110	FOR MOD.LOOP%=0% TO MODCNT%-1%  &
\	  GET #SILCHN%, RECORD 1%  &
\	  FIELD #SILCHN%, 32%*MOD.LOOP%-(MOD.LOOP%>14%)*30%+2% AS Z$,  &
		2% AS NAME1$,		!Module name 1/2 (RAD50)	&
		2% AS NAME2$,		!Module name 2/2 (RAD50)	&
		2% AS IDENT1$,		!IDENT 1/2 (RAD50)		&
		2% AS IDENT2$,		!IDENT 2/2 (RAD50)		&
		2% AS Z$,		!Block offset to module		&
		2% AS SYMOFF$,		!Block offset to symbol table	&
		2% AS SYMCNT$,		!Number of symbols		&
		2% AS LOAD.ADDR$,	!Virtual load address		&
		2% AS MODULE.SIZE$,	!Module size			&
		2% AS XFER.ADDR$	!Virtual transfer address	&
\	  PRINT #RPTCHN%  &
\	  PRINT #RPTCHN%, "File: "; SILFIL$; TAB(30%); "Module: ";  &
		RAD$(SWAP%(CVT$%(NAME1$))); RAD$(SWAP%(CVT$%(NAME2$)));  &
		TAB(60%); "Ident: ";  &
		RAD$(SWAP%(CVT$%(IDENT1$))); RAD$(SWAP%(CVT$%(IDENT2$)))  &
\	  PRINT #RPTCHN%, "Load Address:";  &
		  FNC.OCT$(SWAP%(CVT$%(LOAD.ADDR$)));  &
		TAB(30%); "Transfer Address: ";  &
		  FNC.OCT$(SWAP%(CVT$%(XFER.ADDR$)));  &
		TAB(60%); "Module Size: ";  &
		  FNC.OCT$(SWAP%(CVT$%(MODULE.SIZE$)))  &
\	  PRINT #RPTCHN%  &
\	  SYMCNT%=SWAP%(CVT$%(SYMCNT$))  &
\	  SILBLK%=SWAP%(CVT$%(SYMOFF$))+1%  &
\	  SYMOFF%=32767%  &
\	  LINCNT%=0%
120	  FOR SYM.LOOP%=1% TO SYMCNT%  &
\	    IF SYMOFF%>=256% THEN  &
	      GET #SILCHN%, RECORD SILBLK%  &
\	      SILBLK%=SILBLK%+4%  &
\	      SYMOFF%=0%
130	    IF LINCNT%>=7% THEN  &
	      PRINT #RPTCHN%  &
\	      LINCNT%=0%
140	    PRINT #RPTCHN%, USING "\ \\ \ \    \ ",  &
		RAD$(SWAP%(CVT$%(SYMNAM1$(SYMOFF%)))),  &
		RAD$(SWAP%(CVT$%(SYMNAM2$(SYMOFF%)))),  &
		FNC.OCT$(SWAP%(CVT$%(SYMVAL$(SYMOFF%))));  &
\	    Z%=SWAP%(CVT$%(OVRNUM$(SYMOFF%)))  &
\	    IF Z% THEN  &
	      PRINT #RPTCHN%, USING "##  ", Z%;  &
	    ELSE  &
	      PRINT #RPTCHN%, "    ";
150	    SYMOFF%=SYMOFF%+1%  &
\	    LINCNT%=LINCNT%+1%  &
\	  NEXT SYM.LOOP%  &
\	  PRINT #RPTCHN%  &
\	  PRINT #RPTCHN%, CHR$(12%);  &
\	NEXT MOD.LOOP%  &
	! Get the SIL index block.  Print the info from the module in the	&
	! SIL.  Get the count of symbols and offset to the symbol table.	&
	! Force a read on the first symbol block.  &
	! For all symbols in symbol table:  &
	!  Get a new block every 32 symbols.  Print the symbol name and  &
	!  ocatl value for each symbol.  Skip to a new line every 8  &
	!  symbols.  Go to next symbol in block.  &

160	GOTO 32767  &
20000	DEF* FNC.OCT$(INTVAL%)	! Convert integer to octal string   &
\	  DIM C.OCT%(6%)						!01 &
\	  IF INTVAL%>=0% THEN						!01 &
	    C.OCT%(1%)=48%						!01 &
	  ELSE								!01 &
	    C.OCT%(1%)=49%						!01
20010	  INTVAL%=INTVAL% AND 32767%  &
\	  FOR Z1%=6% TO 2% STEP -1%					!01 &
\	    C.OCT%(Z1%)=(INTVAL% AND 7%)+48%				!01 &
\	    INTVAL%=INTVAL%/8%  &
\	  NEXT Z1%  &
\	  C.OCT%(0%)=6%							!01 &
\	  CHANGE C.OCT% TO Z$						!01 &
\	  FNC.OCT$=Z$  &
\	FNEND  &
	! If integer value is positive use a leading 0, else use a leading	&
	! 1.  Strip off the sign bit to ensure no sign propogation.  Mask	&
	! off each octal digit, convert to ASCII value and store in ASCII	&
	! array.  Convert ASCII array to string and return this value.		&

30000	IF ERR=11% AND ERL=100% THEN  &
	  RESUME 32767  &
	! Exit cleanly on ^Z on KB: input					&

30999	ON ERROR GOTO 0  &
	! All other errors are fatal						&

32767	END
                                                                                                                                                                                                                                                                