{ Control C Trapping Procedures by Paul G. Haahr - 1/12/84  }
{ Contents:                                                 }
{      cctrap - enable CTRL/C trapping.                     }
{      cctrapcount(var counter:integer) - enable CTRL/C     }
{          trapping and set up a variable to stand for the  }
{          number of CTRL/C's typed (see the explanation in }
{          the procedure below).                            }
{      nocctrap - disable CTRL/C trapping.                  }


procedure cctrap;
{ Enable Control C trapping - 1/12/84 - Paul G. Haahr                  }
{ Turns on CTRL/C trapping - prevents a program from being interrupted }
{      by a CTRL/C. Remains in effect until the end of the program or  }
{      until the nocctrap procedure is called.                         }

  type
    interrupt_location = 0..65535;
    interrupt_array = array [1..6] of interrupt_location;
    interrupt_handler = ^interrupt_array;
  const
    trap_flag_value = 8#107070;
  var
    trap_vector origin 0: interrupt_handler;
    trap_flag origin 2: interrupt_location;

  begin { cctrap }
    new(trap_vector);
    trap_vector^[1] := 8#12737; { MOV #trap_flag_value, #2 }
    trap_vector^[2] := trap_flag_value;
    trap_vector^[3] := 2;
    trap_vector^[4] := 2;
    trap_flag := trap_flag_value
  end; { cctrap }


procedure cctrapcount(var counter: integer);
{ Enable Control C trapping with counter - 1/12/84 - Paul G. Haahr     }
{ Turns on CTRL/C trapping - prevents a program from being interrupted }
{      by a CTRL/C.  Remains in effect until the end of the program or }
{      until the nocctrap procedure is called.                         }
{ This procedure is the same as cctrap, except that this one also      }
{      keeps track of how many CTRL/C's have been typed.               }
{ The integer variable passed in the call becomes associated with      }
{      CTRL/C trapping and should not be used for anything else in the }
{      calling procedure or program.  It always will be set to the     }
{      number of CTRL/C's which have been typed since the cctrapcount  }
{      procedure last was called.  Setting this variable to any value  }
{      in the calling program or procedure will set the current CTRL/C }
{      count to that value.  Therefore the count may be reset to zero  }
{      simply by setting that variable to zero.  When this procedure   }
{      is called to enable CTRL/C trapping, it initializes the counter }
{      to zero.                                                        }

  type
    interrupt_location = 0..65535;
    interrupt_array = array [1..6] of interrupt_location;
    interrupt_handler = ^interrupt_array;
  const
    trap_flag_value = 8#107070;
  var
    trap_vector origin 0: interrupt_handler;
    trap_flag origin 2: interrupt_location;

  begin { cctrapcount }
    counter := 0;
    new(trap_vector);
    trap_vector^[1] := 8#12737; { MOV #trap_flag_value, #2 }
    trap_vector^[2] := trap_flag_value;
    trap_vector^[3] := 2;
    trap_vector^[4] := 8#5237; { INC #counter }
    trap_vector^[5] := loophole(interrupt_location, ref(counter));
    trap_vector^[6] := 2;
    trap_flag := trap_flag_value
  end; { cctrapcount }


procedure nocctrap;
{ Disable Control C trapping - 1/12/84 - Paul G. Haahr                 }
{ Turns CTRL/C trapping off (back to normal) - the program again may   }
{      be interrupted by a CTRL/C.                                     }

  type
    interrupt_location = 0..65535;
    interrupt_array = array [1..6] of interrupt_location;
    interrupt_handler = ^interrupt_array;
  var
    trap_vector origin 0: interrupt_handler;
    trap_flag origin 2: interrupt_location;

  begin { nocctrap }
    dispose(trap_vector);
    trap_flag := 0
  end; { nocctrap }
                                                                                                                                                                                                                              