{$nodebug}
type
  locationtype = packed array [1..13] of char;
function locate:locationtype;
{ Return the location (disk and account number in the form DU0:[123,321]) }
{ of the last opened file (or of this program itself if the program has   }
{ not opened any files - this can be useful in a library program that     }
{ needs to chain to another program on the same account when the entire   }
{ package might need to be relocated to another account).  Must be called }
{ before any other operation has the chance to change the FIRQB.          }
{                                                       - 2/8/85 - EFM    }
var
  firqb origin 402B : array [1..32] of char;
  dummy : locationtype;
  a,b,c : char;

    procedure makechar(n : integer; var a,b,c : char);
    { convert integer to 3 characters }
    begin
      c := chr((n mod 10)+48);
      n := n div 10;
      b := chr((n mod 10)+48);
      a := chr((n div 10)+48);
      if a='0' then
        begin
          a := ' ';
          if b='0' then b := ' '
        end
    end; { makechar }

begin  { locate }
  dummy[1] := firqb[25];  { first character of unit -  D }
  dummy[2] := firqb[26];  { second character of unit - U }
  dummy[3] := chr(ord(firqb[27])+48);  { unit number - 0 }
  dummy[4] := ':';        {                            : }
  dummy[5] := '[';        {                            [ }
  makechar(ord(firqb[8]),a,b,c);
  dummy[6] := a;    { 3 character project number -     1 }
  dummy[7] := b;          {                            2 }
  dummy[8] := c;          {                            3 }
  dummy[9] := ',';        {                            ' }
  makechar(ord(firqb[7]),a,b,c);
  dummy[10] := a;   { 3 character programmer number -  3 }
  dummy[11] := b;         {                            2 }
  dummy[12] := c;         {                            1 }
  dummy[13] := ']';       {                            ] }
  locate := dummy
end;  { locate }
{$debug}
                                                