{ PLIB:MSG.PAS }

{ Send/Receive routines - 1/87 - EFM }
{ Requires that PLIB:ZEROFX be included BEFORE this file }
{ Contents:
    removereceiver(error);
    declarereceiver(receivername,msgmax,error);
    receivemsg(sleeptimeinseconds,msgstring,error);
    getmsginfo(jobnum,proj,prog,kbnum,bytesxfrd,bytesnotxfrd,parameterstring);
    sendmsg(receivername,msgstring,error);           }


procedure removereceiver(var error:integer);
  var
    firqbsignedbyte origin 402B : packed array [0..37B] of -128..127;
  begin
    zerofx;  { zero the firqb and the xrb }
    firqbsignedbyte[4b]  :=  0;  { 'remove' subfunction }
    firqbsignedbyte[5b]  :=  0;  { own job number }
    firqbsignedbyte[32b] :=  0;  { RIB # not used }
    firqbsignedbyte[33b] := -1;  { non zero = remove all RIB's }
    emt(255);
    emt(60b);  { .MESAG }
    error := firqbsignedbyte[0]
  end;  { removereceiver }


procedure declarereceiver(receiver:packed array [lowr..highr:integer] of char;
                                msgmax:integer; var error : integer);
{ note - for a non-priv, the last two characters of the 6 character receiver 
            name must be your job number }
  var
    stringlen, i : integer;
    firqbsignedbyte origin 402B : packed array [0..37B] of -128..127;
    firqbinteger origin 402B : packed array [0..17B] of integer;
    firqbchar origin 402B : packed array [0..37B] of char;
  begin
    zerofx;  { zero the firqb and the xrb }
    firqbsignedbyte[4b]  := 1; { 'declare' subfunction }

    if lowr = 0
      then stringlen := ord(receiver[0])  { receiver name string length }
      else stringlen := highr;
    if stringlen > 6 then stringlen := 6;  { max 6 char receiver name }
    for i := 1 to stringlen do      { fill in the receiver name }
      firqbchar[i+5] := receiver[i];
    for i := stringlen + 1 to 6 do  { pad rest of receiver name with spaces }
      firqbchar[i+5] := ' ';

    firqbsignedbyte[14b] := 0;  { object type - not used - fot networks only }
    firqbsignedbyte[15b] := 3;  { access - allow privileged local senders only }
    firqbinteger[7b]     := 0;  { buffer max - use no small buffers? qqq }
    firqbsignedbyte[20b] := msgmax; { msg max }
    firqbsignedbyte[21b] := 0;  { inlink max - no network links }
    firqbinteger[11b]    := 0;  { packet max - not used - for emt logger only }
    firqbsignedbyte[24b] := 0;  { outlink max - no network links }
    firqbsignedbyte[25b] := 0;  { packets/msg - not used - for emt logger only }
    firqbsignedbyte[32b] := 0;  { RIB # }
    emt(255);
    emt(60b);  { .MESAG }
    error := firqbsignedbyte[0]
  end;  { declarereceiver }

procedure receivemsg(sleeptime:integer; var message:packed array 
                       [low..high:integer] of char; var error:integer);
    { sleeptime is in seconds - a 0 means no sleep }
    { If sleep time is zero, sleeps until message is received, else wakes up 
      when a message is queued or sleep time expires.  (Also can be awakened 
      by a delimiter at the job's terminal, by logins being disabled, etc.)  
      In all cases it gets error number 5 and no message - another receive 
      (presumably without a sleep) is needed to get the message, if a message 
      being queued was what woke you.  qqq }
  const
    msgstringlen = 512;
  type
    msgstringtype = packed array [1..msgstringlen] of char;
    word = 0..65535;
  var
    msgstring : msgstringtype;
    i, inlen, lowerlen : integer;
    null : char;
    firqbsignedbyte origin 402B : packed array [0..37B] of -128..127;
    firqbinteger origin 402B : packed array [0..17B] of integer;
    xrbinteger origin 442B : packed array [0..7B] of integer;
  begin
    null := chr(0);
    if low = 0
      then inlen := ord(message[0])
      else inlen := high;
    if inlen < msgstringlen
      then lowerlen := inlen
      else lowerlen := msgstringlen;
    for i := low to high do
      message[i] := null;
    zerofx;  { zero the firqb and the xrb }
    firqbsignedbyte[4b]  := 2;  { 'receive' subfunction }
    if sleeptime = 0
      then firqbsignedbyte[5b]  := 4   { receive modifier - local 
                                            sender, nosleep }
      else firqbsignedbyte[5b]  := 5;  { receive modifier - local 
                                            sender, sleep }
    firqbsignedbyte[6b]  := 0;  { sender select - not specific by job # }
    firqbsignedbyte[7b]  := 0;  { qualifier (norm = 0) - not specific by job # }
    firqbinteger[11b] := sleeptime; { sleep time in sec }
    firqbsignedbyte[32b] := 0;  { RIB # }
    xrbinteger[0b] := msgstringlen;  { buffer size (max to be sent is 512) }
    xrbinteger[2b] := loophole(word, ref(msgstring));  { address of buffer }
    for i := 1 to msgstringlen do
      msgstring[i] := null;
    emt(255);
    emt(60b);  { .MESAG }
    error := firqbsignedbyte[0];
    for i := 1 to lowerlen do
      message[i] := msgstring[i];
    if low = 0
      then message[0] := chr(lowerlen)
  end;  { receivemsg }


procedure getmsginfo(var jobnum, proj, prog, kbnum, 
            bytesxfrd, bytesnotxfrd : integer; 
          var parameterstring : packed array [low..high:integer] of char);
{ must be called immediately after a receivemsg }
  type
    firqbstringtype = packed array [1..20] of char;
  var
    firqbstring origin 416b : firqbstringtype;  { for data returned in firqb }
    firqbsignedbyte origin 402B : packed array [0..37B] of -128..127;
    firqbunsignedbyte origin 402B : packed array [0..37B] of 0..255;
    firqbinteger origin 402B : packed array [0..17B] of integer;
    xrbinteger origin 442B : packed array [0..7B] of integer;
    null : char;
    i, inlen, lowerlen : integer;
  begin
    null := chr(0);
    if low = 0
      then inlen := ord(parameterstring[0])
      else inlen := high;
    if inlen < 20
      then lowerlen := inlen
      else lowerlen := 20;
    for i := low to high do
      parameterstring[i] := null;
    jobnum := firqbsignedbyte[5b] div 2;
    prog   := firqbunsignedbyte[6b];
    proj   := firqbunsignedbyte[7b];
    kbnum  := firqbsignedbyte[10b];  { 377b (-1) for detached }
    bytesnotxfrd := firqbinteger[5b];
    bytesxfrd := xrbinteger[1b];
    for i := 1 to lowerlen do
      parameterstring[i] := firqbstring[i];
    if low = 0
      then parameterstring[0] := chr(lowerlen)
  end;  { getmsginfo }


procedure sendmsg(receiver:packed array [lowr..highr:integer] of char; 
                  message : packed array [lowm..highm:integer] of char;
                  var error : integer);
  type
    word = 0..65535;
  var
    jobnumsentto, stringlen, i : integer;
    firqbsignedbyte origin 402B : packed array [0..37B] of -128..127;
    firqbchar origin 402B : packed array [0..37B] of char;
    xrbinteger origin 442B : packed array [0..7B] of integer;
  begin
    zerofx;  { zero the firqb and the xrb }
    firqbsignedbyte[4b] := -1;  { 'send' subfunction }
    firqbsignedbyte[5b] := 0;   { destination - use receiver name }

    if lowr = 0
      then stringlen := ord(receiver[0])  { receiver name string length }
      else stringlen := highr;
    if stringlen > 6 then stringlen := 6;  { max 6 char receiver name }
    for i := 1 to stringlen do      { fill in the receiver name }
      firqbchar[i+5] := receiver[i];
    for i := stringlen + 1 to 6 do  { pad rest of receiver name with spaces }
      firqbchar[i+5] := ' ';

   { firqbstring := 20 char parameter string to be passed in 
                          firqb, if any, padded with nulls }

    if lowm = 0
      then stringlen := ord(message[0])  { message string length }
      else stringlen := highm;
    if stringlen > 512 then stringlen := 512;  { max 512 char message }
    xrbinteger[0b] := stringlen;               { buffer size - max 512 }
    xrbinteger[1b] := stringlen;               { number of bytes to send }
    if lowm = 0
      then
        xrbinteger[2b] := succ(loophole(word,ref(message)))  { addr of buffer }
      else
        xrbinteger[2b] := loophole(word,ref(message));    { address of buffer }

    emt(255);
    emt(60b);  { .MESAG }
    jobnumsentto := firqbsignedbyte[5b] div 2;
    error := firqbsignedbyte[0]
  end;  { sendmsg }
                                                                                                                                                                                                                                                                                                                                                                     