function power(base,exponent:real):real;
{ Raise any base to any exponent.  - 3/84 - EFM }
var
  i, integerexponent, positiveexponent : integer;
  temp : real;
begin
  if base = 0
    then
      begin
        if exponent < 0 then
          begin
            write('?Warning: zero raised to negative exponent (');
            writeln(exponent:1:3,') in function ''power''.')
          end;
        power := 0
      end
    else
      begin
        integerexponent := trunc(exponent);
        if exponent = integerexponent 
          then
            begin
              positiveexponent := abs(integerexponent);
              temp := 1;
              for i := 1 to positiveexponent do
                temp := temp * base;
              if exponent < 0 then temp := 1 / temp;
              power := temp
            end
          else
            begin
              if base < 0 then
                begin
                  write('?Warning: negative base (',base:1:3,') with ');
                  writeln('fractional exponent (',exponent:1:3,')');
                  writeln('   in function ''power''.');
                  base := abs(base)
                end; { if }
              power := exp(ln(base)*exponent)
            end { else }
      end { else }
end; { power }
                                                                                                                                                                                                                               