{ Random number generator.  EFM/OMSI - 10/30/84 }
{ To use:
	Call randominit once at the beginning of your program.
	Then, to get a random number, use statements such as
            x := random
               to get a random real (decimal) value x, such that 0<=x<1
            x := randomr(a,b)
               to get a random real (decimal) value x, such that a<=x<b
            x := randomi(a,b)
               to get a random integer value x, such that a<=x<=b       }

var
  randomnumberseed : 0..65535;

procedure randominit; { initialize the random number sequence }
  begin
    randomnumberseed := trunc(time * 1000.0);
  end; { randominit }

function random : real; { returns a random decimal value < 1 }
  begin { random }
    randomnumberseed := (randomnumberseed * 13077 + 6925) mod 32768;
    random := randomnumberseed / 32768.0
  end; { random }

function randomi(a,b : real) : integer; { returns a random integer bet. a&b }
  begin { randomi }
    randomnumberseed := (randomnumberseed * 13077 + 6925) mod 32768;
    randomi := trunc((b+1-a)*(randomnumberseed / 32768.0)+a)
  end; { randomi }

function randomr(a,b : real) : real; { returns a random real between a & b }
  begin { randomr }
    randomnumberseed := (randomnumberseed * 13077 + 6925) mod 32768;
    randomr := (randomnumberseed / 32768.0)*(b-a)+a
  end; { randomr }
                                                                                                                                                          