{ plib:trig.pas - trigonometric functions                        }
{   Pascal supplies the functions sin, cos and arctan.  This     }
{   file supplies the functions tan, sinh, cosh and tanh.  In    }
{   all cases the angle must be in radians.  These functions     }
{   work correctly for both single and double precision.         }
{   Morelock says these functions are accurate assuming that     }
{   the angle is less than pi/4, but they seem to work for most  }
{   larger angles as well, although with less precision.         }
{                                                                }
{   3/14/85 - EFM - from ACM Algorithm #229, "Elementary         }
{     Functions by Continued Fractions" by James C. Morelock     }
{                                                                }

function tan(x:real):real;
var
  i : integer;
  r, f : real;
begin
  r := -x * x;
  f := 22;
  for i := 5 downto 1 do
    f := 4*i - 2 + r/f;
  tan := 2*x*f/(f*f+r)
end; { tan }

function sinh(x:real):real;
var
  i : integer;
  r, f : real;
begin
  r := x * x;
  f := 22;
  for i := 5 downto 1 do
    f := 4*i - 2 + r/f;
  sinh := 2*x*f/(f*f-r)
end; { sinh }

function cosh(x:real):real;
var
  i : integer;
  r, f : real;
begin
  r := x * x;
  f := 22;
  for i := 5 downto 1 do
    f := 4*i - 2 + r/f;
  cosh := (f*f+r)/(f*f-r)
end; { cosh }

function tanh(x:real):real;
var
  i : integer;
  r, f : real;
begin
  r := x * x;
  f := 22;
  for i := 5 downto 1 do
    f := 4*i - 2 + r/f;
  tanh := 2*x*f/(f*f+r)
end; { tanh }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            