1       !                                                       &
        !       B A S I C    +    P R O G R A M                 &
        !       FOR RSTS/E  VERSION 8.0                         &

10      !       FILE NAME : MODEMR.BAS
12      !       VERSION 1 7-JUL-81
14      !       PROGRAMMER: WILLIAM H. BLAKE
16      !       RELEASER: TIM GARDNER
20      !                                                       &
        !                                                       &
        !       M O D I F I C A T I O N    H I S T O R Y        &
        !                                                       &

100     !                                                       &
        !                                                       &
        !       P R O G R A M    D E S C R I P T I O N          &
        !                                                       &
        ! THIS PROGRAM WILL RECEIVE A PROTOCOLED DATA           &
        !                                                       &
        ! TRANSFER FROM A REMOTE OPERATING ENVIRONMENT.         &
        !                                                       &
        ! SEE VOL. 1, ISSUE 1 OF CP/M-NET NEWS FOR A PROTOCOL DESCRIPTION. &
        !                                                       &
        ! RELEASE NOTES BY JOHN DUMONT - 11/10/85               &
        !                                                       &
        ! 1) FOR USERS ON HEAVILY LOADED SYSTEMS THAT UTILIZE   &
        !    DZ OR DL TYPE I/O INTERFACES, PLEASE KEEP IN MIND  &
        !    THAT LONG FILE TRANSFERS TO THAT SYSTEM WILL       &
        !    SEVERELY IMPACT THE RESPONSE TIME OF ALL OTHER     &
        !    USERS.                                             &

101     !       CP/M IS A REGISTERED TRADEMARK OF:              &
        !                                DIGITAL RESEARCH       &
        !       RSTS/E IS A REGISTERED TRADEMARK OF:            &
        !                        DIGITAL EQUIPMENT CORPORATION  &

300     !                                                       &
        !       I / O    C H A N N E L S                        &

301     !       CHANNEL         USED FOR                        &
        !                                                       &
        !       1               KB:-PROTOCOL                    &
        !                                                       &
        !       2               DATA FILE-512 CHARACTER RECORDS &
        !                                                       &

400     !                                                       &
        !       V A R I A B L E    D E F I N I T I O N S        &
        !                                                       &

401     !       VARIABLE        DEFINITION                      &

402     !       A$      RAW DATA STRING (132 BYTES IN LENGTH)
404     !       A%      RAW DATA ARRAY
406     !       D$(4)   OUTPUT BUFFER FIELD AREAS
408     !       D%      INDEX FOR OUTPUT BUFFER FIELD AREAS
410     !       I%      TEMPORARY LOOP CONTROL
412     !       N$      FIELD STRING FOR BINARY TERMINAL INPUT
414     !       N%      RECOUNT FOR BINARY TERMINAL INPUT
416     !       O$      OUTPUT FILE NAME
420     !       R%      ON GO TO VARIABLE (14000,15000)
422     !       R1%     RECORD COUNTER
424     !       S$      SINGLE CHARACTER FIELD FOR SENDING CONTROL CHARACTER
426     !       S%      CHECKSUM ACCUMULATOR
428     !       T%      TIMEOUT COUNTER
800     !                                                               &
        !       F U N C T I O N S    A N D    S U B R O U T I N E S     &

801     !       PROGRAMMER DEFINED SUBROUTINES. LINE  DESCRIPTION       &

802     !       14000   READ BINARY TERMINAL DATA                       &
        !                                                               &
        !       1%=132 CHARACTERS RECEIVED                              &
        !                                                               &
        !       2%=END OF TRANSMISSION                                  &
        !                                                               &
        !       3%=CANCEL TRANSFER                                      &
        !                                                               &
        !       4%=TIMEOUT                                              &

803     !       15000  SEND PROTOCOL CONTROL CHARACTERS                 &
        !                                                               &
        !       1%=ACK                                                  &
        !                                                               &
        !       2%=NAK                                                  &

825     !       PROGRAMMER DEFINED FUNCTIONS.                           &

850     !       STANDARD SUBROUTINES.                                   &
        !                                                               &
        !       LINE  DESCRIPTION                                       &
        !                                                               &

875     !       STANDARD FUNCTIONS.                                     &

900     !       D I M E N S I O N    S T A T E M E N T S                &

905     DIM A%(132)                                                     &
        !                                                               &
        !       ARRAY USED TO CHECK DATA INTEGRITY                      &
        !                                                               &
        !       1=SOH                                                   &
        !                                                               &
        !       2=BLK#                                                  &
        !                                                               &
        !       3=2'S COMPLEMENT OF BLK#                                &
        !                                                               &
        !       4 THRU 131 = 8 BIT DATA                                 &
        !                                                               &
        !       132=CHECKSUM (8 BIT ADDITION OVER 1ST 131)              &
        !                                                               &

906     DIM D$(4)                                                       &
        !                                                               &
        !       4 STRINGS FOR OUTPUT BUFFER FIELDS                      &

999     !       S T A R T    O F    P R O G R A M                       &
        !                                                               &

1000    ON ERROR GO TO 19010                                            &
        !                                                               &
        !       SET UP TO CATCH FILE OPEN, FILE TRANSFER, OR TIMEOUTS   &
        !                                                               &

1010    PRINT 'OUTPUT FILE ';                                           &
        \INPUT LINE O$                                                  &
        \O$=CVT$$(O$,38%)                                               &
        \OPEN O$ FOR OUTPUT AS FILE 2 , RECORDSIZE 512%                 &
        \PRINT '~'                                                      &
        !                                                               &
        !       OPEN THE OUTPUT FILE                                    &

1020    OPEN 'KB:' AS FILE 1 , MODE 1                                   &
        !                                                               &
        !       SET UP FOR BINARY (8-BIT) I/O                           &

1030    FIELD #2, 128 AS D$(1),128 AS D$(2), 128 AS D$(3), 128 AS D$(4) &
        !                                                               &
        !       SET UP TO RECEIVE 128 BYTES PER RECORD TRANSFERRED      &

1040    R1%=1%                                                          &
        \D%=0%                                                          &
        !                                                               &
        !       INITIALIZE RECORD COUNTER AND OUTPUT BUFFER CONTROL     &

1100    GOSUB 14000                                                     &
        \ON R% GO TO 1200,1300,1400,1500                                &
        !                                                               &
        !       1%=132 CHARACTERS RECEIVED                              &
        !                                                               &
        !       2%=END OF TRANSMISSION                                  &
        !                                                               &
        !       3%=CANCEL TRANSFER (CAN)                                &
        !                                                               &
        !       4%=TIMEOUT                                              &

1200    CHANGE A$ TO A%                                                 &
        !                                                               &
        !       GET DATA INTO A FORM WE CAN USE                         &

1210    IF A%(1%)<> 1% THEN R%=2%                                       &
        \GOSUB 15000                                                    &
        \GO TO 1100                                                     &
        !                                                               &
        !       NOT VALID START OF DATA RECORD(SOH)                     &

1220    S%=0%                                                           &
        \FOR I%=1% TO 3%                                                &
                \S%=(S%+A%(I%)) AND 255%                                &
        \NEXT I%                                                        &
        \IF S%<> 0% THEN R%=2%                                          &
        \GOSUB 15000                                                    &
        \GO TO 1100                                                     &
        !                                                               &
        !       RECORD NUMBER NOT VALID                                 &

1230    S%=0%                                                           &
        \FOR I%=1% TO 131%                                              &
                \S%=(S%+A%(I%)) AND 255%                                &
        \NEXT I%                                                        &
        \IF S%<> A%(132%) THEN R%=2%                                    &
        \GOSUB 15000                                                    &
        \GO TO 1100                                                     &
        !                                                               &
        !       CHECKSUM OVER ENTIRE RECORD NOT VALID                   &

1240    IF R1% = A%(2%)+1% THEN R%=1%                                   &
        \GOSUB 15000                                                    &
        \GO TO 1100                                                     &
        !                                                               &
        !       HANDLE SITUATION WHERE TRANSMITTER MISSED THE LAST ACK  &

1250    IF R1%<> A%(2%) THEN R%=2%                                      &
        \GOSUB 15000                                                    &
        \GO TO 1100                                                     &
        !                                                               &
        !       SEND NAK IF BLOCK NUMBER IS NOT WHAT WE EXPECT          &

1260    R1%=(R1%+1%) AND 255%                                           &
        \D%=D%+1%                                                       &
        !                                                               &
        !       INCREMENT THE TRANSFER VARIABLES                        &

1270    LSET D$(D%)=MID(A$,4,128)                                       &
        !                                                               &
        !       MOVE DATA INTO THE OUTPUT BUFFER                        &

1280    IF D%=4% THEN PUT #2                                            &
        \D%=0%                                                          &
        !                                                               &
        !       FLUSH THE BUFFER WHEN FULL                              &

1290    R%=1%                                                           &
        \GOSUB 15000                                                    &
        \GOTO 1100                                                      &
        !                                                               &
        !       ACKNOWLEDGE THE DATA AND GO WAIT FOR MORE               &

1300    R%=1%                                                           &
        \GOSUB 15000                                                    &
        \IF D%<> 0% THEN PUT #2                                         &
        !                                                               &
        !       FLUSH PARTIAL BUFFER AT COMPLETION                      &

1305    CLOSE 1,2                                                       &
        \SLEEP 4                                                        &
        \PRINT 'END OF TRANSMISSION'                                    &
        \GO TO 32767                                                    &

1400    CLOSE 1,2                                                       &
        \SLEEP 4                                                        &
        \PRINT 'TRANSFER CANCELED'                                      &
        \GO TO 32767                                                    &

1500    CLOSE 1,2                                                       &
        \SLEEP 4                                                        &
        \PRINT 'TIMEOUT'                                                &
        \GO TO 32767                                                    &

1600    CLOSE 1                                                         &
        \SLEEP 4                                                        &
        \PRINT 'OUTPUT ERROR'                                           &
        \GO TO 32767                                                    &
        !                                                               &
        !       OUTPUT ERROR TO DATA FILE                               &

10000   !                                                               &
        !       P R O G R A M M E R    D E F I N E D    F U N C T I O N S       &
        !       A N D    S U B R O U T I N E S                          &

14000   T%=0%                                                           &
        \A$=""                                                          &
        !                                                               &
        !       SET TIME OUT COUNT TO ZERO                              &
        !                                                               &
        !       WE WILL QUIT AFTER 10 TIMEOUTS OF 10 SECONDS EACH       &
        !                                                               &
        !       SET CUMULTATIVE STRING TO NULL                          &

14010   WAIT 10                                                         &
        !                                                               &
        !       SET UP A 10 SECOND TIMER                                &

14020   GET #1                                                          &
        \N%=RECOUNT                                                     &
        \FIELD #1, N% AS N$                                             &
        \A$=A$+N$                                                       &
        \T% = 0%                                                        &
        !                                                               &
        !       ACCUMULATE RAW 8-BIT DATA INTO A$                       &

14030   IF LEN(A$)=132% THEN R%=1%                                      &
        \RETURN                                                         &
        !                                                               &
        !       FOUND SUFFICIENT NUMBER OF CHARACTERS                   &

14040   IF LEN(A$)> 1 THEN 14010                                        &
        !                                                               &
        !       GO CONTINUE TO BUILD INPUT STRING                       &

14050   IF A$ = CHR$(4%) THEN R%=2%                                     &
        \RETURN                                                         &
        !                                                               &
        !       TRANSFER COMPLETE (EOT)                                 &

14060   IF A$ = CHR$(24%) THEN R%=3%                                    &
        \RETURN                                                         &
        !                                                               &
        !       CANCEL TRANSFER                                         &

14070   GO TO 14010                                                     &
        !                                                               &
        !       NOT A VALID CONTROL CHARACTER                           &

14100   CLOSE 1                                                         &
        \OPEN 'KB:' AS FILE 1 , MODE 1                                  &
        \R%=2%                                                          &
        \GOSUB 15000                                                    &
        !                                                               &
        !       ENTER HERE ON TIME OUT                                  &

14110   T%=T%+1%                                                        &
        \IF T%< 10% THEN 14010 ELSE R%=4%                               &
        \RETURN                                                         &
        !                                                               &
        !       CONTINUE UNTIL 10 CONSECUTIVE TIMEOUTS                  &

15000   FIELD #1 , 1% AS S$                                             &
        \ON R% GO TO 15010,15020                                        &
        !                                                               &
        !       SUBROUTINE TO SEND ACK OR NAK                           &

15010   LSET S$ = CHR$(6%)                                              &
        \GO TO 15030                                                    &
        !                                                               &
        !       SET UP FOR ACK                                          &

15020   LSET S$ = CHR$(21%)                                             &
        \GO TO 15030                                                    &
        !                                                               &
        !       SET UP FOR NAK                                          &

15030   PUT #1% , RECORD 4096% , COUNT 1%                               &
        \RETURN                                                         &
        !                                                               &
        !       SEND THE SINGLE CHARACTER                               &

19000   !       E R R O R    T R A P    H A N D L I N G    R O U T I N E.       &

19010   IF ERL = 14020 THEN RESUME 14100                                &
        !                                                               &
        !       HANDLE INPUT TIME OUT                                   &

19020   IF ERL=1010 THEN PRINT'OPEN ERROR - ';ERR                       &
        \RESUME 1010                                                    &
        !                                                               &
        !       HANDLE PROTECTION VIOLATIONS AND OTHER OPEN ERRORS      &

19030   IF ERL = 1270 THEN RESUME 1600                                  &
        !                                                               &
        !       OUTPUT ERROR TO DATA FILE                               &

30000   !       CCL ENTRY
31000   !       CHAIN ENTRY
32000   !       LOGGED OUT ENTRY
32767   END                                                             &
        !       LAST LINE OF THIS PROGRAM.
                                                                                                                                                             