1       !                                                               &
        !       B A S I C    +    P R O G R A M                         &
        !                                                               &
        !       FOR RSTS/E  VERSION 8.0                                 &

10      !       FILE NAME:      MODEMS.BAS
12      !       VERSION 1       8-JUL-81
14      !       PROGRAMMER:     WILLIAM H. BLAKE
16      !       RELEASER:       TIM GARDNER
20      !                                                               &
        !       M O D I F I C A T I O N    H I S T O R Y                &

100     !       NEW PROGRAM                                             &
        !                                                               &
        !       P R O G R A M    D E S C R I P T I O N                  &
        !                                                               &
        !       THIS PROGRAM WILL SEND A PROTOCOLED DATA                &
        !                                                               &
        !       TRANSFER TO A REMOTE OPERATING ENVIRONMENT.             &
        !                                                               &
        !       SEE VOL. 1, ISSUE 1 OF CP/M-NET NEWS FOR A PROTOCOL     &
        !                DESCRIPTION.                                   &

101     !       CP/M IS A REGISTERED TRADEMARK OF DIGITAL RESEARCH      &
        !       RSTS/E IS A REGISTERED TRADEMARK OF:                    &
        !                               DIGITAL EQUIPMENT CORPRORATION  &

300     !                                                               &
        !       I / O    C H A N N E L S                                &

301     !       CHANNEL         USED FOR:                               &
        !                                                               &
        !       1               KB:-PROTOCOL                            &
        !                                                               &
        !       2               DATA FILE-512 CHARACTER RECORDS         &

400     !                                                               &
        !       V A R I A B L E    D E F I N I T I O N S                &

401     !       VARIABLE        DEFINITION                              &

402     !       A$      RAW DATA STRING (132 BYTES IN LENGTH)
404     !       A%      RAW DATA ARRAY
406     !       D$(4)   INPUT BUFFER FIELD AREAS
408     !       D%      INDEX FOR OUTPUT BUFFER FIELD AREAS
410     !       I%      TEMPORARY LOOP CONTROL
412     !       N$      FIELD STRING FOR BINARY TERMINAL INPUT
414     !       N%      RECOUNT FOR BINARY TERMINAL INPUT
416     !       O$      INPUT FILE NAME
420     !       R%      ON GO TO VARIABLE (14000,15000)
422     !       R1%     RECORD COUNTER
424     !       S$      SINGLE CHARACTER FIELD FOR SENDING CONTROL CHARACTER
426     !       S%      CHECKSUM ACCUMULATOR
428     !       T%      TIMEOUT COUNTER
800     !                                                               &
        !       F U N C T I O N S    A N D    S U B R O U T I N E S     &

801     !       PROGRAMMER DEFINED SUBROUTINES.                         &
        !                                                               &
        !       LINE            DESCRIPTION                             &

802     !       14000           READ BINARY TERMINAL DATA               &
        !                                                               &
        !         1%=ACK                                                &
        !                                                               &
        !         2%=NAK                                                &
        !                                                               &
        !         3%=CANCEL TRANSFER                                    &
        !                                                               &
        !         4%=TIMEOUT                                            &

803     !       15000           SEND PROTOCOL CONTROL CHARACTERS        &
        !                                                               &
        !         1%=ACK                                                &
        !                                                               &
        !         2%=NAK                                                &
        !                                                               &
        !         3%=EOT END OF TRANSMISSION                            &
        !                                                               &
        !         4%=CAN CANCEL TRANSMISSION                            &

804     !       16000           BUILD AND SEND A PROTOCOL RECORD        &

805     !       17000           READ A BLOCK (4 RECORDS) FROM INPUT FILE        &

825     !       PROGRAMMER DEFINED FUNCTIONS.                           &

850     !       STANDARD SUBROUTINES.                                   &
        !                                                               &
        !       LINE            DESCRIPTION                             &

875     !       STANDARD FUNCTIONS.                                     &

900     !                                                               &
        !       D I M E N S I O N    S T A T E M E N T S                &

905     DIM A%(132)                                                     &
        !                                                               &
        !       ARRAY USED TO BUILD DATA PACKETS                        &
        !                                                               &
        !       1=SOH                                                   &
        !                                                               &
        !       2=BLK#                                                  &
        !                                                               &
        !       3=2'S COMPLEMENT OF BLK#                                &
        !                                                               &
        !       4 THRU 131 = 8 BIT DATA                                 &
        !                                                               &
        !       132=CHECKSUM (8 BIT ADDITION OVER 1ST 131)              &

906     DIM D$(4)                                                       &
        !       4 STRINGS FOR INPUT BUFFER FIELDS                       &

999     !                                                               &
        !       S T A R T    O F    P R O G R A M                       &

1000    ON ERROR GO TO 19010                                            &
        !                                                               &
        !       SET UP TO CATCH FILE OPEN, FILE TRANSFER, OR TIMEOUTS   &

1010    PRINT 'INPUT FILE ';                                            &
        \INPUT LINE O$                                                  &
        \O$=CVT$$(O$,38%)                                               &
        \OPEN O$ FOR INPUT AS FILE 2 , RECORDSIZE 512%                  &
        !                                                               &
        !       OPEN THE INPUT FILE                                     &

1020    OPEN 'KB:' AS FILE 1 , RECORDSIZE 132% , MODE 1                 &
        !                                                               &
        !       SET UP FOR BINARY (8-BIT) I/O                           &

1030    FIELD #2, 128 AS D$(1),128 AS D$(2), 128 AS D$(3), 128 AS D$(4) &
        !                                                               &
        !       SET UP TO RECEIVE 128 BYTES PER RECORD TRANSFERRED      &

1040    R1%=1%                                                          &
        \D%=0%                                                          &
        !                                                               &
        !       INITIALIZE RECORD COUNTER AND INPUT BUFFER CONTROL      &

1100    GOSUB 14000                                                     &
        \ON R% GO TO 1200,1300,1400,1500                                &
        !                                                               &
        ! 1%=ACK                                                        &
        !                                                               &
        ! 2%=NAK                                                        &
        !                                                               &
        ! 3%=CANCEL TRANSFER                                            &
        !                                                               &
        ! 4%=TIMEOUT                                                    &

1200    D%=D%+1%                                                        &
        \D%=0% IF D%=5%                                                 &
        !                                                               &
        !       HANDLE THE INPUT BUFFER MANAGEMENT                      &

1210    R1%=(R1%+1%) AND 255%                                           &
        !                                                               &
        !       KEEP THE RECORD COUNTER CLEAN                           &

1300    GOSUB 17000                                                     &
        \GOSUB 16000                                                    &
        \GO TO 1100                                                     &
        !                                                               &
        !       NAK RECEIVED , SEND 1ST RECORD OR CURRENT RECORD        &

1400    CLOSE 1,2                                                       &
        \SLEEP 4                                                        &
        \PRINT 'TRANSFER CANCELED'                                      &
        \GO TO 32767                                                    &

1500    CLOSE 1,2                                                       &
        \SLEEP 4                                                        &
        \PRINT 'TIMEOUT'                                                &
        \GO TO 32767                                                    &

1700    R%=3%                                                           &
        \GOSUB 15000                                                    &
        \GOSUB 14000                                                    &
        \IF R%<>1% THEN 1700                                            &
        !                                                               &
        !       TRANSFER COMPLETE , WAIT FOR ACK IN REPLY TO EOT        &

1710    CLOSE 1,2                                                       &
        \SLEEP 4                                                        &
        \PRINT 'TRANSFER COMPLETE'                                      &
        \GO TO 32767                                                    &

1800    R%=4%                                                           &
        \GOSUB 15000                                                    &
        \GOSUB 14000                                                    &
        \IF R%<>1% THEN 1800                                            &
        !                                                               &
        !       ERROR ON INPUT FILE , CANCEL THE TRANSFER               &

1810    CLOSE 1                                                         &
        \SLEEP 4                                                        &
        \PRINT 'INPUT ERROR - TRANSFER CANCELED'                        &
        \GOTO 32767                                                     &

10000   !                                                               &
        !       P R O G R A M M E R    D E F I N E D    F U N C T I O N S       &
        !                                                               &
        !                  A N D    S U B R O U T I N E S               &
        !                                                               &

14000   T%=0%                                                           &
        \A$=""                                                          &
        !                                                               &
        !       SET TIME OUT COUNT TO ZERO                              &
        !                                                               &
        !       WE WILL QUIT AFTER 10 TIMEOUTS OF 10 SECONDS EACH       &
        !                                                               &
        !       SET CUMULTATIVE STRING TO NULL                          &

14010   WAIT 10                                                         &
        !                                                               &
        !       SET UP A 10 SECOND TIMER                                &

14020   GET #1                                                          &
        \N%=RECOUNT                                                     &
        \FIELD #1, N% AS N$                                             &
        \A$=A$+N$                                                       &
        \T% = 0%                                                        &
        !                                                               &
        !       ACCUMULATE RAW 8-BIT DATA INTO A$                       &

14030   IF LEN(A$)> 1 THEN A$=""                                        &
        \GO TO 14010                                                    &
        !                                                               &
        !       GO CONTINUE TO BUILD INPUT STRING                       &

14040   IF A$ = CHR$(6%) THEN R%=1%                                     &
        \RETURN                                                         &
        !                                                               &
        !       ACK                                                     &

14050   IF A$ = CHR$(21%) THEN R%=2%                                    &
        \RETURN                                                         &
        !                                                               &
        !       NAK                                                     &

14060   IF A$ = CHR$(24%) THEN R%=3%                                    &
        \RETURN                                                         &
        !                                                               &
        !       CANCEL TRANSFER                                         &

14070   GO TO 14010                                                     &
        !                                                               &
        !       NOT A VALID CONTROL CHARACTER                           &

14100   CLOSE 1                                                         &
        \OPEN 'KB:' AS FILE 1 , RECORDSIZE 132% , MODE 1                &
        !                                                               &
        !       ENTER HERE ON A TEN SECOND TIME OUT                     &

14110   T%=T%+1%                                                        &
        \IF T%< 10% THEN 14010 ELSE R%=4%                               &
        \RETURN                                                         &
        !                                                               &
        !       CONTINUE UNTIL 10 CONSECUTIVE TIMEOUTS                  &

15000   FIELD #1 , 1% AS S$                                             &
        \ON R% GO TO 15010,15020,15030,15040                            &
        !                                                               &
        !       SUBROUTINE TO SEND SINGLE CONTROL CHARACTERS            &

15010   LSET S$ = CHR$(6%)                                              &
        \GO TO 15050                                                    &
        !                                                               &
        !       SET UP FOR ACK                                          &

15020   LSET S$ = CHR$(21%)                                             &
        \GO TO 15050                                                    &
        !                                                               &
        !       SET UP FOR NAK                                          &

15030   LSET S$ = CHR$(4%)                                              &
        \GO TO 15050                                                    &
        !                                                               &
        !       SET UP FOR EOT                                          &

15040   LSET S$ = CHR$(24%)                                             &
        \GO TO 15050                                                    &
        !                                                               &
        !       SET UP FOR CAN                                          &

15050   PUT #1%, RECORD 4096%, COUNT 1                                  &
        \RETURN                                                         &
        !                                                               &
        !       SEND THE SINGLE CHARACTER                               &

16000   CHANGE "ABC"+D$(D%) TO A%                                       &
        \A%(1%)=1%                                                      &
        \A%(2%)=R1%                                                     &
        \A%(3%)=256%-R1%-1%                                             &
        !                                                               &
        !       BUILD 1ST 131 CHARACTERS OF RECORD TO SEND              &

16010   S%=0%                                                           &
        \FOR I%=1% TO 131%                                              &
                \S%=(S%+A%(I%)) AND 255%                                &
        \NEXT I%                                                        &
        \A%(132%)=S%                                                    &
        !                                                               &
        !       CALCULATE THE CHECKSUM                                  &

16020   A%(0%)=132%                                                     &
        \CHANGE A% TO A$                                                &
        \FIELD #1 , 132% AS N$                                          &
        \LSET N$=A$                                                     &
        \PUT #1%, RECORD 4096%, COUNT 132%                              &
        \RETURN                                                         &
        !                                                               &
        !       SEND THE 132 CHARACTER RECORD                           &

17000   IF D% = 0% THEN GET #2%                                         &
        \D% = 1%                                                        &
        !                                                               &
        !       READ IN FOUR DATA RECORDS AT A TIME                     &

17010   RETURN                                                          &

19000   !                                                               &
        !                                                               &
        !       E R R O R    T R A P    H A N D L I N G    R O U T I N E.       &
        !                                                               &

19010   IF ERL = 14020 THEN RESUME 14100                                &
        !                                                               &
        !       HANDLE INPUT TIME OUT                                   &

19020   IF ERL=1010 THEN PRINT'OPEN ERROR - ';ERR                       &
        \RESUME 1010                                                    &
        !                                                               &
        !       HANDLE PROTECTION VIOLATIONS AND OTHER OPEN ERRORS      &

19040   IF ERR = 11% AND ERL = 17000 THEN RESUME 1700                   &
        !                                                               &
        !       HANDLE END OF FILE                                      &

19050   IF ERL = 17000 THEN RESUME 1800                                 &
        !                                                               &
        !       HANDLE DATA ERROR ON INPUT FILE                         &

30000   !       CCL ENTRY
31000   !       CHAIN ENTRY
32000   !       LOGGED OUT ENTRY
32767   END                                                             &
        !                                                               &
        !       LAST LINE OF THIS PROGRAM.
                                                                                                                                                                                                                                                                                                                                      